c
c
      subroutine gstype (itype,
     +                   gs)
c     
c action: see if ghostscript or the dll are available
c author: w.g.bardsley, university of manchester,u.k. 16/05/2015
c         24/05/2017 checked to see if cval(8) = '*.exe'
c
c      values returned as follows:
c      itype =  0: neither is available
c      itype =  6: only the dll is available
c      itype =  8: only ghostscript is available
c      itype = 14: both are available
c      itype >= 8: gs is the path to ghostscript  
c       
      implicit none
c
c arguments
c      
      integer,             intent (out) :: itype 
      character (len = *), intent (out) :: gs 
c
c locals
c      
      integer    mode, n0, n6, n8
      parameter (mode = 0, n0 = 0, n6 = 6, n8 = 8) 
      integer    l, nval(12) 
      character (len = 1024) cval(12)
      character (len = 4   ) dot_exe, word4 
      parameter (dot_exe = '.EXE')
      character (len = 1   ) blank
      logical    ok_6, ok_8
      parameter (blank = ' ')
      external   x_okcval, w_config, x_ucase1
      intrinsic  len_trim
      itype = n0
      gs = blank
      call x_okcval (n6,
     +               ok_6) 
      if (ok_6) itype = itype + n6
      call x_okcval (n8,
     +               ok_8)
      if (ok_8) then
         call w_config (mode, nval,
     +                  cval)
         l = len_trim(cval(8))
         if (l.gt.4) then
            word4 = cval(8)(l - 3:l)
            call x_ucase1 (word4)
            if (word4.eq.dot_exe) then
               gs = cval(8)
               itype = itype + n8
            endif
         endif      
      endif 
      end          
c
c
      
      