C  
C
      SUBROUTINE H3DCYL$(ICOLOR_B, ICOLOR_F, ICOLOR_L,
     +                   ICOLOR_T, NEBMAX, NMAX, NTYPE, NX, NY,
     +                   EB, EXPAND, X, XT, Y, YT, Z,
     +                   ERRBAR)
C
C ACTION : Cylinders
C AUTHOR : W.G.Bardsley, University of Manchester, U.K. 
C          24/02/2002 derived from H3DPLT   
C          13/05/2007 added INTENTS
C
C          _B = background
C          _F = foreground
C          _L = front facet
C          _T = top facet
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ICOLOR_B, ICOLOR_F, ICOLOR_L,
     +                                    ICOLOR_T, NEBMAX, NMAX, NTYPE,
     +                                    NX, NY 
      DOUBLE PRECISION, INTENT (IN)    :: EB(NEBMAX,NY), EXPAND,
     +                                    X(NMAX), Y(NMAX), Z(NMAX,NY)
      DOUBLE PRECISION, INTENT (INOUT) :: XT(NMAX), YT(NMAX)
      LOGICAL,          INTENT (IN)    :: ERRBAR
C
C Locals
C     
      INTEGER    NPTS
      PARAMETER (NPTS = 51)
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      INTEGER    I, ICOUNT, ITEMP, J, JCOUNT, JTEMP, K, NBIG, NSUM
      INTEGER    NSTART, NSTOP
      INTEGER    COLOUR_INDEX
      DOUBLE PRECISION XSAV, XTEMP, YSAV, YTEMP, ZTEMP
      DOUBLE PRECISION ZERO, HALF, ONE, THICK, THIRD, THREE, FOUR
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           THICK = 2.0D+00, THREE = 3.0D+00,
     +           THIRD = ONE/THREE, FOUR = 4.0D+00)
      DOUBLE PRECISION PI
      PARAMETER (PI = 3.14159265358979323846264338328D+00)
      DOUBLE PRECISION XDELTA, XFACT, XSHIFT, YDELTA, YFACT, YSHIFT
      DOUBLE PRECISION RADIUS, TDIFF, THETA
      EXTERNAL   GSELNT$, XYZ2XY$, POLYLINE$, FILL_POLYGON$, GSLWSC$
      INTRINSIC  MIN, DBLE, COS, SIN
      IF (ICOLOR_B.LT.0 .OR. ICOLOR_B.GT.71) RETURN
      IF (ICOLOR_F.LT.0 .OR. ICOLOR_F.GT.71) RETURN
      COLOUR_INDEX = ICOLOR_F
      CALL GSELNT$(N1)
      XFACT = (DBLE(NX) - ONE)/(DBLE(NX)*(X(NX) - X(1)))
      XSHIFT = HALF/DBLE(NX)
      XDELTA = EXPAND*XSHIFT
      YFACT = (DBLE(NY) - ONE)/(DBLE(NY)*(Y(NY) - Y(1)))
      YSHIFT = HALF/DBLE(NY)
      YDELTA = EXPAND*YSHIFT
      RADIUS = MIN(XDELTA,YDELTA)
      NBIG = 2*NX*NY
      NSUM = 0
      ICOUNT = 0
      JCOUNT = 1
      DO I = 1, NX + NY - 1
         IF (I.LE.NX) THEN
            ICOUNT = ICOUNT + 1
         ELSE
            JCOUNT = JCOUNT + 1
         ENDIF
         ITEMP = ICOUNT + 1
         JTEMP = JCOUNT - 1
         DO J = JCOUNT, NY
            ITEMP = ITEMP - 1
            JTEMP = JTEMP + 1
            IF (ITEMP.GE.1 .AND. JTEMP.LE.NY .AND. NSUM.LE.NBIG) THEN
C
C Coordinates for the front face
C
               XSAV = (X(ITEMP) - X(1))*XFACT + XSHIFT
               YSAV = (Y(JTEMP) - Y(1))*YFACT + YSHIFT
               ZTEMP = Z(ITEMP,JTEMP)
               THETA = -PI/FOUR
               TDIFF = PI/DBLE(NPTS/2 - 1)
               DO K = 1, NPTS/2
                  XTEMP = XSAV + RADIUS*COS(THETA)
                  YTEMP = YSAV + RADIUS*SIN(THETA)
                  CALL XYZ2XY$(XTEMP, XT(K), YTEMP, YT(K), ZTEMP)
                  THETA = THETA + TDIFF
               ENDDO
               THETA = THREE*PI/FOUR
               ZTEMP = ZERO
               DO K = NPTS/2 + 1, NPTS - 1
                  XTEMP = XSAV + RADIUS*COS(THETA)
                  YTEMP = YSAV + RADIUS*SIN(THETA)
                  CALL XYZ2XY$(XTEMP, XT(K), YTEMP, YT(K), ZTEMP)
                  THETA = THETA - TDIFF
               ENDDO
               XT(NPTS) = XT(1)
               YT(NPTS) = YT(1)
               IF (NTYPE.EQ.1) THEN
                  CALL FILL_POLYGON$(NPTS, XT, YT, ICOLOR_B)
               ELSE
                  CALL FILL_POLYGON$(NPTS, XT, YT, ICOLOR_L)
               ENDIF
               NSUM = NSUM + 1
               IF (NTYPE.NE.3) THEN
                  NSTART = NPTS/2 
                  NSTOP = NPTS - NSTART + 1
                  CALL POLYLINE$(NSTOP, XT(NSTART), YT(NSTART),
     +                           COLOUR_INDEX)                 
               ENDIF
C
C Coordinates for the top
C
               ZTEMP = Z(ITEMP,JTEMP)
               THETA = THREE*PI/FOUR + TDIFF
               DO K = NPTS/2 + 1, NPTS - 1
                  XTEMP = XSAV + RADIUS*COS(THETA)
                  YTEMP = YSAV + RADIUS*SIN(THETA)
                  CALL XYZ2XY$(XTEMP, XT(K), YTEMP, YT(K), ZTEMP)
                  THETA = THETA + TDIFF
               ENDDO
               XT(NPTS) = XT(1)
               YT(NPTS) = YT(1)
               IF (NTYPE.EQ.1) THEN
                  CALL FILL_POLYGON$(NPTS, XT, YT, ICOLOR_B)
               ELSE
                  CALL FILL_POLYGON$(NPTS, XT, YT, ICOLOR_T)
               ENDIF
               NSUM = NSUM + 1
               IF (NTYPE.NE.3) CALL POLYLINE$(NPTS, XT, YT,
     +                                        COLOUR_INDEX)                 
C
C Error bars
C
               IF (ERRBAR) THEN
                  CALL GSLWSC$(THICK)
                  ZTEMP = Z(ITEMP,JTEMP)
                  CALL XYZ2XY$(XSAV, XT(1), YSAV, YT(1), ZTEMP)
                  ZTEMP = ZTEMP + EB(ITEMP,JTEMP)
                  CALL XYZ2XY$(XSAV, XT(2), YSAV, YT(2), ZTEMP)
                  CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
                  IF (NX.GE.NY) THEN
                     CALL XYZ2XY$(XSAV, XT(1), YSAV - THIRD*YDELTA,
     +                            YT(1), ZTEMP)
                     CALL XYZ2XY$(XSAV, XT(2), YSAV + THIRD*YDELTA,
     +                            YT(2), ZTEMP)
                  ELSE
                     CALL XYZ2XY$(XSAV - THIRD*XDELTA, XT(1), YSAV,
     +                            YT(1), ZTEMP)
                     CALL XYZ2XY$(XSAV + THIRD*YDELTA, XT(2), YSAV,
     +                            YT(2), ZTEMP)
                  ENDIF
                  CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
                  CALL GSLWSC$(ONE)
               ENDIF
            ENDIF
         ENDDO
      ENDDO
      END
C
C
