C 
C
      SUBROUTINE H3DPLT$(ICOLOR_B, ICOLOR_F, ICOLOR_L, ICOLOR_R,
     +                   ICOLOR_T, NEBMAX, NMAX, NTYPE, NX, NY,
     +                   EB, EXPAND, X, XT, Y, YT, Z,
     +                   ERRBAR)
C
C ACTION : Facets
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.29/8/95 
C          24/02/2002 added NEBMAX, EB, ERRBAR, EXPAND
C          13/05/2007 added INTENTS
C
C          _B = background
C          _F = foreground
C          _L = left facet
C          _R = right facet
C          _T = top facet
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ICOLOR_B, ICOLOR_F, ICOLOR_L,
     +                                    ICOLOR_R, ICOLOR_T,
     +                                    NEBMAX, NMAX, NTYPE, NX, NY 
      DOUBLE PRECISION, INTENT (IN)    :: EB(NEBMAX,NY), EXPAND,
     +                                    X(NMAX), Y(NMAX),  Z(NMAX,NY) 
      DOUBLE PRECISION, INTENT (INOUT) :: XT(5), YT(5)
      LOGICAL,          INTENT (IN)    :: ERRBAR
C
C Locals
C     
      INTEGER    N1, N2, N3, N4, N5
      PARAMETER (N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5)
      INTEGER    I, ICOUNT, ITEMP, J, JCOUNT, JTEMP, K, L, NBIG, NSUM
      INTEGER    COLOUR_INDEX
     
      DOUBLE PRECISION XSAV, XTEMP, YSAV, YTEMP, ZTEMP
      DOUBLE PRECISION ZERO, HALF, ONE, THICK, THIRD
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           THICK = 2.5D+00, THIRD = 0.3333333D+00)
      DOUBLE PRECISION XDELTA, XFACT, XSHIFT, YDELTA, YFACT, YSHIFT
      EXTERNAL   GSELNT$, XYZ2XY$, POLYLINE$, FILL_POLYGON$, GSLWSC$
      INTRINSIC  DBLE
      IF (ICOLOR_B.LT.0 .OR. ICOLOR_B.GT.71) RETURN
      IF (ICOLOR_F.LT.0 .OR. ICOLOR_F.GT.71) RETURN
      COLOUR_INDEX = ICOLOR_F
      CALL GSELNT$(N1)
      XFACT = (DBLE(NX) - ONE)/(DBLE(NX)*(X(NX) - X(1)))
      XSHIFT = HALF/DBLE(NX)
      XDELTA = EXPAND*XSHIFT
      YFACT = (DBLE(NY) - ONE)/(DBLE(NY)*(Y(NY) - Y(1)))
      YSHIFT = HALF/DBLE(NY)
      YDELTA = EXPAND*YSHIFT
      NBIG = 3*NX*NY
      NSUM = 0
      ICOUNT = 0
      JCOUNT = 1
      DO I = 1, NX + NY - 1
         IF (I.LE.NX) THEN
            ICOUNT = ICOUNT + 1
         ELSE
            JCOUNT = JCOUNT + 1
         ENDIF
         ITEMP = ICOUNT + 1
         JTEMP = JCOUNT - 1
         DO J = JCOUNT, NY
            ITEMP = ITEMP - 1
            JTEMP = JTEMP + 1
            IF (ITEMP.GE.1 .AND. JTEMP.LE.NY .AND. NSUM.LE.NBIG) THEN
               XSAV = (X(ITEMP) - X(1))*XFACT + XSHIFT
               YSAV = (Y(JTEMP) - Y(1))*YFACT + YSHIFT
               DO K = 1, N3
                  ZTEMP = Z(ITEMP,JTEMP)
                  DO L = 1, N4
                     IF (K.EQ.1) THEN
                        IF (L.EQ.1) THEN
                           XTEMP = XSAV + XDELTA
                           YTEMP = YSAV + YDELTA
                        ELSEIF (L.EQ.2) THEN
                           YTEMP = YSAV - YDELTA
                        ELSEIF (L.EQ.3) THEN
                           ZTEMP = ZERO
                        ELSEIF (L.EQ.4) THEN
                           YTEMP = YSAV + YDELTA
                        ENDIF
                     ELSEIF (K.EQ.2) THEN
                        IF (L.EQ.1) THEN
                           XTEMP = XSAV - XDELTA
                           YTEMP = YSAV + YDELTA
                        ELSEIF (L.EQ.2) THEN
                           XTEMP = XSAV + XDELTA
                        ELSEIF (L.EQ.3) THEN
                           ZTEMP = ZERO
                        ELSEIF (L.EQ.4) THEN
                           XTEMP = XSAV - XDELTA
                        ENDIF
                     ELSEIF (K.EQ.3) THEN
                        IF (L.EQ.1) THEN
                           XTEMP = XSAV - XDELTA
                           YTEMP = YSAV + YDELTA
                        ELSEIF (L.EQ.2) THEN
                           YTEMP = YSAV - YDELTA
                        ELSEIF (L.EQ.3) THEN
                           XTEMP = XSAV + XDELTA
                        ELSEIF (L.EQ.4) THEN
                           YTEMP = YSAV + YDELTA
                        ENDIF
                     ENDIF
                     CALL XYZ2XY$(XTEMP, XT(L), YTEMP, YT(L), ZTEMP)
                  ENDDO
                  XT(N5) = XT(1)
                  YT(N5) = YT(1)
                  IF (NTYPE.EQ.1) THEN
                     CALL FILL_POLYGON$(N5, XT, YT, ICOLOR_B)
                  ELSE
                     IF (K.EQ.1) THEN
                        CALL FILL_POLYGON$(N5, XT, YT, ICOLOR_L)
                     ELSEIF (K.EQ.2) THEN
                        CALL FILL_POLYGON$(N5, XT, YT, ICOLOR_R)
                     ELSE
                        CALL FILL_POLYGON$(N5, XT, YT, ICOLOR_T)
                     ENDIF
                  ENDIF
                  NSUM = NSUM + 1
                  IF (NTYPE.NE.3) THEN
                     CALL POLYLINE$(N5, XT, YT, COLOUR_INDEX)
                  ENDIF
               ENDDO
               IF (ERRBAR) THEN
                  CALL GSLWSC$(THICK)
                  ZTEMP = Z(ITEMP,JTEMP)
                  CALL XYZ2XY$(XSAV, XT(1), YSAV, YT(1), ZTEMP)
                  ZTEMP = ZTEMP + EB(ITEMP, JTEMP)
                  CALL XYZ2XY$(XSAV, XT(2), YSAV, YT(2), ZTEMP)
                  CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
                  IF (NX.GE.NY) THEN
                     CALL XYZ2XY$(XSAV, XT(1), YSAV - THIRD*YDELTA,
     +                            YT(1), ZTEMP)
                     CALL XYZ2XY$(XSAV, XT(2), YSAV + THIRD*YDELTA,
     +                            YT(2), ZTEMP)
                  ELSE
                     CALL XYZ2XY$(XSAV - THIRD*XDELTA, XT(1), YSAV,
     +                            YT(1), ZTEMP)
                     CALL XYZ2XY$(XSAV + THIRD*YDELTA, XT(2), YSAV,
     +                            YT(2), ZTEMP)
                  ENDIF
                  CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
                  CALL GSLWSC$(ONE)
               ENDIF
            ENDIF
         ENDDO
      ENDDO
      END
C
C