C
C HERSHEY
C =======   
C
C Note: At 21/03/2007 FHERSH was disabled.
C       It is extremely unlikely that these routines will ever be
C       needed again, but they are left in just in case they need
C       to be developed for some future application with non-Windows
C       fonts.  
C
C These routines are only required for Hershey fonts. The dummy front
C ends DRAW_HERSHEY$ and SET_TEXT_ATTRIBUTE$ are provided to make the
C transformation into short integers and reals, and also to provide
C flexibility in developing a substitution for alternative Hershey
C font implementations.
C It is not required if TRUE_TYPE = .TRUE. or PS =.TRUE. in the
C other simfit plotting routines.
C
C DRAW_HERSHEY$
C SET_TEXT_ATTRIBUTE$
C
C EHERSH : Display Accents
C FHERSH : Display Hershey font substitutions
C IHERSH : Get the Hershey font identifier
C LHERSH : Get the dimensions of a string
C
C
      SUBROUTINE DRAW_HERSHEY$(IHERSH, IH, IV, ICOL, IH_END, IV_END)
C
C ACTION: call DRAW_HERSHEY@
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 08/12/2000
C
      IMPLICIT  NONE
      INTEGER   IHERSH, IH, IV, ICOL, IH_END, IV_END
      INTEGER, PARAMETER :: SHORT = SELECTED_INT_KIND(4)
      INTEGER (KIND = SHORT) JHERSH, JH, JV, JH_END, JV_END
      EXTERNAL  DRAW_HERSHEY
      JHERSH = INT(IHERSH,SHORT)
      JH = INT(IH,SHORT)
      JV = INT(IV,SHORT)
      CALL DRAW_HERSHEY (JHERSH, JH, JV, ICOL, JH_END, JV_END)
      IH_END = JH_END
      IV_END = JV_END
      END
C
C
      SUBROUTINE SET_TEXT_ATTRIBUTE$(FONT, SIZE, ROTATION, ITALIC)
C
C ACTION: call SET_TEXT_ATTRIBUTE@
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 08/12/2000
C
      IMPLICIT NONE
      INTEGER  FONT
      DOUBLE PRECISION SIZE, ROTATION, ITALIC
      EXTERNAL SET_TEXT_ATTRIBUTE
      INTRINSIC SNGL
      CALL SET_TEXT_ATTRIBUTE (FONT, SNGL(SIZE), SNGL(ROTATION),
     +                         SNGL(ITALIC))
      END
C
C
      SUBROUTINE EHERSH
C
C
C ACTION : Demonstrate Math/accents
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/11/96
C          29/02/97 Win32 version
C          25/02/2000 added WGBINI$ to normalise font size then restore
C          17/06/2007 removed defngks.ins and added GETDEF$
C
      IMPLICIT   NONE
      INTEGER    IFONT, NGKS, NFONT
      PARAMETER (IFONT = 106, NGKS = 0, NFONT = 1)
      INTEGER    ICOLOR, ISEND, LTEMP
      DOUBLE PRECISION ANGLE, SIZE1, SIZE2, SLANT, X1, X2, Y
      PARAMETER (ANGLE = 0.0D+00, SIZE1 = 1.5D+00, SLANT = 0.0D+00,
     +           X1 = 0.10D+00, X2 = 0.5D+00)
      CHARACTER  FONT*1, STRNG*72, SYMBOL*72, TYPE2*2
      PARAMETER (FONT = ' ', TYPE2 = 'tl') 
      EXTERNAL   GETDEF$
C
C Arguments for GETDFE$
C                       
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
      
      EXTERNAL   PLTSTR$, INIT$, FINISH$, WGBINI$
C
C Retrieve GKS parameters
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
       
C
C Save font size and line thickness then initialise
C
      ISEND = 1
      CALL WGBINI$(ISEND)
      LTEMP = NGKS
      CALL INIT$(LTEMP)
C
C Left heading ........................................................
C
      Y = 0.95D+00
      ICOLOR = 12
      STRNG = 'Text and key'
      SYMBOL = '000000000000'
      SIZE2 = 1.8D+00
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE2, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Right heading
C
      ICOLOR = 12
      STRNG = 'Appearance in plot'
      SYMBOL = '000000000000000000'
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE2, SLANT, X2, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Left string ... 1 ...................................................
C
      Y = 0.85D+00
      STRNG = 'T = 21@C'
      SYMBOL = '00000000'
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
      Y = 0.80D+00
      STRNG = '00000060'
      SYMBOL = '00000000'
      SIZE2 = 1.6D+00
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE2, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Right string ... 1
C

      ICOLOR = 12
      Y = 0.85D+00
      STRNG = 'T = 21@C'
      SYMBOL = '00000060'
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X2, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Left string ... 2 ...................................................
C
      Y = 0.7D+00
      STRNG = 'a2b2 isoform'
      SYMBOL = '000000000000'
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
      Y = 0.65D+00
      STRNG = '616100000000'
      SYMBOL = '000000000000'
      SIZE2 = 1.5D+00
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE2, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Right string ... 2
C

      ICOLOR = 12
      Y = 0.7D+00
      STRNG = 'a2b2 isoform'
      SYMBOL = '616100000000'
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X2, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Left string ... 3 ...................................................
C
      Y = 0.55D+00
      STRNG = '[Ca++] = 1.2*10-9M'
      SYMBOL = '000000000000000000'
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
      Y = 0.5D+00
      STRNG = '000220000000600220'
      SYMBOL = '000000000000000000'
      SIZE2 = 1.5D+00
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE2, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Right string ... 3
C

      ICOLOR = 12
      Y = 0.55D+00
      STRNG = '[Ca++] = 1.2*10-9M'
      SYMBOL = '000220000000600220'
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X2, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Left string ... 4 ...................................................
C
      Y = 0.4D+00
      STRNG = 'l = X = (1/n)6x(i)'
      SYMBOL = '000000000000000000'
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
      Y = 0.35D+00
      STRNG = 'I000E000000D060000'
      SYMBOL = '000000000000000000'
      SIZE2 = 1.5D+00
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE2, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Right string ... 4
C

      ICOLOR = 12
      Y = 0.4D+00
      STRNG = 'l = X = (1/n)6x(i)'
      SYMBOL = 'I000E000000D060000'
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X2, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Left string ... 5 ...................................................
C
      Y = 0.25D+00
      STRNG = '2z/2t = 32z'
      SYMBOL = '00000000000'
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
      Y = 0.2D+00
      STRNG = '66060000626'
      SYMBOL = '00000000000'
      SIZE2 = 1.5D+00
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE2, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Right string ... 5
C

      ICOLOR = 12
      Y = 0.25D+00
      STRNG = '2z/2t = 32z'
      SYMBOL = '66060000626'
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X2, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Left string ... 6 ...................................................
C
      Y = 0.1D+00
      STRNG = 'C(a) = 4ta-1e-tdt'
      SYMBOL = '00000000000000000'
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
      Y = 0.05D+00
      STRNG = '60600006052202200'
      SYMBOL = '00000000000000000'
      SIZE2 = 1.5D+00
      ICOLOR = 0
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE2, SLANT, X1, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
C
C Right string ... 6
C

      ICOLOR = 12
      Y = 0.1D+00
      STRNG = 'C(a) = 4ta-1e-tdt'
      SYMBOL = '60600006052202200'
      CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +             ANGLE, SIZE1, SLANT, X2, Y, Y_SCALE,
     +             FONT, STRNG, SYMBOL, TYPE2,
     +             HARD_COPY, HPGL, PS)
      CALL FINISH$
      ISEND = 2
C
C Restore font size and line thickness
C
      CALL WGBINI$(ISEND)
      END
C
C
      SUBROUTINE FHERSH
C
C ACTION : Display the Hershey font substitutions
C AUTHOR : W.G.Bardsley, university of manchester, U.K., 7/10/96
C          29/2/97 Win32 version ... Does not call EHERSH
C          21/5/97 Edited to remove pivot
C          7/8/98 removed topmost
C          27/10/99 changed colours to RGB
C          25/02/2000 added WGBINI$
C
      IMPLICIT   NONE
C*****INCLUDE   <windows.ins>
      INTEGER    ICOLOR, ISEND, JCOLOR, K, KX, KY, NUMRGB$ 
      INTEGER    I, IC, IH, IH_END, IV, IV_END, IHERSH, J
      INTEGER    IFONT, IH_DIFF, IH_SHIFT, IV_DIFF, IV_START
      PARAMETER (IFONT = 106, IV_START = 0)
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION FACTOR, F640, PNT85
      PARAMETER (F640 = 640.0D+00, PNT85 = 0.85D+00)
      CHARACTER  CKEY*1, GKEY*1
      PARAMETER (CKEY = '0', GKEY = '6')
      EXTERNAL   W_SYSPAR
      EXTERNAL   NUMRGB$, WGBINI$
      EXTERNAL   IHERSH
      EXTERNAL   DRAW_HERSHEY$, SET_TEXT_ATTRIBUTE$
      INTRINSIC  DBLE, NINT
      ISEND = 1
      CALL WGBINI$(ISEND)
C
C Set RGB colours
C
C*****K = USE_RGB_COLOURS@(N0, N1)
C
C Set up the screen and text attributes
C
      CALL W_SYSPAR (K, 'x')
      KX = NINT(DBLE(K)*PNT85) 
      ISEND = KX!to silence ftn95
      CALL W_SYSPAR (K, 'y')
      KY = NINT(DBLE(K)*PNT85)   
      ISEND = KY!to silence ftn95
      FACTOR = DBLE(KX)/F640
C*****K = WINIO@('%gr[white, rgb_colours]%ww[no_sysmenu]&', KX, KY)
C*****K = WINIO@('%ca[SIMFIT: Maths/Greek font]&')
      K = 1
c*****CALL SET_LINE_WIDTH@(K)
      CALL SET_TEXT_ATTRIBUTE$(IFONT, FACTOR*TWO, ZERO, ZERO)
C
C Initialise
C
      IH_DIFF = NINT(FACTOR*25.0D+00)
      IH_SHIFT = NINT(FACTOR*10.0D+00)
      IV_DIFF = NINT(FACTOR*28.0D+00)
C
C 32 to 47
C
      IV = IV_START
      DO I = 32, 47
         IH = IH_DIFF + IH_SHIFT
         IV = IV + IV_DIFF
         IC = I
         J = IHERSH(IC, IFONT, CKEY)
         ICOLOR = 0
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
         IH = IH + IH_DIFF
         J = IHERSH(IC, IFONT, GKEY)
         ICOLOR = 12
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
      ENDDO
C
C 48 to 63
C
      IV = IV_START
      DO I = 48, 63
         IH = 5*IH_DIFF + IH_SHIFT
         IV = IV + IV_DIFF
         IC = I
         J = IHERSH(IC, IFONT, CKEY)
         ICOLOR = 0
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
         IH = IH + IH_DIFF
         J = IHERSH(IC, IFONT, GKEY)
         ICOLOR = 12
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
      ENDDO
C
C 64 to 79
C
      IV = IV_START
      DO I = 64, 79
         IH = 9*IH_DIFF + IH_SHIFT
         IV = IV + IV_DIFF
         IC = I
         J = IHERSH(IC, IFONT, CKEY)
         ICOLOR = 0
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
         IH = IH + IH_DIFF
         J = IHERSH(IC, IFONT, GKEY)
         IF (I.EQ.64) THEN
            ICOLOR = 12
         ELSE
            ICOLOR = 12
         ENDIF
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
      ENDDO
C
C 80 to 95
C
      IV = IV_START
      DO I = 80, 95
         IH = 13*IH_DIFF + IH_SHIFT
         IV = IV + IV_DIFF
         IC = I
         J = IHERSH(IC, IFONT, CKEY)
         ICOLOR = 0
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
         IH = IH + IH_DIFF
         J = IHERSH(IC, IFONT, GKEY)
         IF (I.LE.90) THEN
            ICOLOR = 12
         ELSE
            ICOLOR = 12
         ENDIF
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
      ENDDO
C
C 96 to 111
C
      IV = IV_START
      DO I = 96, 111
         IH = 17*IH_DIFF + IH_SHIFT
         IV = IV + IV_DIFF
         IC = I
         J = IHERSH(IC, IFONT, CKEY)
         ICOLOR = 0
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
         IH = IH + IH_DIFF
         J = IHERSH(IC, IFONT, GKEY)
         IF (I.EQ.96) THEN
            ICOLOR = 12
         ELSE
            ICOLOR = 12
         ENDIF
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
      ENDDO
C
C 112 to 126
C
      IV = IV_START
      DO I = 112, 126
         IH = 21*IH_DIFF + IH_SHIFT
         IV = IV + IV_DIFF
         IC = I
         J = IHERSH(IC, IFONT, CKEY)
         ICOLOR = 0
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
         IH = IH + IH_DIFF
         J = IHERSH(IC, IFONT, GKEY)
         IF (I.LE.122) THEN
            ICOLOR = 12
         ELSE
            ICOLOR = 12
         ENDIF
         JCOLOR = NUMRGB$(ICOLOR)
         CALL DRAW_HERSHEY$(J, IH, IV, JCOLOR, IH_END, IV_END)
      ENDDO
C
C Close window
C
C*****K = WINIO@('%nl  %3^bt[OK]', 'EXIT')
      ISEND = 2
      CALL WGBINI$(ISEND)
      END
C
C
      FUNCTION IHERSH(IC, IFONT, CKEY)
C
C ACTION : Return the Hershey font identifier
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 24/9/96
C          The Hershey font identifiers are taken from DBOS.LIB
C          08/10/96 Extensive revision
C          22/11/99 Added Symbol font for key = K, Improved interface
C                   and allowed ISOLatin1Encoding and IFONT = 107
C          Date of this version 22/11/99
C
      IMPLICIT   NONE
      INTEGER    IHERSH, IC, IFONT
      INTEGER    JFONT
      INTEGER    ISUBG(33:64), ISUB1(33:47), ISUB2(58:64), ISUB3(91:96),
     +           ISUB4(123:126)
      INTEGER    ISYMB(32:126)
      CHARACTER  CKEY*(*)
      DATA       ISUBG /  738, 3318, 2270,  272, 3501, 2284,  741,
     +                    742,  744, 2235, 2233,  843,  246,  850,
     +                   2237, 2255, 3156, 2265, 2266, 2268, 2401,
     +                   2402, 2261, 2263, 2262, 2264,  278, 2243,
     +                   2240, 2244, 2239, 2218 /
      DATA       ISUB1 / 2714, 2728, 733,   719, 2271, 2718, 2716, 2721,
     +                   2722, 2723, 2725, 2711, 2724, 2710, 2720 /
      DATA       ISUB2 / 2712, 2713, 2241, 2726, 2242, 2715, 2273 /
      DATA       ISUB3 / 2223,  799, 2224,  832,  258, 2249 /
      DATA       ISUB4 / 2225, 2229, 2226, 2246 /
      DATA       ISYMB /    0, 2714, 2266,  733, 2279, 2271, 2718,  282,
     +                   2221, 2222, 2219, 2232, 2211, 2231, 2210, 2220,
     +                   2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207,
     +                   2208, 2209, 2212, 2213, 2241, 2238, 2242, 2215,
     +                   2240, 2027, 2028, 2048, 2030, 2031, 2047, 2029,
     +                   2033, 2035,  634, 2036, 2037, 2038, 2039, 2041,
     +                   2042, 2034, 2043, 2044, 2045, 2025, 2187, 2050,
     +                   2040, 2049, 2076, 2223,  740, 2224,  738, 2231,
     +                   2231, 2127, 2128, 2148, 2130, 2131, 2147, 2129,
     +                   2133, 2135, 2147, 2137, 2137, 2138, 2139, 2141,
     +                   2142, 2185, 2143, 2144, 2145, 2146, 2150, 2150,
     +                   2140, 2149, 2132, 2225, 2229, 2226, 2246 /
C
C Set the default value for IHERSH
C
      IF (IC.EQ.32) THEN
         IHERSH = 0
      ELSE
         IHERSH = 254
      ENDIF
C
C Check for consistent arguments...IC must be in the ASCII range
C
      IF (IC.LE.32 .OR. IC.GT.126) RETURN
C
C Check for consistent arguments...IFONT must be 102, 106 or 107
C
      IF (IFONT.NE.102 .AND. IFONT.NE.106 .AND. IFONT.NE.107) RETURN
C
C Check for consistent arguments...CKEY must be 0 to 8 or ? or A to K
C
      IF (CKEY.EQ.'0' .OR. CKEY.EQ.'1' .OR. CKEY.EQ.'2' .OR.
     +    CKEY.EQ.'8' .OR.
     +    CKEY.EQ.'?' .OR. CKEY.EQ.'A' .OR. CKEY.EQ.'B' .OR.
     +    CKEY.EQ.'C' .OR. CKEY.EQ.'D' .OR. CKEY.EQ.'E' .OR.
     +    CKEY.EQ.'F') THEN
C
C Normal font
C
         JFONT = IFONT
      ELSEIF (CKEY.EQ.'3' .OR. CKEY.EQ.'4' .OR. CKEY.EQ.'5' .OR.
     +        CKEY.EQ.'6' .OR. CKEY.EQ.'G' .OR. CKEY.EQ.'H' .OR.
     +        CKEY.EQ.'I' .OR. CKEY.EQ.'J') THEN
C
C Maths/Greek .. Intercept for special action if Y, Z, y, z or 33 to 64
C
         IF (IC.GE.33 .AND. IC.LE.64) THEN
            IHERSH = ISUBG(IC)
            RETURN
         ELSEIF (IC.EQ.89) THEN
            IHERSH = 683
            RETURN
         ELSEIF (IC.EQ.90) THEN
            IHERSH = 684
            RETURN
         ELSEIF (IC.EQ.121) THEN
            IHERSH = 685
            RETURN
         ELSEIF (IC.EQ.122) THEN
            IHERSH = 686
            RETURN
         ENDIF
C
C All clear ... a normal character is required
C
         IF (CKEY.EQ.'6'.OR. CKEY.EQ.'I' .OR. CKEY.EQ.'J') THEN
            JFONT = 110
         ELSE
            JFONT = 103
         ENDIF
      ELSEIF (CKEY.EQ.'7') THEN
C
C ZapfDingbats
C
         IHERSH = 254
         RETURN
      ELSEIF (CKEY.EQ.'9') THEN
C
C Special characters
C
         IHERSH = 254
         RETURN
      ELSEIF (CKEY.EQ.'K') THEN
C
C Symbol font
C
         IF (IC.GE.32 .AND. IC.LE.126) THEN
            IHERSH = ISYMB(IC)
         ELSE
            IHERSH = 254
         ENDIF
         RETURN
      ELSE
         RETURN
      ENDIF
C
C Return a normal character from now on
C
      IF (IC.GE.97 .AND. IC.LE.122) THEN
C
C a to z (97 to 122)
C
         IF (JFONT.EQ.102) THEN
            IHERSH = 2601
         ELSEIF (JFONT.EQ.103) THEN
            IHERSH = 627
         ELSEIF (JFONT.EQ.106) THEN
            IHERSH = 3101
         ELSEIF (JFONT.EQ.107) THEN
            IHERSH = 3151
         ELSEIF (JFONT.EQ.110) THEN
            IHERSH = 2127
         ENDIF
         IHERSH = IHERSH + IC - 97
      ELSEIF (IC.GE.65 .AND. IC.LE.90) THEN
C
C A to Z (65 to 90)
C
         IF (JFONT.EQ.102) THEN
            IHERSH = 2501
         ELSEIF (JFONT.EQ.103) THEN
            IHERSH = 527
         ELSEIF (JFONT.EQ.106) THEN
            IHERSH = 3001
         ELSEIF (JFONT.EQ.107) THEN
            IHERSH = 3051
         ELSEIF (JFONT.EQ.110) THEN
            IHERSH = 2027
         ENDIF
         IHERSH = IHERSH + IC - 65
      ELSEIF (IC.GE.48 .AND. IC.LE.57) THEN
C
C 0 to 1 (48 to 57)
C
         IF (JFONT.EQ.102) THEN
            IHERSH = 2700
         ELSEIF (JFONT.EQ.103) THEN
            IHERSH = 2700
         ELSEIF (JFONT.EQ.106) THEN
            IHERSH = 3200
         ELSEIF (JFONT.EQ.107) THEN
            IHERSH = 3250
         ELSEIF (JFONT.EQ.110) THEN
            IHERSH = 2700
         ENDIF
         IHERSH = IHERSH + IC - 48
      ELSEIF (IC.GE.33 .AND. IC.LE.47) THEN
C
C ! to / (33 to 47)
C
         IHERSH = ISUB1(IC)
      ELSEIF (IC.GE.58 .AND. IC.LE.64) THEN
C
C : to @ (58 to 64)
C
         IHERSH = ISUB2(IC)
      ELSEIF (IC.GE.91 .AND. IC.LE.96) THEN
C
C [ to ` (91 to 96)
C
         IHERSH = ISUB3(IC)
      ELSEIF (IC.GE.123 .AND. IC.LE.126) THEN
C
C { to ~ (123 to 126)
C
         IHERSH = ISUB4(IC)
      ENDIF
C
C Finally trap any undefined characters as boxes
C
      IF (IHERSH.LT.0 .OR. IHERSH.GT.3962) IHERSH = 254
      END
C
C
      SUBROUTINE LHERSH (IFONT, IVERT, IX, IX_END, IY, IY_END, LENGTH,
     +                   ANGLE, SIZE, SLANT, STRNG, SYMBOL)
C
C ACTION : Return the length, height, etc. of a character string
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 26/9/96
C          05/11/2000 Created off-screen graphics region to avoid
C                     enlarging the metafile
C
C          IFONT = FONT (102 or 106)
C          IVERT = vertical height of characters
C          IX, IY = starting coordinates
C          IX_END, IY_END = final coordinates if plotted
C          LENGTH = length of character string if plotted
C          ANGLE, SIZE, SLANT = character dimensions
C          STRNG = character string
C          SYMBOL = vector of keys
C
      IMPLICIT   NONE
      INTEGER    IFONT, IVERT, IX, IX_END, IY, IY_END, LENGTH
      INTEGER    I, IH, IH_END, IV, IV_END, L, L1, L2
      INTEGER    IASCII, IHERSH
      INTEGER    ICOLOR, NXPIX, NYPIX
      PARAMETER (ICOLOR = 0, NXPIX = 50, NYPIX = 50)
      INTEGER    LEN200
      INTEGER    K, REGIONID, WIDTH, HEIGHT  
      INTEGER    CREATE_GRAPHICS_REGION, DELETE_GRAPHICS_REGION
      DOUBLE PRECISION ANGLE, SIZE, SLANT
      DOUBLE PRECISION  ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION SIZE1
      DOUBLE PRECISION RESUL, XDIFF, YDIFF
      CHARACTER  STRNG*(*), SYMBOL*(*)
      CHARACTER  C1*1, K1*1
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      EXTERNAL   LEN200, IHERSH
      EXTERNAL   SET_TEXT_ATTRIBUTE$, DRAW_HERSHEY$  
      EXTERNAL   CREATE_GRAPHICS_REGION, DELETE_GRAPHICS_REGION
      INTRINSIC  NINT, DBLE, SQRT, ICHAR
C
C Stop here if string is blank
C
      IF (STRNG.EQ.BLANK) RETURN
C
C Create an off screen graphics region
C
      K = 1
      REGIONID = K
      WIDTH = 1000
      HEIGHT = 200
      K = CREATE_GRAPHICS_REGION (REGIONID, WIDTH, HEIGHT)
C
C Initialise IX_END, IY_END, etc.
C
      IX_END = IX
      IY_END = IY
      LENGTH = 0
C
C Calculate the height
C
      IH = NXPIX
      IV = NYPIX
      L = 254
      CALL SET_TEXT_ATTRIBUTE$(IFONT, SIZE, ZERO, ZERO)
      CALL DRAW_HERSHEY$(L, IH, IV, ICOLOR, IH_END, IV_END)
      IVERT = IH_END - IH
C
C Draw an invisible string off-screen to calculate IX_END, IY_END
C
      L1 = 1
      L2 = LEN200(STRNG)
      DO I = L1, L2
         C1 = STRNG(I:I)
         K1 = SYMBOL(I:I)
         IASCII = ICHAR(C1)
         L = IHERSH(IASCII, IFONT, K1)
         IH = NXPIX
         IV = NYPIX
         IF (K1.EQ.'1' .OR. K1.EQ.'2' .OR. K1.EQ.'4' .OR.
     +       K1.EQ.'5') THEN
             SIZE1 = 0.75D+00*SIZE
         ELSE
            SIZE1 = SIZE
         ENDIF
         CALL SET_TEXT_ATTRIBUTE$(IFONT, SIZE1, ANGLE, SLANT)
         CALL DRAW_HERSHEY$(L, IH, IV, ICOLOR, IH_END, IV_END)
         IX_END = IX_END + IH_END - NXPIX
         IY_END = IY_END + IV_END - NYPIX
      ENDDO
C
C Calculate the length
C
      XDIFF = DBLE(IX_END - IX)
      YDIFF = DBLE(IY_END - IY)
      RESUL = SQRT(XDIFF**2 + YDIFF**2)
      LENGTH = NINT(RESUL)
C
C Delete the off screen graphics region
C
      K = DELETE_GRAPHICS_REGION (REGIONID)
      END
C
C
