C
C
      SUBROUTINE HIST01 (N, NH, NUMBER,
     +                   E, X, XH, Y, YH,
     +                   GSAVE)
C
C ACTION : Supply X, Y, E data then calculate and plot a histogram
C AUTHOR : W. G. Bardsley, University of manchester, U.K., 17/2/95
C ADVICE : E, X, Y, N are unchanged but XH, YH contain the histogram
C          in positions 1 to NUMBER, NUMBER = 0 if no calculations done
C          22/06/2004 extensively revised
C          11/11/2005 replaced GKS004 by GKS001 and X02AJF$ by X02AJFG
C          20/04/2007 added INTENTS
C          24/04/2009 improved menu
C          17/03/2010 added normalisation to area = 1
C          25/10/2012 replaced gks001 by gks004 to facilitate coloured bar charts
C
C               N: (input/unchanged) no. of histogram bins requested
C              NH: (input/unchanged) max. dimension of plotting arrays
C          NUMBER: (output) no. actual plotting points
C               E: (input/unchanged) error bar vertical spacing
C               X: (input/unchanged) centre of bins
C              XH: workspace for plotting
C               Y: (input/unchanged) height of bins
C              YH: workspace for plotting
C           GSAVE: (input/unchanged) unused
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: N, NH 
      INTEGER,          INTENT (OUT)   :: NUMBER
      DOUBLE PRECISION, INTENT (IN)    :: E(N), X(N), Y(N)
      DOUBLE PRECISION, INTENT (INOUT) :: XH(NH), YH(NH)
      LOGICAL,          INTENT (IN)    :: GSAVE
C
C Locals
C
      INTEGER    L1, L2, L3, L4
      PARAMETER (L1 = 1, L2 = 1, L3 = 0, L4 = 0)
      INTEGER    M1, M2, M3, M4
      PARAMETER (M1 = 0, M2 = 0, M3 = 0, M4 = 0)
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    I, ICOUNT, NHIST
      INTEGER    ICOLOR, IX, IY, LSHADE
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 0)
      INTEGER    NSTART, NTEXT, NUMOPT
      PARAMETER (NSTART = 6, NUMOPT = 9, NTEXT = NUMOPT + NSTART - 1)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      DOUBLE PRECISION PNT5, PNT7, ZERO, ONE, TWO, TEN
      PARAMETER (PNT5 = 0.5D+00, PNT7 = 0.7D+00, ZERO = 0.0D+00,
     +           ONE = 1.0D+00, TWO = 2.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION AREA, DELTA, DELTA1, DELTA2, DELTA3, DELTA4
      DOUBLE PRECISION XX3(N2), XX4(N2), YY3(N2), YY4(N2)
      DOUBLE PRECISION EPSI
      DOUBLE PRECISION X02AJFG
      CHARACTER (LEN = 12 ) FORM12, WORD12
      CHARACTER (LEN = 40 ) CIPHER, PTITLE, XTITLE, YTITLE
      CHARACTER (LEN = 100) LINE, TEXT(30)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    AREA1, IWARNU, REPEET
      EXTERNAL   LBOX01, FORM12
      EXTERNAL   PUTFAT, GKS004, PUTADV, PATCH2
      EXTERNAL   X02AJFG
      INTRINSIC  MIN, DBLE, SQRT
      SAVE       AREA1
      DATA       AREA1 / .FALSE. /
      DATA NUMBLD / 30*0 /
      DATA NUMPOS / NUMOPT*1 /
C
C Check the data
C
      NUMBER = N0
      IF (N.LT.N1) RETURN
      WORD12 = FORM12(N)  
      EPSI = TEN*SQRT(X02AJFG())
      DELTA3 = (X(N) - X(1))/(DBLE(N) - ONE)
      DELTA1 = (ONE - EPSI)*DELTA3
      DELTA2 = (ONE + EPSI)*DELTA3
      IWARNU = .FALSE.
      DO I = N2, N
         DELTA3 = X(I) - X(I - N1)
         IF (DELTA3.LE.ZERO) THEN
C
C X must be in increasing order
C
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         IF (DELTA3.LT.DELTA1 .OR. DELTA3.GT.DELTA2) IWARNU = .TRUE.
      ENDDO
      IF (IWARNU) THEN
C
C Bins must be equal widths centered on X
C
         WRITE (LINE,200)
         CALL PUTADV (LINE)
      ENDIF
      NHIST = NUMOPT - N1
      REPEET = .TRUE.
C
C Main loop
C
      DO WHILE (REPEET)
         IF (AREA1) THEN
            CIPHER = 'Relative frequencies (Area = 1)'
         ELSE
            CIPHER = 'Actual frequencies'    
         ENDIF   
         WRITE (TEXT,300) WORD12, CIPHER
         NUMBLD(1) = N4
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NHIST, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         IF  (NHIST.LT.NUMOPT - N2) THEN 
C            
C----------------------------------------------------------            
C
            IF (NHIST.EQ.1 .OR. NHIST.EQ.4) THEN
               NUMBER = N4*N + N1
            ELSEIF (NHIST.EQ.2 .OR. NHIST.EQ.5) THEN
               NUMBER = N3*N + N4*N + N1
            ELSEIF (NHIST.EQ.3 .OR. NHIST.EQ.6) THEN
               NUMBER = N3*N + N3*N + N4*N + N1
            ENDIF
            IF (NUMBER.GT.NH) THEN
               WRITE (LINE,400)
               CALL PUTFAT (LINE)
               IF (NH.GE.N4*N + N1) THEN
                  NHIST = N1
                  NUMBER = N4*N + N1
               ELSE
                  RETURN
               ENDIF
            ENDIF
            ICOUNT = N0
            DO I = N1, N
C
C Define delta values
C
               IF (I.EQ.N1) THEN
                  DELTA2 = PNT5*(X(I + N1) - X(I))
                  DELTA1 = DELTA2
               ELSEIF (I.EQ.N) THEN
                  DELTA1 = DELTA2
               ELSE
                  DELTA1 = DELTA2
                  DELTA2 = PNT5*(X(I + N1) - X(I))
               ENDIF
               IF (DELTA1.LE.ZERO .OR. DELTA2.LE.ZERO) THEN
                  WRITE (LINE,100) I
                  CALL PUTFAT (LINE)
                  RETURN
               ENDIF
               IF (NHIST.LE.N3) THEN
                  DELTA3 = DELTA1
                  DELTA4 = DELTA2
               ELSE
                  DELTA3 = PNT7*DELTA1
                  DELTA4 = PNT7*DELTA2
               ENDIF
C
C Create the left hand pair of coordinates
C
               ICOUNT = ICOUNT + N1
               XH(ICOUNT) = X(I) - DELTA3
               YH(ICOUNT) = ZERO
               ICOUNT = ICOUNT + N1
               XH(ICOUNT) = XH(ICOUNT - N1)
               YH(ICOUNT) = Y(I)
               IF (NHIST.NE.N1 .AND. NHIST.NE.N4) THEN
C
C Create the up-down error bar if required
C
                  ICOUNT = ICOUNT + N1
                  XH(ICOUNT) = X(I)
                  YH(ICOUNT) = Y(I)
                  ICOUNT = ICOUNT + N1
                  XH(ICOUNT) = X(I)
                  YH(ICOUNT) = Y(I) + E(I)
C
C Create the error bar cap if required
C
                  IF (NHIST.EQ.3 .OR. NHIST.EQ.6) THEN
                     ICOUNT = ICOUNT + N1
                     XH(ICOUNT) = X(I) - PNT5*MIN(DELTA3,DELTA4)
                     YH(ICOUNT) = YH(ICOUNT - N1)
                     ICOUNT = ICOUNT + N1
                     XH(ICOUNT) = X(I) + PNT5*MIN(DELTA3,DELTA4)
                     YH(ICOUNT) = YH(ICOUNT - N1)
                     ICOUNT = ICOUNT + N1
                     XH(ICOUNT) = X(I)
                     YH(ICOUNT) = YH(ICOUNT - N1)
                  ENDIF
C
C Create the up-down error bar if required
C
                  ICOUNT = ICOUNT + N1
                  XH(ICOUNT) = X(I)
                  YH(ICOUNT) = Y(I)
               ENDIF
C
C Create the right hand coordinates
C
               ICOUNT = ICOUNT + N1
               XH(ICOUNT) = X(I) + DELTA4
               YH(ICOUNT) = Y(I)
               ICOUNT = ICOUNT + N1
               XH(ICOUNT) = XH(ICOUNT - N1)
               YH(ICOUNT) = ZERO
            ENDDO
C
C Wrap round by joining back to first point
C
            ICOUNT = ICOUNT + N1
            XH(ICOUNT) = XH(1)
            YH(ICOUNT) = YH(1)
C
C Normalise if required
C           
            IF (AREA1) THEN
               PTITLE = 'Histogram Normalised to Area = 1'
               YTITLE = 'Relative Frequencies'
               DELTA = (X(N) + X(2) - TWO*X(1))/DBLE(N)              
               AREA = ZERO
               DO I = 1, N
                  AREA = AREA + DELTA*Y(I)
               ENDDO
               DO I = N1, NUMBER
                  IF (YH(I).GT.ZERO) YH(I) = YH(I)/AREA
               ENDDO      
            ELSE
               PTITLE = 'Histogram of Frequencies'
               YTITLE = 'Frequencies'   
            ENDIF  
            XTITLE = 'Bins'
C
C Plot the chosen histogram
C
            CALL GKS004 (L1, L2, L3, L4,
     +                   M1, M2, M3, M4,
     +                   NUMBER, NUMBER, N2, N2,
     +                   XH, XH, XX3, XX4,
     +                   YH, YH, YY3, YY4,
     +                   PTITLE, XTITLE, YTITLE,
     +                   GSAVE, GSAVE)
C            
C----------------------------------------------------------            
C     
         ELSEIF (NHIST.EQ.NUMOPT - N2) THEN
            AREA1 = .NOT.AREA1
            NHIST = 1
         ELSEIF (NHIST.EQ.NUMOPT - N1) THEN
            WRITE (TEXT,500)
            I = 25
            NUMBLD(1) = N1
            CALL PATCH2 (NUMBLD, I,
     +                   TEXT)
            NUMBLD(1) = N0  
            NHIST = 1          
         ELSEIF (NHIST.EQ.NUMOPT) THEN
            REPEET = .FALSE.
         ENDIF
      ENDDO  
C
C Format statements
C      
  100 FORMAT ('x is not in increasing order at point no.',I5)
  200 FORMAT (
     +'X-values should be equally spaced at centres of histogram bins')
  300 FORMAT (
     + 'Plotting histograms'
     +/
     +/'Number of bins:',1X,A
     +/'Y-axis type:',1X,A
     +/
     +/'Filled type'
     +/'Filled type plus error bars (using s)'
     +/'Filled type plus error bars with end caps (using s)'
     +/'Spaced type'
     +/'Spaced type plus error bars (using s)'
     +/'Spaced type plus error bars with end caps (using s)'
     +/'Normalise to Area = 1'
     +/'Help'
     +/'Cancel')
  400 FORMAT ('Too many bins requested for this histogram type')
  500 FORMAT (
     + 'Simfit Histogram and Bar Chart procedures'
     +/
     +/'1.`Histograms display observations of a continuous variable as'
     +/'  `frequencies in adjacent bins, usually to represent the shape'
     +/'  `of an underlying probability density function.'
     +/'2.`Bar charts do not necessarily represent frequencies as with'
     +/'  `histogram, but histograms can be displayed as bar charts.'
     +/'3.`When guessing the shape of a distribution from a histogram,'
     +/'  `note that the shape depends on the number of bins, sample'
     +/'  `size, and whether values outside the range are either'
     +/'  `discarded, or simply added to the extreme bins.'
     +/'4.`Error bars in histograms should indicate the robustness of'
     +/'  `the frequencies as indicators of the actual probabilities.' 
     +/'  `If this has not been estimated independently, then twice the'
     +/'  `square root of the frequency can be used as a very very'
     +/'  `rough Poisson approximation. Error bars in bar charts would'
     +/'  `usually be confidence limits when the bars represent means.'
     +/'5.`When distributions have been fitted, choosing [Advanced]'
     +/'  `allows additional plot files with best fit pdf(x) data to be'
     +/'  `overlayed on histograms normalised to Area = 1, as the'
     +/'  `X-coordinates of the bins correspond to the sample range.'
     +/'6.`To colour the bins choose [Advanced] then edit as follows.'
     +/'  `Choose [Data]: change line-type for data set 1 to the filled'
     +/'  `polygon type, and line-type for data set 2 to solid line.' 
     +/'  `Choose [Colour]: select filled polygon and line colour.')
      END
C
C
