c
c
      subroutine hnplot (isend, nvec,
     +                   xvec)
c
c action: half normal and normal plots
c author: w.g.bardsley, university of manchester, u.k., 19/11/2002
c         30/09/2003 revised
c         11/10/2004 added p to plot title under all circumstances
c         15/11/2005 changed calls to NAG to calls to NAGSUB
c         23/01/2006 deleted nmax and made x1 and y1 allocatable 
c         19/08/2006 made p displayed only if p > 0.05 
c         20/04/2007 added intents
c         05/01/2010 plot circles if nvec =< 20 but dots if nvec > 20 
c
c         isend: (input/unchanged) as follows:
c                 isend = 1: half-normal
c                 isend = 2: normal
c          nvec: (input/unchanged) size of vector (nvec > 3)
c          xvec: (input/unchanged) vector to be plotted
c
      implicit   none
c
c arguments
c
      integer,          intent (in) :: isend, nvec
      double precision, intent (in) :: xvec(nvec)
c
c local allocatable workspaces
c
      double precision, allocatable :: x1(:), y1(:)
c
c locals
c
      integer    i, ierr, ifail, npts
      integer    l1, l2, l3, l4, m1, m2, m3, m4, n1, n2, n3, n4
      parameter (l1 = 0, l2 = 1, l3 = 0, l4 = 0, m2 = 0, m3 = 0, m4 = 0,
     +           n2 = 2, n3 = 0, n4 = 0)
      double precision a, b, c, dn, p, res(20), r, rtol, t
      double precision x2(2), x3(2), x4(2)
      double precision y2(2), y3(2), y4(2)
      double precision g01fafg, g01ebfg, x02amfg
      double precision zero, one, two, three, four, eight, nine
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00,
     +           three = 3.0d+00, four = 4.0d+00, eight = 8.0d+00,
     +           nine = 9.0d+00)
      double precision pnt05
      parameter (pnt05 = 0.05d+00)
      character  ptitle*60, xtitle*50, ytitle*50
      character  line*100
      character  tail*1
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   gks004, putfat, nxsortg
      external   g02cafg, g01fafg, g01ebfg, x02amfg
      intrinsic  dble, sqrt
c
c check input data
c
      if (nvec.lt.3) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspace
c
      ierr = 0
      if (allocated(x1)) deallocate(x1, stat = ierr)
      if (ierr.ne.0) return
      allocate(x1(nvec), stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y1)) deallocate(y1, stat = ierr)
      if (ierr.ne.0) return
      allocate(y1(nvec), stat = ierr)
      if (ierr.ne.0) return
c
c calculate data for plotting
c
      npts = nvec
      n1 = npts
      dn = dble(npts)
      if (isend.eq.1) then
         a = dn + one/two
         b = two*dn + nine/eight
         do i = 1, npts
            if (xvec(i).lt.zero) then
               y1(i) = - xvec(i)
            else
               y1(i) = xvec(i)
            endif
         enddo
         write (xtitle,200)
         write (ytitle,300)
      elseif (isend.eq.2) then
         a = - three/eight
         b = dn + one/four
         do i = 1, npts
            y1(i) = xvec(i)
         enddo
         write (xtitle,400)
         write (ytitle,500)
      else
         deallocate(x1, stat = ierr)
         deallocate(y1, stat = ierr)
         write (line,600)
         call putfat (line)
         return
      endif
c
c assign plotting symbol (circles if =< 20,  or . if > 20)
c
      if (npts.le.20) then
         m1 = 5
      else
         m1 = 1
      endif
c
c sort
c
      call nxsortg (npts,
     +              y1)
c
c generate x
c
      tail = 'L'
      c = zero
      do i = 1, npts
         c = c + one
         p = (a + c)/b
         ifail = 0
         x1(i) = g01fafg(tail, p, ifail)
         if (ifail.ne.0) then
            deallocate(x1, stat = ierr)
            deallocate(y1, stat = ierr)
            write (line,700) ifail, i
            call putfat (line)
            return
         endif
      enddo
c
c best fit line
c
      ifail = 0
      call g02cafg(npts, x1, y1, res, ifail)
      if (ifail.ne.0) then
         deallocate(x1, stat = ierr)
         deallocate(y1, stat = ierr)
         write (line,800) ifail
         call putfat (line)
         return
      endif
      a = res(6)
      b = res(7)
      x2(1) = x1(1)
      y2(1) = a*x2(1) + b
      x2(2) = x1(npts)
      y2(2) = a*x2(2) + b
c
c correlation
c
      rtol = 1.0d+09*x02amfg()
      r = res(5)
      a = dn - two
      b = one - r*r
      if (b.lt.rtol) b = rtol
      t = r*sqrt(a/b)
      tail = 'S'
      ifail = 0
      p = g01ebfg(tail, t, a, ifail)
      if (ifail.ne.0) then
         deallocate(x1, stat = ierr)
         deallocate(y1, stat = ierr)
         write (line,900) ifail
         call putfat (line)
         return
      endif
c
c define plot title
c
      if (isend.eq.1) then
         if (p.ge.pnt05) then
            write (ptitle,1000) r, p
         else
            write (ptitle,1100) r
         endif
      else
         if (p.ge.pnt05) then
            write (ptitle,1200) r, p
         else
            write (ptitle,1300) r
         endif
      endif
      call gks004 (l1, l2, l3, l4, m1, m2, m3, m4, n1, n2, n3, n4,
     +             x1, x2, x3, x4, y1, y2, y3, y4,
     +             ptitle, xtitle, ytitle,
     +             axes, gsave)
c
c deallocate workspaces
c
      deallocate(x1, stat = ierr)
      deallocate(y1, stat = ierr)
c
c format statements
c
  100 format ('Insufficient data for (half) normal plot')
  200 format ('Half-Normal Order Statistic Medians')
  300 format ('Ordered Absolute Values')
  400 format ('Normal Order Statistic Medians')
  500 format ('Ordered Values')
  600 format ('ISEND out of range in call to HNPLOT')
  700 format ('IFAIL =',i3,' from G01FAF/HNPLOT at score',i6)
  800 format ('IFAIL =',i3,' from G02CAF/HNPLOT')
  900 format ('IFAIL =',i3,' from G01EBF/HNPLOT')
 1000 format ('Half-Normal Plot: r =',f8.4,', p =',f7.4)
 1100 format ('Half-Normal Plot: r =',f8.4)
 1200 format ('Normal Plot: r =',f8.4,', p =',f7.4)
 1300 format ('Normal Plot: r =',f8.4)
      end
c
c
