c
c
      subroutine infogs (isend,
     +                   line)
c
c action: confirm file creation from Ghostscript or otherwise
c author: w.g.bardsley, university of manchester, u.k., 29/07/2007
c         14/10/2010 changed text to explain about the supressed -I argument
c
c isend: (input/unchanged) left in for future development
c  line: (input/unchanged) does not have to be a filename unless isend = 2
c
      implicit none
c
c arguments
c          
      integer,             intent (in) :: isend
      character (len = *), intent (in) :: line
c
c locals
c      
      integer    i, ntemp, numbld (30)
      character  fname*1024, text(30)*100, trim80*80
      character  full_path*1024, sim256*1024
      character  blank*1, quote*1
      parameter (blank = ' ', quote = '"')
      logical    there, read_only
      external   attrib, patch2, infofl, triml1, sim256, addstr, trim80
      intrinsic  index
      if (isend.eq.2) then
c
c isend = 2: action
c        
         fname = line
c
c remove quotes if any
c         
         i = index(fname,quote)
         if (i.gt.0) then
            fname(i:i) = blank
            i = index(fname,quote)
            if (i.gt.0) fname(i:i) = blank  
         endif   
         call triml1 (fname)
c
c see if the file exists
c          
         call attrib (fname,
     +                there, read_only)
         if (there) then
             if (read_only) then
                 ntemp = 6
                 call infofl (ntemp,
     +                        fname)
             else
                ntemp = 2
                call infofl (ntemp,
     +                       fname)
                full_path = sim256('w_out.tmp')
                call addstr (full_path, fname)
            endif
         else  
            write (text,100) trim80(fname)
            ntemp = 24
            do i = 1, ntemp
               numbld(i) = 0
            enddo
            numbld(3) = 1
            numbld(5) = 1
            numbld(18) = 1   
            call patch2 (numbld, ntemp,
     +                   text)         
         endif
      else
c
c isend not 2 so no action in this version
c        
         return   
      endif 
c
c format statement
c        
  100 format (
     + 'Ghostscript could not create the file'
     +/
     +/a
     +/
     +/'Conclusion:'
     +/
     +/'If you are trying to transform a long sequence of files, then'
     +/'note that some installations of Ghostscript may only support'
     +/'limited sequences and you may have to use small groups, or'
     +/'even restrict transformation to single files. Otherwise, then' 
     +/'Ghostscript is not configured properly.'
     +/
     +/'Use [Configure] from the main Simfit menus to re-configure GS'
     +/'but note that the paths for the -I Ghostscript argument are'
     +/'not supported any more. Use [Configure] then [Help] to read'
     +/'the file configure.txt for more details.'
     +/
     +/'Advice:'
     +/'1)`Read the Ghostscript documentation'
     +/'2)`Read about Items 20 and 21 in configure.txt'         
     +/'3)`Note that GS -I Paths are not used by Simfit any more.'
     +/'4)`Try using the comand line with the argument indicated by the'
     +/'  `procedure control but without then with a GS paths -I string'
     +/'6)`Check out the setting for any GS environment variables') 
      end
c
c        