C
C
      SUBROUTINE INTYPE$(ITYPE, NOUT, NX, NY, N100,
     +                   X1, X2, X3, Z,
     +                   ABORT)
C
C ACTION: Create a 3-D Plotting file interactively
C ACTION: Type in plotting data
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         17/08/2001 Developed from TYPEIN$
C         13/05/2007 added INTENTS
C         14/06/2010 replaced getim1 by getjm1 and gettxt by getstr
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: NOUT, N100 
      INTEGER,          INTENT (OUT) :: ITYPE, NX, NY 
      DOUBLE PRECISION, INTENT (OUT) :: X1(N100), X2(N100), X3(N100),
     +                                  Z(N100,N100)
      LOGICAL,          INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NSTART, NTEXT, NTOP, NUMOPT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, LSHADE = 1)
      INTEGER    ISEND, N0, N1, N2, N5, N20
      PARAMETER (ISEND = 1, N0 = 0, N1 = 1, N2 = 2, N5 = 5, N20 = 20)
      INTEGER    NUMBLD(N20), NUMPOS(N5)
      INTEGER    NCOLS, NROWS
      INTEGER    I, J, L, LEN200, NUMDEC
      CHARACTER  FNAME*1024
      CHARACTER  LINE*100, TEXT(30)*100, TITLE*80
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, GETMAT, GETSTR$, OFILES, GETJM1, LEN200 
      INTRINSIC  MIN
      SAVE       NCOLS, NROWS
      SAVE       TITLE
      DATA       NUMBLD / N20*0 /
      DATA       NUMPOS / N5*1 /
      DATA       NCOLS, NROWS / 3, 5 /
      DATA       TITLE / '3D Plot' /
C
C Initialise
C
      ABORT = .TRUE.
      ITYPE = N0
      NX = N0
      NY = N0
C
C Decision
C
      WRITE (TEXT,100)
      NUMBLD(1) = N1
      NSTART = 13
      NUMOPT = 4  
      NTEXT = NSTART + NUMOPT - 1
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      ITYPE = NUMDEC
      IF (NUMDEC.LT.NUMOPT) THEN
C
C Open a file and get the data title
C
         CALL OFILES (ISEND, NOUT,
     +                FNAME,
     +                ABORT)
         IF (ABORT) THEN
            CLOSE (UNIT = NOUT)
            RETURN
         ENDIF
         L = MIN(LEN200(FNAME),40)
         LINE = 'A sensible title for this plotting data'
         CALL GETSTR$ (LINE, TITLE)
      ELSE
C
C o/w return
C
         ABORT = .TRUE.
         RETURN
      ENDIF
C
C Get the number of rows required then call GETMAT or GETVEC
C
      IF (NUMDEC.EQ.1) THEN
C
C 3-D BARCHART
C
         NTOP = 20
         IF (NROWS.GT.NTOP) NROWS = NTOP
         LINE = 'The number of x-values (divisions) required'
         CALL GETJM1 (N2, NROWS, NTOP, 
     +                LINE)
         IF (NCOLS.GT.NTOP) NCOLS = NTOP
         LINE = 'The number of y-values (divisions) required'
         CALL GETJM1 (N2, NCOLS, NTOP,
     +                LINE)
         LINE = FNAME(N1:L)//' ... x-down, y-across'
         CALL GETMAT (NCOLS, N100, NROWS, Z,
     +                LINE)
      ELSE
C
C 3-D Cluster or space curve plot
C
         NTOP = N100
         IF (NROWS.GT.NTOP) NROWS = NTOP
         LINE = 'The number of x,y,z-triples required'
         CALL GETJM1 (N1, NROWS, NTOP,
     +                LINE)
         LINE = FNAME(N1:L)//' ... 1=x,2=y,3=z'
         NCOLS = 3
         CALL GETMAT (NCOLS, N100, NROWS,
     +                Z,
     +                LINE)
      ENDIF
C
C Create the data matrix
C
      WRITE (NOUT,'(A)') TITLE
      WRITE (NOUT,'(2I6)') NROWS, NCOLS
      DO I = N1, NROWS
         WRITE (NOUT,200) (Z(I,J), J = 1, NCOLS)
         X1(I) = Z(I,1)
         X2(I) = Z(I,2)
         X3(I) = Z(I,3)
      ENDDO
      WRITE (NOUT,'(I6)') N1
      WRITE (NOUT,'(A)') 'Default line'
      CLOSE (UNIT = NOUT)
      NX = NROWS
      NY = NCOLS
      ABORT = .FALSE. 
C
C Format statements
C      
  100 FORMAT (
     + 'Creating a plot interactively'
     +/
     +/'You can now type in data to create a data file containing your'
     +/'coordinates for 3-D plotting. Only small files can be prepared.'
     +/'For 3-D barcharts you create a matrix with n rows and m columns'
     +/'where a(i,j) is the barchart height at x = i, y = j.'
     +/'For 3-D clusters you create a n by 3 matrix with columns x, y'
     +/'and z = f(x,y) where x, y and z are in arbitrary order.'
     +/'For 3-D space curves you create a n by 3 matrix with columns'
     +/'x = x(t), y = y(t) and z = z(t) for t(i) = t-start + i*t-delta.'
     +/'You can use the file created for the normal plotting options.'
     +/
     +/'3-D barchart (n by m matrix)'
     +/'3-D scattergram (n by 3 x,y,z-matrix)'
     +/'3-D space curve (n by 3 x,y,z-matrix)'
     +/'Cancel')
  200 FORMAT (1P,20E13.5)
      END
C
C