c
c
      subroutine ispsok$(scale_d, scale_1, size_d, size_1, thick_d,
     +                   thick_1, xoff_d, xoff_1, yoff_d, yoff_1,
     +                   clipit, font, orient)
c
c action: check that w_ps.cfg, etc. values in WGB2PS$ are the defaults
c author: w.g.bardsley, university of manchester, u.k., 01/04/2010
c     
      implicit none
c
c arguments
c      
      double precision,    intent (in) :: scale_d, scale_1, 
     +                                    size_d,  size_1,
     +                                    thick_d, thick_1,
     +                                    xoff_d,  xoff_1,
     +                                    yoff_d,  yoff_1
      character (len = *), intent (in) :: clipit, font, orient 
c
c locals
c  
      integer    i, icolor, icount
      integer    n
      parameter (n = 8)
      double precision bot, frac, top   
      double precision pnt25, pnt5, two, three, five
      parameter (pnt25 = 0.25d+00, pnt5 = 0.5d+00, 
     +           two = 2.0d+00, three = 3.0d+00, five = 5.0d+00)
      character  text*100, word12*12, symbol12*12
      character  blank*1
      parameter (blank = ' ')
      logical    ok(n)       
      logical    first
      external   table1, triml1
      save    first
      data    first / .true. /
      if (first) then
c
c only active first time called
c        
         first = .false.
         do i = 1, n
            ok(i) = .true.                           
         enddo  
c
c overall graph scale +/- 25%
c         
         frac = pnt25*scale_d
         if (scale_1.lt.scale_d - frac .or.
     +       scale_1.gt.scale_d + frac) ok(1) = .false. 
c
c font size +/- 50% 
c     
         bot = pnt5*size_d
         top = two*size_d 
         if (size_1.lt.bot .or.
     +       size_1.gt.top) ok(2) = .false.
c
c line thickness from quarter to three times
c     
         if (thick_1.lt.pnt25*thick_d .or.
     +       thick_1.gt.three*thick_d) ok(3) = .false.
c
c x offset +/- two
c     
         if (xoff_1.lt.xoff_d - two .or.
     +       xoff_1.gt.xoff_d + two) ok(4) = .false.  
c
c y offset +/- five
c     
         if (yoff_1.lt.yoff_d - five .or.
     +       yoff_1.gt.yoff_d + five) ok(5) = .false. 
c
c stretch/clip/slide
c                
         if (clipit.ne.'Suppressed') ok(6) = .false.
c
c font family
c           
         if (font.ne.'Helvetica' .and.
     +       font.ne.'Times-Roman' .and.
     +       font.ne.'Courier') ok(7) = .false.
c
c plot orientation
c           
         if (orient.ne.'Portrait') ok(8) = .false.  
c
c add up bad items
c             
         icount = 0
         do i = 1, n
           if (.not.ok(i)) icount = icount + 1
         enddo
c
c finish if no bad items
c         
         if (icount.eq.0) return
c
c inform the user
c           
         icolor = 15  
         call table1 (icolor, 'OPEN')    
         write (text,100) 
         icolor = 4
         call table1 (icolor, text)
         icolor = 0
         call table1 (icolor, blank)
         do i = 1, n
            if (.not.ok(i)) then
               if (i.eq.1) then
                  write(word12,'(f12.2)') scale_1
                  call triml1 (word12)
                  write(symbol12,'(f12.2)') scale_d
                  call triml1 (symbol12)
                  write (text,101) word12, symbol12
               elseif (i.eq.2) then
                  write(word12,'(f12.2)') size_1
                  call triml1 (word12)
                  write(symbol12,'(f12.2)') size_d
                  call triml1 (symbol12)
                  write (text,102) word12, symbol12  
               elseif (i.eq.3) then 
                  write(word12,'(f12.2)') thick_1
                  call triml1 (word12)
                  write(symbol12,'(f12.2)') thick_d
                  call triml1 (symbol12)   
                  write (text,103) word12, symbol12  
               elseif (i.eq.4) then  
                  write(word12,'(f12.2)') xoff_1
                  call triml1 (word12)
                  write(symbol12,'(f12.2)') xoff_d
                  call triml1 (symbol12)  
                  write (text,104) word12, symbol12
               elseif (i.eq.5) then 
                  write(word12,'(f12.2)') yoff_1
                  call triml1 (word12)
                  write(symbol12,'(f12.2)') yoff_d
                  call triml1 (symbol12)     
                  write (text,105) word12, symbol12  
               elseif (i.eq.6) then  
                  word12 = clipit
                  call triml1 (word12)    
                  write (text,106) word12, 'Suppressed  ' 
               elseif (i.eq.7) then 
                  word12 = font
                  call triml1 (word12)   
                  write (text,107) word12, 'Helvetica   '  
               elseif (i.eq.8) then  
                  word12 = orient
                  call triml1 (word12)    
                  write (text,108) word12, 'Portrait    '    
               endif
               call table1 (icolor, text)  
            endif  
         enddo 
         call table1 (icolor, blank)
         icolor = 1
         write (text,109)
         call table1 (icolor,text)
         write (text,110)
         call table1 (icolor,text)
         write (text,111)
         call table1 (icolor,text)
         if (.not.ok(8)) then
            icolor = 4
            call table1 (icolor,blank)
            write (text,112)
            call table1 (icolor,text)
            write (text,113)
            call table1 (icolor,text)
         endif
         call table1 (icolor, 'CLOSE')
      endif
  100 format ('The PostScript control is not in default configuration')
  101 format ('    Scaling factor: ',a12,'... Default: ',a12)
  102 format ('         Font size: ',a12,'... Default: ',a12)
  103 format ('    Line thickness: ',a12,'... Default: ',a12)
  104 format ('          X-offset: ',a12,'... Default: ',a12)
  105 format ('          Y-offset: ',a12,'... Default: ',a12)
  106 format ('Stretch/clip/slide: ',a12,'... Default: ',a12)
  107 format ('              Font: ',a12,'... Default: ',a12)
  108 format ('       Orientation: ',a12,'... Default: ',a12)
  109 format ('You may consider restoring the default configuration to')      
  110 format ('ensure consistent plot dimensions, and use EDITPS to') 
  111 format ('translate, rotate, re-scale, print, etc. if required.') 
  112 format ('Portrait orientation is recommended, especially if')    
  113 format ('you intend to create stacked collages using EDITPS.')    
      end
c
c      