c
c
      subroutine lbplot$(n,
     +                   x, y,
     +                   ptitle, wordx, xtitle, ytitle)
c
c action: 2D plot with labels
c author: w.g.bardsley, university of manchester, U.K
c         derived from pca002 13/04/2005
c         08/07/2006 trapped n > nwords (where nwords =< nword1 in savegks.ins)  
c         20/04/2007 added intents      
c         05/06/2007 added fname and sim256
c         24/12/2007 added 'f$rotate.tmp'
c
c      n: (input/unchanged) no. points
c      x: (input/unchanged) x-coordinates
c      y: (input/unchanged) y-coordinates
c ptitle: (input/unchanged) plot title
c  wordx: (input/unchanged) (x,y)-labels
c xtitle: (input/unchanged) x-legend
c ytitle: (input/unchanged) y-legend
c
      implicit   none
c
c arguments
c
      integer,             intent (in) :: n
      double precision,    intent (in) :: x(n), y(n)
      character (len = *), intent (in) :: ptitle, wordx(n), xtitle,
     +                                    ytitle
c
c locals
c
      integer    i
      integer    ifail, nout, ntotal
      integer    nmax, nwords, n1, n2, n5
      parameter (nmax = 1, nwords = 2000, n1 = 1, n2 = 2, n5 = 5)
      integer    jfiles(nmax), lfiles(nmax), mfiles(nmax), nfiles
      double precision zero
      parameter (zero = 0.0d+00)
      character  filex*1024, fname*1024, title*80, sim256*1024
c
c--------------------------------------------------------------------------------
c THESE PARAMETERS MUST NOT BE TRANSLATED AS THEY ARE THE LABELS FILE FOR SIMPLOT
c-------------------------------------------------------------------------------- 
      character  labfil*12, rotate*12
      parameter (labfil = 'f$labels.tmp',
     +           rotate = 'f$rotate.tmp')
c----------------------------------------------------------------------------      

      character  files(nmax)*1024, line*100, titles(4)*80
      character  blank*1
      parameter (blank = ' ')
      logical    askif, there
      parameter (askif = .false.)
      external   getnou, gettmp, deleet, sim256
      external   smplot$, putfat$
      data       jfiles, lfiles, mfiles
     +         / nmax*0, nmax*0, nmax*1 /
c
c check and calculate ntotal
c
      if (n.lt.1) then
         return   
      elseif (n.gt.nwords) then
         write (line,100) nwords
         call putfat$ (line)
         return   
      else
         ntotal = n
      endif
c
c Open a temporary file and connect to a temporary unit
c
      call gettmp (ifail, filex)
      call getnou (nout)
c
c The file title identifies the file type to simplot
c---------------------------------------------------------------------------
c THIS NEXT LINE MUST NOT BE TRANSLATED AS IT INFORMS SIMPLOT TO PLOT LABELS
c---------------------------------------------------------------------------
      write (title,'(a)') '%simfitplotlabelsfile%'
c---------------------------------------------------------------------------      

      open (unit = nout, file = filex)
      write (nout,'(a)') title
      write (nout,'(i6,i3)') ntotal, n2
      do i = 1, ntotal
         write (nout,'(1p,e13.5)') x(i), y(i)
      enddo
      write (nout,'(i3)') n1
      write (nout,'(a)') 'Default Line'
      close (unit = nout)
c
c Create the actual labels file
c                         
      fname = sim256(labfil)
      call deleet (fname,
     +             askif, there)
      if (there) then 
         write (line,200)
         call putfat$ (line)
      else
         open (unit = nout, file = fname)
         do i = 1, ntotal
            write (nout,'(a)') wordx(i)
         enddo
         close (unit = nout)
      endif
c
c Create the move/rotate file
c                         
      fname = sim256(rotate)
      call deleet (fname,
     +             askif, there)
      if (there) then 
         write (line,300)
         call putfat$ (line)
      else
         open (unit = nout, file = fname)
         write (nout,'(a)') '%simfitrotatelabelsfile%'
         write (nout,'(2i6)') ntotal, n5
         do i = 1, ntotal
            write (nout,'(1p,5e13.5)') x(i), zero, y(i), zero, zero
         enddo
         close (unit = nout)
      endif
      
      nfiles = n1
      files(nfiles) = filex
      titles(1) = ptitle
      titles(2) = xtitle
      titles(3) = ytitle
      titles(4) = blank
      call smplot$(jfiles, lfiles, mfiles, nfiles,
     +             files, titles)
      call deleet (filex, 
     +             askif, there)   
c
c format statements
c     
  100 format ('Too many labels requested: maximum =',i6)
  200 format ('You must attrib -r f$labels.tmp then delete')
  300 format ('You must attrib -r f$rotate.tmp then delete')
      end
c
c
