C
C
      SUBROUTINE LIBFIL$(L, M, NFILES, NGRAFS, NIN,
     +                   NMAX, NPTS, NSAV,
     +                   NTYPE, NTYPE1, NTYPE2, NTYPE3, NY, NZ,
     +                   XMAX, XMIN, YMAX, YMAX3,
     +                   YMAX4, YMIN, YMIN3, YMIN4,
     +                   FNAME, FSAV, TITLE, TSAV,
     +                   ABORT, BARCAP, LIB_FILE, LOWER, UPPER,
     +                   VECTOR_FIELD, YAXIS)

      USE MODULE_SAVEGKS, ONLY : X, XH, XL, Y, YH, YL
C
C ACTION: Use a library file to read in a set of plotting files
C         Returns vector files FSAV(NFILES)
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         ABORT = .TRUE. if library file not usable
C         08/08/1996 Derived from VECFIL/PFILES$ and initialises some
C                    unrequired variables for consistency with PFILES$
C         03/09/1996 Added PSWARN
C         14/07/1997 win32 version
C         10/03/1998 Added VECTOR_FIELD
C         06/10/1998 added extra checks to make sure NIN is closed on exit
C         13/12/1998 removed KLINES, NUMSET, NMARK from argument list
C         29/11/2001 added VU2CHK and FNLIB
C         14/01/2007 added Simfit prefix if local files not found
C         19/01/2007 added INTENTS and protected against the use of prefix (1:l) when l = 0
C         19/07/2007 replaced SIMDIR by DEMDIR
C         24/07/2007 trapped blank lines
C         29/01/2008 removed X, ..., YL from arguments, added MODULE_SAVEGKS and call to GKSSAV$
C         02/08/2008 added call to ISITSF
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NGRAFS, NIN 
      INTEGER,             INTENT (INOUT) :: NMAX
      INTEGER,             INTENT (OUT)   :: NFILES, NPTS, NTYPE,
     +                                       NTYPE1, NTYPE2, NTYPE3,
     +                                       NY, NZ 
      INTEGER,             INTENT (INOUT) :: L(NGRAFS), M(NGRAFS), 
     +                                       NSAV(NGRAFS) 
      DOUBLE PRECISION,    INTENT (INOUT) :: XMAX, XMIN, YMAX,
     +                                       YMAX3, YMAX4, YMIN, YMIN3,
     +                                       YMIN4
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, FSAV(NGRAFS), TITLE,
     +                                       TSAV(NGRAFS)     
      LOGICAL,             INTENT (OUT)   :: ABORT 
      LOGICAL,             INTENT (INOUT) :: BARCAP(NGRAFS), LIB_FILE,
     +                                       LOWER(NGRAFS),
     +                                       UPPER(NGRAFS),
     +                                       VECTOR_FIELD,
     +                                       YAXIS(NGRAFS)     
C
C Locals
C     
      INTEGER    I, IOS, J, K, IADD1, LENSIM, LENTEM, NCOL, NROW
      INTEGER    LEN200
      INTEGER    K0, K1, K2, K3, K4, K6
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K6 = 6)
      DOUBLE PRECISION A, B, C, D, G, H, RTOL, TEMP, X02AME$
      CHARACTER  BLANK*1, BSLASH*1, LINE*80, FNLIB*1024, TMPFIL*1024,
     +           SIMFIT*1024
      PARAMETER (BLANK = ' ', BSLASH = '\')
      LOGICAL    YES
      INTRINSIC  ABS, INDEX
      EXTERNAL   PSWARN, ISITLF, DEMDIR, LEN200, TRIML1, ISITSF
      EXTERNAL   W95_TXT2FN
      EXTERNAL   CHECKF, OFILES$, PUTADV$, PUTFAT$, X02AME$, MAXMIN$,
     +           VU2CHK, GKSSAV$
C
C First initialise ABORT, NFILES, etc.
C
      ABORT = .TRUE.
      NFILES = K0
      NPTS = K0
      NTYPE = K1
      NTYPE1 = K0
      NTYPE2 = K0
      NTYPE3 = K0
      NY = K0
      NZ = K0
      RTOL = 1.0D+09*X02AME$()
C
C Read in from a supposed library file
C
      CLOSE (UNIT = NIN)
      CALL OFILES$(K3, NIN,
     +             FNAME,
     +             ABORT)
      CLOSE (UNIT = NIN)
      FNLIB = FNAME
      IF (FNAME.EQ.BLANK) ABORT = .TRUE.
      IF (ABORT) RETURN
      CALL ISITLF (FNAME,
     +             LIB_FILE)
      IF (.NOT.LIB_FILE) RETURN
      ABORT = .TRUE.
      OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
      IF (IOS.NE.K0) GOTO 60
      TITLE = BLANK
      READ (NIN,100,END=60,ERR=60,IOSTAT=IOS) TITLE
      IF (IOS.NE.K0) GOTO 60
      CALL PSWARN (TITLE)
C
C Disconnect, check, then reconnect and wind on
C
      CLOSE (UNIT = NIN)
      CALL CHECKF (FNAME, TITLE,
     +             ABORT)
      IF (ABORT) THEN
         RETURN
      ELSE
         OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
         READ (NIN,100,END=60,ERR=60,IOSTAT=IOS) TITLE
      ENDIF
      ABORT = .TRUE.
      IADD1 = K0
      DO I = K1, NGRAFS
         READ (NIN,100,END=20,ERR=20,IOSTAT=IOS) FNAME
         IF (IOS.EQ.K0) THEN
            IF (FNAME.EQ.BLANK) THEN
               GOTO 20
            ELSE    
               CALL W95_TXT2FN (FNAME,
     +                          ABORT)
               IF (ABORT) THEN
                  CALL PUTFAT$(
     +'LIBFIL$ error: Filename is not consistent with the OS')
                  WRITE (LINE,200) I + K1
                  CALL PUTADV$(LINE)
                  GOTO 60
               ENDIF
            ENDIF   
         ELSE
            GOTO 20      
         ENDIF         
         IADD1 = IADD1 + K1
         FSAV(IADD1) = FNAME         
      ENDDO
   20 CONTINUE
      CLOSE (UNIT = NIN)
      IF (IADD1.EQ.K0) THEN
         CALL PUTFAT$(
     +'LIBFIL$ error: There are no plotting files in the library file')
         CALL VU2CHK (FNLIB)
         ABORT = .TRUE.
         RETURN
      ENDIF
C
C IADD1 character variables have now been read off the file
C                                      
      CALL DEMDIR (LENSIM,
     +             SIMFIT)      
      DO I = K1, IADD1
         INQUIRE (FILE = FSAV(I), EXIST = YES, IOSTAT = IOS)
         IF (IOS.NE.K0) GOTO 40 
         IF (.NOT.YES) THEN
            IF (LENSIM.GT.K0 .AND. INDEX(FSAV(I),BSLASH).LE.K0) THEN
               TMPFIL = FSAV(I)
               CALL TRIML1 (TMPFIL)  
               LENTEM = LEN200 (TMPFIL)
               FSAV(I) = SIMFIT(K1:LENSIM)//TMPFIL(K1:LENTEM)
               INQUIRE (FILE = FSAV(I), EXIST = YES, IOSTAT = IOS)
               IF (IOS.NE.K0) GOTO 40                                              
            ENDIF  
         ENDIF
C
C Check it is a simfit data file
C         
         IF (YES) THEN
            CALL ISITSF (K, J,
     +                   FSAV(I))  
            IF (J.LE.K0 .OR. K.LE.K0) YES = .FALSE.
         ENDIF     
         IF (YES) THEN
           CLOSE (UNIT = NIN)
           OPEN (UNIT = NIN, FILE = FSAV(I))
           READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) TITLE
           IF (IOS.NE.K0) GOTO 40
           READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) J, K
           IF (IOS.NE.K0) GOTO 40
           IF (J.GT.NMAX) THEN
              NMAX = J
              CALL GKSSAV$(K2, NMAX,
     +                     ABORT)
              IF (ABORT) GOTO 40
           ENDIF                      
           IF (J.GT.K0 .AND. (K.EQ.K2 .OR.
     +                        K.EQ.K3 .OR.
     +                        K.EQ.K4 .OR.
     +                        K.EQ.K6)) THEN
              IF (J.GT.NMAX) THEN
                 IOS = K1
                 CALL PUTFAT$(
     +'LIBFIL$ error: Maximum array dimension exceeded in library file')
              ELSE
                 NFILES = NFILES + K1
                 FSAV(NFILES) = FSAV(I)
                 YAXIS(NFILES) = .TRUE.
              ENDIF
           ELSE
              IOS = K1
              CALL PUTFAT$(
     +'LIBFIL$ error: Illegal file referenced in library file')
           ENDIF
         ELSE
            IOS = K1
            CALL PUTFAT$(
     +'LIBFIL$ error: File referenced in library file not found')
         ENDIF
   40    CONTINUE
         IF (IOS.NE.K0) THEN
            WRITE (LINE,200) I + K1
            CALL PUTADV$(LINE)
            ABORT = .TRUE.
            CLOSE (UNIT = NIN)
            GOTO 60
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
C
C Read data off all files
C
      IF (NFILES.GT.K0) THEN
         IADD1 = K0
         DO I = K1, NFILES
            IADD1 = IADD1 + K1
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FSAV(I))
            READ (NIN,100,END=60,ERR=60,IOSTAT=IOS) TSAV(I)
            IF (IOS.NE.K0) GOTO 60
            READ (NIN,*,END=60,ERR=60,IOSTAT=IOS) NROW, NCOL
            IF (IOS.NE.K0) GOTO 60
            IF (NCOL.EQ.K2 .OR. NCOL.EQ.K3) THEN
C
C Read X, Y ... Define YMAX3, YMAX4, YMIN3, YMIN4
C
               NTYPE = K1
               NTYPE1 = NTYPE1 + K1
               NPTS = K0
               DO J = K1, NROW
                  READ (NIN,*,END=60,ERR=60,IOSTAT=IOS) A, B
                  IF (IOS.NE.K0) GOTO 60
                  NPTS = NPTS + K1
                  X(NPTS) = A
                  Y(NPTS) = B
                  IF (ABS(A).GT.RTOL) THEN
                     TEMP = B/A
                     IF (TEMP.GT.YMAX3) YMAX3 = TEMP
                     IF (TEMP.LT.YMIN3) YMIN3 = TEMP
                  ENDIF
                  IF (ABS(B).GT.RTOL) THEN
                     TEMP = A/B
                     IF (TEMP.GT.YMAX4) YMAX4 = TEMP
                     IF (TEMP.LT.YMIN4) YMIN4 = TEMP
                  ENDIF
               ENDDO
            ELSEIF (NCOL.EQ.K4) THEN
C
C Read X, XH, XL, Y, YH, YL .... Define YMAX3, YMAX4, YMIN3, YMIN4
C
               NTYPE = K2
               NTYPE2 = NTYPE2 + K1
               NPTS = K0
               DO J = K1, NROW
                  READ (NIN,*,END=60,ERR=60,IOSTAT=IOS) A, B, C, D
                  IF (IOS.NE.K0) GOTO 60
                  IF (VECTOR_FIELD) THEN
C
C Do not check A, B, C, D if a vector_field type file is expected
C
                     IOS = K0!to silence ftn95...originally CONTINUE
                  ELSE
                     IF (B.GT.C .OR. C.GT.D) GOTO 60
                  ENDIF
                  NPTS = NPTS + K1
                  X(NPTS) = A
                  XH(NPTS) = A
                  XL(NPTS) = A
                  YL(NPTS) = B
                  Y(NPTS) = C
                  YH(NPTS) = D
                  IF (ABS(A).GT.RTOL) THEN
                     TEMP = B/A
                     IF (TEMP.LT.YMIN3) YMIN3 = TEMP
                     TEMP = D/A
                     IF (TEMP.GT.YMAX3) YMAX3 = TEMP
                  ENDIF
                  IF (ABS(B).GT.RTOL) THEN
                     TEMP = A/B
                     IF (TEMP.GT.YMAX4) YMAX4 = TEMP
                  ENDIF
                  IF (ABS(D).GT.RTOL) THEN
                     TEMP = A/D
                     IF (TEMP.LT.YMIN4) YMIN4 = TEMP
                  ENDIF
               ENDDO
            ELSEIF (NCOL.EQ.K6) THEN
C
C Read X, XH, XL, Y, YH, YL .... Define YMAX3, YMAX4, YMIN3, YMIN4
C
               NTYPE = K6
               NTYPE2 = NTYPE2 + K1
               NPTS = K0
               DO J = K1, NROW
                  READ (NIN,*,END=60,ERR=60,IOSTAT=IOS) G, A, H, B, C, D
                  IF (IOS.NE.K0) GOTO 60
                  NPTS = NPTS + K1
                  X(NPTS) = A
                  XH(NPTS) = H
                  XL(NPTS) = G
                  YL(NPTS) = B
                  Y(NPTS) = C
                  YH(NPTS) = D
                  IF (ABS(A).GT.RTOL) THEN
                     TEMP = B/A
                     IF (TEMP.LT.YMIN3) YMIN3 = TEMP
                     TEMP = D/A
                     IF (TEMP.GT.YMAX3) YMAX3 = TEMP
                  ENDIF
                  IF (ABS(B).GT.RTOL) THEN
                     TEMP = A/B
                     IF (TEMP.GT.YMAX4) YMAX4 = TEMP
                  ENDIF
                  IF (ABS(D).GT.RTOL) THEN
                     TEMP = A/D
                     IF (TEMP.LT.YMIN4) YMIN4 = TEMP
                  ENDIF
               ENDDO
            ENDIF
C
C Define L, M
C
            IF (NTYPE.EQ.K1) THEN
               IF (NPTS.GE.60) THEN
                  M(IADD1) = K0
               ELSE
                  L(IADD1) = K0
               ENDIF
               BARCAP(IADD1) = .FALSE.
               LOWER(IADD1) = .FALSE.
               UPPER(IADD1) = .FALSE.
            ELSEIF (NTYPE.EQ.K2 .OR. NTYPE.EQ.K6) THEN
               L(IADD1) = K0
               BARCAP(IADD1) = .TRUE.
               LOWER(IADD1) = .TRUE.
               UPPER(IADD1) = .TRUE.
            ENDIF
            NSAV(IADD1) = NTYPE
C
C Find the minimum and maximum of the current X and Y Values ..........
C
            IF (VECTOR_FIELD) THEN
               IF (IADD1.EQ.K1) THEN
                  CALL MAXMIN$(K0, NPTS, X, XMAX, XMIN)
                  CALL MAXMIN$(K0, NPTS, Y, YMAX, YMIN)
               ELSE
                  CALL MAXMIN$(K1, NPTS, X, XMAX, XMIN)
                  CALL MAXMIN$(K1, NPTS, Y, YMAX, YMIN)
               ENDIF
               IF (NTYPE.EQ.K2) THEN
                  CALL MAXMIN$(K1, NPTS, YL, XMAX, XMIN)
                  CALL MAXMIN$(K1, NPTS, YH, YMAX, YMIN)
               ENDIF
            ELSE
               IF (IADD1.EQ.K1) THEN
                  CALL MAXMIN$(K0, NPTS, X, XMAX, XMIN)
                  CALL MAXMIN$(K0, NPTS, Y, YMAX, YMIN)
               ELSE
                  CALL MAXMIN$(K1, NPTS, X, XMAX, XMIN)
                  CALL MAXMIN$(K1, NPTS, Y, YMAX, YMIN)
               ENDIF
               IF (NTYPE.EQ.K2 .OR. NTYPE.EQ.K6) THEN
                  CALL MAXMIN$(K1, NPTS, XH, XMAX, XMIN)
                  CALL MAXMIN$(K1, NPTS, XL, XMAX, XMIN)
                  CALL MAXMIN$(K1, NPTS, YH, YMAX, YMIN)
                  CALL MAXMIN$(K1, NPTS, YL, YMAX, YMIN)
               ENDIF
            ENDIF
         ENDDO
         ABORT = .FALSE.
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
C
C Crash
C
   60 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL PUTFAT$(
     +'LIBFIL$ error: File is not a consistent plot type library file')
      CALL VU2CHK (FNLIB)
C
C Format statements
C      
  100 FORMAT (A)
  200 FORMAT (
     +'LIBFIL$ error: Check your library file at line',I3)
      END
C
C
