C
C
      SUBROUTINE LOOP01$(ICOLOR, IFILL, IHUE, IPANEL, ISHAPE, JCOLOR,
     +                   KCOLOR, KPANEL, L, LCTEMP, M, MTRANS,
     +                   NFILES, NGRAFS, NIN, NKCOL, NLOG, NMAX, NPANEL,
     +                   NPTS, NT, NTYPE, NWORDS, NXTRA,
     +                   A, ASYMP, B, C, CZ, D, DZ,
     +                   FACTOR, PSCALE, SIZE, WIDE,
     +                   X, XH, XHT, XL, XLT, XMAX, XMIN,
     +                   XPANEL, XT,
     +                   Y, YDIFF, YDELTA, YH, YHT, YL, YLT, YMAX,YMAX3,
     +                   YMAX4, YMIN, YMIN1, YMIN3, YMIN4, YPANEL,
     +                   YPDIFF, YPXTRA, YT, ZMAX, ZMIN, ZSCALE,
     +                   FSAV, PLINE,
     +                   ABORT, BARCAP, BARCAP_1, BAR_CHART, LOWER,
     +                   MONO, NATLOG,
     +                   PANEL, PANEL_LINES, PIE_CHART, PS, PSHOW, SIDE,
     +                   THREE_D,
     +                   UPPER, VECTOR_FIELD, VIDEO, WIDE_PANEL, YAXIS)
C
C
C ACTION : Lines and error bars for simplot
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 8/6/95
C          01/08/1996 Revised for SIDE PANEL
C          09/08/1996 Added YMAXA, YMINA to correct for panel in vertical mode
C          15/10/1996 Altered code for lower panel
C          20/02/1997 Added BARCAP_1
C          14/07/1987 win32 version
C          12/01/1998 Reversed XPANEL to allow for vector arrows
C          04/02/1998 Added NFILES to argument list for GKSFIL
C          09/03/1998 Added VECTOR_FIELD
C          28/06/2000 added NTYPE = 6
C          29/01/2001 added KPANEL, NGRAFS, NWORDS, removed assumed size arrays
C          07/09/2001 added THREE_D, NKCOL, KCOLOR
C          07/01/2003 redimensioned WIDE(5*NGRAFS) and used offset for
C                     error-bar/symbol line widths
C          14/01/2003 redefined XMAXA, XMINA, YMAXA, YMINA to allow large
C                     side panels to be dragged and now draws lines through
C                     the plotting symbols in panels. Also D19 and IMAX
C          16/01/2003 icluded the code from LOOP02$ to prevent second call to
C                     GKSFIL$ which required a second opening of the same file
C          24/01/2003 Deleted symbol drawing as it allowed lines to cross
C                     over symbols and introduced ACTION to prevent unneccessary
C                     file opening
C          01/05/2003 edited to make PSHOW(I) and IADD1 consistent and reversed
C                     XTEMP(1) and XTEMP(2) so that XTEMP(2) > XTEMP(1) and
C                     vector heads are the correct way round in panel keys
C          14/09/2006 added call to VFPLOT$ for biplots 
C          10/05/2007 added INTENTS and NLOG to arguments
C          01/01/2008 added NXTRA
C          30/11/2010 added WIDE_PANEL and allows up to 8 keys in bottom panel
C          01/02/2011 added NSTEP1, NSTEP2, and SAVINT$
C          09/02/2001 redefined YMINA, YMAXA and added ISHAPE to correct for FLAT aspect ratio
C          11/02/2011 added PANEL_LINES
C          14/06/2011 added code to plot up to 10 bottom panel items
C          20/06/2011 added K29 to limit the restriction on SIZNUM
C          25/08/2014 added BARCHT_3D$
C          21/11/2014 corrected error calling BARCHT with BARCAP(I) instead of BARCAP_1 
C          20/06/2016 now calls VFIELD$ with all colour values IHUE(i) 
C
C Draw the points on the graph as follows:-
C GKSFIL to read in coordinates from input files
C GKSTRN to transform coordinates depending on MTRANS
C Define PSHOW = .TRUE. if points to be plotted
C GKSMRK to draw lines if in feasible region
C GKSBAR to draw error bars if appropriate
C
C First loop ... Call GKSFIL/GKSTRN/GKSMRK/GKSBAR .....................
C
      IMPLICIT    NONE
C
C Integers in argument list
C
      INTEGER, INTENT (IN)    :: IPANEL, ISHAPE, KPANEL, NGRAFS, NIN,
     +                           NKCOL, NLOG, NMAX, NWORDS, NXTRA
      INTEGER, INTENT (IN)    :: MTRANS, NFILES
      INTEGER, INTENT (IN)    :: L(NGRAFS), M(NGRAFS)
      INTEGER, INTENT (INOUT) :: IFILL(NXTRA), IHUE(NXTRA),
     +                           JCOLOR(NGRAFS), KCOLOR(NKCOL),
     +                           LCTEMP  
      INTEGER, INTENT (INOUT) :: ICOLOR, NPANEL, NPTS, NT, NTYPE 
C
C Reals in argument list
C     
      DOUBLE PRECISION,    INTENT (IN)    :: YMIN1
      DOUBLE PRECISION,    INTENT (INOUT) :: A, ASYMP, B, C, CZ, D, DZ,
     +                                       FACTOR(NXTRA), PSCALE,
     +                                       SIZE(NGRAFS),
     +                                       WIDE(5*NGRAFS),
     +                                       XMAX, XMIN, YDELTA,
     +                                       YDIFF, YMAX, YMIN, 
     +                                       YPDIFF, YPXTRA, 
     +                                       ZMAX, ZMIN, ZSCALE  
      DOUBLE PRECISION,    INTENT (INOUT) :: YMAX3, YMAX4, YMIN3, YMIN4
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX), XH(NMAX),
     +                                       XHT(NMAX), XL(NMAX),
     +                                       XLT(NMAX), XT(NMAX),
     +                                       Y(NMAX), YH(NMAX),
     +                                       YHT(NMAX), YL(NMAX),
     +                                       YLT(NMAX), YT(NMAX)
      DOUBLE PRECISION,    INTENT (INOUT) :: XPANEL(2), YPANEL(2)
C
C Characters in argument list
C           
      CHARACTER (LEN = *), INTENT (IN)    :: FSAV(NGRAFS), PLINE(KPANEL)
C
C Logicals in argument list
C      
      LOGICAL,             INTENT (IN)    :: BARCAP(NGRAFS), BARCAP_1,
     +                                       BAR_CHART, LOWER(NGRAFS),
     +                                       MONO, NATLOG(NLOG), PANEL,
     +                                       PANEL_LINES,
     +                                       PIE_CHART, PS, SIDE,
     +                                       THREE_D, UPPER(NGRAFS),
     +                                       VECTOR_FIELD, VIDEO,
     +                                       WIDE_PANEL, 
     +                                       YAXIS(NGRAFS)
      LOGICAL,             INTENT (INOUT) :: PSHOW(KPANEL)
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    K0, K1, K2, K3, K4, K5, K6, K7, K8, K9, K10, K15,
     +           K20, K29
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K7 = 7, K8 = 8, K9 = 9, K10 = 10, K15 = 15, K20 = 20,
     +           K29 = 29)
      INTEGER    I, IADD1, ISEND, J, JSEND, KTEMP1, KTEMP2, NSTEP
      INTEGER    IARROW, JARROW, NGKS, NHATCH, NT1, NT2
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FOUR, TEN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION PNT25, PNT5, PNT55, PNT75, ONETHD, TWOTHD, 
     +                 X2LEFT, XSHIFT
      PARAMETER (PNT25 = 0.25D+00, PNT5 = 0.5D+00, PNT55 = 0.55D+00,
     +           PNT75 = 0.75D+00, ONETHD = ONE/THREE,
     +           TWOTHD = TWO/THREE, X2LEFT = 0.05D+00, 
     +           XSHIFT = ONE/(THREE*FOUR))
      DOUBLE PRECISION EXTRA, XDRAG
      PARAMETER (EXTRA = 0.0625D+00, XDRAG = 0.040D+00)
      DOUBLE PRECISION D19
      PARAMETER (D19 = 19.0D+00)
      DOUBLE PRECISION HEAD_SIZE, RADIUS
      DOUBLE PRECISION DELTA, THETA_1, THETA_2, SIZNUM, XDIFF
      DOUBLE PRECISION XPLOT, XTEMP(2)
      DOUBLE PRECISION TWOPI
      PARAMETER (TWOPI = TWO*3.141592654D+00)
      DOUBLE PRECISION XMAXA, XMINA, YMAXA, YMINA
      DOUBLE PRECISION FTEMP(100)
c      character  line*128
      CHARACTER  TITLE*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ACTION, DENDRO, DOUGH_NUT, THREE_DEE
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   GKSFIL$, GKSTRN$, GKSMRK$, GKSBAR$, VFIELD$, GKSM2D$
      EXTERNAL   BARCHT$, PIECHT$, PIETLT$, BARBAR$, VFPLOT$, SAVINT$
      EXTERNAL   PIENUT$, SAVEDN$, BARCHT_3D$
      EXTERNAL   NSTEP1, NSTEP2
      INTRINSIC  ABS, MAX, DBLE, MIN
C
C Initialise
C          
      ABORT = .FALSE.
      XDIFF = PNT5*(XMAX - XMIN)
      XMAXA = XMAX + XDIFF
      XMINA = XMIN - XDIFF
      YMAXA = YMAX + PNT5*(YMAX - YMIN)
      YMINA = YMIN - PNT5*(YMAX - YMIN)
C
C Reverse XPANEL before drawing the lines to allow for vector lines
C Make XTEMP(2) > XTEMP(1) to get arrow heads the right way for vector lines
C
      IF (.NOT.BAR_CHART .AND. .NOT. PIE_CHART .AND. PANEL
     +                                         .AND. SIDE) THEN
         XPLOT = MAX(XPANEL(1),XPANEL(2))
         XDIFF = ABS(XPANEL(1) - XPANEL(2))
         IF (WIDE_PANEL) THEN
C
C Move XTEMP(1) to the left only if WIDE_PANEL = .TRUE.
C           
            XTEMP(1) = XPLOT - PNT55*XDIFF
         ELSE
            XTEMP(1) = XPLOT
         ENDIF      
         XTEMP(2) = XPLOT + PNT55*XDIFF
      ELSE
         XDIFF = XMAX - XMIN
      ENDIF
C
C Set all PSHOW(I) = .FALSE. and only restore if valid, i.e. L(i) or M(i)
C nonzero, a nonblank key text string PLINE(i), IADD1 < IPANEL, NT > 0
C Initialise IADD1 which is used to position panel items, that is
C when PSHOW(I) = .TRUE. then ADD1 = IADD1 + 1 to move the panel keys
C
      DO I = K1, MIN(KPANEL,NFILES)
         PSHOW(I) = .FALSE.
      ENDDO
      IADD1 = K0
C
C Loop over all data sets, i.e. NFILES data files
C
      DO I = K1, NFILES
C
C See if ACTION is needed
C
         IF (PIE_CHART) THEN
            ACTION = .TRUE.
         ELSEIF (BAR_CHART .AND. I.EQ.K1) THEN
            ACTION = .TRUE.
         ELSEIF (VECTOR_FIELD .AND. I.EQ.K1) THEN
            ACTION = .TRUE.
         ELSEIF (PANEL .AND. M(I).NE.K0) THEN
            ACTION = .TRUE.
         ELSEIF (L(I).NE.K0 .OR. LOWER(I) .OR. UPPER(I)) THEN
            ACTION = .TRUE.
         ELSE
            ACTION = .FALSE.
         ENDIF
      IF (ACTION) THEN
C
C***********************************
C Start of loop when ACTION = .TRUE.
C***********************************
C
C
C Colours
C
         IF (MONO) THEN
            IF (VIDEO) THEN
               ICOLOR = K0
            ELSE
               ICOLOR = K15
            ENDIF
         ELSE
            ICOLOR = JCOLOR(I)
         ENDIF
C
c Re-set NT = 0. NT > 0 only for a successful transformation.
C
         NT = K0
C
C Read in the data from file unless a piechart
C
         DENDRO = .FALSE.
         IF (NTYPE.NE.K4) THEN
            ISEND = K2
            CLOSE (UNIT = NIN)
            CALL GKSFIL$(IFILL, IHUE, ISEND, NFILES, K1, NIN, NMAX,
     +                   NPTS, NTYPE, NWORDS, NXTRA,
     +                   FACTOR, X, XH, XL, Y, YH,
     +                   YL, YMAX3, YMAX4, YMIN3, YMIN4,
     +                   FSAV(I), TITLE,
     +                   ABORT, BAR_CHART, VECTOR_FIELD)
            CLOSE (UNIT = NIN)
            IF (I.EQ.K1) THEN
C
C Is the first file a dendrogram file ?
C
               IF (TITLE(1:22).EQ.'%simfitdendrogramfile%')
     +         DENDRO = .TRUE.
            ENDIF
         ENDIF
C
C Transform data if required (NT > 0 for success)
C
         IF (VECTOR_FIELD) THEN
            IF (NTYPE.EQ.K2) THEN
               IARROW = IFILL(1) 
               JARROW = NPTS
               NGKS = K1
               HEAD_SIZE = FACTOR(1)
               CALL VFIELD$(IARROW, IHUE, JARROW, LCTEMP, NGKS, NMAX,
     +                      HEAD_SIZE, XMAX, XMIN, X, YL, YMAX, YMIN, Y, 
     +                      YH)
C     
C Now set before call to LOOP01$      
C               L(I) = K0
C               M(I) = K0 
            ELSEIF (NTYPE.EQ.K3) THEN 
               JARROW = NPTS
               NGKS = K1  
               CALL VFPLOT$(IFILL, IHUE, JARROW, LCTEMP, NGKS, NMAX,
     +                      FACTOR, XMAX, XMIN, X, XL, YMAX, YMIN, YL,
     +                      Y)
C     
C Now set before call to LOOP01$ 
C               L(I) = K0
C               M(I) = K0 
            ENDIF   
         ELSEIF (NTYPE.EQ.K1 .OR. NTYPE.EQ.K2 .OR. NTYPE.EQ.K6) THEN
            CALL GKSTRN$(MTRANS, NPTS, NLOG, NT, NTYPE,
     +                   ASYMP, X, XH, XHT, XL, XLT, XT,
     +                          Y, YH, YHT, YL, YLT, YT,
     +                   NATLOG)
            NT1 = NT
            NT2 = NT
            IF (NT.GT.K0) THEN
               IF (M(I).EQ.K1) THEN
                  SIZNUM = PNT25*SIZE(I)*ZSCALE
               ELSE
                  SIZNUM = SIZE(I)*ZSCALE
               ENDIF
               IF (DENDRO) THEN
                  IF (YAXIS(I)) THEN
                     CALL GKSM2D$(ICOLOR, K1, L(I), M(I), NT,
     +                            A, B, C, D, SIZNUM, WIDE(I),
     +                            XT, XMAX, XMIN, YT, YMAX, YMIN)
                  ELSE
                     CALL GKSM2D$(ICOLOR, K4, L(I), M(I), NT,
     +                            A, B, CZ, DZ, SIZNUM, WIDE(I),
     +                            XT, XMAX, XMIN, YT, ZMAX, ZMIN)
                  ENDIF
               ELSE
C
C Copy XT,YT into X,Y then use NSTEP1 to further edit by stepping over points 
C This technique requires that X and Y are not used again in this subroutine
C                 
                  ISEND = K1
                  JSEND = I
                  CALL SAVINT$ (ISEND, JSEND, NSTEP,
     +                          STORE)
                  DO ISEND = K1, NT1
                     X(ISEND) = XT(ISEND)
                     Y(ISEND) = YT(ISEND)
                  ENDDO
                  if (NSTEP.GT.0) CALL NSTEP1 (NSTEP, NT1,
     +                                         X, Y)                                       
                  IF (YAXIS(I)) THEN
                     CALL GKSMRK$(ICOLOR, K1, L(I), M(I), NT1,
     +                            A, B, C, D, SIZNUM, WIDE(I),
     +                            X, XMAX, XMIN, Y, YMAX, YMIN)
                  ELSE
                     CALL GKSMRK$(ICOLOR, K4, L(I), M(I), NT1,
     +                            A, B, CZ, DZ, SIZNUM, WIDE(I),
     +                            X, XMAX, XMIN, Y, ZMAX, ZMIN)
                  ENDIF
               ENDIF
C
C Plot a panel if required and data are in range
C Define PSHOW(I) as .TRUE. only if PANEL = .TRUE., NT > 0, L or M nonzero,
C IADD1 < IPANEL, BAR_CHART = .FALSE., and PLINE(I) nonblank, then increment
C IADD1 ... o/w re-set PSHOW(I)
C
               IF (PANEL .AND. I.LE.KPANEL .AND. 
     +             IADD1.LT.IPANEL .AND. .NOT.BAR_CHART) THEN
                  IF (L(I).NE.K0 .OR. M(I).NE.K0) THEN
                     IF (PLINE(I).EQ.BLANK) THEN
                        PSHOW(I) = .FALSE.
                     ELSE
                        PSHOW(I) = .TRUE.
                        IADD1 = IADD1 + K1
                     ENDIF
                  ENDIF
                  IF (PSHOW(I) .AND. PANEL_LINES .AND. L(I).NE.K0) THEN
C
C A line is required for the panel of keys
C
                     NPANEL = K2
                     IF (SIDE) THEN
C
C Calculations if SIDE = .TRUE.
C Note: XPANEL has already been defined by drag/drop procedure 
C       and XTEMP has also been calculated so we only need to calculate YPANEL
C
                        YPANEL(1) = YMAX -
     +                  (DBLE(IADD1) + YPXTRA - ONE)*YDIFF/D19
                        YPANEL(2) = YPANEL(1)
                     ELSE
C
C Calculations if SIDE = .FALSE. to adjust the X, Y coordinates for keys
C Note: XPANEL(2) must be defined separately depending on the number of
C       panel keys, (i.e. IPANEL) at the bottom of the plot
C
                        IF (IPANEL.EQ.K1) THEN
                           XPANEL(2) = XMIN + PNT5*XDIFF
                        ELSEIF (IPANEL.EQ.K2) THEN
                           IF (IADD1.EQ.K1) THEN
                              XPANEL(2) = XMIN + 0.21D+00*XDIFF
                           ELSE
                              XPANEL(2) = XMIN + 0.73D+00*XDIFF
                           ENDIF
                        ELSEIF (IPANEL.EQ.K3) THEN
                           IF (IADD1.EQ.K1) THEN
                              XPANEL(2) = XMIN + XSHIFT*XDIFF
                           ELSEIF (IADD1.EQ.K2) THEN
                              XPANEL(2) = XMIN + ONETHD*XDIFF
     +                                    + XSHIFT*XDIFF
                           ELSE
                              XPANEL(2) = XMIN + TWOTHD*XDIFF
     +                                    + XSHIFT*XDIFF
                           ENDIF
                        ELSEIF (IPANEL.EQ.K4) THEN
                           IF (IADD1.EQ.K1 .OR. IADD1.EQ.K3) THEN
                              XPANEL(2) = XMIN + 0.21D+00*XDIFF
                           ELSE
                              XPANEL(2) = XMIN + 0.73D+00*XDIFF
                           ENDIF
                        ELSEIF (IPANEL.LE.K6) THEN
                           IF (IADD1.EQ.K1 .OR. IADD1.EQ.K4) THEN
                              XPANEL(2) = XMIN + XSHIFT*XDIFF
                           ELSEIF (IADD1.EQ.K2 .OR. IADD1.EQ.K5) THEN
                              XPANEL(2) = XMIN + ONETHD*XDIFF
     +                                    + XSHIFT*XDIFF
                           ELSE
                              XPANEL(2) = XMIN + TWOTHD*XDIFF
     +                                    + XSHIFT*XDIFF
                           ENDIF
                        ELSEIF (IPANEL.LE.K8) THEN
                           IF (IADD1.EQ.K1 .OR. IADD1.EQ.K5) THEN
                              XPANEL(2) = XMIN + XSHIFT*XDIFF
                           ELSEIF (IADD1.EQ.K2 .OR. IADD1.EQ.K6) THEN
                              XPANEL(2) = XMIN + PNT25*XDIFF
     +                                    + XSHIFT*XDIFF
                           ELSEIF (IADD1.EQ.K3 .OR. IADD1.EQ.K7) THEN
                              XPANEL(2) = XMIN + PNT5*XDIFF
     +                                    + XSHIFT*XDIFF
                           ELSE
                              XPANEL(2) = XMIN + PNT75*XDIFF
     +                                    + XSHIFT*XDIFF
                           ENDIF 
                        ELSEIF (IPANEL.LE.K10) THEN  
                           IF (IADD1.EQ.K1 .OR. IADD1.EQ.K6) THEN
                              XPANEL(2) = XMIN + XSHIFT*XDIFF
     +                                   - EXTRA*XDIFF 
                           ELSEIF (IADD1.EQ.K2 .OR. IADD1.EQ.K7) THEN
                              XPANEL(2) = XMIN + PNT25*XDIFF
     +                                    + XSHIFT*XDIFF 
     +                                    - EXTRA*XDIFF
     +                                    - XDRAG*XDIFF
                          ELSEIF (IADD1.EQ.K3 .OR. IADD1.EQ.K8) THEN
                              XPANEL(2) = XMIN + PNT5*XDIFF
     +                                    + XSHIFT*XDIFF
     +                                    - EXTRA*XDIFF
     +                                    - TWO*XDRAG*XDIFF
                           ELSEIF (IADD1.EQ.K4 .OR. IADD1.EQ.K9) THEN
                              XPANEL(2) = XMIN + PNT75*XDIFF
     +                                    + XSHIFT*XDIFF
     +                                    - EXTRA*XDIFF
     +                                    - THREE*XDRAG*XDIFF
                           ELSE
                              XPANEL(2) = XMIN + XDIFF
     +                                    + XSHIFT*XDIFF
     +                                    - EXTRA*XDIFF
     +                                    - FOUR*XDRAG*XDIFF
                       ENDIF    
                        ENDIF
C
C Now define the start and end coordinates for the key line
C Make XTEMP(2) > XTEMP(1) to get arrow heads the right way for vector lines
C Note: YPANEL must be defined depending on the value of IPANEL
C
                        IF (WIDE_PANEL) THEN
                           XTEMP(1) = XPANEL(2) - PNT75*XSHIFT*XDIFF
                        ELSE
                           XTEMP(1) = XPANEL(2)
                        ENDIF      
                        XTEMP(2) = XPANEL(2) + PNT75*XSHIFT*XDIFF
                        IF (IPANEL.LE.K3) THEN
                           YPANEL(1) = YMIN1 + PNT5*YPDIFF*YDELTA
                        ELSEIF (IPANEL.EQ.K4) THEN
                           IF (IADD1.LE.K2) THEN
                              YPANEL(1) = YMIN1 + TWOTHD*YPDIFF*YDELTA
                              IF (ISHAPE.EQ.4) YPANEL(1) = YPANEL(1) +
     +                                         YPDIFF*YDELTA/TEN                                
                           ELSE
                              YPANEL(1) = YMIN1 + ONETHD*YPDIFF*YDELTA
                           ENDIF
                        ELSEIF (IPANEL.LE.K6) THEN   
                           IF (IADD1.LE.K3) THEN
                              YPANEL(1) = YMIN1 + TWOTHD*YPDIFF*YDELTA
                              IF (ISHAPE.EQ.4) YPANEL(1) = YPANEL(1) +
     +                                         YPDIFF*YDELTA/TEN                                                 
                           ELSE
                              YPANEL(1) = YMIN1 + ONETHD*YPDIFF*YDELTA
                           ENDIF
                        ELSEIF (IPANEL.LE.K8) THEN   
                           IF (IADD1.LE.K4) THEN
                              YPANEL(1) = YMIN1 + TWOTHD*YPDIFF*YDELTA
                              IF (ISHAPE.EQ.4) YPANEL(1) = YPANEL(1) +
     +                                         YPDIFF*YDELTA/TEN                                                 
                           ELSE
                              YPANEL(1) = YMIN1 + ONETHD*YPDIFF*YDELTA
                           ENDIF 
                        ELSEIF (IPANEL.LE.K10) THEN   
                           IF (IADD1.LE.K5) THEN
                              YPANEL(1) = YMIN1 + TWOTHD*YPDIFF*YDELTA
                              IF (ISHAPE.EQ.4) YPANEL(1) = YPANEL(1) +
     +                                         YPDIFF*YDELTA/TEN                                                 
                           ELSE
                              YPANEL(1) = YMIN1 + ONETHD*YPDIFF*YDELTA
                           ENDIF  
                        ENDIF 
                        IF (ISHAPE.EQ.4) YPANEL(1) = YPANEL(1) +
     +                                   YPDIFF*YDELTA  
                        YPANEL(2) = YPANEL(1)                          
                     ENDIF
C
C Draw the key line
C
                     IF (.NOT.SIDE .AND. .NOT.WIDE_PANEL) THEN
                        XTEMP(1) = XTEMP(1) - X2LEFT*XDIFF
                        XTEMP(2) = XTEMP(2) - X2LEFT*XDIFF
                     ENDIF 
                     CALL GKSMRK$(ICOLOR, K3, L(I), K0, NPANEL,
     +                            A, B, C, D, PSCALE*SIZNUM, WIDE(I),
     +                            XTEMP, XMAXA, XMINA,
     +                            YPANEL, YMAXA, YMINA)
                  ENDIF
               ENDIF
            ENDIF
            IF (NTYPE.EQ.K2 .OR. NTYPE.EQ.K6) THEN
C
C Draw error bars after allowing for correction for stepping over intermediate points
C This technique requires that XHT, XLT, XT, YHT, YLT, and YT have not been altered
C since being returned from GKSTRN$ and are not used again in this subroutine 
C
               ISEND = K2
               JSEND = I
               CALL SAVINT$ (ISEND, JSEND, NSTEP,
     +                       STORE)
               IF (NSTEP.GT.0) CALL NSTEP2 (NSTEP, NT2,
     +                                      XHT, XLT, XT, YHT, YLT, YT)                              
               IF (M(I).GE.K20 .AND. M(I).LE.K29) SIZNUM = ZERO
               IF (YAXIS(I)) THEN
                  CALL GKSBAR$(ICOLOR, K1, MTRANS, NT2,
     +                         A, B, C, D, SIZNUM, WIDE(NGRAFS + I),
     +                         XT, XHT, XLT, XMAX, XMIN,
     +                         YT, YHT, YLT, YMAX, YMIN,
     +                         BARCAP(I), LOWER(I), UPPER(I))
               ELSE
                  CALL GKSBAR$(ICOLOR, K4, MTRANS, NT2,
     +                         A, B, CZ, DZ, SIZNUM, WIDE(NGRAFS + I),
     +                         XT, XHT, XLT, XMAX, XMIN,
     +                         YT, YHT, YLT, ZMAX, ZMIN,
     +                         BARCAP(I), LOWER(I), UPPER(I))
               ENDIF
            ENDIF
         ELSEIF (NTYPE.EQ.K3) THEN
C
C Draw the barchart
C
            DELTA = ONE
            DO J = K1, NPTS
               IF (MONO) THEN
                  IF (VIDEO) THEN
                     KTEMP1 = K0
                  ELSE
                     KTEMP1 = K15
                  ENDIF
               ELSE
                  IF (LCTEMP.EQ.K15 .AND. IHUE(J).EQ.K15) THEN
                     KTEMP1 = K15
                  ELSE
                     KTEMP1 = IHUE(J)
                  ENDIF
               ENDIF
               IF (IFILL(J).LE.K7) THEN
                  KTEMP2 = K1
               ELSEIF (IFILL(J).EQ.K8) THEN
                  KTEMP2 = K2
               ELSEIF (IFILL(J).EQ.K9) THEN
                  KTEMP2 = K3
               ELSEIF (IFILL(J).EQ.K10) THEN
                  KTEMP2 = K4
               ENDIF
               IF (BAR_CHART) THEN
C
C Complete code for shadow barchart
C                 
                  IF (THREE_D) THEN
                     CALL BARBAR$(KTEMP1, IFILL(J), K1, KCOLOR(6),
     +                            DELTA, FACTOR(J), WIDE(1),
     +                            WIDE(NGRAFS + 1),
     +                            X(J), XMAX, XMIN, YMAX, YMIN, XL(J),
     +                            XH(J), YL(J), Y(J), YH(J),
     +                            BARCAP_1, PS)
                     NHATCH = 80
                     CALL BARCHT_3D$(KTEMP1, IFILL(J), K1, KTEMP2,
     +                               LCTEMP,
     +                               NHATCH,
     +                               DELTA, FACTOR(J), WIDE(1),
     +                               WIDE(NGRAFS + 1),
     +                               X(J), XMAX, XMIN, YMAX, YMIN,
     +                               XL(J), XH(J), YL(J), Y(J), YH(J),
     +                               BARCAP_1, PS, SIDE)
                  ELSE
C
C Code for barchart with no shadow
C                 
                     NHATCH = 80
                     CALL BARCHT$(KTEMP1, IFILL(J), K1, KTEMP2, LCTEMP,
     +                            NHATCH,
     +                            DELTA, FACTOR(J), WIDE(1),
     +                            WIDE(NGRAFS + 1),
     +                            X(J), XMAX, XMIN, YMAX, YMIN, XL(J),
     +                            XH(J), YL(J), Y(J), YH(J),
     +                            BARCAP_1, PS, SIDE)
                  ENDIF
               ENDIF
            ENDDO
         ELSEIF (NTYPE.EQ.K4) THEN
C
C Draw the piechart
C
            CALL SAVEDN$(RADIUS,
     +                   DOUGH_NUT, STORE)
            
            IF (DOUGH_NUT) THEN
               THREE_DEE = .FALSE.
               DO J = 1, NPTS
                  FTEMP(J) = ZERO
               ENDDO   
            ELSE
               THREE_DEE = THREE_D
               DO J = 1, NPTS
                  FTEMP(J) = FACTOR(J)
               ENDDO 
            ENDIF      
            
            IF (THREE_DEE) THEN
               CALL PIETLT$(K0, K0, K0, K0, KCOLOR(6),
     +                      ZERO, ZERO, ZERO, ZERO,
     +                      PANEL, PS, SIDE)
               THETA_1 = ZERO
               DO J = K1, NPTS
                  IF (J.EQ.NPTS) THEN
                     THETA_2 = TWOPI
                  ELSE
                     THETA_2 = THETA_1 + X(J)*TWOPI
                  ENDIF
                  IF (MONO) THEN
                     IF (VIDEO) THEN
                        KTEMP1 = K0
                     ELSE
                        KTEMP1 = K15
                     ENDIF
                  ELSE
                     KTEMP1 = IHUE(J)
                  ENDIF
                  CALL PIETLT$(KTEMP1, IFILL(J), K1, K1, KCOLOR(6),
     +                         FACTOR(J), THETA_1, THETA_2, WIDE(1),
     +                         PANEL, PS, SIDE)
                  THETA_1 = THETA_2
               ENDDO
               CALL PIETLT$(K0, K0, K1, K2, KCOLOR(6),
     +                      ZERO, ZERO, ZERO, ZERO,
     +                      PANEL, PS, SIDE)
            ENDIF
            THETA_1 = ZERO
            DO J = K1, NPTS
               IF (J.EQ.NPTS) THEN
                  THETA_2 = TWOPI
               ELSE
                  THETA_2 = THETA_1 + X(J)*TWOPI
               ENDIF
               IF (MONO) THEN
                  IF (VIDEO) THEN
                     KTEMP1 = K0
                  ELSE
                     KTEMP1 = K15
                  ENDIF
               ELSE
                  KTEMP1 = IHUE(J)
               ENDIF
               IF (IFILL(J).LE.K7) THEN
                  KTEMP2 = K1
               ELSEIF (IFILL(J).EQ.K8) THEN
                  KTEMP2 = K2
               ELSEIF (IFILL(J).EQ.K9) THEN
                  KTEMP2 = K3
               ELSEIF (IFILL(J).EQ.K10) THEN
                  KTEMP2 = K4
               ENDIF
               CALL PIECHT$(KTEMP1, IFILL(J), K1, KTEMP2, LCTEMP,
     +                      FTEMP(J), THETA_1, THETA_2, WIDE,
     +                      PANEL, PS, SIDE, THREE_DEE)
               THETA_1 = THETA_2
            ENDDO
            IF (DOUGH_NUT) CALL PIENUT$(K1, LCTEMP,
     +                                  RADIUS, TWOPI, WIDE,
     +                                  PANEL, PS, SIDE)
         ENDIF
C
C*********************************
C End of loop when ACTION = .TRUE.
C*********************************
C
      ENDIF
      ENDDO
      END
C
C
