C
      SUBROUTINE LOOP02$(ICOLOR, IFILL, IHUE, IPANEL, ISHAPE, JCOLOR,
     +                   KPANEL, LCTEMP, M, MTRANS,
     +                   NFILES, NGRAFS, NIN, NLOG, NMAX, NPANEL, NPTS,
     +                   NT, NTYPE, NWORDS, NXTRA,
     +                   A, ASYMP, C, CZ,
     +                   FACTOR, PSCALE, SIZE, WIDE,
     +                   X, XH, XHT, XL, XLT, XMAX, XMIN,
     +                   XPANEL, XT,
     +                   Y, YDIFF, YDELTA, YH, YHT, YL, YLT, YMAX,YMAX3,
     +                   YMAX4, YMIN, YMIN1, YMIN3, YMIN4, YPANEL,
     +                   YPDIFF, YPXTRA, YT, ZMAX, ZMIN, ZSCALE,
     +                   FSAV,
     +                   ABORT, BARCAP, BAR_CHART,
     +                   MONO, NATLOG,
     +                   PANEL, PANEL_LINES, PANEL_SYMBOLS, PS, PSHOW,
     +                   SIDE, VECTOR_FIELD, VIDEO, WIDE_PANEL, YAXIS)
C
C ACTION : Markers and error bars for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 8/6/95
C          01/07/1996 Revised for SIDE PANEL
C          09/08/1996 Added YMAXA, YMINA to correct panel in vertical mode
C          20/02/1997 Added then removed BARCAP_1
C          14/07/1997 win32 version
C          04/02/1998 Added NFILES to argument list for GKSFIL
C          09/03/1998 Added VECTOR_FIELD
c          07/01/2003 redimensioned WIDE(5*NRMAX) and used offset for
c                     error-bar/symbol linewidths
C          01/05/2003 edited to make PSHOW(I) and IADD1 consistent with LOOP1$
C          10/05/2007 added INTENTS and NLOG to arguments
C          01/01/2008 added NXTRA
C          16/08/2008 added check for outline symbols (30 =< M =< 33)  
C          30/11/2010 added WIDE_PANEL and allows up to 8 keys in bottom panel
C          01/02/2011 added call to NSTEP1 and SAVINT$ 
C          11/02/2001 corrected YMAXA, YMINA abd added ISHAPE to corect for FLAT aspect ratio
C                     and added PANEL_LINES and PANEL_SYMBOLS 
C          14/06/2011 added code to plot up to 10 bottom panel items
C
C
C Draw the points on the graph as follows:-
C GKSFIL to read in coordinates from input files
C GKSTRN to transform coordinates depending on MTRANS
C GKSHOL
C
C Note: Second loop which must be called after a previous call to LOOP01$
C       Call GKSHOL to draw/fill-in markers if in feasible region
C
      IMPLICIT    NONE
C
C Integers in argument list
C
      INTEGER, INTENT (IN)    :: IPANEL, ISHAPE, KPANEL, NGRAFS, NIN,
     +                           NLOG, NMAX, NWORDS, NXTRA  
      INTEGER, INTENT (IN)    :: M(NGRAFS), MTRANS, NFILES   
      INTEGER, INTENT (INOUT) :: IFILL(NXTRA), IHUE(NXTRA), 
     +                           JCOLOR(NGRAFS), LCTEMP
      INTEGER, INTENT (INOUT) :: ICOLOR, NPANEL, NPTS, NT, NTYPE
C
C Reals in argument list
C      
      DOUBLE PRECISION, INTENT (IN)    :: YMIN1
      DOUBLE PRECISION, INTENT (INOUT) :: A, ASYMP, C, CZ,
     +                                    FACTOR(NXTRA), PSCALE,
     +                                    SIZE(NGRAFS), WIDE(5*NGRAFS),
     +                                    XMAX, XMIN, YDELTA, YDIFF,
     +                                    YMAX, YMIN, YPDIFF, 
     +                                    YPXTRA, ZMAX, ZMIN, ZSCALE  
      DOUBLE PRECISION, INTENT (INOUT) :: YMAX3, YMAX4, YMIN3, YMIN4  
      DOUBLE PRECISION, INTENT (INOUT) :: XPANEL(2), YPANEL(2)
      DOUBLE PRECISION, INTENT (INOUT) :: X(NMAX), XH(NMAX), XHT(NMAX),
     +                                    XL(NMAX), XLT(NMAX),
     +                                    XT(NMAX), 
     +                                    Y(NMAX), YH(NMAX), YHT(NMAX),
     +                                    YL(NMAX), YLT(NMAX), YT(NMAX) 
C
C Character in argument list
C     
      CHARACTER (LEN = *), INTENT (IN) :: FSAV(NGRAFS)
C
C Logicals in argument list
C      
      LOGICAL, INTENT (IN)  :: BARCAP(NGRAFS), BAR_CHART, MONO,
     +                         NATLOG(NLOG), PANEL, PANEL_LINES, 
     +                         PANEL_SYMBOLS, PS, 
     +                         PSHOW(KPANEL), SIDE, VECTOR_FIELD,
     +                         VIDEO, WIDE_PANEL, YAXIS(NGRAFS)
      LOGICAL, INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    K0, K1, K2, K3, K4, K5, K6, K7, K8, K9, K10, K15, K19, 
     +           K20, K29
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K7 = 7, K8 = 8, K9 = 9, K10 = 10, K15 = 15, K19 = 19,
     +           K20 = 20, K29 = 29)
      INTEGER    I, IADD1, IFILL1, ISEND, JSEND, NGRAF2, NHATCH, NSTEP
      DOUBLE PRECISION ONE, TWO, THREE, FOUR, TEN
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, THREE = 3.0D+00,
     +           FOUR = 4.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION PNT25, PNT275, PNT5, PNT75, ONETHD, TWOTHD, 
     +                 X2LEFT, XSHIFT
      PARAMETER (PNT25 = 0.25D+00, PNT275 = 0.275D+00, PNT5 = 0.5D+00,
     +           PNT75 = 0.75D+00, ONETHD = ONE/THREE, 
     +           TWOTHD = TWO/THREE, X2LEFT = 0.05D+00, 
     +           XSHIFT = ONE/(THREE*FOUR))
      DOUBLE PRECISION EXTRA, XDRAG
      PARAMETER (EXTRA = 0.0625D+00, XDRAG = 0.040D+00)
      DOUBLE PRECISION D19
      PARAMETER (D19 = 19.0D+00)
      DOUBLE PRECISION BSIZE
      DOUBLE PRECISION SIZNUM, XDIFF, XTEMP(1)
      DOUBLE PRECISION XMAXA, XMINA, YMAXA, YMINA
      CHARACTER  TITLE*80
      LOGICAL    SIDE1
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   GKSFIL$, GKSTRN$, GKSHOL$, PLTBAR$, SAVINT$
      EXTERNAL   NSTEP1 
      INTRINSIC  DBLE, MAX
C
C Initialise
C                
      ABORT = .FALSE.
      NGRAF2 = K2*NGRAFS
      XDIFF = PNT5*(XMAX - XMIN)
      XMAXA = XMAX + XDIFF
      XMINA = XMIN - XDIFF
      YMAXA = YMAX + PNT5*(YMAX - YMIN)
      YMINA = YMIN - PNT5*(YMAX - YMIN)
C
C Redefine XDIFF then loop over the data files
C
      XDIFF = XMAX - XMIN
      IADD1 = K0
      DO I = K1, NFILES
C
C Increment IADD1 if PSHOW(i) = .TRUE. as defined by a previous call to LOOP01$
C
         IF (I.LE.KPANEL) THEN
            IF (PSHOW(I)) IADD1 = IADD1 + K1
         ENDIF  
C
C Open a file for plotting only if a symbol is required
C
         IF (M(I).NE.K0) THEN
            ISEND = K2
            CLOSE (UNIT = NIN)
            CALL GKSFIL$(IFILL, IHUE, ISEND, NFILES, K1, NIN, NMAX,
     +                   NPTS, NTYPE, NWORDS, NXTRA,
     +                   FACTOR, X, XH, XL, Y, YH,
     +                   YL, YMAX3, YMAX4, YMIN3, YMIN4,
     +                   FSAV(I), TITLE,
     +                   ABORT, BAR_CHART, VECTOR_FIELD)
            CLOSE (UNIT = NIN)
            CALL GKSTRN$(MTRANS, NPTS, NLOG, NT, NTYPE,
     +                   ASYMP,
     +                   X, XH, XHT, XL, XLT, XT,
     +                   Y, YH, YHT, YL, YLT, YT, 
     +                   NATLOG)
            IF (NT.GT.K0) THEN
C
C Correct for stepping over intermediate points if required
C              
               ISEND = K2
               JSEND = I
               CALL SAVINT$ (ISEND, JSEND, NSTEP,
     +                       STORE) 
               IF (NSTEP.GT.0) CALL NSTEP1 (NSTEP, NT,
     +                                      XT, YT)                              
               IF (MONO) THEN
                  IF (VIDEO) THEN
                     ICOLOR = K0
                  ELSE
                     ICOLOR = K15
                  ENDIF
               ELSE
                  ICOLOR = JCOLOR(I)
               ENDIF
               IF (M(I).EQ.K1) THEN
                  SIZNUM = PNT25*SIZE(I)*ZSCALE
               ELSE
                  SIZNUM = SIZE(I)*ZSCALE
               ENDIF
               IF (YAXIS(I)) THEN
                  IF (M(I).GE.K20 .AND. M(I).LE.K29) THEN
                     IFILL1 = M(I) - K19
                     SIDE1 = .FALSE.
                     NHATCH = 80
                     CALL PLTBAR$(ICOLOR, IFILL1, K1, LCTEMP, NHATCH,
     +                            NT,
     +                            SIZE(I), WIDE(I), WIDE(NGRAFS + I),
     +                            XT, XMAX, XMIN, YT, YMAX,
     +                            YMIN,
     +                            BARCAP(I), PS, SIDE1)
                  ELSE
                     CALL GKSHOL$(ICOLOR, K1, LCTEMP, M(I), NT,
     +                            A, C, SIZNUM, WIDE(NGRAF2 + I),
     +                            XT, XMAX, XMIN, YT, YMAX, YMIN)
                  ENDIF
               ELSE
                  IF (M(I).GE.K20 .AND. M(I).LE.K29) THEN
                     IFILL1 = M(I) - K19
                     SIDE1 = .FALSE.
                     NHATCH = 80
                     CALL PLTBAR$(ICOLOR, IFILL1, K4, LCTEMP, NHATCH,
     +                            NT,
     +                            SIZE(I), WIDE(I), WIDE(NGRAFS + I),
     +                            XT, XMAX, XMIN, YT, YMAX,
     +                            YMIN,
     +                            BARCAP(I), PS, SIDE1)
                  ELSE
                     CALL GKSHOL$(ICOLOR, K4, LCTEMP, M(I), NT,
     +                            A, CZ, SIZNUM, WIDE(NGRAF2 + I),
     +                            XT, XMAX, XMIN, YT, ZMAX, ZMIN)
                  ENDIF
               ENDIF
               IF (I.LE.KPANEL .AND. PANEL .AND. PANEL_SYMBOLS .AND.
     +            .NOT.BAR_CHART) THEN
                  IF (PSHOW(I)) THEN
                     NPANEL = K1
                     IF (M(I).EQ.K1) THEN
                        SIZNUM = SIZE(I)*PNT5*PNT25*ZSCALE
                     ELSE
                        SIZNUM = SIZE(I)*PNT5*ZSCALE
                     ENDIF
                     IF (SIDE) THEN
C
C Calculations of YPANEL if SIDE = .TRUE. (XPANEL has already been calculated)
C
                        BSIZE = ONE
                        YPANEL(1) = YMAX -
     +                  (DBLE(IADD1) + YPXTRA - ONE)*YDIFF/D19
                        NHATCH = 80
                     ELSE
C
C Calculations of XPANEL and YPANEL if SIDE = .FALSE.
C Note: as in LOOP01$ this depends on the value of IPANEL
C
                        BSIZE = ONE
                        IF (IPANEL.EQ.K1) THEN
                           XPANEL(1) = XMIN + PNT5*XDIFF
                        ELSEIF (IPANEL.EQ.K2) THEN
                           IF (IADD1.EQ.K1) THEN
                              XPANEL(1) = XMIN + 0.21D+00*XDIFF
                           ELSE
                              XPANEL(1) = XMIN + 0.73D+00*XDIFF
                           ENDIF
                        ELSEIF (IPANEL.EQ.K3) THEN
                           IF (IADD1.EQ.K1) THEN
                              XPANEL(1) = XMIN + XSHIFT*XDIFF
                           ELSEIF (IADD1.EQ.K2) THEN
                              XPANEL(1) = XMIN + ONETHD*XDIFF
     +                                    + XSHIFT*XDIFF
                           ELSE
                              XPANEL(1) = XMIN + TWOTHD*XDIFF
     +                                    + XSHIFT*XDIFF
                           ENDIF
                        ELSEIF (IPANEL.EQ.K4) THEN
                           IF (IADD1.EQ.K1 .OR. IADD1.EQ.K3) THEN
                              XPANEL(1) = XMIN + 0.21*XDIFF
                           ELSE
                              XPANEL(1) = XMIN + 0.73*XDIFF
                           ENDIF
                        ELSEIF (IPANEL.LE.K6) THEN
                           IF (IADD1.EQ.K1 .OR. IADD1.EQ. K4) THEN
                              XPANEL(1) = XMIN + XSHIFT*XDIFF
                           ELSEIF (IADD1.EQ.K2 .OR. IADD1.EQ.K5) THEN
                              XPANEL(1) = XMIN + ONETHD*XDIFF
     +                                    + XSHIFT*XDIFF
                           ELSE
                              XPANEL(1) = XMIN + TWOTHD*XDIFF
     +                                    + XSHIFT*XDIFF
                           ENDIF
                        ELSEIF (IPANEL.LE.K8) THEN
                           IF (IADD1.EQ.K1 .OR. IADD1.EQ.K5) THEN
                              XPANEL(1) = XMIN + XSHIFT*XDIFF
                           ELSEIF (IADD1.EQ.K2 .OR. IADD1.EQ.K6) THEN
                              XPANEL(1) = XMIN + PNT25*XDIFF
     +                                    + XSHIFT*XDIFF
                           ELSEIF (IADD1.EQ.K3 .OR. IADD1.EQ.K7) THEN
                              XPANEL(1) = XMIN + PNT5*XDIFF
     +                                    + XSHIFT*XDIFF
                           ELSE
                              XPANEL(1) = XMIN + PNT75*XDIFF
     +                                    + XSHIFT*XDIFF
                           ENDIF 
                        ELSEIF (IPANEL.LE.K10) THEN
                           IF (IADD1.EQ.K1 .OR. IADD1.EQ.K6) THEN
                              XPANEL(1) = XMIN + XSHIFT*XDIFF
     +                                    - EXTRA*XDIFF                               
                           ELSEIF (IADD1.EQ.K2 .OR. IADD1.EQ.K7) THEN
                              XPANEL(1) = XMIN + PNT25*XDIFF
     +                                    + XSHIFT*XDIFF
     +                                    - EXTRA*XDIFF  
     +                                    - XDRAG *XDIFF                           
                           ELSEIF (IADD1.EQ.K3 .OR. IADD1.EQ.K8) THEN
                              XPANEL(1) = XMIN + PNT5*XDIFF
     +                                    + XSHIFT*XDIFF
     +                                    - EXTRA*XDIFF                               
     +                                    - TWO*XDRAG*XDIFF                            
                           ELSEIF (IADD1.EQ.K4 .OR. IADD1.EQ.K9) THEN
                              XPANEL(1) = XMIN + PNT75*XDIFF
     +                                    + XSHIFT*XDIFF
     +                                    - EXTRA*XDIFF 
     +                                    - THREE*XDRAG*XDIFF                            
                           ELSE
                              XPANEL(1) = XMIN + XDIFF
     +                                    + XSHIFT*XDIFF
     +                                    - EXTRA*XDIFF                                           
     +                                    - FOUR*XDRAG*XDIFF                            
                           ENDIF              
                        ENDIF
                        XPANEL(2) = XPANEL(1)
                        IF (IPANEL.LE.K3) THEN
                           YPANEL(1) = YMIN1 + PNT5*YPDIFF*YDELTA
                        ELSEIF (IPANEL.EQ.4) THEN
                           IF (IADD1.LE.K2) THEN
                              YPANEL(1) = YMIN1 + TWOTHD*YPDIFF*YDELTA
                              IF (ISHAPE.EQ.4) YPANEL(1) = YPANEL(1) +
     +                                         YPDIFF*YDELTA/TEN                                
                           ELSE
                              YPANEL(1) = YMIN1 + ONETHD*YPDIFF*YDELTA
                           ENDIF
                        ELSEIF (IPANEL.LE.6) THEN
                           IF (IADD1.LE.K3) THEN
                              YPANEL(1) = YMIN1 + TWOTHD*YPDIFF*YDELTA
                              IF (ISHAPE.EQ.4) YPANEL(1) = YPANEL(1) +
     +                                         YPDIFF*YDELTA/TEN                                
                           ELSE
                              YPANEL(1) = YMIN1 + ONETHD*YPDIFF*YDELTA
                           ENDIF 
                        ELSEIF (IPANEL.LE.K8) THEN     
                           IF (IADD1.LE.K4) THEN
                              YPANEL(1) = YMIN1 + TWOTHD*YPDIFF*YDELTA
                              IF (ISHAPE.EQ.4) YPANEL(1) = YPANEL(1) +
     +                                         YPDIFF*YDELTA/TEN                                
                           ELSE
                              YPANEL(1) = YMIN1 + ONETHD*YPDIFF*YDELTA
                           ENDIF
                        ELSEIF (IPANEL.LE.K10) THEN     
                           IF (IADD1.LE.K5) THEN
                              YPANEL(1) = YMIN1 + TWOTHD*YPDIFF*YDELTA
                              IF (ISHAPE.EQ.4) YPANEL(1) = YPANEL(1) +
     +                                         YPDIFF*YDELTA/TEN                                
                           ELSE
                              YPANEL(1) = YMIN1 + ONETHD*YPDIFF*YDELTA
                           ENDIF   
                        ENDIF
                        IF (ISHAPE.EQ.4) YPANEL(1) = YPANEL(1) +
     +                                   YPDIFF*YDELTA  
                        YPANEL(2) = YPANEL(1)                                 
                        NHATCH = 80
                     ENDIF
                     IF (PANEL_LINES .AND. WIDE_PANEL) THEN
C
C If PANEL_LINES = .TRUE. and WIDE_PANEL = .TRUE. define XTEMP(1) = XPANEL(1) 
C                       
                        XTEMP(1) = MAX(XPANEL(1),XPANEL(2))
                     ELSEIF (SIDE) THEN
C
C Move the symbol to the right if WIDE_PANEL = .FALSE.
C                     
                        XTEMP(1) = MAX(XPANEL(1),XPANEL(2)) + 
     +                             PNT275*ABS(XPANEL(2) - XPANEL(1))   
                     ELSE
C
C Move the symbol to the right if WIDE_PANEL = .FALSE.
C                     
                        XTEMP(1) = XPANEL(1) + XSHIFT*XDIFF /TWO
                     ENDIF   
                     IF (M(I).GE.K20 .AND. M(I).LE.K29) THEN
                        IFILL1 = M(I) - K19
                        SIDE1 = .TRUE.
                        CALL PLTBAR$(ICOLOR, IFILL1, K3, LCTEMP, NHATCH,
     +                               NPANEL,
     +                               BSIZE, WIDE(I), WIDE(NGRAFS + I),
     +                               XTEMP, XMAX, XMIN,
     +                               YPANEL, YMAX, YMIN,
     +                               BARCAP(I), PS, SIDE1)
                     ELSE
                        IF (.NOT.SIDE .AND. .NOT.WIDE_PANEL)
     +                      XTEMP(1) = XTEMP(1) - X2LEFT*XDIFF
                        CALL GKSHOL$(ICOLOR, K3, LCTEMP, M(I), NPANEL,
     +                               A, C, PSCALE*SIZNUM,
     +                               WIDE(NGRAF2 + I),
     +                               XTEMP, XMAXA, XMINA,
     +                               YPANEL, YMAXA, YMINA)
                     ENDIF
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
      ENDDO
      END
C
C
