
C
C
      SUBROUTINE LOOP03$(ICOLOR, IFONT, IPANEL, ISHAPE, KCOLOR, KPANEL,
     +                   L, M, NFILES, NKCOL, NGKS, NOUT_PS,
     +                   SIZE, XSTART,
     +                   YPCHT, YPDIFF, YPMAX, YPMIN, YPXTRA, Y_SCALE,
     +                   PLINE, PSYMB,
     +                   HARD_COPY, HPGL, MONO, PANEL, PANEL_LINES, PS,
     +                   PSHOW, SIDE, VIDEO, WIDE_PANEL)
C
C
C ACTION : Text etc. for panel in simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 7/6/95
C          03/10/1996 Added PLTSTR
C          14/07/1997 win32 version
C          14/01/2003 moved strings sideways to make room for line through
C                     plotting symbol in keys
C          19/10/2004 added ITYPE, XSIZE, STORE, FSIZES$  
C          10/05/2007 added INTENTS 
C          30/11/2010 now allows up to 8 keys in bottom panel
C          07/12/2010 increased the right shift when there are no lines or large symbols
C          11/02/2011 added ISHAPE and correction to bottom panel in FLAT aspect ratio 
C                     and FACTOR to move panel labels up or down if the size is not 1 
C                     also added PANEL_LINES
C          14/06/2011 added code to plot up to 10 bottom panel items
C
C Third loop: Draw text next to line/marker for panel if required .....
C
      IMPLICIT    NONE
C
C Arument list
C
      INTEGER,             INTENT (IN)    :: KPANEL, NFILES, NGKS,
     +                                       NKCOL, NOUT_PS
      INTEGER,             INTENT (IN)    :: IFONT, IPANEL, ISHAPE,
     +                                       KCOLOR(NKCOL),
     +                                       L(NFILES), M(NFILES) 
      INTEGER,             INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION,    INTENT (IN)    :: SIZE, XSTART, YPCHT,
     +                                       YPDIFF, YPMAX, YPMIN,
     +                                       YPXTRA, Y_SCALE
      CHARACTER (LEN = *), INTENT (IN)    :: PLINE(KPANEL),
     +                                       PSYMB(KPANEL)
      LOGICAL,             INTENT (IN)    :: HARD_COPY, HPGL, MONO, 
     +                                       PANEL, PANEL_LINES, PS,
     +                                       PSHOW(KPANEL),
     +                                       SIDE, VIDEO, WIDE_PANEL
C
C Locals
C
      INTEGER    I, IADD1, NFONT
      INTEGER    K0, K1, K2, K3, K4, K5, K6, K7, K8, K9, K10, K15, K20
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K7 = 7, K8 = 8, K9 = 9, K10 = 10, K15 = 15, K20 = 20)
      INTEGER    ITYPE
      PARAMETER (ITYPE = 10)
      DOUBLE PRECISION ONE, TWO, THREE, FOUR, FIVE, SIX, TEN, D19
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, THREE = 3.0D+00,
     +           FOUR = 4.0D+00, FIVE = 5.0D+00, SIX = 6.0D+00, 
     +           TEN = 10.0D+00, D19 = 19.0D+00)
      DOUBLE PRECISION ANGLE, ZERO, FACTOR
      PARAMETER (ANGLE = 0.0D+00, ZERO = 0.0D+00, FACTOR = 0.02D+00)
      DOUBLE PRECISION PNT5, ONETHD, TWOTHD, X2LEFT
      PARAMETER (PNT5 = 0.5D+00, ONETHD = ONE/THREE,
     +           TWOTHD = TWO/THREE, X2LEFT = 0.04D+00)
      DOUBLE PRECISION EXTRA, XDRAG
      PARAMETER (EXTRA = 0.065D+00, XDRAG = 0.0375D+00)
      DOUBLE PRECISION XSHIFT, XSIZE
      DOUBLE PRECISION SLANT, XBEGIN, YBEGIN
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   GSELNT$, PLTSTR$, WGBFNT$, FSIZES$
      INTRINSIC  DBLE, MIN
      IF (PANEL) THEN
C
C Define the standard XSHIFT to move labels to the right 
C
         IF (SIDE) THEN 
            XSHIFT = 0.025D+00
         ELSE
            XSHIFT = 0.03D+00
         ENDIF      
         CHECKOUT: DO I = K1, NFILES
            IF ((PANEL_LINES.AND.L(I).GT.K0) .OR. M(I).GE.K20) THEN
C
C Increase the shift if there are any lines or large symbols
C              
               XSHIFT = 0.04D+00
               EXIT CHECKOUT
            ENDIF
         ENDDO CHECKOUT
C
C Define the font
C
         CALL FSIZES$(ITYPE,
     +                XSIZE,
     +                STORE)
         IF (PS) WRITE (NOUT_PS,100) XSIZE
         CALL WGBFNT$(I, NFONT,
     +                SLANT)
         IF (MONO) THEN
            IF (VIDEO) THEN
               ICOLOR = K0
            ELSE
               ICOLOR = K15
            ENDIF
         ELSE
            ICOLOR = KCOLOR(5)
         ENDIF
C
C Set the transformation then loop over the files
C
         CALL GSELNT$(K2)
         IADD1 = K0
         DO I = K1, MIN(KPANEL,NFILES)
            IF (PSHOW(I)) THEN
               IADD1 = IADD1 + K1
               IF (SIDE) THEN
C
C Calculations if SIDE = .TRUE.
C
                  XBEGIN = XSTART
                  YBEGIN = YPMAX -
     +            (DBLE(IADD1) + YPXTRA - ONE)*YPDIFF/D19
               ELSE
C
C Calculations if SIDE = .FALSE.
C
                  IF (IPANEL.EQ.K1) THEN
                     XBEGIN = 0.55D+00
                  ELSEIF (IPANEL.EQ.K2) THEN
                     IF (IADD1.EQ.K1) THEN
                        XBEGIN = 0.26125D+00
                     ELSE
                        XBEGIN = 0.74125D+00
                     ENDIF
                  ELSEIF (IPANEL.EQ.K3) THEN
                     IF (IADD1.EQ.K1) THEN
                        XBEGIN = ONE/SIX - 0.02D+00
                     ELSEIF (IADD1.EQ.K2) THEN
                        XBEGIN = PNT5 - 0.05D+00
                     ELSE
                        XBEGIN = FIVE/SIX - 0.08D+00
                     ENDIF
                  ELSEIF (IPANEL.EQ.K4) THEN
                     IF (IADD1.EQ.K1 .OR. IADD1.EQ.K3) THEN
                        XBEGIN = 0.26125D+00
                     ELSE
                        XBEGIN = 0.74125D+00
                     ENDIF
                  ELSEIF (IPANEL.LE.K6) THEN
                     IF (IADD1.EQ.K1 .OR. IADD1.EQ.K4) THEN
                        XBEGIN = ONE/SIX - 0.02D+00
                     ELSEIF (IADD1.EQ.K2 .OR. IADD1.EQ.K5) THEN
                        XBEGIN = PNT5 - 0.05D+00
                     ELSE
                        XBEGIN = FIVE/SIX - 0.08D+00
                     ENDIF
                  ELSEIF (IPANEL.LE.K8) THEN
                    IF (IADD1.EQ.K1 .OR. IADD1.EQ.K5) THEN
                        XBEGIN = ONE/SIX - 0.02D+00
                     ELSEIF (IADD1.EQ.K2 .OR. IADD1.EQ.K6) THEN
                        XBEGIN = PNT5 - 0.125D+00
                     ELSEIF (IADD1.EQ.K3 .OR. IADD1.EQ.K7) THEN
                        XBEGIN = PNT5 + 0.1D+00   
                     ELSE
                        XBEGIN = FIVE/SIX 
                     ENDIF   
                  ELSEIF (IPANEL.LE.K10) THEN
                    IF (IADD1.EQ.K1 .OR. IADD1.EQ.K6) THEN
                        XBEGIN = ONE/SIX - 0.02D+00
     +                           - EXTRA                         
                     ELSEIF (IADD1.EQ.K2 .OR. IADD1.EQ.K7) THEN
                        XBEGIN = PNT5 - 0.125D+00
     +                           - EXTRA 
     +                           - XDRAG                        
                     ELSEIF (IADD1.EQ.K3 .OR. IADD1.EQ.K8) THEN
                        XBEGIN = PNT5 + 0.1D+00   
     +                           - EXTRA 
     +                           - TWO*XDRAG                        
                     ELSEIF (IADD1.EQ.K4 .OR. IADD1.EQ.K9) THEN
                        XBEGIN = FIVE/SIX    
     +                           - EXTRA                         
     +                           - THREE*XDRAG                        
                     ELSE
                        XBEGIN = FIVE/SIX + 0.225D+00
     +                           - EXTRA                         
     +                           - FOUR*XDRAG                        
                     ENDIF      
                  ENDIF
                  IF (IPANEL.LE.K3) THEN
                     YBEGIN = YPMIN + PNT5*YPDIFF
                  ELSEIF (IPANEL.EQ.K4) THEN
                     IF (IADD1.LE.K2) THEN
                        YBEGIN = YPMIN + TWOTHD*YPDIFF
                        IF (ISHAPE.EQ.4) YBEGIN = YBEGIN + YPDIFF/TEN
                     ELSE
                        YBEGIN = YPMIN + ONETHD*YPDIFF
                     ENDIF
                  ELSEIF (IPANEL.LE.K6) THEN   
                     IF (IADD1.LE.K3) THEN
                        YBEGIN = YPMIN + TWOTHD*YPDIFF
                        IF (ISHAPE.EQ.4) YBEGIN = YBEGIN + YPDIFF/TEN
                     ELSE
                        YBEGIN = YPMIN + ONETHD*YPDIFF
                     ENDIF
                  ELSEIF (IPANEL.LE.K8) THEN   
                     IF (IADD1.LE.K4) THEN
                        YBEGIN = YPMIN + TWOTHD*YPDIFF
                        IF (ISHAPE.EQ.4) YBEGIN = YBEGIN + YPDIFF/TEN
                    ELSE
                        YBEGIN = YPMIN + ONETHD*YPDIFF
                     ENDIF 
                  ELSEIF (IPANEL.LE.K10) THEN   
                     IF (IADD1.LE.K5) THEN
                        YBEGIN = YPMIN + TWOTHD*YPDIFF
                        IF (ISHAPE.EQ.4) YBEGIN = YBEGIN + YPDIFF/TEN
                    ELSE
                        YBEGIN = YPMIN + ONETHD*YPDIFF
                     ENDIF                        
                  ENDIF  
                  IF (ISHAPE.EQ.4) YBEGIN = YBEGIN +
     +                             (ONE - THREE*FACTOR)*YPDIFF                    
               ENDIF
C
C Alter YBEGIN if GKS is not used to centralise text string vertically
C
               XBEGIN = XBEGIN + XSHIFT
               YBEGIN = YBEGIN - YPCHT/THREE
               IF (ISHAPE.EQ.4) THEN 
                  YBEGIN = YBEGIN + FACTOR*(ONE - XSIZE)/THREE
               ELSE   
                  YBEGIN = YBEGIN + FACTOR*(ONE - XSIZE)
               ENDIF 
               IF (.NOT.SIDE .AND. .NOT.WIDE_PANEL)
     +             XBEGIN = XBEGIN - X2LEFT
               CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +                      ANGLE, XSIZE*SIZE, ZERO, XBEGIN, YBEGIN,
     +                      Y_SCALE,
     +                      BLANK, PLINE(I), PSYMB(I), 'tl',
     +                      HARD_COPY, HPGL, PS)
            ENDIF
         ENDDO
         IF (PS) WRITE (NOUT_PS,100) ONE/XSIZE
      ENDIF                        
C
C This format statement must NOT be edited
C      
  100 FORMAT ('/tl-size tl-size',1X,f7.3,1X,'mul def')
      END
C
C
