C
C This is the main module used by GKSGRF$ to allocate workspace 
C
C MODULE_SAVEGKS
C GKSSAV$ ... the main gateway to allocate dimensions in the module  
C SAVINT$ ... store/retrieve integers one at a time       
C SAVLGL$ ... store/retrieve logicals one at a time
C SAVCHR$ ... store/retrieve character strings one at a time
C SAVPNL$ ... store/retrieve panel labels and vectors
C TXTKEY$ ... store/retrieve panel(1-20), and label(1-20) panel character vectors
C
C Note: This module and related subroutines are based on the assumption that
C       there are 5 title/legend-type text vectors and that dimensions in
C       the rest of the DLL are as follows:
C       NGRAFS = 300  ... total number of graphs possible
C       NWORDS = 2000 ... total number of labels possible
C

C
C*****************************************************************
C-----------------------------------------------------------------
C Start of module to replace savegks.ins
C-----------------------------------------------------------------
C

      MODULE MODULE_SAVEGKS

      IMPLICIT NONE

c
c Saved variables to communicate graphics parameters between the
c menu subroutines. These are copies of the arguments which are
c shared, or where the dimensions are to be unified.
c The parameters NGRAF1, NXTRA1, and NWORD1 should be equal to the
c corresponding dimensions NGRAFS, NXTRA, and NWORDS in the calling
c programs, but for safety they can be larger.
c
c Dimensions in simplot and w_graphics.dll at 11/07/2005 are:
c ngrafs = 300
c nwords = 2000
c
c 07/01/2003 redimensioned wide_1(5*ngraf1)
c 11/07/2005 increased NWORD1 from 1000 to 2000
c 21/12/2007 added xlabel_1
c 18/01/2008 suppressed common blocks and added all the saved variables
c 23/10/2010 added rotate_z 
c 30/11/2010 added wide_panel
c 12/07/2011 added labvec_1, labvec_1_new etc.
c 16/09/2011 transferred everything to module_clearwin except allocatable arrays
c
 
c
c allocatable arrays
c
      
      double precision, allocatable ::  x(:),  xh(:), xht(:),
     +                                 xl(:), xlt(:),  xt(:),
     +                                  y(:),  yh(:), yht(:),
     +                                 yl(:), ylt(:),  yt(:)
c
c saved scalar
c      
      integer    nmax1
      data       nmax1 / 500 /
      
      
c
c global save
c     
      save
      
      END MODULE MODULE_SAVEGKS

C
C-----------------------------------------------------------------
C End of module to replace savegks.ins
C-----------------------------------------------------------------
C*****************************************************************
C
