c
c
      subroutine mtplot (isend, ncmax, ncol, nrmax, nrow,
     +                   a)
c
c action: plot arbitrary rows or columns from a matrix
c author: w.g.bardsley, university of manchester, u.k.
c         12/01/2008 derived from matplt by eliminating nout and biplot
c         20/10/2010 added crplot
c
c         isend: (input/unchanged) as follows:
c                isend = 1: only a vector is supplied
c                isend = 2: only columns can be plotted
c                isend = 3: only rows can be plotted
c                isend = 4: rows or columns can be plotted
c         ncmax: (input/unchanged) dimension
c          ncol: (input/unchanged) no. of columns supplied
c         nrmax: (input/unchanged) dimension
c          nrow: (input/unchanged) no. of rows supplied
c             a: (input/unchanged) matrix of values for plotting 
c
c Note: nwmax restricts the number of points plus labels that can be plotted
c
      implicit   none
c
c arguments
c
      integer,          intent (in) :: isend, ncmax, ncol, nrmax,
     +                                 nrow
      double precision, intent (in) :: a(nrmax,ncmax)
c
c local allocatable arrays 
c      
      double precision, allocatable :: x(:), xtemp(:), y(:), ytemp(:),
     +                                 z(:)
c
c locals
c
      integer    nwmax, nfiles, nmax, ntype, numopt, numtxt
      parameter (nwmax = 2000, nfiles = 1, ntype = 3, numopt = 19,
     +           numtxt = 25)
      integer    numbld(numtxt)
      integer    jfiles(nfiles), lfiles(nfiles), mfiles(nfiles)
      integer    i, ierr, j, jsend, npts, npt1, ntemp, numdec, nxcol,
     +           nycol, nzcol, nxrow, nyrow, nzrow
      integer    l1, m1, n1
      parameter (l1 = 0)
      double precision zero
      parameter (zero = 0.0d+00)
      character  line*100, text(numopt)*100
      character  cipher(numopt)*10, info(numtxt)*100
      character  ptitle*50, xtitle*50, ytitle*50
      character  fname*1024, sim256*1024
      character  blank*1, notav*10
      parameter (blank = ' ', notav = '[NA]')
      character  filex*1024, header*22, labfil*12, title2*80  
c                                                                 
c-----------------------------------------------------------------
c header and labfil must not be edited as they are used by simplot
c      
      parameter (header = '%simfitplotlabelsfile%',
     +           labfil = 'f$labels.tmp',
     +           title2 = 'Data Values')    
c-----------------------------------------------------------------  
c                                                                 
c-----------------------------------------------------------------
c rotfil and word24 must not be edited as they are used by simplot
c      
      character rotfil*12, word24*24
      parameter (word24 = '%simfitrotatelabelsfile%',
     +           rotfil = 'f$rotate.tmp')
      character  begin_labels*13, end_labels*11
      parameter (begin_labels = 'begin{labels}',
     +             end_labels = 'end{labels}')
c-----------------------------------------------------------------        
      character  files(nfiles)*1024, titles(4)*50
      logical    cols, repeet, rows, vector
      logical    plot_columns
      logical    askif, there
      parameter (askif = .false.)
      logical    plot_arrows, plot_labels, plot_lines,
     +           plot_perpendiculars, plot_symbols
      parameter (plot_arrows = .false., 
     +           plot_labels = .true.,
     +           plot_lines = .false.,
     +           plot_perpendiculars = .true., 
     +           plot_symbols = .true.)   
      external   putfat, listbx, getjm1, gks001, hnplot, getnou, gettmp,
     +           deleet, patch2, viewit, sim256, space6$
      external   space5$, smplot$, crplot
      intrinsic  max, min, dble
      save       nxcol, nycol, nzcol
      save       nxrow, nyrow, nzrow
      data       nxcol, nycol, nzcol / 1, 2, 3 /
      data       nxrow, nyrow, nzrow / 1, 2, 3 /
c
c check dimensions
c
      if (ncol.lt.1 .or. nrow.lt.1 .or.
     +    ncol.gt.ncmax .or. nrow.gt.nrmax) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c check isend
c
      cols = .false.
      rows = .false.
      vector = .false.
      if (isend.eq.1 .and. ncol.eq.1) then
         cols = .true.
         vector = .true.
      elseif (isend.eq.2) then
         cols = .true.
      elseif (isend.eq.3) then
         rows = .true.
      elseif (isend.eq.4) then
         cols = .true.
         rows = .true.
      else
         write (line,200)
         call putfat (line)
         return
      endif
c
c allocate workspaces
c                    
      ierr = 0
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xtemp)) deallocate(xtemp, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(ytemp)) deallocate(ytemp, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(z)) deallocate(z, stat = ierr)
      if (ierr.ne.0) return         
      nmax = max(ncol,nrow)
      allocate(x(nmax), stat = ierr)
      if (ierr.ne.0) return 
      allocate(xtemp(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(ytemp(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(z(nmax), stat = ierr)
      if (ierr.ne.0) return  
c
c initialise
c
      do i = 1, numopt
         if (i.lt.numopt - 2) then
            cipher(i) = notav
         else
            cipher(i) = blank
         endif
      enddo
      do i = 1, numtxt
         if (i.eq.1 .or. i.eq.6 .or. i.eq.10 .or. i.eq.15 .or.
     +       i.eq.20 .or. i.eq.24) then
            numbld(i) = 1
         else
            numbld(i) = 0
         endif
      enddo   

      jfiles(1) = 0
      lfiles(1) = 0
      mfiles(1) = 1
      titles(4) = blank
c
c adjustments
c
      if (cols .and. ncol.eq.1) vector = .true.
      do i = 1, numopt - 2
         if (i.ge.1 .and. i.le.3 .and. cols) then
            cipher(i) = blank
         elseif (i.ge.4 .and. i.le.5 .and. cols .and. ncol.gt.1) then
            cipher(i) = blank
         elseif (i.ge.6 .and. i.le.8 .and. cols .and. ncol.gt.2) then
            cipher(i) = blank
         elseif (i.ge.9 .and. i.le.11 .and. rows) then
            cipher(i) = blank
         elseif (i.ge.12 .and. i.le.13 .and. rows .and. nrow.gt.1) then
            cipher(i) = blank
         elseif (i.ge.13 .and. i.le.16 .and. rows .and. nrow.gt.2) then
            cipher(i) = blank 
         endif
      enddo
c
c create the menu
c
      write (text,300) (cipher(i), i = 1, numopt - 3)
c
c main loop
c
      numdec = numopt - 1
      repeet = .true.
      do while (repeet)
         call listbx (numdec, numopt,
     +                text)
         if (cipher(numdec).eq.notav) then
            write (line,400)
            call putfat (line)
            numdec = 0
         endif
          if (numdec.eq.5 .and. ncol.gt.nwmax .or.
     +        numdec.eq.7 .and. ncol.gt.nwmax .or. 
     +        numdec.eq.13 .and. nrow.gt.nwmax .or.                 
     +        numdec.eq.15 .and. nrow.gt.nwmax) then
            call putfat ('Too many labels to plot ... maximum = 2000')
            numdec = 0
         endif          
         if (numdec.eq.0) then
c
c option not available
c
            numdec = numopt - 1
         elseif (numdec.le.3) then
c
c plot 1 column
c
            if (vector) then
               nxcol = 1
            else
               i = 1
               j = ncol
               if (nxcol.gt.j) nxcol = j
               write (line,500) 'as Y'
               call getjm1 (i, nxcol, j,
     +                      line)
            endif
            npts = min(nrow,nmax)
            do i = 1, npts
               y(i) = a(i,nxcol)
            enddo
            if (numdec.eq.1) then
               do i = 1, npts
                  x(i) = dble(i)
               enddo
               write (ptitle,600)
               write (xtitle,700)
               write (ytitle,800) nxcol
               if (npts.lt.50) then
                  m1 = 5
               else
                  m1 = 1
               endif
               n1 = npts
               call gks001 (l1, m1, n1,
     +                      x, y,
     +                      ptitle, xtitle, ytitle)
            elseif (numdec.eq.2) then
               jsend = 1
               call hnplot (jsend, npts,
     +                      y)
            elseif (numdec.eq.3) then
               jsend = 2
               call hnplot (jsend, npts,
     +                      y)
            endif
         elseif (numdec.le.5) then
c
c plot two columns
c
            if (ncol.eq.2) then
               nxcol = 1
               nycol = 2
            else
               i = 1
               j = ncol
               if (nxcol.gt.j) nxcol = j
               write (line,500) 'as X'
               call getjm1 (i, nxcol, j,
     +                      line)
               if (nycol.gt.j) nycol = j
               write (line,500) 'as Y'
               call getjm1 (i, nycol, j,
     +                      line)
            endif
            write (ptitle,900)
            write (xtitle,800) nxcol
            write (ytitle,800) nycol
            npts = min(nrow,nmax)
            do i = 1, npts
               x(i) = a(i,nxcol)
               y(i) = a(i,nycol)
            enddo
            if (numdec.eq.4) then
               if (npts.lt.50) then
                  m1 = 5
               else
                  m1 = 1
               endif
               n1 = npts
               call gks001 (l1, m1, n1,
     +                      x, y,
     +                      ptitle, xtitle, ytitle)
            elseif (numdec.eq.5) then   
c
c create a default plot labels file
c      
               fname = sim256(labfil)
               npts = min(nrow,nwmax)
               call getnou (ntemp)
               open (unit = ntemp, file = fname)
               do i = 1, npts
                  if (i.lt.10) then
                     write (ntemp,'(a1,i1)') 'r', i
                  elseif (i.lt.100) then
                     write (ntemp,'(a1,i2)') 'r', i
                  elseif (i.lt.1000) then
                     write (ntemp,'(a1,i3)') 'r', i
                  else
                     write (ntemp,'(a1,i4)') 'r', i
                  endif            
               enddo
               close (unit = ntemp)   
                             
               npt1 = npts
               titles(1) = ptitle
               titles(2) = xtitle
               titles(3) = ytitle
               
               call gettmp (i,
     +                      filex)
               call getnou (ntemp)
               open (unit = ntemp, file = filex)
               write (ntemp,'(a)') header
               i = 2
               write (ntemp,'(2i6)') npt1, i
               do i = 1, npt1
                  write (ntemp,'(1p,2e13.5)') x(i), y(i)
               enddo
               close (unit = ntemp)
               
               fname = sim256(rotfil)
               open (unit = ntemp, file = fname)
               write (ntemp,'(a)') word24
               i = 5
               write (ntemp,'(2i6)') npt1, i
               do i = 1, npt1
                  write (ntemp,'(1p,5e13.5)') x(i), zero, y(i), zero,
     +                                        zero
               enddo
               close (unit = ntemp)
               
               files(1) = filex
               call smplot$(jfiles, lfiles, mfiles, nfiles,
     +                      files, titles)
               call deleet (filex,
     +                      askif, there)
            endif
         elseif (numdec.le.7) then
c
c plot three columns
c
            if (ncol.eq.3) then
               nxcol = 1
               nycol = 2
               nzcol = 3
            else
               i = 1
               j = ncol
               if (nxcol.gt.j) nxcol = j
               write (line,500) 'as X'
               call getjm1 (i, nxcol, j,
     +                      line)
               if (nycol.gt.j) nycol = j
               write (line,500) 'as Y'
               call getjm1 (i, nycol, j,
     +                      line)
               if (nzcol.gt.j) nzcol = j
               write (line,500) 'as Z'
               call getjm1 (i, nzcol, j,
     +                      line)
            endif
            npts = nrow
            do i = 1, npts
               x(i) = a(i,nxcol)
               y(i) = a(i,nycol)
               z(i) = a(i,nzcol)
            enddo
            if (numdec.eq.6) then
               call space5$(npts, npts,
     +                      x, xtemp, y, ytemp, z)
            elseif (numdec.eq.7) then
               call gettmp (i, 
     +                      filex)
               call getnou (ntemp)
               open (unit = ntemp, file = filex)
               write (ntemp,'(a)') 'columns'
               i = 3
               write (ntemp,'(2i6)') npts, i
               do i = 1, npts
                  write (ntemp,'(1p,3e13.5)') x(i), y(i), z(i)
               enddo
               i = npts + 2
               write (ntemp,'(i6)') i
               write (ntemp,'(a)') begin_labels
               do i = 1, npts
                  if (i.lt.10) then
                     write (ntemp,'(a1,i1)') 'r', i
                  elseif (i.lt.100) then
                     write (ntemp,'(a1,i2)') 'r', i
                  elseif (i.lt.1000) then
                     write (ntemp,'(a1,i3)') 'r', i
                  else
                     write (ntemp,'(a1,i4)') 'r', i
                  endif            
               enddo
               write (ntemp,'(a)') end_labels  
               close (unit = ntemp)
               files(1) = filex
               call space6$(nfiles,
     +                      files,
     +                      plot_arrows,
     +                      plot_labels,
     +                      plot_lines,
     +                      plot_perpendiculars,
     +                      plot_symbols) 
               call deleet (filex,
     +                      askif, there)                          
            endif  
         elseif (numdec.eq.8) then
c
c plot selected columns
c         
            plot_columns = .true.
            call crplot (ncol, nrmax, nrow,
     +                   a,
     +                   plot_columns)               
         elseif (numdec.le.11) then
c
c plot 1 row
c
            if (nrow.eq.1) then
               nxrow = 1
            else
               i = 1
               j = nrow
               if (nxrow.gt.j) nxrow = j
               write (line,1000) 'as Y'
               call getjm1 (i, nxrow, j,
     +                      line)
            endif
            npts = min(ncol,nmax)
            do i = 1, npts
               y(i) = a(nxrow,i)
            enddo
            if (numdec.eq.9) then
               do i = 1, npts
                  x(i) = dble(i)
               enddo
               write (ptitle,1100)
               write (xtitle,700)
               write (ytitle,1200) nxrow
               if (npts.lt.50) then
                  m1 = 5
               else
                  m1 = 1
               endif
               n1 = npts
               call gks001 (l1, m1, n1,
     +                      x, y,
     +                      ptitle, xtitle, ytitle)
            elseif (numdec.eq.10) then
               jsend = 1
               call hnplot (jsend, npts,
     +                      y)
            elseif (numdec.eq.11) then
               jsend = 2
               call hnplot (jsend, npts,
     +                      y)
            endif
         elseif (numdec.le.13) then
c
c plot two rows
c
            if (nrow.eq.2) then
               nxrow = 1
               nyrow = 2
            else
               i = 1
               j = nrow
               if (nxrow.gt.j) nxrow = j
               write (line,1300) 'as X'
               call getjm1 (i, nxrow, j,
     +                      line)
               if (nyrow.gt.j) nyrow = j
               write (line,1300) 'as Y'
               call getjm1 (i, nyrow, j,
     +                      line)
            endif
            Write (ptitle,1400)
            write (xtitle,1200) nxrow
            write (ytitle,1200) nyrow
            npts = min(ncol,nmax)
            do i = 1, npts
               x(i) = a(nxrow,i)
               y(i) = a(nyrow,i)
            enddo
            if (numdec.eq.12) then
               if (npts.lt.50) then
                  m1 = 5
               else
                  m1 = 1
               endif
               n1 = npts
               call gks001 (l1, m1, n1,
     +                      x, y,
     +                      ptitle, xtitle, ytitle)
            elseif (numdec.eq.13) then
c
c create a default plot labels file
c      
               fname = sim256(labfil) 
               npts = min(ncol,nwmax)
               call getnou (ntemp)
               open (unit = ntemp, file = fname)
               do i = 1, npts
                   if (i.lt.10) then
                     write (ntemp,'(a1,i1)') 'c', i
                  elseif (i.lt.100) then
                     write (ntemp,'(a1,i2)') 'c', i
                  elseif (i.lt.1000) then
                     write (ntemp,'(a1,i3)') 'c', i
                  else
                     write (ntemp,'(a1,i4)') 'c', i
                  endif            
               enddo
               close (unit = ntemp)
               
               npt1 = npts
               titles(1) = ptitle
               titles(2) = xtitle
               titles(3) = ytitle
               
               call gettmp (i,
     +                      filex)
               call getnou (ntemp)
               open (unit = ntemp, file = filex)
               write (ntemp,'(a)') header
               i = 2
               write (ntemp,'(2i6)') npt1, i
               do i = 1, npt1
                  write (ntemp,'(1p,2e13.5)') x(i), y(i)
               enddo
               close (unit = ntemp)
 
               fname = sim256(rotfil) 
               open (unit = ntemp, file = fname)
               write (ntemp,'(a)') word24
               i = 5
               write (ntemp,'(2i6)') npt1, i
               do i = 1, npt1
                  write (ntemp,'(1p,5e13.5)') x(i), zero, y(i), zero,
     +                                        zero
               enddo
               close (unit = ntemp)
                              
               files(1) = filex
               call smplot$(jfiles, lfiles, mfiles, nfiles,
     +                      files, titles)
               call deleet (filex,
     +                      askif, there)
            endif
         elseif (numdec.le.15) then
c
c plot three rows
c
            if (nrow.eq.3) then
               nxrow = 1
               nyrow = 2
               nzrow = 3
            else
               i = 1
               j = nrow
               if (nxrow.gt.j) nxrow = j
               write (line,1000) 'as X'
               call getjm1 (i, nxrow, j,
     +                      line)
               if (nyrow.gt.j) nyrow = j
               write (line,1000) 'as Y'
               call getjm1 (i, nyrow, j,
     +                      line)
               if (nzrow.gt.j) nzrow = j
               write (line,1000) 'as Z'
               call getjm1 (i, nzrow, j,
     +                      line)
            endif
            npts = ncol
            do i = 1, npts
               x(i) = a(nxrow,i)
               y(i) = a(nyrow,i)
               z(i) = a(nxrow,i)
            enddo
            if (numdec.eq.14) then
               call space5$(npts, npts,
     +                      x, xtemp, y, ytemp, z)
            elseif (numdec.eq.15) then
               call gettmp (i,
     +                      filex)
               call getnou (ntemp)
               open (unit = ntemp, file = filex)
               write (ntemp,'(a)') 'rows'
               i = 3
               write (ntemp,'(2i6)') npts, i
               do i = 1, npts
                  write (ntemp,'(1p,3e13.5)') x(i), y(i), z(i)
               enddo
               i = npts + 2
               write (ntemp,'(i6)') i
               write (ntemp,'(a)') begin_labels
               do i = 1, npts
                  if (i.lt.10) then
                     write (ntemp,'(a1,i1)') 'c', i
                  elseif (i.lt.100) then
                     write (ntemp,'(a1,i2)') 'c', i
                  elseif (i.lt.1000) then
                     write (ntemp,'(a1,i3)') 'c', i
                  else
                     write (ntemp,'(a1,i4)') 'c', i
                  endif            
               enddo
               write (ntemp,'(a)') end_labels  
               close (unit = ntemp)
               files(1) = filex
               call space6$(nfiles,
     +                      files,
     +                      plot_arrows,
     +                      plot_labels,
     +                      plot_lines,
     +                      plot_perpendiculars,
     +                      plot_symbols) 
               call deleet (filex,
     +                      askif, there)                          
            endif 
         elseif (numdec.eq.16) then
c
c selected rows
c         
            plot_columns = .false.
            call crplot (ncol, nrmax, nrow,
     +                   a,
     +                   plot_columns)                 
         elseif (numdec.eq.numopt - 2) then
c
c View/Save/Print
c                
            call viewit (ncol, nrmax, nrow, ntype,
     +                   a,
     +                   title2)              
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (info,1500) nmax, nwmax, nrow, ncol
            call patch2 (numbld, numtxt,
     +                   info)
         elseif (numdec.eq.numopt) then
            repeet = .false.
         endif
      enddo       
c
c delete labels file
c      
      call deleet (fname,
     +             askif, there)        
c
c deallocate workspaces
c      
      deallocate(x, stat = ierr) 
      deallocate(xtemp, stat = ierr)                                                
      deallocate(y, stat = ierr)   
      deallocate(ytemp, stat = ierr)   
      deallocate(z, stat = ierr)   
c
c format statements
c      
  100 format ('Dimensions inconsistent in call to MTPLOT')
  200 format ('ISEND/NROW/NCOL inconsistent in call to MTPLOT')
  300 format (
     + 'One column: direct plot',1x,a
     +/'One column: half-normal plot',1x,a
     +/'One column: full-normal plot',1x,a
     +/'Two columns: 2D scatter plot',1x,a
     +/'Two columns: 2D advanced plot',1x,a
     +/'Three columns: 3D scatter plot',1x,a
     +/'Three columns: 3D advanced plot',1x,a
     +/'Selected columns: 2D but with 1 or 2 y-scales',1x,a
     +/'One row: direct plot',1x,a
     +/'One row: half-normal plot',1x,a
     +/'One row: full-normal plot',1x,a
     +/'Two rows: 2D scatter plot',1x,a
     +/'Two rows: 2D advanced plot',1x,a
     +/'Three rows: 3D scatter plot',1x,a 
     +/'Three rows: 3D advanced plot',1x,a
     +/'Selected Rows: 2D but with 1 or 2 y-scales',1x,a
     +/'View/Save/Print the matrix'
     +/'Help'
     +/'Cancel')
  400 format ('Option not available')
  500 format ('Column number for plotting',1x,a)
  600 format ('Standard vector plot')
  700 format ('Number')
  800 format ('Column',i4)
  900 format ('Two column plot')
 1000 format ('Row number for plotting',1x,a)
 1100 format ('Standard matrix row plot')
 1200 format ('Row',i4)
 1300 format ('Row number for plotting',1x,a)
 1400 format ('Two row plot')
 1500 format (
     + 'Plotting a matrix (max. points =',i6,', max. labels =',i5,')'
     +/'You have supplied a matrix with',i6,' rows and',i6,' columns,'
     +/'and there are several ways you can interpret the A(i,j) values'
     +/'as coordinates, so that the rows or columns can be plotted.'
     +/
     +/'Direct plot'
     +/'Here the y-coordinates are the successive row or column values'
     +/'while the x-values are just successive integers.'
     +/
     +/'Normal plots'
     +/'These normal score plots are used to test for normality. The'
     +/'half-normal choice changes the sign of negative values which is'
     +/'valuable with numbers centered around zero, like residuals.'
     +/
     +/'2D plots'
     +/'The swarm can be plotted as symbols only, or in advanced mode'
     +/'with integer labels. If you select to edit the X-axis, you can'
     +/'edit the default labels, or input new labels from a text file.'
     +/
     +/'3D plots'
     +/'The swarm can be plotted as symbols in three dimensions. Also,'
     +/'perpendiculars and labels can be added.'
     +/
     +/'Selected rows or columns'
     +/'One row/column is x, the rest are y(x)(LHaxis) or z(x)(RHaxis)')
      end
c
c
