C
C
      SUBROUTINE MVPLOT 
C
C ACTION: missing values plotting
C AUTHOR: W. G. Bardsley, University of Manchester, U.K. derived from m_anova1 21/08/2018
C
      IMPLICIT   NONE
C
C Local allocatable array
C
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:) 
C
C Locals
C
      INTEGER    NBIG, NVBIG
      PARAMETER (NBIG = 100,    !default upper limit for NSMALL vectors
     +           NVBIG = 10000) !default upper limit for X vectors
      INTEGER    JFILES(NBIG), LFILES(NBIG), MFILES(NBIG), NOBS(NBIG),
     +           NOBS_X(NBIG)   
      INTEGER    NCMAX, NMAX, NRMAX
      INTEGER    NTEMP(1)
      INTEGER    NCOLS, NFILES, NFILES_X, NIN, NROWS
      INTEGER    KVAL9, NKLCFG 
      INTEGER    I, ICOUNT, IERR, IOS, ISEND, J, JCOUNT, L
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 0)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(20)
      INTEGER    IPREV, ITYPE, NOUT1
      PARAMETER (ITYPE = 2)
      INTEGER    N0, N1, N2, N5, N21
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N5 = 5, N21 = 21)
      DOUBLE PRECISION B(1), X(NVBIG), Y(NVBIG), Z(NVBIG)
      DOUBLE PRECISION XTEMP(N1), YTEMP(N1)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER (LEN = 1024) FNAMEA, FSAV(NBIG)
      CHARACTER (LEN = 100 ) TEXT(30), LINE
      CHARACTER (LEN = 80  ) TITLEA, TSAV(NBIG)
      CHARACTER (LEN = 50  ) CB_LABELS(NBIG), X_TITLE
      CHARACTER (LEN = 40  ) LABELS(NBIG), LABELS_X(NBIG), TITLES(4),
     +                       TITLES_X(4)
      CHARACTER (LEN = 12  ) FORM12, WORD12(2)
      CHARACTER (LEN = 1   ) BLANK, FTEMP(1), TTEMP(1)
      PARAMETER (X_TITLE =
     +'Select the items for box/whisker/scatter plots' )
      PARAMETER (BLANK = ' ')
      LOGICAL    USE1(NBIG)
      LOGICAL    NEWDAT, SHOWIT(4)
      LOGICAL    REPEET
      LOGICAL    ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_TOP = .TRUE., TAB_MID = .TRUE., TAB_BOT = .TRUE.)
      LOGICAL    ABORT, AGAIN, LIBFIL, MATRIX, INCOMPLETE, PROJ, READY
      EXTERNAL   TBOX01, VECFIL, PFILES, GETNOU, FORM12, SMPLOT, DELEET
      EXTERNAL   NKLCFG, TFILEQ, INCOMP, BWPLOT, MATTIN, RPPLOT, GETTMP,
     +           BWPLUS, CHKBOX, EBPLOT
      SAVE       FNAMEA, TITLEA, SHOWIT
      DATA       SHOWIT / 4*.TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
      DATA       FNAMEA, TITLEA / BLANK, BLANK /
C      
C Initialise NEWDAT and SUPPLY
C
       NEWDAT = .TRUE.
       READY = .FALSE.
       DO I = N1, NBIG
          JFILES(I) = N0
          LFILES(I) = N0
          MFILES(I) = N0
          NOBS(I) = N0
          NOBS_X(I) = N0
          FSAV(I) = BLANK
          TSAV(I) = 'Default title'
          USE1(I) = .FALSE.
          IF (I.LT.10) THEN
             WRITE (LABELS(I),'(A,1X,I1)') 'Sample', I
             LABELS_X(I) = LABELS(I)
             WRITE (CB_LABELS(I),'(A,1X,I1)')
     +             'Data supplied for sample number', i 
          ELSEIF (I.LT.100) THEN
             WRITE (LABELS(I),'(A,1X,I2)') 'Sample', I 
             LABELS_X(I) = LABELS(I)
             WRITE (CB_LABELS(I),'(A,1X,I2)')
     +             'Data supplied for sample number', i   
          ELSE  
             WRITE (LABELS(I),'(A,1X,I4)') 'Sample', I 
             LABELS_X(I) = LABELS(I)
             WRITE (CB_LABELS(I),'(A,1X,I4)')
     +             'Data supplied for sample number', i   
          ENDIF    
       ENDDO 
       DO I = N1, NVBIG
          X(I) = ZERO
          Y(I) = ZERO
          Z(I) = ZERO
       ENDDO    
C
C Deallocate
C
      IERR = N0 
      IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
      IF (IERR.NE.N0) RETURN
C
C Main loop
C
      AGAIN = .TRUE.
      READY = .FALSE.
      DO WHILE (AGAIN)
         NCMAX = N0
         NRMAX = N0
         NMAX = N0
         IF (.NOT.READY) THEN
C
C Data input from this subroutine ... First get input type required
C
            REPEET = .TRUE.
            DO WHILE (REPEET)
               NDEC = N1
               WRITE (TEXT,100)
               NUMBLD(1) = 4
               NOPT = 7
               NSTART = 16
               NUMTXT = NSTART + NOPT - N1
               CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, 
     +                      NOPT, NUMPOS, NSTART, NUMTXT,
     +                      TEXT,
     +                      TAB_TOP, TAB_MID, TAB_BOT)
               NUMBLD(1) = N0
               REPEET = .FALSE.
               INCOMPLETE = .FALSE.
               IF (NDEC.EQ.1) THEN
                  WRITE (LINE,200)
                  MATRIX = .TRUE.
                  LIBFIL = .FALSE.
                  PROJ = .FALSE.
               ELSEIF (NDEC.EQ.2) THEN
                  WRITE (LINE,300)
                  MATRIX = .FALSE.
                  LIBFIL = .TRUE.
                  PROJ = .FALSE.
               ELSEIF (NDEC.EQ.3) THEN
                  WRITE (LINE,400)
                  MATRIX = .FALSE.
                  LIBFIL = .FALSE.
                  PROJ = .FALSE.
               ELSEIF (NDEC.EQ.4) THEN
                  WRITE (LINE,500)
                  MATRIX = .FALSE.
                  LIBFIL = .FALSE.
                  PROJ = .TRUE.
               ELSEIF (NDEC.EQ.5) THEN
                  WRITE (LINE,600)
                  MATRIX = .FALSE.
                  LIBFIL = .FALSE.
                  PROJ = .FALSE.
                  INCOMPLETE = .TRUE.
               ELSEIF (NDEC.EQ.6) THEN
                  REPEET = .TRUE.
                  CALL INCOMP (N0, N1, NFILES, NTEMP, N1,
     +                         XTEMP, YTEMP, 
     +                         FNAMEA, FTEMP, TTEMP,
     +                         ABORT)                   
               ELSE
                  RETURN
               ENDIF
            ENDDO
            IF (MATRIX) THEN
C
C Method 1: Read in and analyse data matrices
C
               NCMAX = NBIG
               NRMAX = NVBIG 
               ALLOCATE (A(NRMAX,NCMAX), STAT = IERR)
               ISEND = 2
               CALL GETNOU (NIN)
               CLOSE (UNIT = NIN) 
               CALL MATTIN (ISEND, NCMAX, NCOLS, NIN, NRMAX, NROWS,
     +                      A, B,         
     +                      FNAMEA, TITLEA,
     +                      ABORT, FIXCOL, FIXROW, LABEL)
               CLOSE (UNIT = NIN)
               IF (ABORT) THEN
                  READY = .FALSE.
               ELSE
                  READY = .TRUE.   
                  NFILES = NCOLS
                  ICOUNT = 0
                  DO I = 1, NFILES
                     USE1(I) = .TRUE.
                     NOBS(I) = NROWS
                     DO J = 1, NROWS
                        ICOUNT = ICOUNT + 1
                        Y(ICOUNT) = A(J,I)
                     ENDDO
                  ENDDO    
                  DEALLOCATE (A, STAT = IERR)   
               ENDIF   
               NEWDAT = .FALSE.
            ELSEIF (.NOT.PROJ .AND. .NOT.INCOMPLETE) THEN
C
C Methods 2 and 3: Read in files individually or from a libary file
C
               IF (SHOWIT(NDEC)) THEN
                  KVAL9 = NKLCFG(N21)
                  IF (KVAL9.EQ.N1) THEN
                     CALL TFILEQ (LINE)
                     SHOWIT(NDEC) = .FALSE.
                  ENDIF   
               ENDIF   
               CALL GETNOU (NIN)
               CLOSE (UNIT = NIN)
               CALL VECFIL (NFILES, NIN, NVBIG, NBIG,
     +                      X,
     +                      FSAV, TSAV,
     +                      ABORT, LIBFIL)
               CLOSE (UNIT = NIN)
               IF (NFILES.LT.N2) NFILES = N0
               IF (.NOT.ABORT .AND. NFILES.GT.N1) THEN
                  ICOUNT = N0
                  NMAX = N0
                  DO I = N1, NFILES
                     USE1(I) = .TRUE.
                     CLOSE (UNIT = NIN)
                     OPEN (UNIT = NIN, FILE = FSAV(I))
                     READ (NIN,'(A)') TSAV(I)
                     READ (NIN,*) NOBS(I), J
                     DO L = N1, NOBS(I)
                        ICOUNT = ICOUNT + N1
                        READ (NIN,*,IOSTAT=IOS) Y(ICOUNT)
                     ENDDO   
                     CLOSE (UNIT = NIN)
                     NMAX = NMAX + NOBS(I)
                  ENDDO
                  READY = .TRUE.
               ENDIF
            ELSEIF (PROJ .AND. .NOT.INCOMPLETE) THEN
C
C Method 4: Read in from the vector project archive
C
               IF (SHOWIT(NDEC)) THEN
                  KVAL9 = NKLCFG(N21) 
                  IF (KVAL9.EQ.N1) THEN
                     CALL TFILEQ (LINE)
                     SHOWIT(NDEC) = .FALSE.
                  ENDIF   
               ENDIF   
               IPREV = N0
               NFILES = N0
               CALL GETNOU (NIN)
               CLOSE (UNIT = NIN)
               CALL GETNOU (NOUT1)
               CLOSE (UNIT = NOUT1)
               CALL PFILES (IPREV, ITYPE, NFILES, NIN, NBIG, NOUT1,
     +                      FSAV,
     +                      USE1)
               CLOSE (UNIT = NIN)
               CLOSE (UNIT = NOUT1)
               IF (NFILES.GT.N1) THEN
                  CALL GETNOU (NIN)
                  ICOUNT = N0
                  DO I = N1, NFILES
                     USE1(I) = .TRUE.
                     CLOSE (UNIT = NIN)
                     OPEN (UNIT = NIN, FILE = FSAV(I))
                     READ (NIN,'(A)') TSAV(I)
                     READ (NIN,*) NOBS(I), J
                     DO L = N1, NOBS(I)
                        ICOUNT = ICOUNT + N1
                        READ (NIN,*,IOSTAT=IOS) Y(ICOUNT)
                     ENDDO   
                     CLOSE (UNIT = NIN)
                     NMAX = NMAX + NOBS(I)
                  ENDDO
                  READY = .TRUE.
               ELSE
                  ABORT = .TRUE.
                  NFILES = N0
               ENDIF
            ELSEIF (INCOMPLETE) THEN
C
C Method 5: Read in from the an incomplete matrix file
C

C               IF (SHOWIT(NDEC)) THEN
C                  KVAL9 = NKLCFG(N21) 
C                  IF (KVAL9.EQ.N1) THEN
C                     CALL TFILEQ (LINE)
C                     SHOWIT(NDEC) = .FALSE.
C                  ENDIF   
C              ENDIF   

               NCMAX = NBIG
               NMAX = NVBIG
               IPREV = N0
               NFILES = N0
               CALL INCOMP (N1, NCMAX, NFILES, NOBS, NMAX,
     +                      X, Y,           
     +                      FNAMEA, FSAV, TSAV,
     +                      ABORT) 
               IF (NFILES.GT.N1) THEN
                  DO I = N1, NFILES
                     USE1(I) = .TRUE.
                  ENDDO
                  READY = .TRUE.
               ELSE
                  ABORT = .TRUE.
                  NFILES = N0
               ENDIF   
            ENDIF
         ENDIF
         IF (READY) THEN
C
C Box and whisker plot, etc.
C
            TITLES(1) = 'Plotting Multiple Samples'
            TITLES(2) = 'Samples' 
            TITLES(3) = 'Values'
            TITLES(4) = BLANK
            DO I = N1, NFILES
               USE1(I) = .TRUE.
            ENDDO
            WORD12(1) = FORM12(NFILES)
            REPEET = .TRUE.
            NDEC = N1
            DO WHILE (REPEET)
               ICOUNT = N0
               DO I = N1, NFILES
                  IF (USE1(I)) ICOUNT = ICOUNT + N1
               ENDDO
               WORD12(2) = FORM12(ICOUNT)     
               WRITE (TEXT,700) WORD12(1), WORD12(2)
               NUMBLD(1) = 4
               NOPT = 7
               NSTART = 6
               NUMTXT = NSTART + NOPT - 1
               CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, 
     +                      NOPT, NUMPOS, NSTART, NUMTXT,
     +                      TEXT,
     +                      TAB_TOP, TAB_MID, TAB_BOT)
               NUMBLD(1) = 0
               IF (NDEC.GE.1 .AND. NDEC.LE.4) THEN
C
C Check the items selected for box/whisker/scatter, plotting then define Z
C                 
                  NFILES_X = N0
                  ICOUNT = N0
                  JCOUNT = N0
                  DO I = N1, NFILES
                     IF (USE1(I)) THEN
                        NFILES_X = NFILES_X + N1
                        NOBS_X(NFILES_X) = NOBS(I)
                        LABELS_X(NFILES_X) = LABELS(I)
                        DO J = N1, NOBS(I)
                           ICOUNT = ICOUNT + N1
                           JCOUNT = JCOUNT + N1
                           Z(JCOUNT) = Y(ICOUNT)
                        ENDDO   
                     ELSE
                        ICOUNT = ICOUNT + NOBS(I)      
                     ENDIF
                  ENDDO     
               ENDIF  
               IF (NDEC.EQ.1) THEN
C
C NDEC = 1: Box and whisker plot
C                 
                  ISEND = 2
                  CALL BWPLOT (ISEND, NOBS_X, NFILES_X, NVBIG,
     +                         Z, 
     +                         LABELS_X, TITLES) 
               ELSEIF (NDEC.EQ.2) THEN
C
C NDEC = 2: Box and whisker plot with scatter
C               
                  ISEND = 2
                  CALL BWPLUS (ISEND, NOBS_X, NFILES_X, NVBIG,
     +                         Z, 
     +                         LABELS_X, TITLES) 

               ELSEIF (NDEC.EQ.3) THEN
C
C NDEC = 3: Scatter plot
C               
                  L = N0
                  ICOUNT = N0
                  DO I = N1, NFILES
                     IF (USE1(I)) THEN
                        ICOUNT = ICOUNT + 1
                        CALL GETTMP (J, 
     +                               FSAV(ICOUNT))
                        CALL GETNOU (NIN)
                        OPEN (UNIT = NIN, FILE = FSAV(ICOUNT),
     +                        IOSTAT = IOS)
                        WRITE (NIN,'(A)',IOSTAT=IOS) TSAV(ICOUNT)
                        WRITE (NIN,'(2I6)',IOSTAT=IOS) NOBS(I), N2
                        DO J = N1, NOBS(I)
                           L = L + N1
                           X(L) = DBLE(I)
                           WRITE (NIN,'(2E13.5)',IOSTAT=IOS) X(L), Z(L)
                           JFILES(L) = N0
                           LFILES(L) = N0
                           MFILES(L) = N5
                        ENDDO
                        CLOSE(UNIT = NIN)
                     ENDIF
                  ENDDO
                  CALL SMPLOT (JFILES, LFILES, MFILES, NFILES_X, 
     +                         FSAV,
     +                         TITLES)
                  DO I = N1, NFILES_X
                     CALL DELEET (FSAV(I),
     +                            ASKIF, THERE)
                  ENDDO  
               ELSEIF (NDEC.EQ.4) THEN   
C
C NDEC = 4: error bars
C                 
                  TITLES_X(1) = 'Barchart & Errorbars'
                  TITLES_X(2) = 'Items'
                  TITLES_X(3) = 'Means'
                  TITLES_X(4) = BLANK 
                  ISEND = 2
                  CALL EBPLOT (ISEND, NOBS_X, NFILES_X, NVBIG,
     +                         Z, 
     +                         LABELS_X, TITLES_X)                 
               ELSEIF (NDEC.EQ.5) THEN
C
C NDEC = 5: Percentiles plot
C               
                  CALL RPPLOT (NOBS, NFILES, NVBIG,
     +                         Y, 
     +                         TITLES)                   
               ELSEIF (NDEC.EQ.6) THEN
C
C NDEC = 6: Suppress/Restore data for box and whisker plots
C               
                  CALL CHKBOX (NFILES, 
     +                         CB_LABELS, X_TITLE,
     +                         USE1)                    
                  ICOUNT = 0
                  DO I = 1, NFILES
                     IF (USE1(I)) ICOUNT = ICOUNT + 1
                  ENDDO
                  IF (ICOUNT.EQ.0) USE1(1) = .TRUE.     
               ELSE
                  REPEET = .FALSE.
                  NEWDAT = .FALSE.
               ENDIF   
            ENDDO           
         ENDIF
         IF (NEWDAT) THEN
C
C Another go
C
            AGAIN = .TRUE.
         ELSE
C
C Quit the loop
C
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate workspace
C
         IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)

C
C Format statements
C
  100 format (
     + 'How to input sets of data samples for plotting'
     +/  
     +/'The options depend on sample sizes, i.e. if there are any empty' 
     +/'cells indicted by non-numerics (such as blanks, X, or NA, etc.)'   
     +/
     +/'For rectangular data tables with no missing values you can'  
     +/'input standard Simfit data files, or paste from the clipboard.'
     +/  
     +/'Where columns of the data matrix may not all be of the same'
     +/'length due to missing values you can use either:'
     +/'a)`A library file of vectors;'
     +/'b)`Individual column vectors;'
     +/'c)`Vectors from a project archive; or'
     +/'d)`An incomplete matrix file (tab/comma/semicolon separated).'  
     +/
     +/'Input a complete matrix (no missing values)'
     +/'Input a library file for vectors'
     +/'Input individual column vectors'
     +/'Input vectors from a project archive'
     +/'Input an incomplete matrix file (with missing values)'
     +/'Help'
     +/'Cancel')
  200 FORMAT (
     +'Now input a n by m matrix file formatted like matrix.tf1')
  300 FORMAT (
     +'Now input n vector files formatted like column1.tf1')
  400 FORMAT (
     +'Now input a library file of vectors formatted like anova1.tfl')
  500 FORMAT (
     +'Now select n vector files from your project archive')
  600 FORMAT (
     +'Now select a missing data file like incomplete.tf1')  
  700 FORMAT (
     + 'Plotting data defined by sets of column vectors'
     +/
     +/'Total number of column vectors available',1x,a
     +/'Number to plot as box/whisker/scatter/error-bars',1x,a
     +/
     +/'Plot: Box and Whisker'
     +/'Plot: Box and Whisker with scattered data'
     +/'Plot: Scattered data'
     +/'Plot: Means and Error Bars'
     +/'Plot: Percentiles'
     +/'Suppress/Restore samples'
     +/'Cancel')       
      END
C
C
