c
c
      subroutine nstep1 (nstep, nt,  
     +                   xt, yt)
c
c action: return a truncated data set by stepping over nstep intermediate points
c author: w.g.bardsley, university of manchester, u.k., 01/02/2011
c
c nstep = number of consecutive data points to step over 
c         (e.g., as set by subroutine nsteps and returned from subroutine savint$) 
c    nt = on entry ... starting dimension e.g., as returned by gkstrn$ 
c         on exit  ... new dimension of transformed data on exit
c    xt = on entry ... transformed data values e.g., as returned by gkstrn$
c         on exit  ... returned in stepped over form   
c    yt = on entry ... transformed data values e.g., as returned by gkstrn$
c         on exit  ... returned in stepped over form   
c
c Note: points 1 and at the original nt are included in the edited data set
c
      implicit none
c
c arguments
c         
      integer,          intent (in)    :: nstep
      integer,          intent (inout) :: nt
      double precision, intent (inout) :: xt(nt), yt(nt) 
c
c locals
c     
      integer    icount, ksend, np1
c
c no action if =< 2 points or nstep =< 0
c        
      if (nt.le.2 .or. nstep.le.0) return
c
c create the abbreviated data set
c        
      np1 = nstep + 1  
      icount =  1 - np1
      ksend = 0
      do while (icount.le.nt)
         icount = icount + np1
         if (icount.le.nt) then
            ksend = ksend + 1
            xt(ksend) = xt(icount)
            yt(ksend) = yt(icount)
         endif
      enddo 
c
c make sure the last point is included
c      
      if (icount - np1.lt.nt) then
         ksend = ksend + 1
         xt(ksend) = xt(nt)
         yt(ksend) = yt(nt)
      endif      
      nt = ksend
      end
c
c
      
       
         