c
c
      subroutine nuplot$(nfiles, ntype,
     +                   fsav, fsav1)
c
c action: import a new graphics file into simplot
c author: w.g.bardsley, university of manchester, u.k., 22/11/2002 
c         20/04/2007 added intents
c
c         nfiles = current number of files ... in the calling program
c         ntype = ntype(nfiles + 1)        ... in the calling program
c         fsav = fsav(nfiles + 1)          ... in the calling program
c         fsav1 = fsav1(nfiles + 1)        ... in the calling program
c         if successful then nfiles is incremented and ntype, fsav,
c         and fsav1 are assigned to return the new graphics file
c         if unsuccessful then nfiles, ntype, fsav and fsav1 are unchanged
c
c
      implicit  none   
c
c arguments
c      
      integer,             intent (inout) :: nfiles, ntype 
      character (len = *), intent (inout) :: fsav, fsav1
c
c locals
c      
      integer   i, ierr, ios, ncol, nout, nrow, ntype1
      integer   isend, mode2
      parameter(isend = 3, mode2 = 2)
      double precision x(6), xmax, xmid, xmin, ymax, ymid, ymin
      character filex*1024, fname*1024, mssage*100
      logical   abort
      external  getnou, ofiles, vu2chk, copyfl, putfat, putadv, gettmp
      intrinsic max, min
c
c attempt to open a file
c
      call putadv (
     +'Now open an ASCII text coordinate file with 2,3,4 or 6 columns')
      call getnou (nout)
      close (unit = nout)
      call ofiles (isend, nout, fname, abort)
      if (abort) then
         close (unit = nout)
         return
      endif
c
c attempt to read title, nrow and ncol
c
      read (nout,'(a)',iostat=ios) mssage
      if (ios.ne.0) then
         mssage = 'Cannot read the title from line 1'
         abort = .true.
      endif
      if (.not.abort) then
         read (nout,*,iostat=ios) nrow, ncol
         if (ios.ne.0) then
            mssage = 'Cannot read the two integers from line 2'
            abort = .true.
         endif
      endif
c
c check nrow and ncol
c
      if (.not.abort) then
         if (nrow.lt.1) then
            mssage = 'Insufficient rows of data to plot'
            abort = .true.
         endif
      endif
      if (.not.abort) then
         if (ncol.eq.2 .or. ncol.eq.3) then
            ntype1 = 1
         elseif (ncol.eq.4) then
            ntype1 = 2
         elseif (ncol.eq.6) then
            ntype1 = 6
         else
            mssage = 'number of columns must be 2, 3, 4 or 6'
            abort = .true.
         endif
      endif
c
c check that data can be read off the file
c
      if (.not.abort) then
         ierr = 2
         ios = 0
         if (ncol.eq.2) then
            do i = 1, nrow
               if (ios.eq.0) read (nout,*,iostat=ios) x(1), x(2)
               if (ios.eq.0) ierr = ierr + 1
            enddo
         elseif (ncol.eq.3) then
            do i = 1, nrow
               if (ios.eq.0) read (nout,*,iostat=ios) x(1), x(2), x(3)
               if (ios.eq.0) ierr = ierr + 1
            enddo
         elseif (ncol.eq.4) then
            do i = 1, nrow
               if (ios.eq.0) read (nout,*,iostat=ios) x(1), x(2),
     +                                                x(3), x(4)
               if (ios.eq.0) ierr = ierr + 1
            enddo
         else
            do i = 1, nrow
               if (ios.eq.0) read (nout,*,iostat=ios) x(1), x(2), x(3),
     +                                                x(4), x(5), x(6)
               if (ios.eq.0) ierr = ierr + 1
            enddo
         endif
         if (ios.ne.0) then
            ierr = ierr + 1
            write (mssage,100) ierr
            abort = .true.
         endif
      endif
c
c close the input unit
c
      close (unit = nout)
c
c check the error bars if required
c
      if (.not.abort .and. ncol.ge.4) then
         ierr = 0
         open (unit = nout, file = fname)
         read (nout,'(a)') mssage
         read (nout,*) nrow, ncol
         if (ncol.eq.4) then
            do i = 1, nrow
               if (.not.abort) then
                  ierr = ierr + 1
                  read (nout,*) x(1), x(2), x(3), x(4)
                  ymax = max(x(2),x(4))
                  ymid = x(3)
                  ymin = min(x(2),x(4))
                  if (ymin.gt.ymid .or. ymid.gt.ymax) then
                     abort = .true.
                     write (mssage,200) ierr
                  endif
               endif
            enddo
         elseif (ncol.eq.6) then
            do i = 1, nrow
               if (.not.abort) then
                  ierr = ierr + 1
                  read (nout,*) x(1), x(2), x(3), x(4), x(5), x(6)
                  xmax = max(x(1),x(3))
                  xmid = x(2)
                  xmin = min(x(1),x(3))
                  ymax = max(x(4),x(6))
                  ymid = x(5)
                  ymin = min(x(4),x(6))
                  if (xmin.gt.xmid .or. xmid.gt.xmax .or.
     +                ymin.gt.ymid .or. ymid.gt.ymax) then
                     abort = .true.
                     write (mssage,300) ierr
                  endif
               endif
            enddo
         endif
         close (unit = nout)
      endif
      if (.not.abort) then
c
c success
c
         call gettmp (ierr, filex)
         if (ierr.eq.0) then
            fsav = fname
            fsav1 = filex
            call copyfl (mode2, fsav, fsav1, abort)
            if (.not.abort) then
               nfiles = nfiles + 1
               ntype = ntype1
            endif
         endif
      else
c
c failure
c
         call putfat (mssage)
         call vu2chk (fname)
      endif  
c
c format statements
c      
  100 format ('Failure to read data from file at line',i6)
  200 format ('y_low > y_mean or y_mean > y_high at data point',i6)
  300 format ('low > mean, or mean > high at data point',i6)
      end
c
c
