C
C
      SUBROUTINE NYYBAR$(ISEND, N, 
     +                   X, Y, E)
C
C ACTION : Supply E(N), X(N), Y(N) and calculate no. of distinct points
C          and sample standard deviations at replicates
C          If there are replicates E can be replaced by sample sigmas S
C          or some multiples as the user decides
C          Otherwise the E values are unchanged and a warning is issued
C
C          ISEND = 1, Just replace E by sample standard deviations
C                     N, X, Y unchanged
C                     This option is for weighting a curve-fit type file
C          ISEND = 2, Compress and replace Y by mean and E by S.E. mean
C                     N set to no. of distinct values
C                     X replaced by the distinct values
C                     This option is for making a compressed curve-fit file
C          ISEND = 3, Compress and replace Y by YBAR and E by 95% c.lim.
C                     or some multiple of std.err. or std. dev.
C                     This option is for making an error bar file for plotting
C ADVICE : The X-values must be in increasing order
C NAG    : G01CAE -> G01FBF
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 9/11/90
C          23/03/1994 DBOS version
C          19/10/1995 replaced G01CAF by G01FBF for NAG mark 16
C          19/06/1996 reorganised and enlarged options for ISEND = 3
C                     to include plot and choice of error bar parameters
C          22/06/2006 introduced allocatable arrays
C          20/04/2007 added INTENTS and changed array dimensions from (N) to (*)
C          21/09/2011 now calls X_NYYBAR
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND
      INTEGER,          INTENT (INOUT) :: N
      DOUBLE PRECISION, INTENT (INOUT) :: E(*), X(*), Y(*)
      EXTERNAL X_NYYBAR
      CALL X_NYYBAR (ISEND, N, 
     +               X, Y, E)
      END
C
C
