C
C
      SUBROUTINE PANELS$(IPANEL, ISHAPE, KPANEL, L, M, NFILES, NGRAFS,
     +                   PSCALE, XDIFF, XMAX, XMIN, XPANEL, XPDRAG,
     +                   XPMAX, XPMIN, XSTART, YDIFF, YMAX, YMIN,
     +                   YPDRAG, YPXTRA,
     +                   PLINE,
     +                   FIRST, PANEL, SIDE)
C
C ACTION : Panels for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 7/6/95
C          01/10/1996 Reconstructed using XPMAX, XPMIN, XS1, XS2, XS3
C                     XS1, XS2, XS3 must agree with those in GKSPLT$
C          03/10/1996 Redefined PSCALE depending on ISHAPE
C          15/10/1996 Introduced FIRST
C          14/07/1997 win32 version
C          27/01/1998 Replaced KPANEL by K15 in calculations
C          14/01/2003 replaced K15 by K20 and limited IPANEL using IPMAX
C          20/04/2007 added INTENTS
C          01/12/2010 increased IPMAX to 8 when SIDE = .FALSE. 
C          14/06/2011 increased IPMAX to 10 when SIDE = .FALSE. 
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER,          INTENT (IN)    :: KPANEL, NGRAFS 
      INTEGER,          INTENT (IN)    :: ISHAPE, L(NGRAFS), M(NGRAFS),
     +                                    NFILES  
      INTEGER,          INTENT (INOUT) :: IPANEL
      DOUBLE PRECISION, INTENT (INOUT) :: PSCALE, XDIFF, XMAX, XMIN,
     +                                    XPANEL(2), XPDRAG, XPMAX,
     +                                    XPMIN, XSTART, YDIFF, YMAX,
     +                                    YMIN, YPDRAG, YPXTRA
      CHARACTER (LEN = *), INTENT (IN) :: PLINE(KPANEL)
      LOGICAL,             INTENT (IN) :: FIRST, PANEL, SIDE
C
C Locals but note that XS1, XS2, XS3 must agree with those in GKSPLT$
C
      INTEGER    I, IPMAX
      INTEGER    K0, K1, K2, K3, K10, K20
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K10 = 10, K20 = 20)
      DOUBLE PRECISION XS1, XS2, XS3
      PARAMETER (XS1 = 0.825D+00, XS2 = 0.825D+00, XS3 = 0.825D+00)
      DOUBLE PRECISION ONE, TWO, THREE, TEN
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, THREE = 3.0D+00,
     +           TEN = 10.0D+00)
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      INTRINSIC  DBLE, MIN
      IF (FIRST) THEN
C
C Define XDIFF and YDIFF and swap if necessary
C
         IF (XMAX.LT.XMIN) THEN
            XDIFF = XMIN
            XMIN = XMAX
            XMAX = XDIFF
         ENDIF
         IF (YMAX.LT.YMIN) THEN
            XDIFF = YMIN
            YMIN = YMAX
            YMAX = XDIFF
         ENDIF
         XDIFF = XMAX - XMIN
         YDIFF = YMAX - YMIN
C
C Define IPANEL and parameters for position of panel if required
C
         IPANEL = K0
         IF (PANEL) THEN
            DO I = K1, MIN(KPANEL,NFILES)
               IF (L(I).NE.K0 .OR. M(I).NE.K0) THEN
                  IF (PLINE(I).NE.BLANK) THEN
                    IPANEL = IPANEL + K1
                  ENDIF
               ENDIF
            ENDDO
            IF (SIDE) THEN
               IPMAX = K20
            ELSE
               IPMAX = K10
            ENDIF
            IF (IPANEL.GT.IPMAX) IPANEL = IPMAX
         ENDIF
      ELSE
         IF (PANEL) THEN
            IF (SIDE) THEN
               PSCALE = ONE
               XPANEL(1) = XPMAX
               XPANEL(2) = XPMIN
               IF (ISHAPE.EQ.K1) THEN
                  XSTART = XS1
               ELSEIF (ISHAPE.EQ.K2) THEN
                  XSTART = XS2
               ELSEIF (ISHAPE.EQ.K2) THEN
                  XSTART = XS3
               ELSE
                  XSTART = XS1
               ENDIF
               XSTART = XSTART + XPDRAG
               YPXTRA =  DBLE(K20 - IPANEL)/TWO  - TEN*YPDRAG
               IF (YPXTRA.LT.- THREE) THEN
                  YPXTRA = - THREE
               ELSEIF (YPXTRA .GT. DBLE(K20) + TWO) THEN
                  YPXTRA = DBLE(K20) + TWO
               ENDIF
            ELSE
               IF (ISHAPE.EQ.K1) THEN
                  PSCALE = 0.9D+00
               ELSEIF (ISHAPE.EQ.K2) THEN
                  PSCALE = 0.75D+00
               ELSEIF (ISHAPE.EQ.K3) THEN
                  PSCALE = 0.5D+00
               ELSE
                  PSCALE = 0.9D+00
               ENDIF
            ENDIF
         ENDIF
      ENDIF
      END
C
C
