C
C
      SUBROUTINE PARSE1$(NUMBER, SYMBOL, VALUE)
C
C ACTION : Interpret VALUE then return NUMBER, SYMBOL
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 20/10/96
C          20/10/1996 Derived from PSNUMB 
C          20/03/2007 added INTENTS
C
C          This subroutine parses VALUE as follows:-
C          No E, D, d or e: copy VALUE to NUMBER and default SYMBOL
C          E/e/D/d encountered: 1) copy up to E unchanged
C                               2) replace E or e by x10 (in general)
C                               3) replace E+00, E000, E+000 by nothing
C                               4) replace +0X, 00X, +00X by X (super)
C                               5) replace -0X, -00X by -X (super)
C                               6) replace +XY by XY (super)
C                               7) replace XYZ, +XYZ by XYZ (super)
C
C ADVICE :  This routine will only work with the later versions of
C           PSGRAPHS and PLTSTR$ using * for x10
C           Note the use of (*10)
C                           (300) for x10
C
      IMPLICIT   NONE
C
C Arguments
C       
      CHARACTER (LEN = *), INTENT (IN)  :: VALUE    
      CHARACTER (LEN = *), INTENT (OUT) :: NUMBER, SYMBOL  
C
C Locals
C      
      INTEGER    I, ICOUNT, J, L, LEN200
      INTEGER    N80
      PARAMETER (N80 = 80)
      CHARACTER  STRNG*(N80)
      CHARACTER  WORD1*1, WORD2*2, WORD3*3, WORD4*4
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    OK
      EXTERNAL   TRIML1, LEN200
C
C initialise SYMBOL, NUMBER, STRING
C
      SYMBOL = BLANK
      NUMBER = BLANK
      STRNG = BLANK
      IF (VALUE.EQ.BLANK) THEN
C
C No action for blank string
C
         RETURN
      ELSE
C
C Copy the string but insert E for things like 1.234+123
C
         SYMBOL = VALUE
         CALL TRIML1 (SYMBOL)
         L = LEN200(SYMBOL)
         IF (L.GT.1) THEN
            WORD1 = SYMBOL(1:1)
            IF (WORD1.EQ.'+') THEN
C
C Discard starting + character
C
               J = 0
               OK = .FALSE.
            ELSE
C
C Set the first character
C
               J = 1
               STRNG(J:J) = WORD1
               IF (WORD1.EQ.'E' .OR. WORD1.EQ.'e' .OR.
     +             WORD1.EQ.'D' .OR. WORD1.EQ.'d') THEN
                   OK = .TRUE.
               ELSE
                  OK = .FALSE.
               ENDIF
            ENDIF
            DO I = 2, L
               J = J + 1
               WORD1 = SYMBOL(I:I)
               IF (WORD1.EQ.'E' .OR. WORD1.EQ.'e' .OR.
     +             WORD1.EQ.'D' .OR. WORD1.EQ.'d') THEN
                  STRNG(J:J) = WORD1
                  OK = .TRUE.
               ELSEIF (WORD1.EQ.'+' .OR. WORD1.EQ.'-') THEN
                  IF (OK) THEN
                     STRNG(J:J) = WORD1
                  ELSE
                     STRNG(J:J) = 'E'
                     J = J + 1
                     STRNG(J:J) = WORD1
                     OK = .TRUE.
                  ENDIF
               ELSE
                  STRNG(J:J) = WORD1
               ENDIF
            ENDDO
         ELSE
            STRNG = SYMBOL
         ENDIF
         CALL TRIML1 (STRNG)
         SYMBOL = BLANK
         NUMBER = BLANK
      ENDIF
C
C Analyse the string sequentially
C
      OK = .TRUE.
      ICOUNT = 0
      J = 0
      L = LEN200(STRNG)
      DO I = 1, L
         IF (OK) THEN
C
C Process the string until E or e is encountered
C
            WORD1 = STRNG(I:I)
            IF (WORD1.EQ.'E' .OR. WORD1.EQ.'e' .OR.
     +          WORD1.EQ.'D' .OR. WORD1.EQ.'d') THEN
C
C Special action if an E is encountered. J is now fixed. First write x10
C
               J = J + 1
               ICOUNT = ICOUNT + 1
               OK = .FALSE.
               IF (L - J.EQ.0) THEN
C
C The special case 'E' ... no action so decrease J and ICOUNT
C
                  J = J - 1
                  ICOUNT = ICOUNT - 1
               ELSEIF (L - J.EQ.1) THEN
C
C The special case 'EX' ... no action or x10^X
C
                  WORD1 = STRNG(J + 1:J + 1)
                  IF (WORD1.EQ. '+' .OR. WORD1.EQ.'-' .OR.
     +                WORD1 .EQ.'0') THEN
                     J = J - 1
                     ICOUNT = ICOUNT - 1
                  ELSE
                     NUMBER(ICOUNT:ICOUNT + 2) = '*10'
                     ICOUNT = ICOUNT + 3
                     NUMBER(ICOUNT:ICOUNT) = WORD1
                  ENDIF
               ELSEIF (L - J.EQ.2) THEN
C
C The special case 'EXY' ... no action, x10^Y or x10^XY
C
                  WORD1 = STRNG(J + 1:J + 1)
                  WORD2 = STRNG(J + 1:J + 2)
                  IF (WORD2.EQ. '+0' .OR. WORD2.EQ.'-0' .OR.
     +                WORD2 .EQ.'00') THEN
                     J = J - 1
                     ICOUNT = ICOUNT - 1
                  ELSE
                     NUMBER(ICOUNT:ICOUNT + 2) = '*10'
                     ICOUNT = ICOUNT + 3
                     IF (WORD1.EQ.'+' .OR. WORD1.EQ.'0') THEN
                        NUMBER(ICOUNT:ICOUNT) = STRNG(L:L)
                     ELSE
                        NUMBER(ICOUNT:ICOUNT + 1) = WORD2
                        ICOUNT = ICOUNT + 1
                     ENDIF
                  ENDIF
               ELSEIF (L - J.EQ.3) THEN
C
C The special case 'EXYZ' ... no action, x10^Z, x10^YZ or x10^XYZ
C
                  WORD1 = STRNG(J + 1:J + 1)
                  WORD2 = STRNG(J + 1:J + 2)
                  WORD3 = STRNG(J + 1:J + 3)
                  IF (WORD3.EQ.'+00' .OR. WORD3.EQ.'-00' .OR.
     +                WORD3.EQ.'000') THEN
C
C EXYZ: Deal with E+00 and E000
C
                     J = J - 1
                     ICOUNT = ICOUNT - 1
                  ELSE
                     NUMBER(ICOUNT:ICOUNT + 2) = '*10'
                     ICOUNT = ICOUNT + 3
C
C
C EXYZ: Deal with E+0 and E00
C
                     IF (WORD2.EQ.'+0' .OR. WORD2.EQ.'00') THEN
                        NUMBER(ICOUNT:ICOUNT) = STRNG(L:L)
C
C EXYZ: Deal with E-0
C
                     ELSEIF (WORD2.EQ.'-0') THEN
                        NUMBER(ICOUNT:ICOUNT) = '-'
                        ICOUNT = ICOUNT + 1
                        NUMBER(ICOUNT:ICOUNT) = STRNG(L:L)
C
C EXYZ: Deal with E+
C
                     ELSEIF (WORD1.EQ.'+') THEN
                        NUMBER(ICOUNT:ICOUNT + 1) = STRNG(L - 1:L)
                        ICOUNT = ICOUNT + 1
                     ELSE
                        NUMBER(ICOUNT:ICOUNT + 2) = STRNG(L - 2:L)
                        ICOUNT = ICOUNT + 2
                     ENDIF
                  ENDIF
               ELSEIF (L - J.EQ.4) THEN
C
C The special case EABCD ... no action, x10^D, x10^CD, x10^BCD or x10^ABCD
C
                  WORD1 = STRNG(J + 1:J + 1)
                  WORD2 = STRNG(J + 1:J + 2)
                  WORD3 = STRNG(J + 1:J + 3)
                  WORD4 = STRNG(J + 1:J + 4)
                  IF (WORD4.EQ.'+000' .OR. WORD4 .EQ.'-000' .OR.
     +                WORD4.EQ.'0000') THEN
C
C EABCD: Deal with E+000, E-000 and E0000
C
                     J = J - 1
                     ICOUNT = ICOUNT - 1
                  ELSE
                     NUMBER(ICOUNT:ICOUNT + 2) = '*10'
                     ICOUNT = ICOUNT + 3
C
C EABCD: Deal with E+00 and E000
C
                     IF (WORD3.EQ.'+00' .OR. WORD3.EQ.'000') THEN
                        NUMBER(ICOUNT:ICOUNT) = STRNG(L:L)
C
C EABCD: Deal with E-00
C
                     ELSEIF (WORD3.EQ.'-00') THEN
                        NUMBER(ICOUNT:ICOUNT) = '-'
                        ICOUNT = ICOUNT + 1
                        NUMBER(ICOUNT:ICOUNT) = STRNG(L:L)
C
C EABCD: Deal with E+0
C
                     ELSEIF (WORD2.EQ.'+0') THEN
                        NUMBER(ICOUNT:ICOUNT + 1) = STRNG(L - 1:L)
                        ICOUNT = ICOUNT + 1
C
C EABCD: Deal with E-0
C
                     ELSEIF (WORD2.EQ.'-0') THEN
                        NUMBER(ICOUNT:ICOUNT) = '-'
                        ICOUNT = ICOUNT + 1
                        NUMBER(ICOUNT:ICOUNT + 1) = STRNG(L - 1:L)
                        ICOUNT = ICOUNT + 1
C
C EABCD: Deal with E+
C
                     ELSEIF (WORD1.EQ.'+') THEN
                        NUMBER(ICOUNT:ICOUNT + 2) = STRNG(L - 2:L)
                        ICOUNT = ICOUNT + 2
                     ELSE
                        NUMBER(ICOUNT:ICOUNT + 3) = STRNG(L - 3:L)
                        ICOUNT = ICOUNT + 3
                     ENDIF
                  ENDIF
               ENDIF
            ELSEIF (WORD1.EQ.'+' .OR. WORD1.EQ.'-' .OR.
     +              WORD1.EQ.'.' .OR.
     +              WORD1.EQ.'0' .OR. WORD1.EQ.'1' .OR.
     +              WORD1.EQ.'2' .OR. WORD1.EQ.'3' .OR.
     +              WORD1.EQ.'4' .OR. WORD1.EQ.'5' .OR.
     +              WORD1.EQ.'6' .OR. WORD1.EQ.'7' .OR.
     +              WORD1.EQ.'8' .OR. WORD1.EQ.'9') THEN
               J = J + 1
               ICOUNT = ICOUNT + 1
C
C Signs, digits and points preceeding an E or e
C
               NUMBER(ICOUNT:ICOUNT) = WORD1
            ENDIF
         ENDIF
      ENDDO
      IF (ICOUNT.GT.0) THEN
         WORD1 = '0'
         J = 0
         DO I = 1, ICOUNT
            IF (J.LT.ICOUNT) THEN
               J = J + 1
               IF (NUMBER(J:J).EQ.'*') THEN
                  SYMBOL(J:J) = '3'
                  J = J + 1
                  SYMBOL(J:J) = '0'
                  J = J + 1
                  SYMBOL(J:J) = '0'
                  WORD1 = '2'
               ELSE
                  SYMBOL(J:J) = WORD1
               ENDIF
            ENDIF
         ENDDO
      ENDIF
      END
C                                             
C