C
C
      SUBROUTINE PCKEYS$(ISEND, IFILL, IHUE, LCTEMP, MCOLOR, NCFONT,
     +                   NOUT_PS, NPTS,
     +                   SIDE_X, SIDE_Y, WIDE, WIDE1, XPC, Y_SCALE,
     +                   FSAV1, PLINE, PSYMB,
     +                   HARD_COPY, HPGL, MONO, PS, SIDE, VIDEO)
C
C
C ACTION : Panel/key for simplot PIECHART
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 30/6/95
C          24/09/1996 Added PLTSTR$ AND vector
C          14/07/1997 win32 version
C          11/09/1998 Added FSAV, FSAV1
C          25/10/2000 Added SIDE_X, SIDE_Y and allowed panel to move
C          08/01/2003 added WIDE1 and increased number of keys
C          19/10/2004 added ITYPE, XSIZE, STORE, FSIZES$
C          22/04/2007 added INTENTS 
C          04/12/2010 added PLINE and PSYMB to arguments
C          14/05/2011 increased maximum number of side panel items to 20
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NPTS
      INTEGER,             INTENT (IN)    :: ISEND, LCTEMP, MCOLOR,
     +                                       NCFONT, NOUT_PS
      INTEGER,             INTENT (INOUT) :: IFILL(NPTS), IHUE(NPTS) 
      DOUBLE PRECISION,    INTENT (IN)    :: SIDE_X, SIDE_Y, 
     +                                       WIDE1, XPC, Y_SCALE
      DOUBLE PRECISION,    INTENT (INOUT) :: WIDE
      CHARACTER (LEN = *), INTENT (IN)    :: FSAV1
      CHARACTER (LEN = *), INTENT (INOUT) :: PLINE(20), PSYMB(20)
      LOGICAL,             INTENT (IN)    :: HARD_COPY, HPGL, MONO, PS,
     +                                       SIDE, VIDEO
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +           N15, N20
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N10 = 10, N11 = 11, N12 = 12,
     +           N15 = 15, N20 = 20)
      INTEGER    ITYPE, NHATCH
      PARAMETER (ITYPE = 10, NHATCH = 100)
      INTEGER    KCOLOR
      INTEGER    I, K, L, NFONT, NPTS1
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION X1, X2, X3
      PARAMETER (X1 = 0.725D+00, X2 = 0.77D+00, X3 = 0.78D+00)
      DOUBLE PRECISION XX1, XX2, XX3
      PARAMETER (XX1 = 0.075D+00, XX2 = 0.4D+00, XX3 = 0.725D+00)
      DOUBLE PRECISION YY1, YY2, YY3, YY4
      PARAMETER (YY1 = 0.02D+00, YY2 = 0.07D+00, YY3 = 0.12D+00,
     +           YY4 = 0.17D+00)
      DOUBLE PRECISION YMAX, YMIN
      PARAMETER (YMAX = 0.85D+00, YMIN = 0.05D+00)
      DOUBLE PRECISION XBOT, XTOP
      PARAMETER (XBOT = 0.05D+00, XTOP = 0.95D+00)
      DOUBLE PRECISION YBOT, YTOP
      PARAMETER (YBOT = 0.25D+00, YTOP = 0.95D+00)
      DOUBLE PRECISION FACTOR(N20)
      DOUBLE PRECISION FACTOR_1(N20)
      DOUBLE PRECISION XDELTA, XSIZE, XTEMP, YDELTA, YTEMP, Y1, Y2
      DOUBLE PRECISION PNT04, PNT06, PNT25, PNT5, PNT8
      PARAMETER (PNT04 = 0.04D+00, PNT06 = 0.06D+00, PNT25 = 0.25D+00,
     +           PNT5 = 0.5D+00, PNT8 = 0.8D+00)
      DOUBLE PRECISION SLANT, XSTART, YSTART
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    BARCAP, SIDE1
      PARAMETER (BARCAP = .FALSE., SIDE1 = .FALSE.)
      LOGICAL    PIEKEY, STORE
      PARAMETER (PIEKEY = .TRUE., STORE = .FALSE.)
      LOGICAL    FIRST
      EXTERNAL   PLTSTR$, EDITPC$, BARCHT$, WGBFNT$, FSIZES$
      INTRINSIC  DBLE, MIN
      SAVE       FIRST, FACTOR, XSTART, YSTART
      DATA       FACTOR_1 / N20*ONE /
      DATA       FIRST / .TRUE. /
      DATA       XSTART, YSTART / X3, YMAX /
      IF (FIRST) THEN
C
C Define positions and parameters for panel keys
C        
         FIRST = .FALSE.
         DO I = N1, N20
            FACTOR(I) = FACTOR_1(I)
         ENDDO
         K = N0
         DO I = N1, NPTS
            IF (IFILL(I).NE.N0) K = K + N1
         ENDDO
         IF (K.LE.N15) THEN
            YDELTA = (YMAX - YMIN)/DBLE(N15)
            YSTART = YMAX - DBLE(N15 - K)*YDELTA/TWO
         ELSE   
            IF (K.GT.N20) K = N20
            YDELTA = (YMAX - YMIN)/DBLE(K)
            YSTART = YMAX - DBLE(N20 - K)*YDELTA/TWO  
         ENDIF     
      ENDIF
      IF (ISEND.EQ.N0) THEN
C
C Move side panel to icon arrow coordinates..........................
C

         XSTART = SIDE_X + PNT06
         YSTART = SIDE_Y
      ELSEIF (ISEND.EQ.N1) THEN
C
C Plot bars and labels for PANEL/KEY .................................
C
         CALL FSIZES$(ITYPE,
     +                XSIZE, 
     +                STORE)
         IF (PS) WRITE (NOUT_PS,100) XSIZE
         CALL WGBFNT$(I, NFONT,
     +                SLANT)
         IF (SIDE) THEN
            IF (XSTART.LT.XBOT) XSTART = XBOT
            IF (XSTART.GT.XTOP) XSTART = XTOP
            IF (YSTART.LT.YBOT) YSTART = YBOT
            IF (YSTART.GT.YTOP) YSTART = YTOP
            XDELTA = X2 - X1
            YDELTA = (YMAX - YMIN)/(DBLE(N20) - ONE)
            Y1 = YSTART
            K = N0
            DO I = N1, NPTS
               IF (K.LT.N20 .AND. IFILL(I).NE.N0 .AND.
     +             PLINE(I).NE.BLANK) THEN
                  K = K + N1
                  Y1 = Y1 - YDELTA
                  Y2 = Y1 + PNT8*YDELTA
                  IF (MONO) THEN
                     IF (VIDEO) THEN
                        KCOLOR = N0
                     ELSE
                        KCOLOR = N15
                     ENDIF
                  ELSE
                     KCOLOR = IHUE(I)
                  ENDIF
                  CALL PLTSTR$(MCOLOR, NCFONT, NFONT, N0, NOUT_PS,
     +                         ZERO, XSIZE*XPC, ZERO, XSTART,
     +                         Y1 + PNT25*YDELTA,
     +                         Y_SCALE,
     +                         BLANK, PLINE(I), PSYMB(I), 'left',
     +                         HARD_COPY, HPGL, PS)
                  IF (IFILL(I).LE.N7) THEN
                     L = N1
                  ELSEIF (IFILL(I).EQ.N8) THEN
                     L = N2
                  ELSEIF (IFILL(I).EQ.N9) THEN
                     L = N3
                  ELSEIF (IFILL(I).EQ.N10) THEN
                     L = N4
                  ENDIF
                  CALL BARCHT$(KCOLOR, IFILL(I), N2, L, LCTEMP, NHATCH,
     +                         XDELTA, FACTOR(I), WIDE, WIDE1,
     +                         XSTART - PNT04, YMAX, YMIN, YMAX, YMIN,
     +                         Y1, Y1, Y1, Y2, Y2,
     +                         BARCAP, PS, SIDE1)
               ENDIF
            ENDDO
         ELSE
            XDELTA = PNT25*(XX2 - XX1)
            YDELTA = PNT25*(YY2 - YY1)
            K = N0
            DO I = N1, NPTS
               IF (K.LT.N12 .AND. IFILL(I).NE.N0 .AND.
     +             PLINE(I).NE.BLANK) THEN
                  K = K + N1
                  IF (K.EQ.N1 .OR. K.EQ.N4 .OR. K.EQ.N7 .OR.
     +                K.EQ.N10) THEN
                     XTEMP = XX1
                  ELSEIF (K.EQ.N2 .OR. K.EQ.N5 .OR. K.EQ.N8 .OR.
     +                    K.EQ.N11) THEN
                     XTEMP = XX2
                  ELSE
                     XTEMP = XX3
                  ENDIF
                  IF (NPTS.LE.N3) THEN
                     YTEMP = YY2
                  ELSEIF (NPTS.LE.N6) THEN
                     IF (K.LE.3) THEN
                        YTEMP = YY2
                     ELSE
                        YTEMP = YY1
                     ENDIF
                  ELSE
                     IF (K.LE.N3) THEN
                        YTEMP = YY4
                     ELSEIF (K.LE.N6) THEN
                        YTEMP = YY3
                     ELSEIF (K.LE.N9) THEN
                        YTEMP = YY2
                     ELSE
                        YTEMP = YY1
                     ENDIF
                  ENDIF
                  Y1 = YTEMP - PNT25*YDELTA
                  Y2 = YTEMP + TWO*YDELTA + PNT25*YDELTA
                  IF (MONO) THEN
                     IF (VIDEO) THEN
                        KCOLOR = N0
                     ELSE
                        KCOLOR = N15
                     ENDIF
                  ELSE
                     KCOLOR = IHUE(I)
                  ENDIF
                  CALL PLTSTR$(MCOLOR, NCFONT, NFONT, N0, NOUT_PS,
     +                         ZERO, XSIZE*XPC, ZERO,
     +                         XTEMP + PNT5*XDELTA, YTEMP, Y_SCALE,
     +                         BLANK, PLINE(I), PSYMB(I), 'left',
     +                         HARD_COPY, HPGL, PS)
                  IF (IFILL(I).LE.N7) THEN
                     L = N1
                  ELSEIF (IFILL(I).EQ.N8) THEN
                     L = N2
                  ELSEIF (IFILL(I).EQ.N9) THEN
                     L = N3
                  ELSEIF (IFILL(I).EQ.N10) THEN
                     L = N4
                  ENDIF
                  CALL BARCHT$(KCOLOR, IFILL(I), N2, L, LCTEMP, NHATCH,
     +                         PNT5*XDELTA, FACTOR(I), WIDE, WIDE1,
     +                         XTEMP, YMAX, YMIN, YMAX, YMIN,
     +                         Y1, Y1, Y1, Y2, Y2,
     +                         BARCAP, PS, SIDE1)
               ENDIF
            ENDDO
         ENDIF
         IF (PS) WRITE (NOUT_PS,100) ONE/XSIZE
      ELSEIF (ISEND.EQ.N2) THEN
C
C Edit the key details................................................
C
         NPTS1 = MIN(NPTS,N20)
         CALL EDITPC$(IFILL, IHUE, NPTS1,
     +                FACTOR, WIDE,
     +                FSAV1, PLINE, PSYMB,
     +                PIEKEY)
      ENDIF  
C
C This format statement must NOT be edited
C      
  100 FORMAT ('/tl-size tl-size',1X,f7.3,1X,'mul def')
      END
C  
C