C
C
      SUBROUTINE PCPLOT$(ISEND, IFILLV, IHUEV, NVEC,
     +                   FACT, XVEC,
     +                   LVEC, TVEC)
C
C ACTION  : Supply a vector then create a piechart by calling GKSGRF$
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C           Derived from SMPLOT$ 28/05/2001
C           07/01/2003 redimensioned WIDE(5*NGRAFS)
C           21/10/2004 added call to SYMBOL
C           11/07/2005 increased NMAX from 50 to 100
C           20/04/2007 added INTENTS and initialised labels for vectors
C           01/01/2008 added NXTRA
C           15/01/2008 redimensioned NMAX = 10000 and NWORDS = 2000
C           28/01/2008 removed X, ..., YT from argument list to GKSGRF$
C           29/06/2009 also deletes FILEX since FSAV(1) and FSAV1(1) are redefined
C           02/11/2010 added SIZE and WIDE to argument list to SYMBOL
C           28/12/2010 added TXTKEY to retrieve current text keys 
C           23/04/2011 increased dimension to 20
C           06/07/2011 added WORDX and VECTORS in call to LABELS
C           12/07/2011 added WORDY to TXTKEY argument list
C
C           Arguments are unchanged.
C
C           ISEND: (input/unchanged) use labels as follows:
C                   ISEND = 1: vector type pie chart file with default labels, etc.
C                   ISEND = 2: fully specified pie chart file with supplied labels, etc.
C          IFILLV: (input/unchanged) fill style (if ISEND = 2)
C           IHUEV: (input/unchanged) colour (if ISEND = 2)
C            NVEC: (input/unchanged) dimension of vector
C            FACT: (input/unchanged) vector of displacements (if ISEND = 2)
C            XVEC: (input/unchanged) vector of values (XVEC(i) > 0)
C            LVEC: (input/unchanged) labels if ISEND = 2
C            TVEC: (input/unchanged) title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NVEC
      INTEGER,             INTENT (IN) :: ISEND, IFILLV(NVEC), 
     +                                    IHUEV(NVEC)
      DOUBLE PRECISION,    INTENT (IN) :: FACT(NVEC), XVEC(NVEC)
      CHARACTER (LEN = *), INTENT (IN) :: LVEC(NVEC), TVEC
C
C Locals
C
      INTEGER    KPANEL, NFILE1, NGRAFS, NGRAF2, NGRAF3, NGRAF4, NIN,
     +           NMAX, NWORDS, NXTRA
      PARAMETER (NIN = 3, NMAX = 100, NGRAFS = 300, NGRAF2 = 2*NGRAFS,
     +           NGRAF3 = 3*NGRAFS, NGRAF4 = 4*NGRAFS,
     +           NWORDS = 2000, KPANEL = NMAX, NXTRA = NWORDS)
      INTEGER    JSEND
      PARAMETER (JSEND = 1)
      INTEGER    N0, N1, N2, N4, N10, N20, N40, N60, N71
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N10 = 10, 
     +           N20 = 20, N40 = 40, N60 = 60, N71 = 71)
      INTEGER    IFILL(NXTRA), IHUE(NXTRA), JCOLOR(NGRAFS),
     +           KCOLOR(N20), L(NGRAFS), M(NGRAFS), NSAV(NGRAFS)
      INTEGER    I, IFAIL, IOS, NMAX1, NOUT
      INTEGER    IFILL_1(N20), IHUE_1(N20)
      DOUBLE PRECISION FACTOR(NXTRA), SIZE(NGRAFS), WIDE(5*NGRAFS)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  FILEX*1024
      CHARACTER  TITLES(4)*1
      CHARACTER  FSAV(NGRAFS)*1024, FSAV1(NGRAFS)*1024,
     +           LABEL1(NWORDS)*40,
     +           LABVEC(NWORDS)*40, PLINE(KPANEL)*40, PSYMB(KPANEL)*40,
     +           TSAV(NGRAFS)*80, WORDX(NWORDS)*40, WORDY(NWORDS)*40
      CHARACTER  LABEL_1(N20)*40, VECTORS(N60)*40
      CHARACTER  BLANK*1, ZERO40*40
      PARAMETER (BLANK = ' ',
     +           ZERO40 = '0000000000000000000000000000000000000000')
      LOGICAL    TYPE_IN
      LOGICAL    BARCAP(NGRAFS), BARCAP_1, BAR_CHART, LIB_FILE,
     +           LOWER(NGRAFS), PIE_CHART, PLOTX(NWORDS), PLOTY(NWORDS),
     +           PLOTZ(NWORDS), PSHOW(KPANEL), SUPPLY_XY, TWO_PLOTS,
     +           UPPER(NGRAFS), VECTOR_FIELD, YAXIS(NGRAFS)
      LOGICAL    ASKIF, STORE, THERE
      PARAMETER (ASKIF = .FALSE., STORE = .FALSE.)
      EXTERNAL   GKSGRF$, DELEET, GETTMP, GETNOU, SYMBOL, LABELS,
     +           TXTKEY
      EXTERNAL   DEFGKS$, PLTOBJ$, PUTFAT$
C
C Check the data supplied
C
      IF (ISEND.LT.N1 .OR. ISEND.GT.N2) THEN
         CALL PUTFAT$('ISEND out of range in call to PCPLOT')
         RETURN
      ENDIF
      IF (NVEC.LT.N2) THEN
         CALL PUTFAT$('Must have at least 2 items for a pie chart')
         RETURN
      ENDIF
      IF (NVEC.GT.NMAX) THEN
         CALL PUTFAT$('Maximum dimension (100) for pie chart exceeded')
         RETURN
      ENDIF
      DO I = N1, NVEC
         IF (XVEC(I).LE.ZERO) THEN
            CALL PUTFAT$('Segments =< 0 not allowed in pie charts')
            RETURN
         ENDIF
      ENDDO
C
C Initialise gks and graphical objects
C
      CALL DEFGKS$
      CALL PLTOBJ$(N1, N1)
C
C Initialise all the array variables even though they are not to be used
C
      BARCAP_1 = .TRUE.
      DO I = N1, KPANEL
         PLINE(I) = BLANK
         PSYMB(I) = ZERO40
         PSHOW(I) = .TRUE.
      ENDDO
      DO I = N1, NGRAFS
         JCOLOR(I) = N0
         L(I) = N1
         M(I) = N1
         NSAV(I) = N1
         SIZE(I) = ONE
         WIDE(I) = ONE
         WIDE(I + NGRAFS) = ONE
         WIDE(I + NGRAF2) = ONE
         WIDE(I + NGRAF3) = ONE
         WIDE(I + NGRAF4) = ONE
         FSAV(I) = BLANK
         FSAV1(I) = BLANK
         TSAV(I) = BLANK
         BARCAP(I) = .TRUE.
         LOWER(I) = .TRUE.
         UPPER(I) = .TRUE.
         YAXIS(I) = .TRUE.
      ENDDO
      DO I = N1, NWORDS
         IFILL(I) = N1
         IHUE(I) = N0
         FACTOR(I) = ONE
         LABEL1(I) = BLANK
         LABVEC(I) = ZERO40
         WORDX(I) = BLANK
         WORDY(I) = BLANK
         PLOTX(I) = .TRUE.
         PLOTY(I) = .TRUE.
         PLOTZ(I) = .TRUE.
      ENDDO
      DO I = N1, N4
         TITLES(I) = BLANK
      ENDDO
C
C Get the current defaults
C
      CALL LABELS (JSEND, IHUE_1, IFILL_1,
     +             LABEL_1, PLINE, WORDX, VECTORS) 
      DO I = N1, N20
         LABVEC(I) = VECTORS(I)
         PSYMB(I) = VECTORS(I + N20)
         WORDY(I) = VECTORS(I + N40)
      ENDDO                  
      CALL SYMBOL (JSEND, JCOLOR, KCOLOR, L, M,
     +             SIZE, WIDE)
      CALL TXTKEY (LABVEC, PSYMB, WORDY, 
     +             STORE)  
C
C Create a piechart file
C
      CALL GETTMP (IFAIL,
     +             FILEX)
      IF (IFAIL.NE.N0) RETURN
      CALL GETNOU (NOUT)
      OPEN (UNIT = NOUT, FILE = FILEX, IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF
      WRITE (NOUT,'(A)') TVEC
      IF (ISEND.EQ.N1) THEN
C
C Vector type pie chart file using current defaults
C
         WRITE (NOUT,'(2I6)') NVEC, N1
         DO I = N1, NVEC
            WRITE (NOUT,'(1P,E11.3)') XVEC(I)
         ENDDO   
         WRITE (NOUT,'(I6)') NVEC + 2
         WRITE (NOUT,'(A)') 'begin{labels}' 
         DO I = N1, NVEC 
            IF (I.LE.9) THEN
               WRITE (NOUT,'(I1)') I
            ELSEIF (I.LE.99) THEN
               WRITE (NOUT,'(I2)') I
            ELSE
               WRITE (NOUT,'(I4)') I 
            ENDIF        
         ENDDO  
         WRITE (NOUT,'(A)') 'end{labels}' 
      ELSE
C
C Create a fully specified pie chart type file
C
         DO I = N1, NVEC
            IFILL(I) = IFILLV(I)
            IHUE(I) = IHUEV(I)
            WIDE(I) = FACT(I)
            IF (IFILL(I).LT.N0 .OR. IFILL(I).GT.N10) IFILL(I) = N1
            IF (IHUE(I).LT.N0 .OR. IHUE(I).GT.N71) IHUE(I) = N1
            IF (WIDE(I).LT.ZERO .OR. WIDE(I).GT.ONE) WIDE(I) = ZERO
         ENDDO
         WRITE (NOUT,'(2I6)') NVEC, N4
         DO I = N1, NVEC
            WRITE (NOUT,'(1P,E11.3,I4,0P,F6.2,I4)') XVEC(I), IFILL(I),
     +                                              WIDE(I), IHUE(I)
         ENDDO
         WRITE (NOUT,'(I6)') NVEC + 2
         WRITE (NOUT,'(A)') 'begin{labels}'
         DO I = N1, NVEC
            WRITE (NOUT,'(A)') LVEC(I)
         ENDDO
         WRITE (NOUT,'(A)') 'end{labels}'
      ENDIF
      CLOSE (UNIT = NOUT)
C
C Set the variables then call GKSGRF$
C
      NFILE1 = N1
      FSAV(1) = FILEX
      FSAV1(1) = FILEX
      BAR_CHART = .FALSE.
      LIB_FILE = .FALSE.
      PIE_CHART = .TRUE.
      SUPPLY_XY = .TRUE.
      TWO_PLOTS = .FALSE.
      TYPE_IN = .FALSE.
      VECTOR_FIELD = .FALSE.

      NMAX1 = NMAX
      
      CALL GKSGRF$(IFILL, IHUE, JCOLOR, KPANEL, L, M, NFILE1,
     +             NGRAFS, NIN, NMAX1, NSAV, NWORDS, NXTRA,
     +             FACTOR, SIZE, WIDE, 
     +             FSAV, FSAV1, LABEL1, LABVEC, PLINE, PSYMB,
     +             TSAV, TITLES, WORDX, WORDY,
     +             BARCAP, BARCAP_1, BAR_CHART, LIB_FILE, LOWER,
     +             PIE_CHART, PLOTX, PLOTY, PLOTZ, PSHOW,
     +             SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +             VECTOR_FIELD, YAXIS)
C
C Delete the temporary files used for plotting
C
      CALL DELEET (FILEX, 
     +             ASKIF, THERE)
      CALL DELEET (FSAV(N1),
     +             ASKIF, THERE)
      CALL DELEET (FSAV1(N1),
     +             ASKIF, THERE)
      END
C
C
