C
C Calls pcplot$
C
      SUBROUTINE PCPLOT (ISEND, IFILLV, IHUEV, NVEC,
     +                   FACT, XVEC,
     +                   LVEC, TVEC)
C
C ACTION  : Supply a vector then create a piechart by calling GKSGRF$
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C
C           Arguments are unchanged.
C
C           ISEND: (input/unchanged) use labels as follows:
C                   ISEND = 1: vector type pie chart file with no labels
C                   ISEND = 2: fully specified pie chart file with labels
C          IFILLV: (input/unchanged) fill style (if ISEND = 2)
C           IHUEV: (input/unchanged) colour (if ISEND = 2)
C            NVEC: (input/unchanged) dimension of vector
C            FACT: (input/unchanged) vector of displacements (if ISEND = 2)
C            XVEC: (input/unchanged) vector of values (XVEC(i) > 0)
C            LVEC: (input/unchanged) labels if ISEND = 2
C            TVEC: (input/unchanged) title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NVEC
      INTEGER,             INTENT (IN) :: ISEND, IFILLV(NVEC),
     +                                    IHUEV(NVEC)
      DOUBLE PRECISION,    INTENT (IN) :: FACT(NVEC), XVEC(NVEC)
      CHARACTER (LEN = *), INTENT (IN) :: LVEC(NVEC), TVEC
      EXTERNAL   PCPLOT$
      CALL PCPLOT$(ISEND, IFILLV, IHUEV, NVEC,
     +             FACT, XVEC,
     +             LVEC, TVEC)
      END
C
C
