    
C
C
      SUBROUTINE PDFCDF (NCDF, NOUT, NPAR, NPDF, NTYPE, 
     +                   PAR, XBOT, XCDF, XPDF, XTOP, YCDF, YPDF,
     +                   PTITLE, XTITLE, YTITLE)
C
C ACTION: Plot PDF and CDF if required between limits A and B 
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.,
C         10/08/2007 derived from CDFPDF
c         05/04/2014 added calls to GKS001, DBPLOT, FORM20, and PATCH2  
C
C NTYPE = 1: normal
C NTYPE = 2: chi-square
C NTYPE = 3: F 
C NTYPE = 4: t
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NCDF, NOUT, NPAR, NPDF,
     +                                       NTYPE
      DOUBLE PRECISION,    INTENT (IN)    :: PAR(NPAR), XBOT, XTOP
      DOUBLE PRECISION,    INTENT (INOUT) :: XCDF(NCDF), XPDF(NPDF),
     +                                       YPDF(NPDF), YCDF(NCDF)
      CHARACTER (LEN = *), INTENT (IN)    :: PTITLE, XTITLE, YTITLE
C
C Locals
C      
      INTEGER    L0, L1, L2, N1, N2, N3
      PARAMETER (L0 = 0, L1 = 1, L2 = 2, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    NFILES, NMAX
      PARAMETER (NFILES = 2, NMAX = 21)
      INTEGER    JFILES(NFILES), LFILES(NFILES), MFILES(NFILES) 
      INTEGER    I, IFAIL, J, NTEMP
      INTEGER    NUMDEC, NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 7, NUMSTA = 8, NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    NUMBLD(30)
      DOUBLE PRECISION XFACT, XMU, XSIGMA
      DOUBLE PRECISION DBLE_N, ENEG, EXPON, FACTOR
      DOUBLE PRECISION DBLE_M, EPOS, EXPON1, EXPON2, RATIO, RTOL
      DOUBLE PRECISION EPSI, ONE, TWO, THREE, FOUR
      PARAMETER (EPSI = 1.0D-20, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00)
      DOUBLE PRECISION BOT_VALUE, TOP_VALUE
      PARAMETER (BOT_VALUE = -1.96D+00, TOP_VALUE = -BOT_VALUE)
      DOUBLE PRECISION A, B, DELTA
      DOUBLE PRECISION XBOT1(NMAX), XTOP1(NMAX), YBOT1(NMAX), 
     +                 YTOP1(NMAX)
      DOUBLE PRECISION CDF_NORMAL, PDF_NORMAL
      DOUBLE PRECISION CDF_CHISQUARE, PDF_CHISQUARE
      DOUBLE PRECISION CDF_F, PDF_F
      DOUBLE PRECISION CDF_T, PDF_T
      CHARACTER (LEN = 100 ) TEXT(30)
      CHARACTER (LEN = 1024) FILES(NFILES)
      CHARACTER (LEN = 40  ) TITLES(4)
      CHARACTER (LEN = 20  ) A_WORD, B_WORD, A_MIN, B_MAX, FORM20 
      LOGICAL    F, CHISQD, NORMAL, T
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      LOGICAL    REPEET, YES
      LOGICAL    LEFT_AXIS(NFILES)
      EXTERNAL   GETDL2, GKS001, GKS004
      EXTERNAL   CDF_NORMAL, PDF_NORMAL
      EXTERNAL   CDF_CHISQUARE, PDF_CHISQUARE
      EXTERNAL   CDF_F, PDF_F 
      EXTERNAL   CDF_T, PDF_T
      EXTERNAL   LSTBOX, GETNOU, GETTMP, DBPLOT, TMPDEL, PATCH2, FORM20,
     +           PUTWAR
      INTRINSIC  DBLE
      DATA       NUMBLD / 30*0 /
C
C Initialise then Check and act on NTYPE and NPAR
C      
      F = .FALSE.
      CHISQD = .FALSE.
      NORMAL = .FALSE.
      T = .FALSE.
      IF (NTYPE.EQ.1 .AND. NPAR.GE.3) THEN
         NORMAL = .TRUE.
         XMU = PAR(1)
         XSIGMA = PAR(2)
         XFACT = PAR(3)
         A = XMU - THREE*XSIGMA
         B = XMU + THREE*XSIGMA
      ELSEIF (NTYPE.EQ.2 .AND. NPAR.GE.4) THEN
         CHISQD = .TRUE.
         DBLE_N = PAR(1)   
         ENEG = PAR(2)
         EXPON = PAR(3)
         FACTOR = PAR(4)
         A = EPSI
         B = TWO*PAR(1)
      ELSEIF (NTYPE.EQ.3 .AND. NPAR.GE.8) THEN
         F = .TRUE.
         DBLE_M = PAR(1)
         DBLE_N = PAR(2)
         EPOS = PAR(3)
         EXPON1 = PAR(4)
         EXPON2 = PAR(5)
         FACTOR = PAR(6)
         RATIO = PAR(7)
         RTOL = PAR(8)  
         A = EPSI
         B = FOUR
      ELSEIF (NTYPE.EQ.4 .AND. NPAR.GE.3) THEN
         T = .TRUE.
         DBLE_N = PAR(1)
         EXPON = PAR(2)   
         FACTOR = PAR(3)
         A = - TWO
         B = TWO
      ELSE
         RETURN
      ENDIF  
      IF (A.LT.XBOT .OR. B.GT.XTOP) CALL PUTWAR (
     +'PDFCDF called with parameters leading to A < X_min or B > X_max')
      A_WORD = FORM20(A)
      A_MIN = FORM20(XBOT)
      B_WORD = FORM20(B)
      B_MAX = FORM20(XTOP)
      REPEET = .TRUE.
      YES = .TRUE.
      NUMDEC = NUMOPT - 1
      DO WHILE (REPEET) 
         WRITE (TEXT,100) A_WORD, A_MIN, B_WORD, B_MAX
         NUMBLD(1) = 4
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                TEXT)
         NUMBLD(1) = 0
         IF (NUMDEC.LE.4) THEN   
C
C NUMDEC < 4: plot
C                
            IF (YES) THEN
C
C Calculate if YES = .TRUE. after re-setting YES = .FALSE.
C        
               YES = .FALSE.
               DELTA = (B - A)/(DBLE(NPDF) - ONE)
C
C Calculate XPDF
C         
               XPDF(N1) = A
               DO I = N2, NPDF - N1
                  XPDF(I) = XPDF(I - N1) + DELTA
               ENDDO
               XPDF(NPDF) = B
C
C Calculate YPDF
C         
               IF (NORMAL) THEN
                  DO I = N1, NPDF
                     YPDF(I) = PDF_NORMAL (XPDF(I), XFACT, XMU, XSIGMA)
                  ENDDO
               ELSEIF (CHISQD) THEN 
                  DO I = N1, NPDF
                     YPDF(I) = PDF_CHISQUARE (ENEG, EXPON, FACTOR, 
     +                                        XPDF(I))
                  ENDDO  
                ELSEIF (F) THEN 
                  DO I = N1, NPDF
                     YPDF(I) = PDF_F (EPOS, EXPON1, EXPON2, FACTOR,
     +                                RATIO, RTOL, XPDF(I))
                  ENDDO     
               ELSEIF (T) THEN 
                  DO I = N1, NPDF
                     YPDF(I) = PDF_T (DBLE_N, EXPON, FACTOR, XPDF(I))         
                  ENDDO   
               ENDIF  
C
C Calculate XCDF
C          
               DELTA = (B - A)/(DBLE(NCDF) - ONE)
               XCDF(N1) = A
               DO I = N2, NCDF - N1
                  XCDF(I) = XCDF(I - N1) + DELTA
               ENDDO
               XCDF(NCDF) = B
C
C Calculate YCDF
C         
               IF (NORMAL) THEN
                  DO I = N1, NCDF
                     YCDF(I) = CDF_NORMAL (NOUT, 
     +                                     XCDF(I), XMU, XSIGMA)
                  ENDDO
               ELSEIF (CHISQD) THEN
                  DO I = N1, NCDF
                     YCDF(I) = CDF_CHISQUARE (NOUT, 
     +                                        DBLE_N, XCDF(I))
                  ENDDO
               ELSEIF (F) THEN
                  DO I = N1, NCDF
                     YCDF(I) = CDF_F (NOUT, 
     +                                DBLE_M, DBLE_N, XCDF(I))
                  ENDDO   
               ELSEIF (T) THEN
                  DO I = N1, NCDF
                     YCDF(I) = CDF_T (NOUT, 
     +                                DBLE_N, XCDF(I))
                  ENDDO      
               ENDIF  
            ENDIF   
C
C Plot
C          
            IF (NUMDEC.EQ.1) THEN
               CALL GKS001 (L1, L0, NCDF,
     +                      XCDF, YCDF,
     +                      PTITLE, XTITLE, 'cdf')              
            ELSEIF (NUMDEC.EQ.2) THEN
               CALL GKS001 (L1, L0, NPDF,
     +                      XPDF, YPDF,
     +                      PTITLE, XTITLE, 'pdf')     
            ELSEIF (NUMDEC.EQ.3) THEN  
C
C Check for special case to illustrate tails for normal pdf with MU = 0, SIGMA = 1
C            
               IF (NTYPE.EQ.1 .AND.
     +             XMU.GE.- EPSI .AND. XMU.LE.EPSI .AND.
     +             XSIGMA.GE.ONE - EPSI .AND. XSIGMA.LE.ONE + EPSI .AND.            
     +             A.LT.BOT_VALUE .AND. B.GT.TOP_VALUE) THEN
     
                   DELTA = (BOT_VALUE - A)/DBLE(NMAX - 2)
                   XBOT1(1) = A
                   YBOT1(1) = PDF_NORMAL (A, XFACT, XMU, XSIGMA)
                   DO I = N2, NMAX - N2
                     XBOT1(I) = XBOT1(I - 1) + DELTA
                     YBOT1(I) = PDF_NORMAL (XBOT1(I), XFACT, XMU,
     +                                      XSIGMA)
                  ENDDO
                  XBOT1(NMAX - 1) = BOT_VALUE
                  YBOT1(NMAX - 1) = PDF_NORMAL (BOT_VALUE, XFACT, XMU,
     +                                          XSIGMA)                  
                  XBOT1(NMAX) = BOT_VALUE
                  YBOT1(NMAX) = YBOT1(1)
                  
                  DELTA = (B - TOP_VALUE)/DBLE(NMAX - 2) 
                  XTOP1(1) = TOP_VALUE
                  YTOP1(1) = PDF_NORMAL (B, XFACT, XMU, XSIGMA)
                  XTOP1(2) = TOP_VALUE
                  YTOP1(2) = PDF_NORMAL (TOP_VALUE, XFACT, XMU, XSIGMA)
                  DO I = N3, NMAX - N1
                     XTOP1(I) = XTOP1(I - 1) + DELTA
                     YTOP1(I) = PDF_NORMAL (XTOP1(I), XFACT, XMU,
     +                                      XSIGMA)
                  ENDDO
                  XTOP1(NMAX) = B
                  YTOP1(NMAX) = YTOP1(1)
                  CALL GKS004 (L1, L1, L1, L2, L0, L0, L0, L0,
     +                         NMAX, NMAX, NPDF, NCDF, 
     +                         XBOT1, XTOP1, XPDF, XCDF, 
     +                         YBOT1, YTOP1, YPDF, YCDF,
     +                         PTITLE, XTITLE, YTITLE, AXES, GSAVE)
                        
               ELSE
                  CALL GKS004 (L1, L2, L0, L0, L0, L0, L0, L0,
     +                         NPDF, NCDF, NCDF, NCDF,
     +                         XPDF, XCDF, XCDF, XCDF, 
     +                         YPDF, YCDF, YCDF, YCDF,
     +                         PTITLE, XTITLE, YTITLE, AXES, GSAVE)
               ENDIF
            ELSEIF (NUMDEC.EQ.4) THEN
               LEFT_AXIS(1) = .TRUE.
               LEFT_AXIS(2) = .FALSE.
               DO I = 1, NFILES
                  JFILES(I) = 0
                  LFILES(I) = 3 - I
                  MFILES(I) = 0
                  CALL GETTMP (IFAIL,
     +                         FILES(I))                
                  CALL GETNOU (NTEMP)
                  OPEN (UNIT = NTEMP, FILE = FILES(I))
                  WRITE (NTEMP,'(A)') 'Temporary File'
                  IF (I.EQ.1) THEN
                     WRITE (NTEMP,'(2I6)') NCDF, N2
                     DO J = 1, NCDF
                        WRITE (NTEMP,'(2E14.6)') XCDF(J), YCDF(J)
                     ENDDO
                     TITLES(3) = 'cdf'
                  ELSE
                     WRITE (NTEMP,'(2I6)') NPDF, N2
                     DO J = 1, NPDF
                        WRITE (NTEMP,'(2E14.6)') XPDF(J), YPDF(J)
                     ENDDO
                     TITLES(4) = 'pdf' 
                  ENDIF         
                  CLOSE (UNIT = NTEMP)
               ENDDO 
               TITLES(1) = PTITLE
               TITLES(2) = XTITLE
               CALL DBPLOT (JFILES, LFILES, MFILES, NFILES,
     +                      FILES, TITLES,
     +                      LEFT_AXIS) 
               CALL TMPDEL (NFILES,
     +                      FILES)                         
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: adjust A, B
C      
            IF (A.LT.XBOT) A = XBOT
            IF (B.GT.XTOP) B = XTOP  
            CALL GETDL2 (EPSI, XBOT, A, B, XTOP,
     +  'Start-value, then stop-value for independent variable')
            A_WORD = FORM20(A)
            B_WORD = FORM20(B)
            YES = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C NUMDEC = NUMOPT - 1: help
C      
            WRITE (TEXT,200)
            NUMBLD(1) = 1
            NUMBLD(3) = 1
            NUMBLD(11) = 1
            NUMBLD(20) = 1 
            NTEMP = 24
            CALL PATCH2 (NUMBLD, NTEMP,
     +                   TEXT) 
            NUMBLD(1) = 0
            NUMBLD(3) = 0
            NUMBLD(11) = 0
            NUMBLD(20) = 0          
         ELSE
C
C NUMDEC = NUMOPT: cancel
C        
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Options for plotting cdf and pdf curves'
     +/
     +/'Current plot starts at',2X,A
     +/'Minimum value permitted is',2X,A
     +/'Current plot ends at',2X,A
     +/'Maximum value permitted is',2X,A
     +/
     +/'Plot cdf'
     +/'Plot pdf'
     +/'Plot cdf and pdf (one vertical scale)'
     +/'Plot cdf and pdf (two vertical scales)' 
     +/'Change the plotting range'
     +/'Help'
     +/'Cancel') 
  200 FORMAT (
     +  'The cdf and pdf plotting options'
     +/         
     +/'cdf'         
     +/'This is the cumulative distribution function which plots as a'         
     +/'curve rising monotonically from zero at the lowest point in the'         
     +/'range to a value of one at the highest point in the range. The'          
     +/'Kolmogorov-Smirnov 1-sample test is based on the maximum'           
     +/'distance between the sample cumulative distribution and the'         
     +/'assumed cumulative distribution.'          
     +/          
     +/'pdf'         
     +/'This is the probability density function, which is what people'         
     +/'are attempting to approximate using histograms or bar charts.'          
     +/'These are popular for visual display because the pdf often has'          
     +/'a distinctive shape and can be used for a chi-squared test.'         
     +/'However, it is necessary to have a very large sample and many'         
     +/'histogram bins before the histogram is a reliable indicator of'         
     +/'the shape of the true pdf, i.e. the population pdf.'         
     +/         
     +/'Differential scaling for the cdf and pdf'         
     +/'The cdf curve is the integral of the pdf curve but, as these'         
     +/'require different vertical scales, the ability to plot both'
     +/'curves with the same horizontal axis but different vertical'
     +/'axes is provided') 
      END
C
C
