C
C
      SUBROUTINE PFILE1$(IFILL, IHUE, ISEND, NFILES, NGROUP, NIN, NMAX,
     +                   NPTS, NTYPE, NWORDS, NXTRA,
     +                   FACTOR, YMAX3, YMAX4,
     +                   YMIN3, YMIN4,
     +                   FNAME, TITLE,
     +                   ABORT, BAR_CHART, VECTOR_FIELD)

      USE MODULE_SAVEGKS, ONLY : X, XH, XL, Y, YH, YL
C
C ACTION : Input files for GKS graphics          
C          ISEND = 1 : ask if file is OK then OPEN, check and read in data
C          ISEND = 2 : OPEN file then read in data directly
C          NIN = UNIT number for file opening
C          NMAX = max. dimension for arrays
C          NPTS = no. of points accepted
C          NTYPE = 1 : 2 columns X = XH = XL, Y = YH = YL
C          NTYPE = 2 : 4 columns X = XH = XL then YL, Y, YH
C          NTYPE = 3 : 9 columns for a bar chart
C
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          29/01/2008 derived from GKSFIL$ but using MODULE_SAVEGKS
C          01/08/2008 added call to ISITSF 
C          15/06/2010 added KVAL_11 and call to NKLCFG
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NIN, NWORDS, NXTRA
      INTEGER,             INTENT (INOUT) :: NMAX
      INTEGER,             INTENT (INOUT) :: IFILL(NXTRA),
     +                                       IHUE(NXTRA), NPTS
      INTEGER,             INTENT (INOUT) :: NFILES, NGROUP, NTYPE 
      DOUBLE PRECISION,    INTENT (INOUT) :: FACTOR(NXTRA)
      DOUBLE PRECISION,    INTENT (INOUT) :: YMAX3, YMAX4, YMIN3, YMIN4
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (INOUT) :: BAR_CHART, VECTOR_FIELD 
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N16, N21,
     +           N23, N71
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N10 = 10, N16 = 16, N21 = 21, 
     +           N23 = 23, N71 = 71)
      INTEGER    NTEXT
      PARAMETER (NTEXT = 18)
      INTEGER    I, J, NCOL, NROW
      INTEGER    KVAL_11, NKLCFG
      INTEGER    ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      DOUBLE PRECISION A, B, C, D, E, F, G, H, RTOL, TEMP, X02AME$, Z
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    FIRST
      LOGICAL    SUPPLY_XY
      PARAMETER (SUPPLY_XY = .FALSE.)
      EXTERNAL   CHKFIL, PUTMES, ISITSF, NKLCFG
      EXTERNAL   PUTFAT$, X02AME$, OFILES$
      EXTERNAL   GKSF2B$, GKSSAV$
      INTRINSIC  ABS, NINT
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
C
C Initialise then check ISEND
C
      NPTS = N0
      NCOL = N0
      NROW = N0
      RTOL = 1.0D+09*X02AME$()
      ABORT = .TRUE.
      IF (ISEND.LT.N1 .OR. ISEND.GT.N2) THEN
         CALL PUTFAT$('ISEND error in PFILE1$')
         RETURN
      ENDIF
      IF (ISEND.EQ.N1) THEN
C
C First time so attempt to open files (ISEND = 1) unless NFILES = 0
C If NFILES = 0 LIBFIL has not opened a library file but has the filename
C If the file is wrong first time FNAME = BLANK in GKSGRF to try again
C
         CLOSE (UNIT = NIN)
         IF (NFILES.GT.N0 .OR. FNAME.EQ.BLANK .OR. BAR_CHART) THEN
            CALL OFILES$(N3, NIN, 
     +                   FNAME,
     +                   ABORT)
            IF (ABORT) THEN
               FNAME = BLANK
            ELSE
               CLOSE (UNIT = NIN)
               CALL ISITSF (NCMID, NRMID,
     +                      FNAME)
               IF (NCMID.GT.N0 .AND. NRMID.GT.N0) THEN
                  OPEN (UNIT = NIN, FILE = FNAME)
               ELSE
                  ABORT = .TRUE.
                  FNAME = BLANK   
               ENDIF
            ENDIF               
         ELSE
            CLOSE (UNIT = NIN)
            CALL ISITSF (NCMID, NRMID,
     +                   FNAME)           
            IF (NCMID.GT.N0 .AND. NRMID.GT.N0) THEN
               ABORT = .FALSE.
               OPEN (UNIT = NIN, FILE = FNAME)
            ELSE
               ABORT = .TRUE.
               FNAME = BLANK   
            ENDIF        
         ENDIF
         IF (FNAME.EQ.BLANK) ABORT = .TRUE.
         IF (ABORT) THEN
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF
C
C There is now a valid file so try to read it
C
         ABORT = .TRUE.
         IF (BAR_CHART) THEN
            NCBOT = N9
            NCTOP = N9
         ELSE
            NCBOT = N2
            NCTOP = N4
         ENDIF
         NCMID = - N1
         NRBOT = N1
         NRMID = - N1
         NRTOP = NMAX
         ICOUNT = N1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 20
         ICOUNT = N2
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         IF (IOS.NE.0) GOTO 20
         NCMID = J
         NRMID = I
         NCOL = J
         NROW = I
         IF (NCOL.LT.N1 .OR. NROW.LT.N1) GOTO 20
         IF (NROW.GT.NMAX) THEN
            NMAX = NROW
            CALL GKSSAV$(N2, NMAX,
     +                   ABORT)
            IF (ABORT) GOTO 20
         ENDIF                       
         IF (NFILES .EQ.N0 .AND. BAR_CHART) THEN
C
C Create a barchart file from a matrix file which defines NGROUP, etc.
C
            CLOSE (UNIT = NIN)
            IF (FIRST) THEN
               KVAL_11 = NKLCFG(N23)
               IF (KVAL_11.EQ.N1) THEN
                  FIRST = .FALSE.
                  WRITE (TEXT,100)
                  CALL PUTMES (NTEXT, TEXT)
               ENDIF   
            ENDIF
            CALL GKSF2B$(NGROUP, NIN, FNAME, ABORT, SUPPLY_XY)
            IF (ABORT) GOTO 20
            OPEN (UNIT = NIN, FILE = FNAME)
            ICOUNT = N1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
            IF (IOS.NE.0) GOTO 20
            ICOUNT = N2
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
            IF (IOS.NE.0) GOTO 20
            NCMID = J
            NRMID = I
            NCOL = J
            NROW = I
         ENDIF
         IF (NCOL.LT.N2 .OR. NCOL.EQ.N5 .OR.
     +       NCOL.EQ.N7 .OR. NCOL.EQ.N8 .OR. NCOL.GT.N9) THEN
             GOTO 20
         ENDIF
         IF (NCOL.EQ.N9) THEN
            IF (.NOT.BAR_CHART .AND. .NOT.VECTOR_FIELD) GOTO 20
         ENDIF   
         IF (NCOL.EQ.2 .OR. NCOL.EQ.3) THEN
            NTYPE = N1
            DO I = N1, NROW
               ICOUNT = ICOUNT + N1
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B
               IF (IOS.NE.0) GOTO 20
               NPTS = NPTS + N1
               X(NPTS) = A
               Y(NPTS) = B
               IF (ABS(A).GT.RTOL) THEN
                  TEMP = B/A
                  IF (TEMP.GT.YMAX3) YMAX3 = TEMP
                  IF (TEMP.LT.YMIN3) YMIN3 = TEMP
               ENDIF
               IF (ABS(B).GT.RTOL) THEN
                  TEMP = A/B
                  IF (TEMP.GT.YMAX4) YMAX4 = TEMP
                  IF (TEMP.LT.YMIN4) YMIN4 = TEMP
               ENDIF
            ENDDO
         ELSEIF (NCOL.EQ.N4) THEN
            NTYPE = N2
            DO I = N1, NROW
               ICOUNT = ICOUNT + N1
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B, C, D
               IF (IOS.NE.0) GOTO 20
               IF (VECTOR_FIELD) THEN
C
C Do not check A, B, C, D if a vector field type file is expected
C
                  IOS = 0!to silence ftn95...originally CONTINUE
               ELSE
                  IF (B.GT.C .OR. C.GT.D) GOTO 20
               ENDIF
               NPTS = NPTS + N1
               X(NPTS) = A
               XH(NPTS) = A
               XL(NPTS) = A
               YL(NPTS) = B
               Y(NPTS) = C
               YH(NPTS) = D
               IF (ABS(A).GT.RTOL) THEN
                  TEMP = B/A
                  IF (TEMP.LT.YMIN3) YMIN3 = TEMP
                  TEMP = D/A
                  IF (TEMP.GT.YMAX3) YMAX3 = TEMP
               ENDIF
               IF (ABS(B).GT.RTOL) THEN
                  TEMP = A/B
                  IF (TEMP.GT.YMAX4) YMAX4 = TEMP
               ENDIF
               IF (ABS(D).GT.RTOL) THEN
                  TEMP = A/D
                  IF (TEMP.LT.YMIN4) YMIN4 = TEMP
               ENDIF
            ENDDO
         ELSEIF (NCOL.EQ.N6) THEN
            NTYPE = N6
            DO I = N1, NROW
               ICOUNT = ICOUNT + N1
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) G, A, H, B, C, D
               IF (IOS.NE.0) GOTO 20
               NPTS = NPTS + N1
               X(NPTS) = A
               XH(NPTS) = H
               XL(NPTS) = G
               YL(NPTS) = B
               Y(NPTS) = C
               YH(NPTS) = D
               IF (ABS(A).GT.RTOL) THEN
                  TEMP = B/A
                  IF (TEMP.LT.YMIN3) YMIN3 = TEMP
                  TEMP = D/A
                  IF (TEMP.GT.YMAX3) YMAX3 = TEMP
               ENDIF
               IF (ABS(B).GT.RTOL) THEN
                  TEMP = A/B
                  IF (TEMP.GT.YMAX4) YMAX4 = TEMP
               ENDIF
               IF (ABS(D).GT.RTOL) THEN
                  TEMP = A/D
                  IF (TEMP.LT.YMIN4) YMIN4 = TEMP
               ENDIF
            ENDDO
         ELSEIF (NCOL.EQ.N9) THEN
            NTYPE = N3
            DO I = N1, NROW
               ICOUNT = ICOUNT + N1
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B, C, D, E, F,
     +                                               G, H, Z
               IF (IOS.NE.N0) GOTO 20
               IF (BAR_CHART .AND. I.GT.N1) THEN
                  IF (A.LT.X(I - N1)) THEN
                     CALL PUTFAT$(
     +              'X must be in non-decreasing order for a bar chart')
                     GOTO 20
                  ENDIF
               ENDIF
               NPTS = NPTS + N1
               X(NPTS) = A
               XL(NPTS) = B
               XH(NPTS) = C
               YL(NPTS) = D
               Y(NPTS) = E
               YH(NPTS) = F
               IFILL(NPTS) = NINT(G)
               FACTOR(NPTS) = H
               IHUE(NPTS) = NINT(Z)
C
C Check that bar-chart parameters make sense
C               
               IF (BAR_CHART) THEN
                  IF (IFILL(NPTS).LT.N0 .OR. IFILL(NPTS).GT.N10)
     +                IFILL(NPTS) = N1
               ELSEIF (VECTOR_FIELD) THEN 
                  IF (IFILL(NPTS).LT.N0 .OR.
     +               (IFILL(NPTS).GT.N8 .AND. IFILL(NPTS).LT.N16) .OR.
     +                IFILL(NPTS).GT.N21) IFILL(NPTS) = N1
               ENDIF
               IF (FACTOR(NPTS).LT.ZERO .OR. FACTOR(NPTS).GT.ONE)
     +             FACTOR(NPTS) = ONE
               IF (IHUE(NPTS).LT.N0 .OR. IHUE(NPTS).GT.N71)
     +             IHUE(NPTS) = N0
            ENDDO
         ENDIF
      ELSE
C
C Second time called just read in the data (ISEND = 2)
C
         CALL OFILES$(N4, NIN, FNAME, ABORT)
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.N0) GOTO 20
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) NROW, NCOL
         IF (IOS.NE.N0) GOTO 20
         IF (NCOL.EQ.N2 .OR. NCOL.EQ.N3) THEN
            NTYPE = N1
            DO I = N1, NROW
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B
               IF (IOS.NE.0) RETURN
               NPTS = NPTS + N1
               X(NPTS) = A
               Y(NPTS) = B
               IF (ABS(A).GT.RTOL) THEN
                  TEMP = B/A
                  IF (TEMP.GT.YMAX3) YMAX3 = TEMP
                  IF (TEMP.LT.YMIN3) YMIN3 = TEMP
               ENDIF
               IF (ABS(B).GT.RTOL) THEN
                  TEMP = A/B
                  IF (TEMP.GT.YMAX4) YMAX4 = TEMP
                  IF (TEMP.LT.YMIN4) YMIN4 = TEMP
               ENDIF
            ENDDO
         ELSEIF (NCOL.EQ.N4) THEN
            NTYPE = N2
            DO I = N1, NROW
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B, C, D
               IF (IOS.NE.N0) RETURN
               IF (VECTOR_FIELD) THEN
C
C Do not check A, B, C, D if a vector field type file is expected
C
                  IOS = N0!to silence ftn95...was originally CONTINUE
               ELSE
                  IF (B.GT.C .OR. C.GT.D) RETURN
               ENDIF
               NPTS = NPTS + N1
               X(NPTS) = A
               XH(NPTS) = A
               XL(NPTS) = A
               YL(NPTS) = B
               Y(NPTS) = C
               YH(NPTS) = D
            ENDDO
         ELSEIF (NCOL.EQ.N6) THEN
            NTYPE = N6
            DO I = N1, NROW
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) G, A, H, B, C, D
               IF (IOS.NE.N0) RETURN
               NPTS = NPTS + N1
               X(NPTS) = A
               XH(NPTS) = H
               XL(NPTS) = G
               YL(NPTS) = B
               Y(NPTS) = C
               YH(NPTS) = D
            ENDDO
         ELSEIF (NCOL.EQ.N9) THEN
            NTYPE = N3
            DO I = N1, NROW
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B, C, D, E, F,
     +                                               G, H, Z
               IF (IOS.NE.N0) RETURN
               NPTS = NPTS + N1
               X(NPTS) = A
               XL(NPTS) = B
               XH(NPTS) = C
               YL(NPTS) = D
               Y(NPTS) = E
               YH(NPTS) = F
C
C This code was turned off 6/4/99 to allow cfg files to re-set the
C colours, fill styles, etc.
C This time round DO NOT ignore G, H, Z but remember to re-set the
C colour elsewhere if IHUE = LCTEMP = 15 and re-set extreme values
C 14/09/2006 code re-instated for biplots 
C                                      
C              IF (VECTOR_FIELD) THEN 
C                  IFILL(NPTS) = NINT(G)
C                  FACTOR(NPTS) = H
C                  IHUE(NPTS) = NINT(Z)
C               ENDIF
C
C Check that bar-chart parameters make sense
C                                          
               IF (BAR_CHART) THEN
                  IF (IFILL(NPTS).LT.N0 .OR. IFILL(NPTS).GT.N10)
     +                IFILL(NPTS) = N1
               ELSEIF (VECTOR_FIELD) THEN  
                 IF (IFILL(NPTS).LT.N0 .OR.
     +               (IFILL(NPTS).GT.N8 .AND. IFILL(NPTS).LT.N16) .OR.
     +                IFILL(NPTS).GT.N21) IFILL(NPTS) = N1               
               ENDIF
               IF (FACTOR(NPTS).LT.ZERO .OR. FACTOR(NPTS).GT.ONE)
     +             FACTOR(NPTS) = ONE
               IF (IHUE(NPTS).LT.N0 .OR. IHUE(NPTS).GT. N71)
     +             IHUE(NPTS) = N0
            ENDDO
         ENDIF
      ENDIF
      CLOSE (UNIT = NIN)
      ABORT = .FALSE.
      RETURN
C
C LABEL 20: Here only if a crash has occurred
C =========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      IF (ISEND.EQ.N1) THEN
         IF (NROW.GT.NMAX) THEN
            WRITE (LINE,200) NROW, NMAX
            CALL PUTFAT$(LINE)
         ELSEIF (NCOL.EQ.N9 .AND. NROW.GT.NWORDS) THEN
            WRITE (LINE,200) NROW, NWORDS
            CALL PUTFAT$(LINE)   
         ENDIF   
         CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +                NRTOP,
     +                FNAME, TITLE)
      ENDIF 
C
C Format statement
C      
  100 FORMAT (
     + 'First time message: bar chart labels and groups'
     +/
     +/'Advanced bar chart files have m*n rows and m*n labels so that'
     +/'every bar can have an individual label. However, you may want'
     +/'a chart where the bars form m separate n-groups and you only'
     +/'require one label per group of n. So each time you read in such'
     +/'a file you are asked to specify the number of bars per group'
     +/'(that is n) to position the m labels required correctly.'
     +/
     +/'For instance, if you have a file with fifteen bars but you want'
     +/'five groups of three, then you would add five labels to the end'
     +/'of the file and then ten dummy labels. The first five labels'
     +/'would then be used at the centres of the five groups of three'
     +/'bars and the ten dummy labels would be ignored. This is done'
     +/'automatically if you create a bar chart file from a matrix.'
     +/
     +/'You can change the number of bars per group interactively by'
     +/'selecting the [Labels] button then the X-axis menu item.')
  200 FORMAT ('No. of items requested =',i6,1x,'Maxmimum allowed = ',I6) 
      END
C
C
