C
C
      SUBROUTINE PFILES$(IFILL, IHUE, L, M,
     +                   NFILES, NGRAFS, NGROUP, NIN, NMAX, NPTS,
     +                   NSAV, NTYPE, NTYPE1, NTYPE2, NTYPE3,
     +                   NWORDS, NXTRA, NY, NZ,
     +                   FACTOR,
     +                   XMAX, XMIN, YMAX,
     +                   YMAX3, YMAX4, YMIN, YMIN3, YMIN4, ZMAX, ZMIN,
     +                   FNAME, FSAV, LABELS, TITLE, TSAV,
     +                   ABORT, BARCAP, BAR_CHART, LOWER, TWO_PLOTS,
     +                   UPPER, VECTOR_FIELD, YAXIS, YES)

      USE MODULE_SAVEGKS, ONLY : X, XH, XL, Y, YH, YL 
C
C ACTION : input plotting files
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 7/6/95
C          28/11/1997 win32 version
C          04/02/1998 Added NFILES in argument list to GKSFIL to switch off
C                     OFILES 1st time after LIBFIL has failed
C          09/03/1998 Added VECTOR_FIELD
C          09/12/1998 Added NGROUP
C          13/12/1998 removed KLINES, NUMSET, NMARK from argument list
C          29/11/2001 added VU2CHK and TRIM80  
C          20/04/2007 added INTENTS
C          01/01/2008 added NXTRA
C          29/01/2008 added MODULE_SAVEGKS and removed X, .., YL from argument list
C                     and also replaced GKSFIL$ by PFILE1$
C          05/10/2020 added call to LHSRHS for use in two plot mode
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER,             INTENT (IN)    :: NGRAFS, NIN, NWORDS, NXTRA 
      INTEGER,             INTENT (INOUT) :: NMAX
      INTEGER,             INTENT (INOUT) :: IFILL(NXTRA),
     +                                       IHUE(NXTRA), L(NGRAFS),
     +                                       M(NGRAFS), NFILES,
     +                                       NGROUP, NPTS, NSAV(NGRAFS),
     +                                       NTYPE, NTYPE1, NTYPE2,
     +                                       NTYPE3, NY, NZ
      DOUBLE PRECISION,    INTENT (INOUT) :: FACTOR(NXTRA)
      DOUBLE PRECISION,    INTENT (INOUT) :: XMAX, XMIN, 
     +                                       YMAX, YMAX3, YMAX4,
     +                                       YMIN, YMIN3, YMIN4, ZMAX,
     +                                       ZMIN
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, FSAV(NGRAFS), 
     +                                       LABELS(NWORDS), TITLE,
     +                                       TSAV(NGRAFS)
      LOGICAL,             INTENT (IN)    :: BAR_CHART, TWO_PLOTS,
     +                                       VECTOR_FIELD    
      LOGICAL,             INTENT (INOUT) :: BARCAP(NGRAFS),
     +                                       LOWER(NGRAFS),
     +                                       UPPER(NGRAFS),
     +                                       YAXIS(NGRAFS), YES
      LOGICAL ,            INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMCOL = 0,
     +           NUMROW = 0)
      INTEGER    K0, K1, K9
      PARAMETER (K0 = 0, K1 = 1, K9 = 9)
      INTEGER    I, IADD1, ISEND
      CHARACTER  BLANK*1, HEADER(6)*100, LINE*100, TEXT(30)*100,
     +           TRIM80*80
      PARAMETER (BLANK = ' ')
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FIRSTY, FIRSTZ
      EXTERNAL   PUTBEL$, MAXMIN$, PFILE1$, PUTFAT$
      EXTERNAL   YESNO1, YESNO2, TRIM80, GETWRD
      EXTERNAL   LHSRHS 
      ISEND = 1
      CLOSE (UNIT = NIN)
      CALL PFILE1$(IFILL, IHUE, ISEND, NFILES, NGROUP, NIN, NMAX, NPTS,
     +             NTYPE, NWORDS, NXTRA,
     +             FACTOR, 
     +             YMAX3, YMAX4, YMIN3, YMIN4, 
     +             FNAME, TITLE,
     +             ABORT, BAR_CHART, VECTOR_FIELD)
      CLOSE (UNIT = NIN)
      IF (FNAME.EQ.BLANK) ABORT = .TRUE.
      IF (ABORT) GOTO 20
C
C Check if files are consistent if BAR_CHART
C
      IF (BAR_CHART) THEN
         IF (NFILES.EQ.0. AND. NTYPE.NE.3) THEN
            CALL PUTFAT$('The first file must be a bar chart type file')
            GOTO 20
         ENDIF
         IF (NFILES.GT.0 .AND. NTYPE.EQ.3) THEN
            CALL PUTFAT$('Only the first file can be a bar chart file')
            GOTO 20
         ENDIF
      ENDIF
      IF (NFILES.GT.0) THEN
         IADD1 = 0
         DO I = 1, NFILES
            IF (IADD1.EQ.0 .AND. FNAME.EQ.FSAV(I)) THEN
               IADD1 = IADD1 + 1
               ABORT = .FALSE.
               CALL PUTBEL$
               CALL YESNO2 (ICOLOR, IXL, IYL,
     +'WARNING : File is already accepted ... Use it again ?', ABORT)
               ABORT = .NOT.ABORT
            ENDIF
         ENDDO
      ENDIF
      IF (.NOT.ABORT .AND. NPTS.GT.0) THEN
C
C File accepted so set NFILES and default line and marker types .......
C
         NFILES = NFILES + 1
         YAXIS(NFILES) = .TRUE.
         IF (TWO_PLOTS) THEN
            CALL LHSRHS (FNAME,
     +                   YAXIS(NFILES))
         ENDIF
         FIRSTY = .FALSE.
         FIRSTZ = .FALSE.
         IF (YAXIS(NFILES)) THEN
            NY = NY + 1
            IF (NY.EQ.1) FIRSTY = .TRUE.
         ELSE
            NZ = NZ + 1
            IF (NZ.EQ.1) FIRSTZ = .TRUE.
         ENDIF
         IF (NTYPE.EQ.1) THEN
            NTYPE1 = NTYPE1 + 1
            IF (NPTS.GE.60) THEN
               M(NFILES) = 0
            ELSE
               L(NFILES) = 0
            ENDIF
            BARCAP(NFILES) = .FALSE.
            LOWER(NFILES) = .FALSE.
            UPPER(NFILES) = .FALSE.
         ELSEIF (NTYPE.EQ.2 .OR. NTYPE.EQ.6) THEN
            NTYPE2 = NTYPE2 + 1
            L(NFILES) = 0
            BARCAP(NFILES) = .TRUE.
            LOWER(NFILES) = .TRUE.
            UPPER(NFILES) = .TRUE.
         ELSEIF (NTYPE.EQ.3) THEN
            NTYPE3 = NTYPE3 + 1
            M(NFILES) = 0
            BARCAP(NFILES) = .FALSE.
            LOWER(NFILES) = .FALSE.
            UPPER(NFILES) = .FALSE.
         ENDIF
         NSAV(NFILES) = NTYPE
         FSAV(NFILES) = FNAME
         TSAV(NFILES) = TITLE
C
C Find the minimum and maximum of the current X and Y Values ..........
C
         IF (NFILES.EQ.1) THEN
            IF (.NOT.BAR_CHART) CALL MAXMIN$(K0, NPTS,
     +                                       X, XMAX, XMIN)
         ELSE
            IF (.NOT.BAR_CHART) CALL MAXMIN$(K1, NPTS,
     +                                       X, XMAX, XMIN)
         ENDIF
         IF (FIRSTY) THEN
            CALL MAXMIN$(K0, NPTS,
     +                   Y, YMAX, YMIN)
         ELSEIF (FIRSTZ) THEN
            CALL MAXMIN$(K0, NPTS,
     +                   Y, ZMAX, ZMIN)
         ELSEIF (YAXIS(NFILES)) THEN
            CALL MAXMIN$(K1, NPTS, 
     +                   Y, YMAX, YMIN)
         ELSE
            CALL MAXMIN$(K1, NPTS,
     +                   Y, ZMAX, ZMIN)
         ENDIF
         IF (NTYPE.EQ.2) THEN
            IF (VECTOR_FIELD) THEN
               CALL MAXMIN$(K1, NPTS,
     +                      YL, XMAX, XMIN)
               CALL MAXMIN$(K1, NPTS,
     +                      YH, YMAX, YMIN)
            ELSE
               IF (.NOT.BAR_CHART) CALL MAXMIN$(K1, NPTS,
     +                                          XH, XMAX, XMIN)
               IF (.NOT.BAR_CHART) CALL MAXMIN$(K1, NPTS,
     +                                          XL, XMAX, XMIN)
               IF (YAXIS(NFILES)) THEN
                  CALL MAXMIN$(K1, NPTS,
     +                         YH, YMAX, YMIN)
                  CALL MAXMIN$(K1, NPTS,
     +                         YL, YMAX, YMIN)
               ELSE
                  CALL MAXMIN$(K1, NPTS, 
     +                         YH, ZMAX, ZMIN)
                  CALL MAXMIN$(K1, NPTS,
     +                         YL, ZMAX, ZMIN)
               ENDIF
            ENDIF
         ELSEIF (NTYPE.EQ.3) THEN
            CALL MAXMIN$(K1, NPTS,
     +                   XH, YMAX, YMIN)
            CALL MAXMIN$(K1, NPTS,
     +                   XL, YMAX, YMIN)
            CALL MAXMIN$(K1, NPTS,
     +                   YH, YMAX, YMIN)
            CALL MAXMIN$(K1, NPTS, 
     +                   YL, YMAX, YMIN)
         ENDIF
      ENDIF
C
C Read labels if BAR_CHART
C
      IF (NFILES.EQ.1 .AND. BAR_CHART .AND. NTYPE.EQ.3) 
     +    CALL GETWRD (K1, K9, NIN, NPTS, NWORDS,
     +                 FNAME, LABELS)         
   20 CONTINUE
      IF (NFILES.EQ.0) THEN
         NTEXT = 0
         CONTINUE
      ELSE
         IF (NFILES.LE.12) THEN
            WRITE (LINE,100) 'Files currently available for plotting:'
            NTEXT = 1
            TEXT(NTEXT) = LINE
            DO I = 1, NFILES
               NTEXT = NTEXT + 1
               LINE = TRIM80(FSAV(I))
               TEXT(NTEXT) = LINE
            ENDDO
         ELSE
            WRITE (LINE,100)
     +         'Last 12 of files currently available for plotting:'
            NTEXT = 1
            TEXT(NTEXT) = LINE
            DO I = NFILES - 11, NFILES
               NTEXT = NTEXT + 1
               LINE = TRIM80(FSAV(I))
               TEXT(NTEXT) = LINE
            ENDDO
         ENDIF
      ENDIF
      WRITE (HEADER,200) NFILES, NTYPE1, NTYPE2, NTYPE3
      DO I = 1, 6
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = HEADER(I)
      ENDDO
      WRITE (LINE,300)
      YES = .TRUE.
      CALL YESNO1 (ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT,
     +             LINE, TEXT,
     +             BORDER, FLASH, HIGH, YES)
C
C Format statements
C      
  100 FORMAT (1X,A)
  200 FORMAT (
     + 'Current status of plotting data'
     +/'Total number of current coordinate sets:',I4
     +/'Number of plots with just lines/symbols:',I4
     +/'Number of with lines/symbols/error-bars:',I4
     +/'Number of with barchart-data/error-bars:',I4
     +/)
  300 FORMAT (
     +'Do you want to read in another data file for plotting ?')
      END
C
C

c
      subroutine lhsrhs (fname,
     +                   yaxis)  
c
c action: choose LHS or RHS from a data file intended for a double plot
c author: w.g.bardsley, university of manchester, u.k., 05/10/2020
c      
      implicit none
      character (len = *), intent(in)   :: fname
      logical,             intent (out) :: yaxis  

      integer    ios, nout, numdec, numopt, numsta, numtxt
      parameter (numopt = 2, numsta = 14, numtxt = 15)
      integer    numbld(numtxt)
      character (len = 100) line, text(numtxt)
      external   getnou, ucase1, lstbox
      intrinsic  index
      data       numbld / numtxt*0 /
c
c initialise and see if LHS or RHS is somewhere in the title
c      
      yaxis = .true.
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios) 
      read (nout,'(a)',iostat=ios) line
      close (unit = nout)
      call ucase1 (line) 
      if (index(line,'LHS').gt.0) then
         yaxis = .true.
      elseif (index(line,'RHS').gt.0) then
         yaxis = .false.
      else
c
c LHS or RHS is not in the title so ask the user
c        
         write (text,100)
         numdec = 1
         numbld(1) = 4
         yaxis = .true.
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         if (numdec.eq.2) yaxis = .false.
      endif
c
c format statement
c      
  100 format (
     + 'Plotting using the LHS Y-axis or RHS Z-axis with double plots'
     +/    
     +/'If the expression LHS is included somewhere in the title (i.e.'
     +/'the first line of a data file for plotting) the data will be'   
     +/'plotted using the left hand Y-axis scaling.'
     +/
     +/'If the expression RHS is included somewhere in the title (i.e'    
     +/'the first line of a data file for plotting) the data will be'    
     +/'plotted using the right hand Z-axis scaling.'    
     +/    
     +/'The current data file does not have the cipher LHS or RHS in'    
     +/'the title so you must now decide which data scaling to use.'    
     +/    
     +/'Plot with the scaling factors used for the LHS Y-axis'    
     +/'Plot with the scaling factors used for the RHS Z-axis')    
      end 
c
c            

