C
C PIECHT$
C PIENUT$
C
      SUBROUTINE PIECHT$(ICOLOR, IFILL, K, L, LCTEMP,
     +                   FACTOR, THETA_1, THETA_2, WIDE,
     +                   PANEL, PS, SIDE, THREE_D)
C
C ACTION : Draw a pie chart marker for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 19/7/95
C          14/07/1997 win32 version
C          07/09/2001 added THREE_D and TILT
C          09/01/2003 added YMID and PNT575
C          20/11/2004 added IHUE = 0, i.e. black when IFILL = 2 (solid)
C          22/04/2007 added INTENTS
C
C          ICOLOR = colour
C          IFILL = fill style: 0=none,1=empty,2=full
C          FACTOR = fraction DISPLACED
C          THETA_1 = start angle
C          THETA_2 = end angle
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: ICOLOR, IFILL, K, L, LCTEMP
      DOUBLE PRECISION, INTENT (IN) :: FACTOR, THETA_1, THETA_2, WIDE
      LOGICAL,          INTENT (IN) :: PANEL, PS, SIDE, THREE_D
C
C Locals
C      
      INTEGER    NGRAF, NMAX, N0, N1
      PARAMETER (NGRAF = 50, NMAX = 160, N0 = 0, N1 = 1)
      INTEGER    I, IHUE
      INTEGER    COLOUR_INDEX
      DOUBLE PRECISION X(NGRAF), Y(NGRAF)
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FOUR, SLOPE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00, SLOPE = 1.0D+10)
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN
      PARAMETER (XMAX = 1.0D+00, XMIN = 0.0D+00, YMAX = 1.0D+00,
     +           YMIN = 0.0D+00)
      DOUBLE PRECISION PNT04, PNT25, PNT35, PNT5, PNT575
      PARAMETER (PNT04 = 0.04D+00, PNT25 = 0.25D+00, PNT35 = 0.35D+00,
     +           PNT5 = 0.5D+00, PNT575 = 0.575D+00) 
C Pie chart routines: TILT must be identical in these routines as it is the
C                     amount of tilt to correct the y values in THREE-D mode     
      DOUBLE PRECISION TILT
      PARAMETER (TILT = 0.125D+00)
      DOUBLE PRECISION YTOX
      PARAMETER (YTOX = THREE/FOUR)
      DOUBLE PRECISION ALPHA, BETA, THETA, XDELTA, XMID, XSTART, YDIFF,
     +                 YDELTA, YMID
      DOUBLE PRECISION XADD, YADD
      EXTERNAL   PSPOLY$, PUTFAT$
      EXTERNAL   GSELNT$, GSLN$, GSLWSC$
      EXTERNAL   FILL_POLYGON$, POLYLINE$, STROKE$
      INTRINSIC  COS, SIN, DBLE
C
C Return if IFILL = 0
C
      IF (IFILL.EQ.0) RETURN
C
C Check that ICOLOR, IFILL and FACTOR make sense
C
      IF (ICOLOR.LT.0 .OR. ICOLOR.GT.71) THEN
         CALL PUTFAT$('ICOLOR out of range (0,71) in call to PIECHT')
         RETURN
      ENDIF
      IF (IFILL.LT.0 .OR. IFILL.GT.10) THEN
         CALL PUTFAT$('IFILL out of range (0,10) in call to PIECHT')
         RETURN
      ENDIF
      IF (FACTOR.LT.ZERO .OR. FACTOR.GT.ONE) THEN
         CALL PUTFAT$('Factor out of range (0,1) in call to PIECHT')
         RETURN
      ENDIF
      CALL GSELNT$(K)
      CALL GSLN$(N1)
      CALL GSLWSC$(WIDE)
C
C Convert ICOLOR to integer then define X, Y and IHUE
C
      COLOUR_INDEX = ICOLOR
      IF (IFILL.EQ.2) THEN
         IHUE = N0
      ELSE
         IHUE = COLOUR_INDEX
      ENDIF
C
C Draw the segment
C
      IF (PANEL .AND. SIDE) THEN
         XMID = PNT35
      ELSE
         XMID = PNT5
      ENDIF
      IF (PANEL .AND. .NOT.SIDE) THEN
         YMID = PNT575
      ELSE
         YMID = PNT5
      ENDIF
      IF (FACTOR.GT.ZERO) THEN
         THETA = (THETA_1 + THETA_2)/TWO
         XADD = YTOX*FACTOR*PNT04*COS(THETA)
         YADD = FACTOR*PNT04*SIN(THETA)
         XMID = XMID + XADD
         YMID = YMID + YADD
      ENDIF
      X(1) = XMID
      X(2) = XMID + YTOX*PNT25*COS(THETA_1)
      X(NGRAF - 1) = XMID + YTOX*PNT25*COS(THETA_2)
      X(NGRAF) = XMID
      Y(1) = YMID
      Y(2) = YMID + PNT25*SIN(THETA_1)
      Y(NGRAF - 1) = YMID + PNT25*SIN(THETA_2)
      Y(NGRAF) = YMID
      XDELTA = (THETA_2 - THETA_1)/(DBLE(NGRAF) - THREE)
      XSTART = THETA_1
      DO I = 3, NGRAF - 2
         XSTART = XSTART + XDELTA
         X(I) = XMID + YTOX*PNT25*COS(XSTART)
         Y(I) = YMID + PNT25*SIN(XSTART)
      ENDDO
C
C TILT if THREE_D = .TRUE.
C
      IF (THREE_D) THEN
         DO I = 1, NGRAF
            IF (Y(I).GE.YMID) THEN
               Y(I) = Y(I) - TILT*(Y(I) - YMID)
            ELSE
               Y(I) = Y(I) + TILT*(YMID - Y(I))
            ENDIF
         ENDDO
      ENDIF
      IF (PS) THEN
         IF (IFILL.EQ.2) THEN
            CALL PSPOLY$(COLOUR_INDEX, NGRAF - 1, X, Y, 'pf')
         ELSE
            CALL PSPOLY$(COLOUR_INDEX, NGRAF - 1, X, Y, 'pe')
         ENDIF
         CALL PSPOLY$(IHUE, NGRAF - 1, X, Y, 'pc')
      ELSE
         IF (IFILL.EQ.2) THEN
            CALL FILL_POLYGON$(NGRAF, X, Y, COLOUR_INDEX)
         ELSE
            CALL FILL_POLYGON$(NGRAF, X, Y, LCTEMP)
         ENDIF
         CALL POLYLINE$(NGRAF, X, Y, IHUE)
      ENDIF
      IF (IFILL.GT.2) THEN
         IF (IFILL.GT.7) CALL GSLN$(L)
         CALL GSLWSC$(PNT25)
         XDELTA = (XMAX - XMIN)/DBLE(NMAX)
         YDIFF = YMAX - YMIN
         YDELTA = TWO*YDIFF/DBLE(NMAX)
      ENDIF
      IF (IFILL.EQ.3 .OR. IFILL.EQ.5 .OR. IFILL.GT.7) THEN
         ALPHA = YMIN - THREE*YDIFF
         BETA = YDIFF/(XMAX - XMIN)
         DO I = 1, 6*NMAX
            ALPHA = ALPHA + YDELTA
            CALL STROKE$(COLOUR_INDEX, IFILL, NGRAF,
     +                   ALPHA, BETA, X, Y)
         ENDDO
      ENDIF
      IF (IFILL.EQ.4 .OR. IFILL.EQ.5) THEN
         ALPHA = YMIN - YDIFF
         BETA = YDIFF/(XMIN - XMAX)
         DO I = 1, 6*NMAX
            ALPHA = ALPHA + YDELTA
            CALL STROKE$(COLOUR_INDEX, IFILL, NGRAF,
     +                   ALPHA, BETA, X, Y)
         ENDDO
      ENDIF
      IF (IFILL.EQ.6) THEN
         ALPHA = YMIN - THREE*YDIFF
         BETA = ZERO
         DO I = 1, 6*NMAX
            ALPHA = ALPHA + YTOX*YDELTA
            CALL STROKE$(COLOUR_INDEX, IFILL, NGRAF,
     +                   ALPHA, BETA, X, Y)
         ENDDO
      ENDIF
      IF (IFILL.EQ.7) THEN
         ALPHA = YMIN
         BETA = SLOPE
         DO I = 1, 6*NMAX
            ALPHA = ALPHA - SLOPE/NMAX
            CALL STROKE$(COLOUR_INDEX, IFILL, NGRAF, 
     +                   ALPHA, BETA, X, Y)
         ENDDO
      ENDIF
      IF (IFILL.GT.2) THEN
         IF (IFILL.GT.7) CALL GSLN$(N1)
         CALL GSLWSC$(WIDE)
      ENDIF
      END
C
C
      SUBROUTINE PIENUT$(K, LCTEMP,
     +                   RADIUS, TWOPI, WIDE,
     +                   PANEL, PS, SIDE)
C
C ACTION : Draw a pie chart central disc for a doughnut type plot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          16/03/2014 derived from PIECHT$
C          22/04/2007 added INTENTS
C
C          ICOLOR = colour
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: K, LCTEMP
      DOUBLE PRECISION, INTENT (IN) :: RADIUS, TWOPI, WIDE
      LOGICAL,          INTENT (IN) :: PANEL, PS, SIDE
C
C Locals
C      
      INTEGER    NGRAF, N0, N1
      PARAMETER (NGRAF = 100, N0 = 0, N1 = 1)
      INTEGER    I, IHUE, NTEMP
      INTEGER    COLOUR_INDEX
      DOUBLE PRECISION X(NGRAF), Y(NGRAF)
      DOUBLE PRECISION ZERO, THREE, FOUR
      PARAMETER (ZERO = 0.0D+00, THREE = 3.0D+00, FOUR = 4.0D+00)
      DOUBLE PRECISION PNT25, PNT35, PNT5, PNT575
      PARAMETER (PNT25 = 0.25D+00, PNT35 = 0.35D+00,
     +           PNT5 = 0.5D+00, PNT575 = 0.575D+00) 
      DOUBLE PRECISION FACTOR, THETA_1, THETA_2
      DOUBLE PRECISION YTOX
      PARAMETER (YTOX = THREE/FOUR)
      DOUBLE PRECISION XDELTA, XMID, XSTART, YMID
      EXTERNAL   PSPOLY$
      EXTERNAL   GSELNT$, GSLN$, GSLWSC$
      EXTERNAL   FILL_POLYGON$, POLYLINE$
      INTRINSIC  COS, SIN, DBLE
C
C Initialise
C
      CALL GSELNT$(K)
      CALL GSLN$(N1)
      CALL GSLWSC$(WIDE)
C
C Convert ICOLOR to integer then define X, Y and IHUE
C
      COLOUR_INDEX = LCTEMP
      IHUE = N0
C
C Draw the segment
C
      IF (PANEL .AND. SIDE) THEN
         XMID = PNT35
      ELSE
         XMID = PNT5
      ENDIF
      IF (PANEL .AND. .NOT.SIDE) THEN
         YMID = PNT575
      ELSE
         YMID = PNT5
      ENDIF
      FACTOR = RADIUS
      THETA_1 = ZERO
      THETA_2 = TWOPI 
      X(1) = XMID
      X(2) = XMID + FACTOR*YTOX*PNT25*COS(THETA_1)
      X(NGRAF - 1) = XMID + FACTOR*YTOX*PNT25*COS(THETA_2)
      X(NGRAF) = XMID
      Y(1) = YMID
      Y(2) = YMID + FACTOR*PNT25*SIN(THETA_1)
      Y(NGRAF - 1) = YMID + FACTOR*PNT25*SIN(THETA_2)
      Y(NGRAF) = YMID
      XDELTA = (THETA_2 - THETA_1)/(DBLE(NGRAF) - THREE)
      XSTART = THETA_1
      DO I = 3, NGRAF - 2
         XSTART = XSTART + XDELTA
         X(I) = XMID + FACTOR*YTOX*PNT25*COS(XSTART)
         Y(I) = YMID + FACTOR*PNT25*SIN(XSTART)
      ENDDO
      DO I = 1, NGRAF - 2
         X(I) = X(I + 1)
         Y(I) = Y(I + 1)
      ENDDO 
      NTEMP = NGRAF - 2
      X(NTEMP) = X(1)
      Y(NTEMP) = Y(1)  
      IF (PS) THEN
         CALL PSPOLY$(COLOUR_INDEX, NTEMP, X, Y, 'pf')
         CALL PSPOLY$(IHUE, NTEMP, X, Y, 'pc')
      ELSE
         CALL FILL_POLYGON$(NTEMP, X, Y, COLOUR_INDEX)
         CALL POLYLINE$(NTEMP, X, Y, IHUE)
      ENDIF
      END
C
C