C
C
      SUBROUTINE PIEFIL$(IFILL, IHUE, NIN, NMAX, NPTS,
     +                   FACTOR, X,
     +                   FNAME, LABEL1, TITLE,
     +                   ABORT, SUPPLY_XY)
C
C ACTION : Input/transform files for a PIE CHART
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          Derived from GKSFIL$ 18/7/95
C          06/09/1996 Added CHKFIL
C          14/07/1997 win32 version
C          07/12/1998 Added code to transform a vector file
C          29/01/2001 Re-dimensioned arrays assuming NMAX =< NWORDS
C          28/05/2001 added SUPPLY_XY to accomodate calls from PCPLOT$
C          29/11/2001 added VU2CHK
C          04/06/2002 added FNAME to CHKFIL and suppressed VU2CHK
C          14/10/2004 extensive revision  
C          22/04/2007 added INTENTS
C          28/01/2007 added begin{labels} ... end{labels}
C          02/08/2008 added call to ISITSF
C          01/12/2010 added PANEL in call to LABELS
C          23/04/2010 increased dimension to 20 in call to LABELS 
C          06/07/2011 added WORDX and VECTORS in call to LABELS
C
C          IFILL: (output) segment fill styles 0 =< IFILL(i) =< 10
C           IHUE: (output) segment colours 0 =< IHUE(I) =< 71
C            NIN: (input/unchanged) unconnected unit for file opening
C           NMAX: (input/unchanged) maximum dimension
C           NPTS: (output) number of pie chart segments NPTS =< NMAX
C         FACTOR: (output) segment displacements 0 =< FACTOR(i) =< 1
C              X: (output) segment proportions 0 < X(i) =< 1, sum X(i) = 1
C          FNAME: (input/output) if a vector file is supplied then FNAME is
C                                changed to a temporary file name o/w
C                                FNAME is unchanged
C         LABEL1: (input/output) segment labels. If the file opened has
C                                sufficient labels appended these will be
C                                used o/w the labels in the argument will
C                                be used
C          TITLE: (output) pie chart title
C          ABORT: (output) .true. if failure. If .false. then FNAME
C                          is OK for creating a pie chart
C      SUPPLY_XY: (input/unchanged) .true. if file is supplied
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NMAX
      INTEGER,             INTENT (OUT)   :: IFILL(NMAX), IHUE(NMAX)
      INTEGER,             INTENT (OUT)   :: NPTS
      DOUBLE PRECISION,    INTENT (OUT)   :: FACTOR(NMAX), X(NMAX) 
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, LABEL1(NMAX), TITLE
      LOGICAL,             INTENT (IN)    :: SUPPLY_XY 
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    I, J, K, NCOL, NOUT1, NROW
      INTEGER    N0, N1, N2, N3, N4, N10, N20, N60, N71
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N10 = 10,
     +           N20 = 20, N60 = 60, N71 = 71)
      INTEGER    ICOLOR, NUMHDR
      PARAMETER (ICOLOR = 3, NUMHDR = 13)
      INTEGER    IOS, NUMBLD(NUMHDR)
      INTEGER    ICOUNT, NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      INTEGER    JFILL(N20), JCOLOR(N20)
      DOUBLE PRECISION A, B, C, D, XSUM
      DOUBLE PRECISION EPSI, ONE, ZERO, FTEEN
      PARAMETER (EPSI = 1.0D-10, ONE = 1.0D+00, ZERO = 0.0D+00,
     +           FTEEN = 15.0D+00)
      CHARACTER  HEADER(NUMHDR)*100, LINE*100, TNAME*1024
      CHARACTER  PANEL(N20)*40, TEXT(N20)*40, WORDX(N20)*40,
     +           VECTORS(N60)*40
      CHARACTER  SYMBOL*11
      PARAMETER (SYMBOL = 'a Pie Chart')
      CHARACTER  CHOP80*80, TRIM80*80
      CHARACTER (LEN = 12) FORM12, WORD12_NCOL, WORD12_NROW
      LOGICAL    YES
      EXTERNAL   CHKFIL, ISITSF
      EXTERNAL   OFILES$, PUTFAT$, PUTADV$
      EXTERNAL   ANSWER, GETNOU, GETTMP, CHOP80, TRIM80, GETWRD, LABELS,
     +           FORM12
      INTRINSIC  NINT, DBLE
      DATA       NUMBLD / NUMHDR*0 /
C
C Initialise NPTS and ABORT then open the data file
C
      NPTS = N0
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      IF (SUPPLY_XY) THEN
C
C Open the file supplied
C
         OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
         IF (IOS.EQ.N0) THEN
            ABORT = .FALSE.
         ELSE
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF
      ELSE
C
C Request a file
C
         CALL OFILES$(N3, NIN,
     +                FNAME,
     +                ABORT)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            RETURN
         ELSE
            CALL ISITSF (J, K,
     +                   FNAME)
            IF (J.GT.N0 .AND. K.GT.N0) THEN         
               OPEN (UNIT = NIN, FILE = FNAME)
            ELSE
               ABORT = .TRUE.
               RETURN
            ENDIF
         ENDIF         
      ENDIF
C
C Re-set ABORT = .TRUE., define NOUT1 then check dimensions
C
      ABORT = .TRUE.
      CALL GETNOU (NOUT1)
      NCBOT = N4
      NCTOP = N4
      NCMID = - N1
      NRBOT = N1
      NRTOP = NMAX
      NRMID = - N1
C
C ICOUNT = current line number in case of failure
C
      ICOUNT = N1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
      IF (IOS.NE.N0) GOTO 20
      ICOUNT = N2
      READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      IF (IOS.NE.N0) GOTO 20
      NCMID = J
      NRMID = I
      NCOL = J
      NROW = I
      IF (NROW.LT.N1 .OR. NROW.GT.NMAX) GOTO 20
      IF (NCOL.NE.N1 .AND. NCOL.NE.N4) GOTO 20
C
C Pick up the default labels
C
      CALL LABELS (N1, JCOLOR, JFILL,
     +             TEXT, PANEL, WORDX, VECTORS) 
      IF (NCOL.EQ.N1) THEN
C
C NCOL = 1: Special action if a vector file has been read in, i.e.
C ========= create a temporary pie chart file
C
         NCOL = N4
         CALL GETTMP (I,
     +                TNAME)
         CALL GETNOU (NOUT1)
         OPEN (UNIT = NOUT1, FILE = TNAME)
         WRITE (NOUT1,'(A)') TITLE
         WRITE (NOUT1,'(2I6)') NROW, NCOL
         C = ZERO
         DO I = N1, NROW
            ICOUNT = ICOUNT + N1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A
            IF (IOS.NE.N0) GOTO 20
            IF (I.LE.N20) THEN
               B = DBLE(JFILL(I))
               D = DBLE(JCOLOR(I))
            ELSE
               B = ONE
               D = FTEEN
            ENDIF
            WRITE (NOUT1,'(1P,4E11.3)') A, B, C, D
         ENDDO
C
C Try to read any labels appended to the file (use N1 since now NCOL = 4)
C
         CLOSE (UNIT = NIN)
         CALL GETWRD (N1, N1, NIN, NROW, NMAX,
     +                FNAME, LABEL1)          
         CLOSE (UNIT = NIN) 
         WRITE (NOUT1,'(I6)') NROW + 2
         WRITE (NOUT1,'(A)') 'begin{labels}'
         DO I = N1, NROW
            WRITE (NOUT1,'(A)') LABEL1(I)
         ENDDO
         WRITE (NOUT1,'(A)') 'end{labels}'
C
C Close the units, set FNAME = TNAME, then connect FNAME and wind on to line 2
C
         CLOSE (UNIT = NOUT1)
         FNAME = TNAME
         OPEN (UNIT = NIN, FILE = FNAME)
         ICOUNT = N1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.N0) GOTO 20
         ICOUNT = N2
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) NROW, NCOL
         IF (IOS.NE.N0) GOTO 20
         IF (.NOT.SUPPLY_XY) THEN
            WRITE (LINE,100)
            CALL PUTADV$(LINE)
         ENDIF
      ENDIF
      IF (SUPPLY_XY) THEN
C
C Proceed to analyse the file
C
         YES = .TRUE.
      ELSE
C
C Provide option to quit
C
         WORD12_NCOL = FORM12(NCOL)
         WORD12_NROW = FORM12(NROW)
         WRITE (HEADER,200) TRIM80(FNAME), CHOP80(TITLE),
     +                      WORD12_NROW, WORD12_NCOL, SYMBOL
         WRITE (LINE,300)
         YES = .TRUE.
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(7) = N1
         NUMBLD(12) = N1
         CALL ANSWER (ICOLOR, NUMBLD, NUMHDR,
     +                HEADER, LINE,
     +                YES)
      ENDIF
      IF (.NOT.YES) THEN
         CLOSE (UNIT = NIN)
         CLOSE (UNIT = NOUT1)
         ABORT = .TRUE.
         RETURN
      ENDIF
C
C All is well so resume reading data off the file
C
      ICOUNT = N2
      DO I = N1, NROW
         ICOUNT = ICOUNT + N1
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B, C, D
         IF (IOS.NE.0) GOTO 20
         NPTS = NPTS + N1
         X(NPTS) = A
         IFILL(NPTS) = NINT(B)
         FACTOR(NPTS) = C
         IHUE(NPTS) = NINT(D)
C
C Check that PIE-chart parameters make sense
C
         IF (IFILL(NPTS).LT.N0 .OR. IFILL(NPTS).GT.N10)
     +       IFILL(NPTS) = N1
         IF (FACTOR(NPTS).LT.ZERO .OR. FACTOR(NPTS).GT.ONE)
     +       FACTOR(NPTS) = ONE
         IF (IHUE(NPTS).LT.N0 .OR. IHUE(NPTS).GT.N71)
     +       IHUE(NPTS) = N0
      ENDDO
C
C Now try to read labels off the bottom of the file
C
      CLOSE (UNIT = NIN)
      CALL GETWRD (N1, N4, NIN, NPTS, NMAX,
     +             FNAME, LABEL1)       
C
C Normalise the X-values so the sum = 1 and delete any X =< 0
C
      J = NPTS
      NPTS = N0
      XSUM = ZERO
      DO I = N1, J
         IF (X(I).GT.EPSI) THEN
            NPTS = NPTS + N1
            X(NPTS) = X(I)
            XSUM = XSUM + X(NPTS)
            IFILL(NPTS) = IFILL(I)
            FACTOR(NPTS) = FACTOR(I)
            IHUE(NPTS) = IHUE(I)
            LABEL1(NPTS) = LABEL1(I)
         ENDIF
      ENDDO
      IF (XSUM.LE.EPSI .OR. NPTS.LT.N2) THEN
C
C Pie chart is not possible
C
         CALL PUTFAT$('Insufficient data for a pie chart')
         ABORT = .TRUE.
      ELSE
C
C Pie chart can be created
C
         DO I = N1, NPTS
            X(I) = X(I)/XSUM
         ENDDO
         ABORT = .FALSE.
      ENDIF 
C
C Re-initialise unused variables
C         
      DO I = NPTS + N1, NMAX
         IFILL(I) = N0
         IHUE(I) = N0 
         FACTOR(I) = ZERO
         X(I) = ZERO
      ENDDO   
C
C The file reading was completed so make sure units are closed then return
C
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT1)
      RETURN
C
C LABEL 20: This point will only be reached if a crash has occurred
C =========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT1)
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
C
C Format statements
C               
  100 FORMAT ('A temporary piechart type file has been created')
  200 FORMAT (
     + 'Plotting data as a Piechart'
     +/
     +/'Filename:'
     +/A
     +/
     +/'Title:'
     +/A
     +/
     +/'Number of rows of data =',1X,A
     +/'Number of data columns =',1X,A
     +/
     +/'Seems suitable for',1X,A
     +/)
  300 FORMAT ('Do you want to plot data from this file ?')
      END
C
C
