C
C
      SUBROUTINE PIETLT$(ICOLOR, IFILL, K, L, LCTEMP,
     +                   FACTOR, THETA_1, THETA_2, WIDE,
     +                   PANEL, PS, SIDE)
C
C ACTION : Draw a tilted pie chart marker under-segment for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 19/7/95
C          07/09/2001 derived from PIECHT$
C          09/01/2003 added YMID
C          20/11/2004 added IHUE = outline colour for 3D shaded section 
C          22/04/2007 added INTENTS
C
C          ICOLOR = colour
C          IFILL = fill style: 0=none,1=empty,2=full
C          FACTOR = fraction DISPLACED
C          THETA_1 = start angle
C          THETA_2 = end angle
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: ICOLOR, IFILL, K, L, LCTEMP 
      DOUBLE PRECISION, INTENT (IN) :: FACTOR, THETA_1, THETA_2, WIDE 
      LOGICAL,          INTENT (IN) :: PANEL, PS, SIDE
C
C Locals
C      
      INTEGER    NGRAF, NMAX, N0, N1
      PARAMETER (NGRAF = 50, NMAX = 50, N0 = 0, N1 = 1)
      INTEGER    I, IHUE, J, NTEMP
      INTEGER    COLOUR_INDEX
      INTEGER    ICOL_SAV(NMAX), IFILL_SAV(NMAX), ITYPE_SAV(NMAX),
     +           NPTS_SAV
      DOUBLE PRECISION X(NGRAF), Y(NGRAF)
      DOUBLE PRECISION XTEMP(2*NGRAF), YTEMP(2*NGRAF)
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FOUR
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00)
      DOUBLE PRECISION PNT04, PNT25, PNT35, PNT5, PNT575
      PARAMETER (PNT04 = 0.04D+00, PNT25 = 0.25D+00, PNT35 = 0.35D+00,
     +           PNT5 = 0.5D+00, PNT575 = 0.575D+00) 
C Pie chart routines: TILT must be identical in these routines as it is the
C                     amount of tilt to correct the y values in THREE-D mode     
      DOUBLE PRECISION TILT, YDROP
      PARAMETER (TILT = 0.125D+00, YDROP = 0.06D+00)
      DOUBLE PRECISION PI, PIBY2, PI3O2
      PARAMETER (PI = 3.141592654D+00, PIBY2 = PI/TWO,
     +           PI3O2 = THREE*PI/TWO)
      DOUBLE PRECISION YTOX
      PARAMETER (YTOX = THREE/FOUR)
      DOUBLE PRECISION XDELTA, XMID, XSTART
      DOUBLE PRECISION THETA, T1, T2, XADD, YADD, YMID
      DOUBLE PRECISION FACT_SAV(NMAX), THETA1_SAV(NMAX),
     +                 THETA2_SAV(NMAX), WIDE_SAV(NMAX)
      EXTERNAL   PSPOLY$, PUTFAT$
      EXTERNAL   GSELNT$, GSLN$, GSLWSC$
      EXTERNAL   FILL_POLYGON$, POLYLINE$
      INTRINSIC  COS, SIN
      SAVE       ICOL_SAV, IFILL_SAV, ITYPE_SAV, NPTS_SAV,
     +           FACT_SAV, THETA1_SAV, THETA2_SAV, WIDE_SAV
      IF (L.EQ.0) THEN
C
C Initialise the arrays for saving parameters
C
         NPTS_SAV = 0
         DO I = 1, NMAX
            ICOL_SAV(I) = 0
            IFILL_SAV(I) = 0
            ITYPE_SAV(I) = 0
            FACT_SAV(I) = ZERO
            THETA1_SAV(I) = ZERO
            THETA2_SAV(I) = ZERO
            WIDE_SAV(I) = ZERO
         ENDDO
      ELSEIF (L.EQ.1) THEN
C
C Return if IFILL = 0 or NPTS > NMAX otherwise store
C
         IF (IFILL.EQ.0) RETURN
C
C Check that ICOLOR, IFILL and FACTOR make sense
C
         IF (ICOLOR.LT.0 .OR. ICOLOR.GT.71) THEN
            CALL PUTFAT$('ICOLOR out of range (0,71) in call to PIETLT')
            RETURN
         ENDIF
         IF (IFILL.LT.0 .OR. IFILL.GT.10) THEN
            CALL PUTFAT$('IFILL out of range (0,8) in call to PIETLT')
            RETURN
         ENDIF
         IF (FACTOR.LT.ZERO .OR. FACTOR.GT.ONE) THEN
            CALL PUTFAT$('Factor out of range (0,1) in call to PIETLT')
            RETURN
         ENDIF
C
C Store (this routine is called iteratively with L = 1 to store parameters)
C
         IF (NPTS_SAV.LT.NMAX) THEN
            NPTS_SAV = NPTS_SAV + 1
         ELSE
            RETURN
         ENDIF
         I = NPTS_SAV
         ICOL_SAV(I) = ICOLOR
         IFILL_SAV(I) = IFILL
         FACT_SAV(I) = FACTOR
         THETA1_SAV(I) = THETA_1
         THETA2_SAV(I) = THETA_2
         WIDE_SAV(I) = WIDE
         IF (THETA_1.LE.PIBY2) THEN
            ITYPE_SAV(I) = 10
         ELSEIF (THETA_1.LE.PI) THEN
            ITYPE_SAV(I) = 20
         ELSEIF (THETA_1.LE.PI3O2) THEN
            ITYPE_SAV(I) = 30
         ELSE
            ITYPE_SAV(I) = 40
         ENDIF
         IF (THETA_2.LE.PIBY2) THEN
            ITYPE_SAV(I) = ITYPE_SAV(I) + 1
         ELSEIF (THETA_2.LE.PI) THEN
            ITYPE_SAV(I) = ITYPE_SAV(I) + 2
         ELSEIF (THETA_2.LE.PI3O2) THEN
            ITYPE_SAV(I) = ITYPE_SAV(I) + 3
         ELSE
            ITYPE_SAV(I) = ITYPE_SAV(I) + 4
         ENDIF
      ELSEIF (L.EQ.2) THEN
C
C Draw the facets (stored data are now used)
C
         CALL GSELNT$(K)
         CALL GSLN$(N1)
         IF (PANEL .AND. SIDE) THEN
            XMID = PNT35
         ELSE
            XMID = PNT5
         ENDIF
         IF (PANEL .AND. .NOT.SIDE) THEN
            YMID = PNT575
         ELSE
            YMID = PNT5
         ENDIF
C
C Draw the first rectangle
C
         DO I = NPTS_SAV, 1, -1
            IF (ITYPE_SAV(I).EQ.11 .OR. ITYPE_SAV(I).EQ.12 .OR.
     +          ITYPE_SAV(I).EQ.13 .OR. ITYPE_SAV(I).EQ.14) THEN
               COLOUR_INDEX = ICOL_SAV(I)
               CALL GSLWSC$(WIDE_SAV(I))
               X(1) = XMID
               X(2) = XMID + YTOX*PNT25*COS(THETA1_SAV(I))
               Y(1) = YMID
               Y(2) = YMID + PNT25*SIN(THETA1_SAV(I))
               THETA = (THETA1_SAV(I) + THETA2_SAV(I))/TWO
               XADD = YTOX*FACT_SAV(I)*PNT04*COS(THETA)
               YADD = FACT_SAV(I)*PNT04*SIN(THETA)
               DO J = 1, 2
                  X(J) = XADD + X(J)
                  Y(J) = YADD + Y(J)
               ENDDO
               DO J = 1, 2
                  IF (Y(J).GE.YMID) THEN
                     Y(J) = Y(J) - TILT*(Y(J) - YMID)
                  ELSE
                     Y(J) = Y(J) + TILT*(YMID - Y(J))
                  ENDIF
                  Y(J) = Y(J) - YDROP
               ENDDO
               XTEMP(1) = X(1)
               XTEMP(2) = X(2)
               XTEMP(3) = X(2)
               XTEMP(4) = X(1)
               XTEMP(5) = X(1)
               YTEMP(1) = Y(1)
               YTEMP(2) = Y(2)
               YTEMP(3) = Y(2) + YDROP
               YTEMP(4) = Y(1) + YDROP
               YTEMP(5) = Y(1)
               NTEMP = 5
C
C Define IHUE
C
               IF (IFILL_SAV(I).EQ.2) THEN
                  IHUE = N0
               ELSE
                  IHUE = COLOUR_INDEX
               ENDIF
               IF (PS) THEN
                  CALL PSPOLY$(LCTEMP, NTEMP - 1, XTEMP, YTEMP, 'pf')
                  CALL PSPOLY$(IHUE, NTEMP - 1, XTEMP, YTEMP,
     +                         'pc')
               ELSE
                  CALL FILL_POLYGON$(NTEMP, XTEMP, YTEMP, LCTEMP)
                  CALL POLYLINE$(NTEMP, XTEMP, YTEMP, IHUE)
               ENDIF
            ENDIF
         ENDDO
         DO I = NPTS_SAV, 1, -1
            IF (ITYPE_SAV(I).EQ.44) THEN
               COLOUR_INDEX = ICOL_SAV(I)
               CALL GSLWSC$(WIDE_SAV(I))
               X(1) = XMID
               X(2) = XMID + YTOX*PNT25*COS(THETA1_SAV(I))
               Y(1) = YMID
               Y(2) = YMID + PNT25*SIN(THETA1_SAV(I))
               THETA = (THETA1_SAV(I) + THETA2_SAV(I))/TWO
               XADD = YTOX*FACT_SAV(I)*PNT04*COS(THETA)
               YADD = FACT_SAV(I)*PNT04*SIN(THETA)
               DO J = 1, 2
                  X(J) = XADD + X(J)
                  Y(J) = YADD + Y(J)
               ENDDO
               DO J = 1, 2
                  IF (Y(J).GE.YMID) THEN
                     Y(J) = Y(J) - TILT*(Y(J) - YMID)
                  ELSE
                     Y(J) = Y(J) + TILT*(YMID - Y(J))
                  ENDIF
                  Y(J) = Y(J) - YDROP
               ENDDO
               XTEMP(1) = X(1)
               XTEMP(2) = X(2)
               XTEMP(3) = X(2)
               XTEMP(4) = X(1)
               XTEMP(5) = X(1)
               YTEMP(1) = Y(1)
               YTEMP(2) = Y(2)
               YTEMP(3) = Y(2) + YDROP
               YTEMP(4) = Y(1) + YDROP
               YTEMP(5) = Y(1)
               NTEMP = 5
C
C Define IHUE
C
               IF (IFILL_SAV(I).EQ.2) THEN
                  IHUE = N0
               ELSE
                  IHUE = COLOUR_INDEX
               ENDIF
               IF (PS) THEN
                  CALL PSPOLY$(LCTEMP, NTEMP - 1, XTEMP, YTEMP, 'pf')
                  CALL PSPOLY$(IHUE, NTEMP - 1, XTEMP, YTEMP,
     +                         'pc')
               ELSE
                  CALL FILL_POLYGON$(NTEMP, XTEMP, YTEMP, LCTEMP)
                  CALL POLYLINE$(NTEMP, XTEMP, YTEMP, IHUE)
               ENDIF
            ENDIF
         ENDDO
C
C Draw the second rectangle
C
         DO I = 1, NPTS_SAV
            IF (ITYPE_SAV(I).EQ.12 .OR. ITYPE_SAV(I).EQ.13 .OR.
     +          ITYPE_SAV(I).EQ.22 .OR. ITYPE_SAV(I).EQ.23 .OR.
     +          ITYPE_SAV(I).EQ.33) THEN
               COLOUR_INDEX = ICOL_SAV(I)
               CALL GSLWSC$(WIDE_SAV(I))
               X(NGRAF - 1) = XMID + YTOX*PNT25*COS(THETA2_SAV(I))
               X(NGRAF) = XMID
               Y(NGRAF - 1) = YMID + PNT25*SIN(THETA2_SAV(I))
               Y(NGRAF) = YMID
               THETA = (THETA1_SAV(I) + THETA2_SAV(I))/TWO
               XADD = YTOX*FACT_SAV(I)*PNT04*COS(THETA)
               YADD = FACT_SAV(I)*PNT04*SIN(THETA)
               DO J = NGRAF - 1, NGRAF
                  X(J) = XADD + X(J)
                  Y(J) = YADD + Y(J)
               ENDDO
               DO J = NGRAF - 1, NGRAF
                  IF (Y(J).GE.YMID) THEN
                     Y(J) = Y(J) - TILT*(Y(J) - YMID)
                  ELSE
                     Y(J) = Y(J) + TILT*(YMID - Y(J))
                  ENDIF
                  Y(J) = Y(J) - YDROP
               ENDDO
               XTEMP(1) = X(NGRAF)
               XTEMP(2) = X(NGRAF - 1)
               XTEMP(3) = X(NGRAF - 1)
               XTEMP(4) = X(NGRAF)
               XTEMP(5) = X(NGRAF)
               YTEMP(1) = Y(NGRAF)
               YTEMP(2) = Y(NGRAF - 1)
               YTEMP(3) = Y(NGRAF - 1) + YDROP
               YTEMP(4) = Y(NGRAF) + YDROP
               YTEMP(5) = Y(NGRAF)
               NTEMP = 5
C
C Define IHUE
C
               IF (IFILL_SAV(I).EQ.2) THEN
                  IHUE = N0
               ELSE
                  IHUE = COLOUR_INDEX
               ENDIF
               IF (PS) THEN
                  CALL PSPOLY$(LCTEMP, NTEMP - 1, XTEMP, YTEMP, 'pf')
                  CALL PSPOLY$(IHUE, NTEMP - 1, XTEMP, YTEMP,
     +                         'pc')
               ELSE
                  CALL FILL_POLYGON$(NTEMP, XTEMP, YTEMP, LCTEMP)
                  CALL POLYLINE$(NTEMP, XTEMP, YTEMP, IHUE)
               ENDIF
            ENDIF
         ENDDO
         DO I = 1, NPTS_SAV
            IF (ITYPE_SAV(I).EQ.13 .OR. ITYPE_SAV(I).EQ.14 .OR.
     +          ITYPE_SAV(I).EQ.23 .OR. ITYPE_SAV(I).EQ.24 .OR.
     +          ITYPE_SAV(I).EQ.33 .OR. ITYPE_SAV(I).EQ.34 .OR.
     +          ITYPE_SAV(I).EQ.44) THEN
C
C Draw the front facets
C
               COLOUR_INDEX = ICOL_SAV(I)
               CALL GSLWSC$(WIDE_SAV(I))
               T2 = THETA2_SAV(I)
               IF (ITYPE_SAV(I).EQ.13 .OR. ITYPE_SAV(I).EQ.14 .OR.
     +             ITYPE_SAV(I).EQ.23 .OR. ITYPE_SAV(I).EQ.24) THEN
                   T1 = PI
               ELSE
                   T1 = THETA1_SAV(I)
               ENDIF
               X(1) = XMID
               X(2) = XMID + YTOX*PNT25*COS(T1)
               X(NGRAF - 1) = XMID + YTOX*PNT25*COS(T2)
               X(NGRAF) = XMID
               Y(1) = YMID
               Y(2) = YMID + PNT25*SIN(T1)
               Y(NGRAF - 1) = YMID + PNT25*SIN(T2)
               Y(NGRAF) = YMID
               XDELTA = (T2 - T1)/(NGRAF - THREE)
               XSTART = T1
               DO J = 3, NGRAF - 2
                  XSTART = XSTART + XDELTA
                  X(J) = XMID + YTOX*PNT25*COS(XSTART)
                  Y(J) = YMID + PNT25*SIN(XSTART)
               ENDDO
               THETA = (THETA1_SAV(I) + THETA2_SAV(I))/TWO
               XADD = YTOX*FACT_SAV(I)*PNT04*COS(THETA)
               YADD = FACT_SAV(I)*PNT04*SIN(THETA)
               DO J = 1, NGRAF
                  X(J) = XADD + X(J)
                  Y(J) = YADD + Y(J)
               ENDDO
               DO J = 1, NGRAF
                  IF (Y(J).GE.YMID) THEN
                     Y(J) = Y(J) - TILT*(Y(J) - YMID)
                  ELSE
                     Y(J) = Y(J) + TILT*(YMID - Y(J))
                  ENDIF
                  Y(J) = Y(J) - YDROP
               ENDDO
               NTEMP = 0
               DO J = 2, NGRAF - 1
                  NTEMP = NTEMP + 1
                  XTEMP(NTEMP) = X(J)
                  YTEMP(NTEMP) = Y(J)
               ENDDO
               DO J = NGRAF - 1, 2, -1
                  NTEMP = NTEMP + 1
                  XTEMP(NTEMP) = X(J)
                  YTEMP(NTEMP) = Y(J) + YDROP
               ENDDO
               NTEMP = NTEMP + 1
               XTEMP(NTEMP) = XTEMP(1)
               YTEMP(NTEMP) = YTEMP(1)
C
C Define IHUE
C
               IF (IFILL_SAV(I).EQ.2) THEN
                  IHUE = N0
               ELSE
                  IHUE = COLOUR_INDEX
               ENDIF
               IF (PS) THEN
                  CALL PSPOLY$(LCTEMP, NTEMP - 1, XTEMP, YTEMP, 'pf')
                  CALL PSPOLY$(IHUE, NTEMP - 1, XTEMP, YTEMP,
     +                         'pc')
               ELSE
                  CALL FILL_POLYGON$(NTEMP, XTEMP, YTEMP, LCTEMP)
                  CALL POLYLINE$(NTEMP, XTEMP, YTEMP, IHUE)
               ENDIF
            ENDIF
         ENDDO
      ENDIF
      END
C
C