C
C
      SUBROUTINE PLABEL$(ICOLOR, KCOLOR, NCFONT, NKCOL, NOUT_PS, NPTS,
     +                   FACTOR, X, XPC, Y_SCALE,
     +                   LABELS, VECTOR,
     +                   HARD_COPY, HPGL, MONO, PANEL, PS, SIDE,
     +                   THREE_D)
C
C
C ACTION : Label for simplot PIECHART
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 21/6/95
C          24/09/1996 Added PLTSTR$ and VECTOR
C          14/07/1997 win32 version
C          07/09/2001 added FACTOR and THREE_D and adjusted label positions
C          09/01/2003 added YMID
C          14/10/2004 added ITYPE, XSIZE, STORE, FSIZES$     
C          22/04/2007 added INTENTS
C
      IMPLICIT   NONE
C
C Argumentst
C
      INTEGER,             INTENT (IN)    :: NKCOL, NPTS
      INTEGER,             INTENT (IN)    :: KCOLOR(NKCOL), NCFONT,
     +                                       NOUT_PS
      INTEGER,             INTENT (INOUT) :: ICOLOR  
      DOUBLE PRECISION,    INTENT (IN)    :: FACTOR(NPTS), X(NPTS), XPC,
     +                                       Y_SCALE
      CHARACTER (LEN = *), INTENT (IN)    :: LABELS(NPTS), VECTOR(NPTS)
      LOGICAL,             INTENT (IN)    :: HARD_COPY, HPGL, MONO,
     +                                       PANEL, PS, SIDE, THREE_D
C
C Locals
C
      INTEGER    I, ITYPE, K0, NFONT
      PARAMETER (ITYPE = 9, K0 = 0)
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, PI, TWOPI, PIBY2, PI3BY2
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00,
     +           PI = 3.14159D+00, TWOPI = TWO*PI, PIBY2 = PI/TWO,
     +           PI3BY2 = THREE*PI/TWO)
      DOUBLE PRECISION SLANT, XADD, XMID, YADD, YMID, XSIZE
      DOUBLE PRECISION PNT03, PNT3, PNT35, PNT5, PNT575, YTOX
      PARAMETER (PNT03 = 0.03D+00, PNT3 = 0.3D+00,
     +           PNT35 = 0.35D+00, PNT5 = 0.5D+00, PNT575 = 0.575D+00,
     +           YTOX = 0.75D+00)
C Pie chart routines: TILT must be identical in these routines as it is the
C                     amount of tilt to correct the y values in THREE-D mode     
      DOUBLE PRECISION TILT
      PARAMETER (TILT = 0.125D+00)
      DOUBLE PRECISION THETA, THETA_1, THETA_2, XBEGIN, YBEGIN
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  LINE*20, TYPE1*2
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   PLTSTR$, WGBFNT$, FSIZES$
      INTRINSIC  SIN, COS
C
C Set up fonts for labels on PIE CHART .................................
C
      CALL FSIZES$(ITYPE,
     +             XSIZE,
     +             STORE)
      IF (PS) THEN
         WRITE (NOUT_PS,100) XSIZE
         WRITE (NOUT_PS,200) XSIZE
      ENDIF
      CALL WGBFNT$(I, NFONT, SLANT)
      IF (PANEL .AND. SIDE) THEN
         XMID = PNT35
      ELSE
         XMID = PNT5
      ENDIF
      IF (PANEL .AND. .NOT.SIDE) THEN
         YMID = PNT575
      ELSE
         YMID = PNT5
      ENDIF
      THETA_1 = ZERO
      DO I = 1, NPTS
         THETA_2 = THETA_1 + X(I)*TWOPI
         THETA = (THETA_1 + THETA_2)/TWO
         IF (LABELS(I).NE.BLANK) THEN
            LINE = LABELS(I)
            IF (THETA.GT.PIBY2 .AND. THETA.LT.PI3BY2) THEN
               TYPE1 = 'tr'
            ELSE
               TYPE1 = 'tl'
            ENDIF
            XADD = YTOX*FACTOR(I)*PNT03*COS(THETA)
            YADD = FACTOR(I)*PNT03*SIN(THETA)
            IF (THETA.GT.PI) YADD = YADD + PNT03*SIN(THETA)
            XBEGIN = XMID + YTOX*PNT3*COS(THETA) + XADD
            YBEGIN = YMID + PNT3*SIN(THETA) + YADD
            IF (THREE_D .AND. YBEGIN.GT.YMID) YBEGIN = YBEGIN -
     +                                        TILT*(YBEGIN - YMID)
            IF (.NOT.MONO) ICOLOR = KCOLOR(3)
            CALL PLTSTR$(ICOLOR, NCFONT, NFONT, K0, NOUT_PS,
     +                   ZERO, XSIZE*XPC, ZERO, XBEGIN, YBEGIN, Y_SCALE,
     +                   BLANK, LINE, VECTOR(I), TYPE1,
     +                   HARD_COPY, HPGL, PS)
         ENDIF
         THETA_1 = THETA_2
      ENDDO
      IF (PS) THEN
         WRITE (NOUT_PS,100) ONE/XSIZE
         WRITE (NOUT_PS,200) ONE/XSIZE
      ENDIF
C
C These format statements must NOT be edited
C      
  100 FORMAT ('/tl-size tl-size',1X,f7.3,1X,'mul def')
  200 FORMAT ('/tr-size tr-size',1X,f7.3,1X,'mul def')
      END
C 
C