c
c
      subroutine plot24   
c                   
c action: plots 1 to 4 data files
c author: w.g.bardsley, university of manchester u.k., 28/04/2024
c         14/05/2024 added isend/jsend to allow rbox04 ganged input with jsend = 2
c         20/05/2024 improved behaviour when adding a file from store.
c     
c Note: this version of plot24 always initialises and does not save any editing 
      
c
c locals
c
      integer isend, jsend, mode, nin, numsta
      parameter (isend = 1, jsend = 2, mode = 2, nin = 3, numsta = 3) 
      integer numdec, numopt, numtxt
      integer l1, l2, l3, l4, m1, m2, m3, m4, n1, n2, n3, n4
      integer i, ifail, k, l, ncol(5), nrow(5)
      integer ncol1, nrow1
      double precision x1(500), x2(500), x3(500), x4(500),
     +                 y1(500), y2(500), y3(500), y4(500) 
      character (len = 1024) files(4), fnamea(8), newfile(4), stub
      character (len = 129 ) opts(6)
      character (len = 129 ) qtitle, text(8), titles(4)
      character (len = 80  ) ptitle
      character (len = 20  ) xtitle, ytitle
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical axes, gsave
      logical useit(4), useit1(4)
      logical abort, repeet
      save x1, x2, x3, x4, y1, y2, y3, y4
      data axes, gsave  / .true., .true. /
      data l1, l2, l3, l4 / 1, 2, 3, 4 /
      data m1, m2, m3, m4 / 5, 8, 11, 14 /
      data n1, n2, n3, n4 / 0, 0, 0, 0 / 
      data ptitle, xtitle, ytitle 
     +/ 'Plotting selected files' , 'X' , 'Y' / 
      external copycp, gks004, listbx, rbox04, viewer, putadv
      external x_demdir, gettmp, deltmp, isitmf
c
c initialise defaults 
c    
  20  CONTINUE  
         CALL X_DEMDIR (L,
     +                  STUB)
         IF (STUB(L:L).NE. '\') THEN
            L = L + 1
            STUB(L:L) = '\'
         ENDIF 
         FNAMEA(1) = STUB(1:L)//'SV_PLOT.TF1'
         FNAMEA(2) = STUB(1:L)//'SV_PLOT.TF2'
         FNAMEA(3) = STUB(1:L)//'SV_PLOT.TF3'
         FNAMEA(4) = STUB(1:L)//'SV_PLOT.TF4'
         FNAMEA(5) = STUB(1:l)//'SV_PLOT.TF5'
         FNAMEA(6) = STUB(1:l)//'SV_PLOT.TF6'
         FNAMEA(7) = STUB(1:l)//'SV_PLOT.TF7'
         FNAMEA(8) = STUB(1:l)//'SV_PLOT.TF8'      
         do k = 1, 4
            useit(k) = .true.
            useit1(k) = .false.
         enddo    
c
c use gettmp to define files(i)
c         
         do i = 1, 4
            close (unit = nin)
            call gettmp (ifail,
     +                   newfile(i))
            open (nin, file = newfile(i))
            write (nin,'(a)') blank 
            close (unit = nin)
            files(i) = newfile(i)
         enddo   
         do i = 1, 4
            if (i.eq.1) then
               call copycp (mode, 
     +                      fnamea(1), files(1),
     +                      abort)
               if (abort) call putadv('Error calling copycp') 
            else
               call copycp (mode, 
     +                      fnamea(i + 4), files(i),
     +                      abort)
               if (abort) call putadv('Error calling copycp') 
            endif
         enddo
         do k = 1, 4
               if (k.eq.1) then
                  open (unit = nin, file = files(k))
                  read (nin, '(a)') titles(k) 
                  read (nin, *) nrow(k), ncol(k)
                  do l = 1, nrow(k)
                     read (nin,*) x1(l), y1(l) 
                  enddo 
                  close (unit = nin)
               elseif (k.eq.2) then
                  open (unit = nin, file = files(k))
                  read (nin, '(a)') titles(k) 
                  read (nin, *) nrow(k), ncol(k)
                  do l = 1, nrow(k)
                     read (nin,*) x2(l), y2(l) 
                  enddo 
                  close (unit = nin)
               elseif (k.eq.3) then
                  open (unit = nin, file = files(k))
                  read (nin, '(a)') titles(k) 
                  read (nin, *) nrow(k), ncol(k)
                  do l = 1, nrow(k)
                     read (nin,*) x3(l), y3(l) 
                  enddo 
                  close (unit = nin)
               else
                  open (unit = nin, file = files(k))
                  read (nin, '(a)') titles(k)
                  read (nin, *) nrow(k), ncol(k)
                  do l = 1, nrow(k)
                  read (nin,*) x4(l), y4(l)
                  enddo
                  close (unit = nin)
               endif 
            enddo
c
c main loop
c
      repeet = .true.
      do while (repeet)
         numopt = 6! exactly 6 lines of text
         numdec = 1! default option for main menu
         write (text,100)
         call listbx (numdec, numopt,
     +                text)
c     
c numdec = numopt: return
c
         if (numdec.eq.6) return
c
c numdec = 1: read the data  
c           
         if (numdec.eq.1) then
c
c open data files and read details and data
c         
            do k = 1, 4
               if (k.eq.1) then
                  open (unit = nin, file = files(k))
                  read (nin, '(a)') titles(k) 
                  read (nin, *) nrow(k), ncol(k)
                  do l = 1, nrow(k)
                     read (nin,*) x1(l), y1(l) 
                  enddo 
                  close (unit = nin)
               elseif (k.eq.2) then
                  open (unit = nin, file = files(k))
                  read (nin, '(a)') titles(k) 
                  read (nin, *) nrow(k), ncol(k)
                  do l = 1, nrow(k)
                     read (nin,*) x2(l), y2(l) 
                  enddo 
                  close (unit = nin)
               elseif (k.eq.3) then
                  open (unit = nin, file = files(k))
                  read (nin, '(a)') titles(k) 
                  read (nin, *) nrow(k), ncol(k)
                  do l = 1, nrow(k)
                     read (nin,*) x3(l), y3(l) 
                  enddo 
                  close (unit = nin)
               else
                  open (unit = nin, file = files(k))
                  read (nin, '(a)') titles(k)
                  read (nin, *) nrow(k), ncol(k)
                  do l = 1, nrow(k)
                  read (nin,*) x4(l), y4(l)
                  enddo
                  close (unit = nin)
               endif 
            enddo
c
c numdec = 2: select files using rbox04
c                 
         elseif (numdec.eq.2) then
            do k = 1, 4
               opts(k) = titles(k)
            enddo       
            text(1) = 'Select data files to be plotted' 
            text(2) = blank
            do k = 1, 4
               text(k + 2) = opts(k) 
            enddo  
            numopt = 4 ! exactly 4 options 
            numtxt = 6 ! the 4 options (i.e.titles) and 2 header lines
            call rbox04 (isend, numopt, numsta, numtxt,
     +                   useit,
     +                   text)           
            l = 0
            do k = 1, 4         
               if (useit(k)) l = l + 1
            enddo
            if (l.eq.0) useit(1) = .true.
c             
c numdec = 3: view a file 
c    
       elseif (numdec.eq.3) then
            
            do k = 1, 4
               opts(k) = titles(k)
               useit1(k) = .false.
            enddo
            text(1) = 'Select a data file to be viewed'
            text(2) = blank
            do k = 1, 4
               text(k + 2) = opts(k) 
            enddo  
            numopt = 4 ! exactly 4 options 
            numtxt = 6 ! the 4 options (i.e. titles) plus two header lines
            call rbox04 (jsend, numopt, numsta, numtxt,
     +                   useit1,
     +                   text)      
            l = 0 
            do k = 1, 4
               if (useit1(k)) then
                  l = k
                  exit
               endif 
            enddo
            if (l.eq.0) then
               call putadv ('No file has been selected for viewing') 
            else
               i = 1 
               call viewer (isend, 
     +                      files(l), blank, blank)
            endif                          
c
c numdec = 4: input a new file
c            
         elseif (numdec.eq.4) then
            do k = 1, 4
               opts(k) = titles(k)
               useit1(k) = .false.
            enddo 
            text(1) = 'Select a data file to be replaced' 

            text(2) = blank 
            do k = 1, 4
               text(k + 2) = opts(k) 
            enddo   
            numopt = 4 ! exactly 4 options 
            numtxt = 6 ! the 4 options (i.e. titles) plus 2 header lines 
            call rbox04 (jsend, numopt, numsta, numtxt,
     +                   useit1,
     +                   text) 
            l = 0 
            do k = 1, 4
               if (useit1(k)) then
                  l = k
                  exit
               endif 
            enddo
            if  (l.eq.0) then
               call putadv ('No file has been selected for replacement')
            else
               call copycp (isend,
     +                      newfile, files(l),
     +                      abort)
               call isitmf (ncol1, nrow1,
     +                      newfile) 
               if (ncol1.lt.2 .or. ncol1.gt.3 .or. nrow1.lt.2) then
                  call putadv (
     +'Defaults restored: new file is not suitable for plotting')
                  goto 20  
               else              
                  open (nin, file = files(l))
                  read (nin,'(a)') qtitle
                  close (unit = nin) 
                  titles(l) = qtitle
                  if (abort) then
                     call putadv ('Cannot open the input file')
                     goto 20
                  endif                       
               endif
            endif            
         elseif (numdec.eq.5) then
            goto 20 ! replace files and titles by starting defaults
         endif
c
c check that at least one file is accepted before plotting
c         
       
         n1 = 0   
         n2 = 0   
         n3 = 0   
         n4 = 0 
         
         l = 0
         do k = 1, 4  
            if (useit(k)) l = l + 1
         enddo
         if (l.eq.0) useit(1) = .true.           
 
         if (useit(1)) n1 = nrow(1)
         if (useit(2)) n2 = nrow(2)        
         if (useit(3)) n3 = nrow(3)         
         if (useit(4)) n4 = nrow(4)
        
c
c fnally plot the selected files
c           
         if (numdec.eq.1) then    
            call gks004 (l1, l2, l3, l4,
     +                   m1, m2, m3, m4,
     +                   n1, n2, n3, n4,
     +                   x1, x2, x3, x4,
     +                   y1, y2, y3, y4,
     +                   ptitle, xtitle, ytitle,
     +                   axes, gsave)
         endif
         
c end of main do loop
c         
      enddo
c
c delete temporary files
c      
      call deltmp 
c
c format statement
c      
  100 format (
     + 'Plot selected data files',
     +/'Select data files for plotting'
     +/'View a data file'
     +/'Input a new data file'
     +/'Restore default data files'
     +/'Quit ... Exit plotting routine')
      end      
c
c      