C
C
      SUBROUTINE PLTACC$(ICOLOR, IH, IH_END, IV, IV_END, IVERT,
     +                   THETA,
     +                   C, K,
     +                   HPGL)
C
C ACTION : Plot an accent
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/11/96
C          This version uses the character supplied in C
C          06/12/2000 replaced all INTEGER*2 by INTEGER
C          20/03/2007 edited for w_clearwin.dll
C          22/05/2007 added INTENTS
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: IH, IH_END, IV, IV_END,
     +                                       IVERT  
      INTEGER,             INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION,    INTENT (IN)    :: THETA  
      CHARACTER (LEN = 1), INTENT (IN)    :: C, K 
      LOGICAL,             INTENT (IN)    :: HPGL
C
C Locals
C      
      INTEGER    I, IADDY, IWIDEA, IWIDEC, IX, IX_END, IY, IY_END, L
      INTEGER    NXPIX, NYPIX
      INTEGER    COLOUR_LONG, NUMRGB$
      INTEGER    J, HEIGHT, REGIONID, WIDTH
      PARAMETER (NXPIX = 50, NYPIX = 50) 
      INTEGER    CREATE_GRAPHICS_REGION, DELETE_GRAPHICS_REGION
      DOUBLE PRECISION DEGRAD
      PARAMETER (DEGRAD = 3.1415927D+00/180.0D+00)
      DOUBLE PRECISION DELTA, R, PHI, THETA1, X, Y
      DOUBLE PRECISION F90, F180, F270, F360, ONE, TWO
      PARAMETER (F90 = 90.0D+00, F180 = 180.0D+00, F270 = 270.0D+00,
     +           F360 = 360.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      EXTERNAL   NUMRGB$
      EXTERNAL   DRAW_HERSHEY$   
      EXTERNAL   CREATE_GRAPHICS_REGION, DELETE_GRAPHICS_REGION
      INTRINSIC  ABS, SQRT, NINT, ATAN, SIN, COS, ICHAR, DBLE
C
C Find the width of the accent or return if K not in range
C
      IF (K.EQ.'A') THEN
C...grave
         L = 2249
      ELSEIF (K.EQ.'B') THEN
C...acute
         L = 2248
      ELSEIF (K.EQ.'C') THEN
C...circumflex
         L = 2247
      ELSEIF (K.EQ.'D') THEN
C...tilde
         L = 2246
      ELSEIF (K.EQ.'E') THEN
C...macron
         L = 2231
      ELSEIF (K.EQ.'F') THEN
C...dieresis
         L = 239
      ELSEIF (K.EQ.'G') THEN
C...greek-hat
         L = 2247
      ELSEIF (K.EQ.'H') THEN
C...greek-bar
         L = 2231
      ELSEIF (K.EQ.'I') THEN
C...greek-hat
         L = 2247
      ELSEIF (K.EQ.'J') THEN
C...greek-bar
         L = 2231
      ELSE
        RETURN
      ENDIF
C
C Define THETA1
C
      THETA1 = THETA
C
C Create the y-offset
C
      IF (L.EQ.239) THEN
         IADDY = (3*IVERT)/4
      ELSEIF (L.EQ.2231) THEN
         IADDY = (3*IVERT)/4
      ELSEIF (L.EQ.2246) THEN
         IADDY = (3*IVERT)/4
      ELSEIF (L.EQ.2247) THEN
         IADDY = (3*IVERT)/4
      ELSEIF (L.EQ.2248) THEN
         IADDY = IVERT/3
      ELSEIF (L.EQ.2249) THEN
         IADDY = IVERT/3
      ENDIF
      I = ICHAR(C)
      IF (I.GE.97 .AND. I.LE.122) THEN
C
C Lower case letters so handcrafting required
C
         IF (L.EQ.2248 .OR. L.EQ.2249) THEN
C... grave/acute (try 4/5)
            IADDY = (4*IADDY)/5
         ELSEIF (I.EQ.98 .OR. I.EQ.100 .OR. I.EQ.102 .OR. I.EQ. 104 .OR.
     +           I.EQ.107 .OR. I.EQ.108 .OR. I.EQ.116) THEN
C... b, d, f, h, k, l, t (try 4/5)
            IADDY = (4*IADDY)/5
         ELSE
C... the rest (try 9/10 of 2/3)
            IADDY = (9*IADDY)/15
         ENDIF
      ENDIF
C
C Find the width of the accent
C
      J = 1
      REGIONID = J
      WIDTH = 1000
      HEIGHT = 200
      J = CREATE_GRAPHICS_REGION (REGIONID, WIDTH, HEIGHT)
      IX = NXPIX
      IY = NYPIX
      COLOUR_LONG = NUMRGB$(ICOLOR)
      CALL DRAW_HERSHEY$(L, IX, IY, COLOUR_LONG, IX_END, IY_END)
      J = DELETE_GRAPHICS_REGION (REGIONID)
      X = DBLE(IX_END - IX)
      Y = DBLE(IY_END - IY)
      DELTA = SQRT(X**2 + Y**2)
      IWIDEA = NINT(DELTA)
C
C Find the width of the letter
C
      X = DBLE (IH_END - IH)
      Y = DBLE (IV_END - IV)
      DELTA = SQRT(X**2 + Y**2)
      IWIDEC = NINT(DELTA)
      IF (ABS(THETA1 - ONE).LE.ONE .OR. ABS(THETA1 - F360).LE.ONE) THEN
C
C THETA = 0 or 360
C
         IX = IH - (IWIDEA - IWIDEC)/2
         IF (HPGL) THEN
            IY = IV + IADDY
         ELSE
            IY = IV - IADDY
         ENDIF
      ELSEIF (ABS(THETA1 - F90).LE.ONE .OR. ABS(THETA1 + F270).LE.ONE)
     +                                                           THEN
C
C THETA = 90 or - 270
C
         IX = IH - IADDY
         IF (HPGL) THEN
            IY = IV - (IWIDEA - IWIDEC)/2
         ELSE
            IY = IV + (IWIDEA - IWIDEC)/2
         ENDIF
      ELSEIF (ABS(THETA1 + F90).LE.ONE .OR. ABS(THETA1 - F270).LE.ONE)
     +                                                           THEN
C
C THETA = - 90 or 270
C
         IX = IH + IADDY
         IF (HPGL) THEN
            IY = IV + (IWIDEA - IWIDEC)/2
         ELSE
            IY = IV - (IWIDEA - IWIDEC)/2
         ENDIF
      ELSE
C
C THETA is not a multiple of half pi
C
         IF (IWIDEA.EQ.IWIDEC) THEN
            PHI = F90*DEGRAD
         ELSEIF (IWIDEA.GT.IWIDEC) THEN
            X = DBLE(IWIDEA - IWIDEC)/TWO
            Y = DBLE(IADDY)
            PHI = F180*DEGRAD - ATAN(Y/X)
         ELSE
            X = DBLE(IWIDEC - IWIDEA)/TWO
            Y = DBLE(IADDY)
            PHI = ATAN(Y/X)
         ENDIF
         R = SQRT(X**2 + Y**2)
         IX = IH + NINT(R*COS(THETA1*DEGRAD + PHI))
         IF (HPGL) THEN
            IY = IV + NINT(R*SIN(THETA1*DEGRAD + PHI))
         ELSE
            IY = IV - NINT(R*SIN(THETA1*DEGRAD + PHI))
         ENDIF
      ENDIF
      CALL DRAW_HERSHEY$(L, IX, IY, COLOUR_LONG, IX_END, IY_END)
      END
C 
C