C 
C
      SUBROUTINE PLTBAR$(ICOLOR, IFILL, K, LCTEMP, NHATCH, NT,
     +                   SIZE, WIDE, WIDE1,
     +                   XT, XMAX, XMIN, YT, YMAX, YMIN,
     +                   BARCAP, PS, SIDE)
C
C ACTION : Call BARCHT$ as plotting symbol
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 1/10/95
C          20/02/1997 Added BARCAP to argument list
C          14/07/1997 win32 version
C          21/12/1997 Multiplied YSIDE by SIZE
C          08/01/2003 added WIDE1 and NHATCH
C          01/05/2003 corrected SIZE** to SIZE* in definition of YSIDE 
C          19/05/2007 added INTENTS
C          13/11/2016 made ICOLOR and IFILL INTENT (IN)
C          12/08/2019 added plotting as vertical rods if NT > NMAX 
C
      IMPLICIT   NONE 
C
C Arguments
C                                             
      INTEGER,          INTENT (IN)    :: K, LCTEMP, NHATCH, NT 
      INTEGER,          INTENT (IN)    :: ICOLOR, IFILL
      DOUBLE PRECISION, INTENT (IN)    :: WIDE, WIDE1, XT(NT), XMAX,
     +                                    XMIN, YMAX, YMIN, YT(NT)
      DOUBLE PRECISION, INTENT (INOUT) :: SIZE  
      LOGICAL,          INTENT (IN)    :: BARCAP, PS, SIDE
C
C Locals
C      
      INTEGER    I, L 
      INTEGER    N1, NMAX, NPTS
      PARAMETER (N1 = 1, NMAX = 40, NPTS = 20)
      DOUBLE PRECISION DELTA, YSIDE, Y1, Y2, Y3, Y4, Y5
      DOUBLE PRECISION YTOX
      PARAMETER (YTOX = 0.75D+00)
      EXTERNAL   BARCHT$, SOLID_LINE$, GSELNT$, GSLN$
      INTRINSIC  DBLE 
C
C Plot as spikes if NT > NMAX 
C       
      IF (NT.GT.NMAX) THEN
         CALL GSELNT$(K)
         CALL GSLN$(N1)
         DO I = 1, NT
            CALL SOLID_LINE$ (XT(I), YMIN, XT(I), YT(I), ICOLOR)
         ENDDO 
         RETURN
      ENDIF    
C
C Define DELTA and L
C
c      IF (NT.LT.NPTS) THEN	
c         DELTA = SIZE*YTOX*(XMAX - XMIN)/DBLE(NT - 1)
c         YSIDE = 0.5D+00*SIZE*(YMAX - YMIN)/DBLE(NT - 1)
c      ELSE   
         DELTA = SIZE*YTOX*(XMAX - XMIN)/DBLE(NPTS)
         YSIDE = 0.5D+00*SIZE*(YMAX - YMIN)/DBLE(NPTS)
c      ENDIF 
        
      IF (IFILL.LE.7) THEN
         L = 1
      ELSEIF (IFILL.EQ.8) THEN
         L = 2
      ELSEIF (IFILL.EQ.9) THEN
         L = 3
      ELSE
         L = 4
      ENDIF
C
C Main loop to call BARCHT
C
      DO I = 1, NT
         IF (SIDE) THEN
            Y1 = YT(I) - YSIDE
            Y4 = YT(I) + YSIDE
         ELSE
            Y1 = YMIN
            Y4 = YT(I)
         ENDIF
         Y2 = Y1
         Y3 = Y1
         Y5 = Y4
         CALL BARCHT$(ICOLOR, IFILL, K, L, LCTEMP, NHATCH,
     +                DELTA, SIZE, WIDE, WIDE1, XT(I), XMAX, XMIN,
     +                YMAX, YMIN, Y1, Y2, Y3, Y4, Y5,
     +                BARCAP, PS, SIDE)
      ENDDO
      END
C
C