C
C
      SUBROUTINE PLTLAB$(JCOLOR, M, MTRANS, NCFONT, NIN, NMAX, NOUT_PS,
     +                   NWORDS,
     +                   ASYMP, SIZE1, X, XMAX, XMIN, XPC, XT, Y, YMAX,
     +                   YMIN, Y_SCALE, YT,
     +                   FSAV, WORDX, WORDY,
     +                   HARD_COPY, HPGL, MONO, NATLOG, PLOTX, PS,
     +                   VIDEO)
C
C ACTION : Plot text labels instead of markers
C          Derived from LOOP04$ 10/08/2001
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          15/10/2004 added ITYPE, XSIZE, STORE
C          17/07/2005 aded PLOTX and increased NWMAX to 2000 
C          22/08/2006 introduced XMAX1, XMIN1, YMAX1, YMIN1 to expand
C                     plotting area and replaced FACTOR by FACTX and FACTY
C          18/09/2006 edited, changed ITYPE from 5 to 11 and introduced NPTS 
C          22/04/2007 added INTENTS 
C          25/12/2007 added corrections for X_SHIFT, Y_SHIFT, and THETA
C          11/01/2008 made JCOLOR an aray
C          19/08/2010 Made FACTX > FACTY and increased diagonal shift factors  
C
C  JCOLOR: (input/unchanged) font colour
C       M: (input/unchanged) text coordinate shift type 0, 1, or 2
C  MTRANS: (input/unchanged) coordinate transformation number
C  NCFONT: (input/unchanged) font type
C     NIN: (input/unchanged) unconnected unit for data input
C    NMAX: (input/unchanged) dimension of X,Y workspace
C NOUT_PS: (input/unchanged) unit for PostScript output
C  NWORDS: (input/unchanged) dimension for labels
C   ASYMP: (input/unchanged) asymptote for transformation (Hill plot)
C   SIZE1: (input/unchanged) size for text displacement if M > 0
C       X: workspace
C    XMAX: (input/unchanged) upper X-range for plotting
C    XMIN: (input/unchanged) lower X-range for plotting 
C     XPC: (input/unchanged) base-line font size
C      XT: workspace
C       Y: workspace
C    YMAX: (input/unchanged) upper Y-range for plotting
C    YMIN: (input/unchanged) lower Y-range for plotting 
C Y_SCALE: (input/unchanged) Y-scaling factor for aspect ratio
C      YT: workspace
C    FSAV: (input/unchanged) file with coordinates and labels, e.g. 'f$labels.tmp'
C   WORDX: (input/unchanged) labels for plotting
C   WORDY: (input/unchanged) font keys
C   HARD_COPY, HPGL, MONO, NATLOG, PLOTX, PS, VIDEO : (input/unchanged) 
C
      IMPLICIT    NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NMAX, NWORDS
      INTEGER,             INTENT (IN)    :: JCOLOR(NWORDS), M, MTRANS,
     +                                       NCFONT, NIN, NOUT_PS
      DOUBLE PRECISION,    INTENT (IN)    :: ASYMP, SIZE1, XMAX, XMIN,
     +                                       XPC, YMAX, YMIN, Y_SCALE
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX), XT(NMAX), 
     +                                       Y(NMAX), YT(NMAX)
      CHARACTER (LEN = *), INTENT (IN)    :: FSAV, WORDX(NWORDS),
     +                                       WORDY(NWORDS)
      LOGICAL,             INTENT (IN)    :: HARD_COPY, HPGL, MONO,
     +                                       NATLOG(11), PLOTX(NWORDS),
     +                                       PS, VIDEO
C
C Locals
C
      INTEGER    ITYPE, NWMAX
      PARAMETER (ITYPE = 11, NWMAX = 2000)
      INTEGER    K0, K1, K2, K5, K15
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K5 = 5, K15 = 15)
      INTEGER    I, ICOLOR, IOS, NCOL, N, NFONT, NPTS, NT
      DOUBLE PRECISION ANGLE, XSIZE, XTEMP, YTEMP
      DOUBLE PRECISION FACTX, FACTY, XMAX1, XMIN1, YMAX1, YMIN1
      DOUBLE PRECISION T1, T2, T3, T4, T5, XDIFF, YDIFF 
      DOUBLE PRECISION THETA(NWMAX)
      DOUBLE PRECISION ZERO, ONE, PNT05
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PNT05 = 0.05D+00)
      CHARACTER  FNAME*1024, SIM256*1024
      CHARACTER  BLANK*1, TYPE1*4
      PARAMETER (BLANK = ' ', TYPE1 = 'free')
      CHARACTER  TITLE*80
      CHARACTER  STRNG1(NWMAX)*40, VECTOR(NWMAX)*40
      LOGICAL    STORE, THERE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   TRNLAB$, PLTSTR$, WGBFNT$, FSIZES$, SIM256 
      INTRINSIC  MIN 
      T1 = ZERO                     !to silence NAGfor
      T3 = ONE                      !to silence NAGfor
      IF (T1.GT.T3) THERE = .FALSE. !to silence NAGfor
C
C Define XDIFF and YDIFF and NPTS
C       
      XDIFF = XMAX - XMIN
      YDIFF = YMAX - YMIN 
      NPTS = MIN(NMAX,NWORDS,NWMAX)
      IF (XDIFF.LE.ZERO .OR. YDIFF.LE.ZERO .OR. NPTS.LT.1) RETURN
C
C Read in data from data file and make sure it is a plot labels type file
C
      CLOSE (UNIT = NIN)
      OPEN (UNIT = NIN, FILE = FSAV)
      READ (NIN,'(A)',IOSTAT=IOS) TITLE
      IF (IOS.NE.K0 .OR. TITLE(1:22).NE.'%simfitplotlabelsfile%') THEN
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
      READ (NIN,*,IOSTAT=IOS) N, NCOL
      IF (IOS.NE.K0 .OR. N.LT.K1 .OR. NCOL.NE.K2) THEN
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF                  
C
C Adjust N if required then read X and Y from the file
C      
      IF (N.GT.NPTS) N = NPTS
      DO I = K1, N
         READ (NIN,*,IOSTAT=IOS) X(I), Y(I)
         IF (IOS.NE.K0) THEN
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF
      ENDDO
      CLOSE (UNIT = NIN)
C
C Check for shifting and rotating
C      
      DO I = K1, N
         THETA(I) = ZERO
      ENDDO   
      FNAME = SIM256('f$rotate.tmp')
      INQUIRE (FILE = FNAME, EXIST = THERE)
      IF (THERE) THEN
         OPEN (UNIT = NIN, FILE = FNAME)
         READ (NIN,'(A)',IOSTAT=IOS) TITLE
         IF (IOS.EQ.K0 .AND. 
     +       TITLE(1:24).EQ.'%simfitrotatelabelsfile%') THEN
            READ (NIN,*,IOSTAT=IOS) I, NCOL
            IF (IOS.EQ.K0 .AND. I.GE.N .AND. NCOL.EQ.K5) THEN
                DO I = K1, N
                   READ (NIN,*,IOSTAT=IOS) T1, T2, T3, T4, T5
                   IF (IOS.EQ.K0) THEN
                      X(I) = X(I) + T2
                      Y(I) = Y(I) + T4
                      THETA(I) = T5
                   ELSE
                      EXIT
                   ENDIF     
                ENDDO  
             ENDIF
          ENDIF
          CLOSE (UNIT = NIN)
       ENDIF         
C
C Transform the data
C
      CALL TRNLAB$(MTRANS, N, NT, NWMAX, NWORDS,
     +             ASYMP, X, XT, Y, YT,
     +             WORDX, WORDY, STRNG1, VECTOR,
     +             NATLOG, PLOTX)
C
C Plot the labels
C
      IF (NT.GT.K0) THEN
         CALL WGBFNT$(I, NFONT,
     +                ANGLE)
C
C Define FACTOR using empirical scaling factors to offset the label
C
         IF (M.LE.0) THEN
            FACTX = ZERO
            FACTY = ZERO
         ELSEIF (M.EQ.1) THEN
            FACTX = 0.010D+00*SIZE1*XDIFF 
            FACTY = 0.007D+00*SIZE1*YDIFF
         ELSE
            FACTX = 0.020D+00*SIZE1*XDIFF  
            FACTY = 0.015D+00*SIZE1*YDIFF
         ENDIF
C
C Adjust font size
C
         CALL FSIZES$(ITYPE, 
     +                XSIZE,
     +                STORE)
         IF (PS) WRITE (NOUT_PS,100) XSIZE
C
C Draw words as labels
C                        
         XMAX1 = XMAX + PNT05*XDIFF
         XMIN1 = XMIN - PNT05*XDIFF
         YMAX1 = YMAX + PNT05*YDIFF
         YMIN1 = YMIN - PNT05*YDIFF
         DO I = K1, MIN(NT,NWMAX)
            ANGLE = THETA(I)
            XTEMP = XT(I)
            YTEMP = YT(I)
            IF (XTEMP.GE.XMIN1 .AND. XTEMP.LE.XMAX1 .AND.
     +          YTEMP.GE.YMIN1 .AND. YTEMP.LE.YMAX1) THEN
               IF (MONO) THEN
                  IF (VIDEO) THEN
                     ICOLOR = K0
                  ELSE
                     ICOLOR = K15
                  ENDIF
               ELSE
                  ICOLOR = JCOLOR(I)
               ENDIF    
               CALL PLTSTR$(ICOLOR, NCFONT, NFONT, K1, NOUT_PS,
     +                      ANGLE, XSIZE*XPC, ZERO, XTEMP + FACTX,
     +                      YTEMP - FACTY, Y_SCALE,
     +                      BLANK, STRNG1(I), VECTOR(I), TYPE1,
     +                      HARD_COPY, HPGL, PS)
            ENDIF
         ENDDO
         IF (PS) WRITE (NOUT_PS,100) ONE/XSIZE
      ENDIF
C
C this format statement must NOT be edited
C      
  100 FORMAT ('/tl-size tl-size',1X,f7.3,1X,'mul def')
      END
C
C
