C
C
      SUBROUTINE PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +                   ANGLE, SIZE, SLANT, X, Y, Y_SCALE,
     +                   FONT, STRNG, SYMBOL, TYPE1,
     +                   HARD_COPY, HPGL, PS)
C
C ACTION : Plot a text string
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/9/96
C          27/09/1996 Removed NHPGL added SLANT
C          11/11/1996 Added PLTACC$
C          21/05/1997 Added call to GETDEF$ to get C_SCALE
C          21/12/1997 Altered SIZE2 to get scaling closer to Hershey
C          23/01/1998 added call to PSCOLR$
C          05/02/1998 Added checks on ranges in arguments and corrected
C                     false call to PSCOLOR$ that had crept in accidentally
C          24/11/1999 added call to SLASHB$
C          20/12/1999 adjusted IV for under_score, i.e. character 95
C          22/02/2000 added call to WGBCFG$
C          26/10/2000 added call to SAVELW$
C          21/11/2000 added TRUE_TYPE
C          27/11/2002 added %#string escape sequence 
C          21/05/2007 added INTENTS 
C
C          TYPE1 = 'free' then use all arguments o/w use defaults
C          Text handling is the same as with PSWORD$
C
C          ICOLOR  = colour of text
C          IFONT   = screen font
C          NFONT   = number of font for Postscript (if 'free')
C          NGKS    = number of GKS transformation
C          NOUT_PS = unit connected for PostScript
C          ANGLE   = angle of rotation (if 'free')
C          SIZE    = size of letters
C          SLANT = italics parameter
C          X, Y    = coordinates for string
C          Y_SCALE = scaling parameter set in DLL
C          FONT    = specially defined font if outside default range
C          STRNG   = string to plot
C          SYMBOL  = index to accompany STRNG
C          TYPE1   = e.g. 'free', 'tl', etc.
C          HARD_COPY, HPGL, PS = logicals set in DLL .
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NFONT, NGKS, NOUT_PS
      INTEGER,             INTENT (INOUT) :: ICOLOR, IFONT 
      DOUBLE PRECISION,    INTENT (IN)    :: ANGLE, SIZE, SLANT, X, Y,
     +                                       Y_SCALE 
      CHARACTER (LEN = *), INTENT (IN)    :: FONT, STRNG, SYMBOL, TYPE1
      LOGICAL,             INTENT (IN)    :: HARD_COPY, HPGL, PS
C
C Locals
C      
      INTEGER    J, LEN200, LTEMP
      INTEGER    II1, II2, II3, II4
      INTEGER    K4
      PARAMETER (K4 = 4)
      INTEGER    I, IX, IY, JFONT, L, L1, L2
      INTEGER    IH, IH_END, ISUB, ISUPER, IV, IV_END, IVERT, LENGTH
      INTEGER    IADD1, IH1, IH2, IV1, IV2
      INTEGER    IASCII, IHERSH, ITYPE, IADD2X, IADD2Y
      INTEGER    N1, N2, N3, N4
      PARAMETER (N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    COLOUR_LONG, NUMRGB$
      INTEGER    ISEND, NCOLOR
      PARAMETER (ISEND = 4, NCOLOR = 16)
      DOUBLE PRECISION ITALIC, SIZE1, SIZE2, SIZE3, THETA, XBEGIN,
     +                 YBEGIN
      PARAMETER (SIZE2 = 180.0D+00/1.15D+00)
      DOUBLE PRECISION ZERO, NINETY
      PARAMETER (ZERO = 0.0D+00, NINETY = 90.0D+00)
      DOUBLE PRECISION DEGRAD, TWO, FOUR, RSUB, RSUPER, XSUB, XSUPER,
     +                 YSUB, YSUPER
      PARAMETER (DEGRAD = 3.1415927D+00/180.0D+00, TWO = 2.0D+00,
     +           FOUR = 4.0D+00)
      DOUBLE PRECISION C_SCALE, DD1, DD2, DD3, DD4, VALUE
      DOUBLE PRECISION BLUE(NCOLOR), GREEN(NCOLOR), RED(NCOLOR)
      DOUBLE PRECISION WGBCFG$
      DOUBLE PRECISION FACTOR
      CHARACTER  STRING_1*80, SYMBOL_1*80
      CHARACTER  C1*1, DFOLT(13)*22, FONT1*40, FONT2*40, K1*1
      CHARACTER  BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ADJUST, LL1, LL2, LL3, LL4, LL5, LL6
      LOGICAL    TRUE_TYPE
      EXTERNAL   SET_TEXT_ATTRIBUTE$, DRAW_HERSHEY$
      EXTERNAL   PSWORD$, GSELNT$, GKSR2I$, PUTFAT$, PLTACC$, GETDEF$,
     +           PSCOLR$, NUMRGB$, SLASHB$, WGBCFG$, SAVELW$, TTYPE1$
      EXTERNAL   IHERSH, LEN200, LHERSH, TRIML1
      INTRINSIC  NINT, ICHAR, SIN, COS, DBLE, MAX
      DATA       DFOLT / '/Times-Roman',
     +                   '/Times-Bold',
     +                   '/Times-Italic',
     +                   '/Times-BoldItalic',
     +                   '/Helvetica',
     +                   '/Helvetica-Bold',
     +                   '/Helvetica-Oblique',
     +                   '/Helvetica-BoldOblique',
     +                   '/Courier',
     +                   '/Courier-Bold',
     +                   '/Courier-Oblique',
     +                   '/Courier-BoldOblique',
     +                   '/Symbol' /
C
C Check the parameters supplied o/w set TRUE_TYPE = .TRUE.
C
      IF (STRNG.EQ.BLANK) THEN
         RETURN
      ELSE
         TRUE_TYPE = .TRUE.
      ENDIF
      IF (TRUE_TYPE) THEN
         CALL TTYPE1$(ICOLOR, NFONT, NGKS, NOUT_PS,
     +                ANGLE, SIZE, SLANT, X, Y,
     +                FONT, STRNG, SYMBOL, TYPE1,
     +                HPGL, PS)
         RETURN
      ENDIF
      IF (ICOLOR.LT.0 .OR. ICOLOR.GT.71) THEN
         IF (PS) CALL PUTFAT$(
     +      'PLTSTR$ must be called with 0 =< ICOLOR =< 71')
         ICOLOR = 0
      ENDIF
      IF (IFONT.NE.102 .AND. IFONT.NE.106 .AND. IFONT.NE.107) THEN
         IF (.NOT.PS) CALL PUTFAT$(
     +      'PLTSTR$ must be called with IFONT = 102, 106 or 107')
         IFONT = 102
      ENDIF
C
C Use the parameters supplied so original arguments are unchanged
C
      JFONT = IFONT
      LTEMP = NGKS
      CALL GSELNT$(LTEMP)
      SIZE1 = SIZE*WGBCFG$(K4)
      ITALIC = SLANT
      IF (TYPE1.EQ.'ti' .OR. TYPE1.EQ.'xl' .OR. TYPE1.EQ.'tc' .OR.
     +    TYPE1.EQ.'tl' .OR. TYPE1.EQ.'tr' .OR. TYPE1.EQ.'ty') THEN
         ITYPE = N1
         THETA = ZERO
      ELSEIF (TYPE1.EQ.'yl' .OR. TYPE1.EQ.'td') THEN
         ITYPE = N2
         THETA = NINETY
      ELSEIF (TYPE1.EQ.'zl') THEN
         ITYPE = N3
         THETA = - NINETY
      ELSE
         ITYPE = N4
         THETA = ANGLE
      ENDIF
      IF (THETA.LT.- 360.0D+00 .OR. THETA.GT.360.0D+00) THETA = ZERO
      XBEGIN = X
      YBEGIN = Y
C
C Make sure PS colour is declared before text is defined
C
      IF (PS) CALL PSCOLR$(ISEND, ICOLOR, NOUT_PS, BLUE, GREEN, RED)
C
C Manipulate STRING and SYMBOL .. Copy or TRIML1 if appropriate
C
      IF (PS .OR. TYPE1.EQ.'left'  .OR. TYPE1.EQ.'centre' .OR.
     +            TYPE1.EQ.'right' .OR. TYPE1.EQ.'free') THEN
         STRING_1 = STRNG
         SYMBOL_1 = SYMBOL
      ELSE
         STRING_1 = STRNG
         CALL SLASHB$(STRING_1)
         L1 = LEN200(STRING_1)
         CALL TRIML1 (STRING_1)
         L2 = LEN200(STRING_1)
         L = LEN200(SYMBOL)
         SYMBOL_1 = SYMBOL(N1 + L1 - L2:L)
      ENDIF
C
C Map the real/external coordinates into integers (pixels)
C
      CALL GKSR2I$(IX, IY, XBEGIN, YBEGIN)
C
C Take separate action with PS (from everything else)
C
      IF (PS) THEN
C
C PostScript ..........................................................
C Requires special action if TYPE1 = 'free'
C
         IF (TYPE1.EQ.'free') THEN
            IF (NFONT.GE.1 .AND. NFONT.LE.13) THEN
               FONT1 = DFOLT(NFONT)
            ELSE
               FONT2 = FONT
               CALL TRIML1 (FONT2)
               IF (FONT2(1:1).EQ.'\') THEN
                  FONT1 = FONT2
               ELSE
                  FONT1 = '\'//FONT2(1:39)
               ENDIF
            ENDIF
            L = LEN200(FONT1)
            WRITE (NOUT_PS,100) FONT1(N1:L), NINT(SIZE1*SIZE2),
     +                          IX, IY, NINT(THETA)
         ENDIF
         CALL PSWORD$(ICOLOR, XBEGIN, YBEGIN, STRING_1, SYMBOL_1, TYPE1)
      ELSE
C
C Screen/pcl/BMP........................................................
C
         VALUE = TWO
         IF (HARD_COPY .AND. .NOT.HPGL) THEN
            CALL SAVELW$(VALUE, 'p')
            IADD1 = MAX(NINT(VALUE), N4)
         ELSE
            CALL SAVELW$(VALUE, 'h')
            IADD1 = MAX(NINT(VALUE), N1)
         ENDIF
         IF (NFONT.EQ.2 .OR. NFONT.EQ.4  .OR. NFONT.EQ.6 .OR.
     +       NFONT.EQ.8 .OR. NFONT.EQ.10 .OR. NFONT.EQ.12) THEN
C
C NFONT even implies bold fonts
C
             ADJUST = .TRUE.
         ELSE
            ADJUST = .FALSE.
         ENDIF
C
C NFONT = 13 implies SYMBOL font
C
         IF (NFONT.EQ.13) THEN
            DO J = 1, LEN200(SYMBOL_1)
               IF (SYMBOL_1(J:J).EQ.'0') SYMBOL_1(J:J) = 'K'
            ENDDO
         ENDIF
         CALL GETDEF$(II1, II2, II3, II4, DD1, DD2, DD3, DD4, LL1,
     +                LL2, LL3, LL4, LL5, LL6)
         C_SCALE = DD1
         FACTOR = C_SCALE
         IF (HARD_COPY) SIZE1 = Y_SCALE*SIZE1
C
C Use LHERSH to find the coordinate details
C
         IH = IX
         IV = IY
         L1 = N1
         L2 = LEN200(STRING_1)
         CALL LHERSH (JFONT, IVERT, IH, IH_END, IV, IV_END, LENGTH,
     +                ANGLE, FACTOR*SIZE1, ITALIC,
     +                STRING_1(L1:L2), SYMBOL_1)
         ISUB = IVERT/N4
         ISUPER = IVERT/N2
C
C Adjust IX and IY as required
C
         IF (TYPE1.EQ.'ti' .OR. TYPE1.EQ.'xl') THEN
C
C Centralise the title or x-legend
C
            IX = IX - LENGTH/N2
         ELSEIF (TYPE1.EQ.'yl') THEN
C
C Centralise the y-legend
C
            IF (HPGL) THEN
               IY = IY - LENGTH/N2
            ELSE
               IY = IY + LENGTH/N2
            ENDIF
         ELSEIF (TYPE1.EQ.'zl') THEN
C
C Centralise the z-legend
C
            IF (HPGL) THEN
               IY = IY + LENGTH/N2
            ELSE
               IY = IY - LENGTH/2
            ENDIF
         ELSEIF (TYPE1.EQ.'tr') THEN
C
C Right justification
C
            IX = IX - LENGTH
         ELSEIF (TYPE1.EQ.'td') THEN
C
C Text pointing down
C
            IX = IX + IVERT/N3
            IF (HPGL) THEN
               IY = IY - LENGTH
            ELSE
               IY = IY + LENGTH
            ENDIF
         ELSEIF (TYPE1.EQ.'tc') THEN
C
C Text centralised
C
            IX = IX - LENGTH/N2
         ELSEIF (TYPE1.EQ.'ty') THEN
C
C Text as for annotation of y-axis
C
            IX = IX - LENGTH
            IF (HPGL) THEN
               IY = IY - IVERT/N3
            ELSE
               IY = IY + IVERT/N3
            ENDIF
         ELSEIF (TYPE1.EQ.'tz') THEN
C
C Text as for annotation of z-axis
C
            IF (HPGL) THEN
               IY = IY - IVERT/N3
            ELSE
               IY = IY + IVERT/N3
            ENDIF
         ELSE
C
C Arbitrary text ... longhand for clarity
C
            RSUB = DBLE(IVERT)/FOUR
            XSUB = RSUB*SIN(THETA*DEGRAD)
            YSUB = RSUB*COS(THETA*DEGRAD)
            RSUPER = DBLE(IVERT)/TWO
            XSUPER = RSUPER*SIN(THETA*DEGRAD)
            YSUPER = RSUPER*COS(THETA*DEGRAD)
         ENDIF
C
C Now draw the text string ... character by character
C
         IH_END = IX
         IV_END = IY
         DO I = L1, L2
C
C Select the character using IHERSH/JFONT/C1/K1
C
            C1 = STRING_1(I:I)
            K1 = SYMBOL_1(I:I)
            IASCII = ICHAR(C1)
            IF (IASCII.EQ.95) K1 = '1'
            L = IHERSH(IASCII, JFONT, K1)
            IH = IH_END
            IV = IV_END
C
C Adjust for subscript and superscript if required
C
            IF (K1.EQ.'1' .OR. K1.EQ.'4') THEN
               SIZE3 = 0.75D+00*SIZE1
               IF (ITYPE.EQ.N1) THEN
                  IF (HPGL) THEN
                     IV = IV - ISUB
                  ELSE
                     IV = IV + ISUB
                  ENDIF
               ELSEIF (ITYPE.EQ.N2) THEN
                  IH = IH + ISUB
               ELSEIF (ITYPE.EQ.N3) THEN
                  IH = IH - ISUB
               ELSEIF (ITYPE.EQ.N4) THEN
                  IADD2X = NINT(XSUB)
                  IF (HPGL) THEN
                    IADD2Y = - NINT(YSUB)
                  ELSE
                    IADD2Y = NINT(YSUB)
                  ENDIF
                  IH = IH + IADD2X
                  IV = IV + IADD2Y
               ENDIF
            ELSEIF (K1.EQ.'2' .OR. K1.EQ.'5') THEN
               SIZE3 = 0.75D+00*SIZE1
               IF (ITYPE.EQ.N1) THEN
                  IF (HPGL) THEN
                     IV = IV + ISUPER
                  ELSE
                     IV = IV - ISUPER
                  ENDIF
               ELSEIF (ITYPE.EQ.N2) THEN
                  IH = IH - ISUPER
               ELSEIF (ITYPE.EQ.N3) THEN
                  IH = IH + ISUPER
               ELSEIF (ITYPE.EQ.N4) THEN
                  IADD2X = - NINT(XSUPER)
                  IF (HPGL) THEN
                    IADD2Y = NINT(YSUPER)
                  ELSE
                    IADD2Y = - NINT(YSUPER)
                  ENDIF
                  IH = IH + IADD2X
                  IV = IV + IADD2Y
               ENDIF
            ELSE
               SIZE3 = SIZE1
            ENDIF
C
C Draw the Hershey character TWICE, second time iadd1 pixel to RHS
C
            CALL SET_TEXT_ATTRIBUTE$(JFONT, FACTOR*SIZE3,
     +                               THETA, ITALIC)
            COLOUR_LONG = NUMRGB$(ICOLOR)
            CALL DRAW_HERSHEY$(L, IH, IV, COLOUR_LONG, IH_END,
     +                         IV_END)
            IF (NFONT.NE.5 .AND. NFONT.NE.7) THEN
C
C If not Helvetica or Helvetica Oblique make a second stroke
C
               IH1 = IH + IADD1
               IV1 = IV
               CALL DRAW_HERSHEY$(L, IH1, IV1, COLOUR_LONG, IH2,
     +                           IV2)
            ENDIF
            IF (ADJUST) THEN
C
C Draw the Hershey character TWICE AGAIN for bold font
C
               IH1 = IH
               IV1 = IV + IADD1
               CALL DRAW_HERSHEY$(L, IH1, IV1, COLOUR_LONG, IH2,
     +                            IV2)
               IH1 = IH + IADD1
               IV1 = IV + IADD1
               CALL DRAW_HERSHEY$(L, IH1, IV1, COLOUR_LONG, IH2,
     +                            IV2)
            ENDIF
C
C Add any accents as required
C
            CALL PLTACC$(ICOLOR, IH, IH_END, IV, IV_END, IVERT,
     +                   THETA, C1, K1, HPGL)
            IF (ADJUST) THEN
C
C Draw again 1 pixel to RHS for bold font
C
               IH1 = IH + IADD1
               IV1 = IV
               CALL PLTACC$(ICOLOR, IH1, IH2, IV1, IV2, IVERT,
     +                      THETA, C1, K1, HPGL)
            ENDIF
C
C Re-adjust dimensions if required
C
            IF (K1.EQ.'1' .OR. K1.EQ.'4') THEN
               IF (ITYPE.EQ.N1) THEN
                  IF (HPGL) THEN
                     IV_END = IV_END + ISUB
                   ELSE
                     IV_END = IV_END - ISUB
                  ENDIF
               ELSEIF (ITYPE.EQ.N2) THEN
                  IH_END = IH_END - ISUB
               ELSEIF (ITYPE.EQ.N3) THEN
                  IH_END = IH_END + ISUB
               ELSEIF (ITYPE.EQ.N4) THEN
                  IH_END = IH_END - IADD2X
                  IV_END = IV_END - IADD2Y
               ENDIF
            ELSEIF (K1.EQ.'2' .OR. K1.EQ.'5') THEN
               IF (ITYPE.EQ.N1) THEN
                  IF (HPGL) THEN
                     IV_END = IV_END - ISUPER
                  ELSE
                     IV_END = IV_END + ISUPER
                  ENDIF
               ELSEIF (ITYPE.EQ.N2) THEN
                  IH_END = IH_END + ISUPER
               ELSEIF (ITYPE.EQ.N3) THEN
                  IH_END = IH_END - ISUPER
               ELSEIF (ITYPE.EQ.N4) THEN
                  IH_END = IH_END - IADD2X
                  IV_END = IV_END - IADD2Y
               ENDIF
            ENDIF
         ENDDO
         CALL SAVELW$(VALUE, 'r')
      ENDIF
C
C Format statement (DO NOT TRANSLATE)
C      
  100 FORMAT ('/font ',A,' D /size ',I5,' D'
     +/'GS font F size S ',2I6,' M ',I4,' rotate%#string')
      END
C 
C