C
C
      SUBROUTINE PS2BMP (FNAME,
     +                   SUPPLY)       
C
C ACTION : PS to BMP using GHOSTSCRIPT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 18/4/98
C          Arguments will be found in the Ghostscript files, e.g.
C          use.htm, devices.htm, etc. 
C          29/09/2006 derived from PS2PNG
C          02/01/2007 edited for Linux
C          23/06/2009 added call to X_OKCVAL
C          28/09/2010 sets CVAL(9) = BLANK not GSPaths
C          24/01/2011 added TRIM100 
C          04/10/2013 added ADJUSTL and improved 
C          09/05/2017 added logical argument in call to X_OKCVAL
C          20/05/2017 added calls to GSTYPE, X_DQUOTE, W_EPSGS 
C          19/06/2017 made the dll priority 
C
      IMPLICIT   NONE
C
C Arguments
C          
      CHARACTER (LEN = *), INTENT (IN) :: FNAME
      LOGICAL,             INTENT (IN) :: SUPPLY
C
C Locals
C       
      INTEGER    ISEND, JSEND, KSEND
      PARAMETER (ISEND = 3, JSEND = 8, KSEND = 6)
      INTEGER    N0, N1, N2, N3, N4, N5, N12, N16, N17, NM1
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N12 = 12, N16 = 16, N17 = 17, NM1 = -N1)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 6,
     +           NSTART = 6, NTEXT = NSTART + NUMOPT - 1, NUMTXT = 22)
      INTEGER    NUMBLD(NUMTXT), NUMPOS(NUMOPT)
      INTEGER    LEN200, LSTART, LSTOP, L1, L2, NIN
      INTEGER    ITYPE, NCTYPE, NHIGH, NRES, NWIDE
      DOUBLE PRECISION X1, X2, Y1, Y2
      DOUBLE PRECISION F72
      PARAMETER (F72 = 72.0D+00)
      CHARACTER  FILE1*1024, FILE2*1024, GS*1024, LINE*1024, STRNG*1024,
     +           STRNG1*100, TFILE*1024, WORD3*3, WORD4*4, WORD5*5,
     +           WORD6*6, WORD10*10        
      CHARACTER  TEMP*1024, TRIM100*100
      CHARACTER  TYPE1*16, QUAL(3)*16
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  HEIGHT*10, TEXT(30)*100, WIDTH*10
      CHARACTER  DFOLT1*31, DFOLT2*71
      PARAMETER (DFOLT1 = '-q -dBATCH -dSAFER -dNOPAUSE -r',
     +           DFOLT2 = '-q -dBATCH -dSAFER -dNOPAUSE '//
     +                    '-dGraphicsAlphaBits=4 -dTextAlphaBits=4 -r')
      LOGICAL    ABORT, GSOK, OK, PS2, PS3, PS4, READY, REPEET,
     +           THERE
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ASKIF
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   OFILES, GETNOU, TRIML1, UCASE1, LEN200, PUTADV,
     +           LBOX01, PATCH1, PUTFAT, PS2CHK, GETJGE, DELEET, 
     +           LISTBX, PUTWAR,  INFOGS, TRIM100, GSTYPE 
      EXTERNAL   W_STARTP, W_EPS2GS, X_DQUOTE
      INTRINSIC  DBLE, NINT, ADJUSTL
      SAVE       NCTYPE, NRES 
      DATA       NCTYPE, NRES / 2, 600 /
      DATA       NUMBLD / NUMTXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       QUAL / 'Compact...bmp16 ',
     +                  'Normal...bmp256 ',
     +                  'Maximum...bmp16m' /
C
C Part 1: See if we can find ghostscript and font/initialisation files
C -------
C     
      CALL GSTYPE (ITYPE,
     +             GS)!returns ITYPE: 0 = neither, 6 = DLL, 8 = GS, 14 = both  
      IF (ITYPE.LT.KSEND) THEN
         CALL PUTADV ('Cannot find Ghostscript or the DLL')
         RETURN
      ENDIF  
      GSOK = .TRUE. 
C
C Part 2: Main branch point for cycling
C -------
C                                         
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Initialise
C
         PS2 = .FALSE.
         PS3 = .FALSE.
         PS4 = .FALSE.
         READY = .FALSE.
         FILE1 = BLANK
         FILE2 = BLANK
         LINE = BLANK
         WRITE (WORD10,'(I10)') NRES
         CALL TRIML1 (WORD10)
         STRNG = BLANK
         IF (NCTYPE.EQ.1) THEN
            STRNG = DFOLT1//WORD10
            TYPE1 = QUAL(1)
            WORD6 = 'bmp16 '
         ELSEIF (NCTYPE.EQ.2) THEN
            STRNG = DFOLT2//WORD10
            TYPE1 = QUAL(2)
            WORD6 = 'bmp256' 
         ELSE 
            STRNG = DFOLT2//WORD10
            TYPE1 = QUAL(3)
            WORD6 = 'bmp16m'     
         ENDIF        
         STRNG1 = TRIM100(STRNG)
         WRITE (TEXT,200) STRNG1, WORD6, NRES, TYPE1
         NUMDEC = NUMOPT - N1
         NUMBLD(1) = 1
         NUMBLD(4) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0 
C
C If NUMDEC = 1, or 2 then check that the GS executable has been found
C         
         IF (NUMDEC.GE.N1 .AND. NUMDEC.LE.N2) THEN 
            IF (GSOK) THEN
               OK = .TRUE.
            ELSE      
               WRITE (LINE,100)
               CALL PUTFAT (LINE)
               NUMDEC = N0 
               OK = .FALSE.
            ENDIF   
         ELSE
            OK = .FALSE.   
         ENDIF    
         IF (OK) THEN
C
C If OK then try to get a file
C
            CALL GETNOU (NIN) 
            IF (SUPPLY) THEN 
               INQUIRE (FILE = FNAME, EXIST = THERE)
               IF (THERE) THEN
                  ABORT = .FALSE.
                  FILE1 = FNAME
                  OPEN (UNIT = NIN, FILE = FILE1) 
               ELSE   
                  ABORT = .TRUE.
               ENDIF   
            ELSE               
               CALL OFILES (ISEND, NIN, 
     +                      FILE1,
     +                      ABORT)
            ENDIF
            IF (ABORT) THEN 
               CLOSE (UNIT = NIN)
               NUMDEC = N0
               OK = .FALSE.
            ELSE   
C
C Is the filename long enough after removing double quotes ?
C
               CALL X_DQUOTE (NM1, L2,
     +                           FILE1)
               IF (L2.LT.N4) THEN  
                  WRITE (LINE,300)
                  CALL PUTFAT (LINE)
                  CLOSE (UNIT = NIN)
                  NUMDEC = N0
                  OK = .FALSE.
               ENDIF
C
C Is it a .ps or .eps file ?
C                      
               IF (OK) THEN   
                  L1 = L2 - N2
                  WORD3 = FILE1(L1:L2)
                  CALL UCASE1 (WORD3)
                  IF (WORD3.EQ.'.PS') THEN
                     PS2 = .TRUE.
                     READY = .TRUE.
                  ENDIF
                  IF (.NOT.READY) THEN
                     L1 = L1 - N1
                     WORD4 = FILE1(L1:L2)
                     CALL UCASE1 (WORD4)
                     IF (WORD4.EQ.'.EPS') THEN
                        PS3 = .TRUE.
                        READY = .TRUE.
                     ENDIF
                  ENDIF      
                  IF (.NOT.READY .AND. L1.GT.N1) THEN
                     L1 = L1 - N1
                     WORD5 = FILE1(L1:L2)
                     CALL UCASE1 (WORD5)
                     IF (WORD5.EQ.'.EPSF' .OR. WORD5.EQ.'.EPSI') THEN
                        PS4 = .TRUE.
                        READY = .TRUE.
                     ENDIF
                  ENDIF
                  IF (.NOT.READY) THEN 
                     WRITE (LINE,300)
                     CALL PUTFAT (LINE)
                     CLOSE (UNIT = NIN)
                     NUMDEC = N0
                     OK = .FALSE.
                  ENDIF 
               ENDIF
C
C Does the file start with %!, etc. ?
C                
               IF (OK) THEN 
                  CALL PS2CHK (NIN,
     +                         X1, X2, Y1, Y2, 
     +                         TFILE,
     +                         ABORT)
                  CLOSE (UNIT = NIN)
                  IF (ABORT) THEN 
                     WRITE (LINE,300)
                     CALL PUTFAT (LINE)
                     CALL DELEET (TFILE, 
     +                            ASKIF, THERE)
                     NUMDEC = N0
                     OK = .FALSE.
                  ENDIF
               ENDIF
            ENDIF   
         ENDIF
         IF (OK) THEN      
C         
C NUMDEC = 1 or NUMDEC = 2: file seems OK
C ========================================
C
C Step 1: Calculate the bitmap size from the BoundingBox parameters
C
            NHIGH = NINT(DBLE(NRES)*Y2/F72)
            NWIDE = NINT(DBLE(NRES)*X2/F72)
            WRITE (WIDTH,'(I10)') NWIDE
            WRITE (HEIGHT,'(I10)') NHIGH  
            CALL TRIML1 (WIDTH)
            CALL TRIML1 (HEIGHT) 
            IF (NCTYPE.EQ.1) THEN
               STRNG = DFOLT1//WORD10(1:LEN200(WORD10))//BLANK//
     +'-dDEVICEWIDTH='//WIDTH(1:LEN200(WIDTH))//BLANK//
     +'-dDEVICEHEIGHT='//HEIGHT
            ELSE 
               STRNG = DFOLT2//WORD10(1:LEN200(WORD10))//BLANK//
     +'-dDEVICEWIDTH='//WIDTH(1:LEN200(WIDTH))//BLANK//
     +'-dDEVICEHEIGHT='//HEIGHT            
            ENDIF
C
C Step 2: Define output file...inputfile.ps or inputfile.eps become outputfile.png
C                        
            TEMP = FILE1
 
            L2 = LEN200 (TEMP) 
            L1 = N1
            IF (PS2) THEN
               L2 = L2 - N2
            ELSEIF (PS3) THEN
               L2 = L2 - N3  
            ELSEIF (PS4) THEN
               L2 = L2 - N4 
            ENDIF
            FILE2 = TEMP(L1:L2)//'bmp'
            CALL X_DQUOTE (N1, L2,
     +                     FILE2)           
C
C Step 3: Build up the command line... -I<>
C
            LINE = BLANK     
C
C Step 4: Build up the command line...add the string
C
            L1 = N1
            L2 = LEN200 (STRNG)
            LSTART = N1
            LSTOP = LSTART + L2 - N1
            LINE(LSTART:LSTOP) = STRNG(L1:L2)
C
C Step 5: Build up the command line...add the device
C
            LSTART = LSTOP + N1
            IF (NUMDEC.EQ.N1) THEN
               LSTOP = LSTART + N17
               LINE(LSTART:LSTOP) = ' -sDEVICE=bmpgray'
            ELSE
               LSTOP = LSTART + N16   
               IF (NCTYPE.EQ.1) THEN
                  LINE(LSTART:LSTOP) = ' -sDEVICE=bmp16 '
               ELSEIF (NCTYPE.EQ.2) THEN
                  LINE(LSTART:LSTOP) = ' -sDEVICE=bmp256'
               ELSE 
                  LINE(LSTART:LSTOP) = ' -sDEVICE=bmp16m'      
               ENDIF   
            ENDIF
C            
C Step 6: Build up the command line...name the output file
C
            LSTART = LSTOP + N1
            LSTOP = LSTART + N12
            LINE(LSTART:LSTOP) = '-sOutputFile='
            L1 = N1
            L2 = LEN200 (FILE2)
            LSTART = LSTOP + N1
            LSTOP = LSTART + L2 - N1
            LINE(LSTART:LSTOP) = FILE2(L1:L2)
            LSTART = LSTOP + N1
            LSTOP = LSTART
            LINE(LSTART:LSTOP) = BLANK
C
C Step 7: Build up the command line...add the input filename
C
            CALL X_DQUOTE (N1, L2,
     +                     TFILE)       
            L1 = N1

            LSTART = LSTOP + N1
            LSTOP = LSTART + L2 - N1
            LINE(LSTART:LSTOP) = TFILE(L1:L2)
C
C Step 8: Use STARTP to fire up Ghostscript
C
            LINE = ADJUSTL (LINE)
            IF (ITYPE.EQ.JSEND) THEN
              CALL W_STARTP (GS,
     +                        LINE)! = 8 so ONLY GhostScript available 
               ABORT = .FALSE.                 
            ELSE  
               CALL W_EPS2GS (LINE,
     +                        ABORT)! use the DLL
            ENDIF
            IF (.NOT.ABORT) CALL INFOGS (N2,
     +                                   FILE2)      
            CALL DELEET (TFILE,
     +                   ASKIF, THERE) 
            
         ELSEIF (NUMDEC.EQ.N3) THEN  
C
C NUMDEC = 3: change resolution         
C ===========
C                                  

            WRITE (LINE,400) N5
            CALL GETJGE (NRES, N5,
     +                   LINE)      
         ELSEIF (NUMDEC.EQ.N4) THEN  
C
C NUMDEC = 4: change compression and colour        
C ===========
C                                  
                          
            CALL LISTBX (NCTYPE, N3,
     +                   QUAL)       
            IF (NCTYPE.EQ.3) THEN
               WRITE (LINE,500)
               CALL PUTWAR (LINE)
            ENDIF   
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C NUMDEC = 4: help
C ===========
C         
            WRITE (TEXT,600)
            NUMBLD(12) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                TEXT,
     +                BORDER)
            NUMBLD(12) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: quit
C ================
C         
            REPEET = .FALSE.   
         ENDIF  
      ENDDO
  100 FORMAT (
     +'Cannot find Ghostscript, e.g. gswin64c.exe ... configure')    
  200 FORMAT (
     + 'Creating .bmp files from .eps files'
     +/
     +/'The current ghostscript command line argument is:'
     +/A
     +/
     +/'Create a .bmp file: monochrome (-sDEVICE=bmpgray)'
     +/'Create a .bmp file: coloured (-sDEVICE=',a,')'
     +/'Change: resolution (current =',I5,'dpi)'
     +/'Change: precision/colours (current =',1x,a,')',
     +/'Help'
     +/'Cancel') 
  300 FORMAT (
     +'Not a valid (.ps,.eps, or .epsf) Encapsulated PostScript file')   
  400 FORMAT (
     +'Resolution required (default = 72 or 600, minimum =',i4,')')   
  500 FORMAT (
     +'This option leads to very large files and may be a bad choice') 
  600 FORMAT (
     + 'PostScript files are the best graph files for scientific plots'
     +/'but sometimes it is necessary to transform them into bitmaps'
     +/'despite the associated loss of quality. Normal .bmp files are'
     +/'too large and, for the Internet, a compressed bitmap format is'
     +/'required. For scientific plots SVG and PNG files are superior'
     +/'to JPEG format but, for various reasons, the JPEG standard is'
     +/'now widely established. This program will read in a .eps file'
     +/'and build up a command line, so that Ghostscript can create a'
     +/'BMP file with the same name but with extension .bmp, i.e.'
     +/'myfile.ps (or .eps) is unchanged, but myfile.bmp is created.'
     +/
     +/'The following points should be noted'
     +/
     +/'1)`Simfit must be configured to use the Ghostscript executable'
     +/'2)`The .eps file supplied must be correctly formatted'
     +/'3)`There is no prompt for overwriting an existing myfile.bmp'
     +/'4)`Use grey scale (bmpgray) only for black and white .eps files'
     +/'  `and colour (bmp16 or bmp256) only for coloured .eps files'
     +/'5)`SVG and PNG files have many advantages over BMP, JPEG, or'
     +/'  `TIFF files and can be used by most applications.'
     +/'6)`Normally you should not use .bmp at all for scientific plots'
     +/'  `but, if you do, bmp256 should provide sufficient colours.')  
      END
C
C
