C
C
      SUBROUTINE PS2CHK (NIN,
     +                   X1, X2, Y1, Y2, 
     +                   TFILE,
     +                   ABORT)
C
C ACTION : Is it a ps file ?
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/12/95
C          Copy of ISITPS from editps but creates a shifted eps file
C          14/08/2006 revised and increased line length from 256 to 1024
C          22/04/2007 added INTENTS
C
C            NIN: (input/unchanged) unit with supposed PS file already connected
C X1, X2, Y1, Y2: (output) new BoundingBox after translation
C          TFILE: (output) temporary file with new eps file after translating
C          ABORT: (output) error indicator
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NIN 
      DOUBLE PRECISION,    INTENT (OUT) :: X1, X2, Y1, Y2 
      CHARACTER (LEN = *), INTENT (OUT) :: TFILE 
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    IADD1, IFAIL, IOS
      INTEGER    NOUT
      INTEGER    N0
      PARAMETER (N0 = 0)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINE*1024
      CHARACTER  WORD2*2, WORD14*14
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    DONE1, DONE2
      EXTERNAL   PUTFAT, TRIML1, GETNOU, GETTMP
      INTRINSIC  NINT
C
C Initialise
C
      IADD1 = 1
      IOS = N0
      X1 = ZERO
      X2 = ZERO
      Y1 = ZERO
      Y2 = ZERO   
      TFILE = BLANK
      ABORT = .TRUE.
      DONE1 = .FALSE.
      DONE2 = .FALSE.
C
C Check for %! on first line
C
      READ (NIN,'(A)',IOSTAT=IOS) LINE
      IF (IOS.EQ.N0) THEN
         CALL TRIML1 (LINE)
         WORD2 = LINE(1:2)
      ELSE
         WORD2 = BLANK
      ENDIF      
      IF (WORD2.NE.'%!') THEN  
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF
C
C Open temporary file and write the first line
C
      CALL GETNOU (NOUT)
      CALL GETTMP (IFAIL,
     +             TFILE)
      OPEN (UNIT = NOUT, FILE = TFILE, IOSTAT = IOS)
      WRITE (NOUT,'(A)') LINE
C
C Check for BoundingBox
C
      WORD2 = '%%'
      DO WHILE (WORD2.EQ.'%%')
         IADD1 = IADD1 + 1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
         IF (IOS.NE.N0) GOTO 20
         CALL TRIML1 (LINE)
         WORD2 = LINE(1:2)
         WORD14 = LINE(1:14)
         IF (WORD14.EQ.'%%BoundingBox:') THEN
            READ (LINE(15:120),*,END=20,ERR=20,IOSTAT=IOS) X1,Y1,X2,Y2
            IF (IOS.NE.0) GOTO 20
            WRITE (NOUT,200) N0, N0, NINT(X2 - X1), NINT(Y2 - Y1)
            DONE1 = .TRUE.
         ELSEIF (WORD14.EQ.'%%EndComments ') THEN
            IF (.NOT.DONE1) GOTO 20
            WRITE (NOUT,'(A)') LINE
            WRITE (NOUT,300) - NINT(X1), - NINT(Y1)
            X2 = X2 - X1
            Y2 = Y2 - Y1
            DONE2 = .TRUE.
         ELSE
            WRITE (NOUT,'(A)') LINE
         ENDIF
      ENDDO
C
C Check to make sure BoundingBox read and translation done
C
      IF (.NOT.DONE1 .OR. .NOT.DONE2) GOTO 20
C
C Carry on reading and writing
C
      IOS = N0
      DO WHILE (IOS.EQ.N0)
         READ (NIN,'(A)',IOSTAT=IOS) LINE
         IF (IOS.NE.N0) THEN
            ABORT = .FALSE.
            CLOSE (UNIT = NOUT)
            RETURN
         ENDIF   
         WRITE (NOUT,'(A)') LINE
      ENDDO
C
C LABEL 20: Failure to find BoundingBox
C      
   20 CONTINUE
      ABORT = .TRUE.
      WRITE (LINE,400) IADD1
      CALL PUTFAT (LINE)
      CLOSE (UNIT = NOUT)  
C
C Except for 100 these format statements must NOT be translated
C      
  100 FORMAT ('EPSF files must begin with %! ... File rejected')
  200 FORMAT ('%%BoundingBox:',4I6)
  300 FORMAT (2I6,' translate')
  400 FORMAT (
     +'No EPS %%BoundingBox:x1,y1,x2,y2 in DSC comments 2 to',I3)
      END
C
C
