c
c
      subroutine ps2ini (x1, x2, y1, y2, 
     +                   ext, file1, file2, fname, 
     +                   ok)
c
c action: check then initialise before calling the ghostscript routines
c author: w.g.bardsley, university of manchester, u.k., 12/05/2017
c
c x1, x2, y1, y2: BoundingBox parameters
c            ext: extension required, e.g. 'pdf' or '.pdf'  
c          file1: fname with double quotes
c          file2: fname with new extension and double quotes
c          fname: input file with or without double quotes
c             ok: .true. if successful
c       
      implicit none
c
c arguments
c      
      double precision,    intent (out) :: x1, x2, y1, y2
      character (len = *), intent (in)  :: ext, fname
      character (len = *), intent (out) :: file1, file2
      logical,             intent (out) :: ok  
c
c locals
c      
      integer    ios, l1, l2, l3, ldot, nin 
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 1024) tfile
      character (len = 100 ) ext_copy
      character (len = 4   ) suffix
      character (len = 1   ) blank, dot, dquote
      parameter (blank = ' ', dot = '.', dquote = '"')
      logical    abort, askif, back, there
      parameter (askif = .false., back = .true.)
      intrinsic  index, len_trim, adjustl
      external   ucase1, getnou, deleet, ps2chk
c
c initialise then check fname
c      
      x1 = zero
      x2 = zero
      y1 = zero
      y2 = zero
      file1 = blank
      file2 = blank
      ok = .false.
      l2 = len_trim (fname)
      if (fname(1:1).eq.dquote .and. fname(l2:l2).eq.dquote) then
         file1 = fname(2:l2 - 1)
         l2 = l2 - 2
      else
         file1 = fname
      endif        
      if (l2.lt.4) return
c
c examine the input file extension and new extension
c      
      ldot = index(file1, dot, back)
      l1 = l2 - ldot
      if (l1.lt.2 .or. l1.gt.4) return
      suffix = file1(ldot + 1:l2) 
      call ucase1 (suffix)
      if (suffix.ne.'PS' .and. suffix.ne.'EPS' .and. 
     +    suffix.ne.'EPSF' .and. suffix.ne.'EPSI') return
      l3 = len_trim(ext)
      if (l3.lt.2) return
c
c check that the input file is an EPS type file
c      
      call getnou (nin)
      open (unit = nin, file = file1, iostat = ios)  
      if (ios.ne.0) then
         close (unit = nin)
         return
      endif       
      CALL PS2CHK (NIN,
     +             X1, X2, Y1, Y2, 
     +             TFILE,
     +             ABORT)
      CLOSE (UNIT = NIN)
      CALL DELEET (TFILE, 
     +             ASKIF, THERE)
      IF (ABORT) RETURN 
c
c calculate file1 and file2 then return ok = .true.  
c      
      ext_copy = ext
      ext_copy = adjustl(ext_copy) 
      l3 = len_trim(ext_copy)
      if (ext_copy(1:1).eq.dot) then
         file2 = file1(1:ldot)//ext_copy(2:l3)
      else
         file2 = file1(1:ldot)//ext_copy(1:l3)
      endif  
      l1 = len_trim(file1)
      l2 = len_trim(file2)
      file1 = dquote//file1(1:l1)//dquote    
      file2 = dquote//file2(1:l2)//dquote 
      ok = .true. 
      end
c
c      