C
C
      SUBROUTINE PS2PDF (FNAME,
     +                   SUPPLY)
C
C ACTION : PS to PDF using GHOSTSCRIPT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 18/4/98
C          Arguments will be found in the Ghostscript files, e.g.
C          use.htm, devices.htm, etc.  
C
C Note: In general the PS2XYZ routines always open a listbox because there are choices
C       required for the transformation, e.g. DPI and so on.  
C       PS2PDF differs from the other PS2XYZ subroutines because there is no need to
C       edit the argument list to ghostsript. So the effect of SUPPLY is as follows:
C       SUPPLY = .TRUE. proceed to create the output file directly then return
C       SUPPLY = .FALSE. ignore FNAME supplied and open a new file FILE1
C   
C          29/06/2006 derived from PS2PNG 
C          02/01/2007 edited for Linux 
C          3/06/2009 added call to X_OKCVAL
C          28/09/2010 sets CVAL(9) = BLANK not GSPaths
C          24/01/2011 added TRIM100
C          04/10/2013 added ADJUSTL and improved
C          09/05/2017 added logical argument in call to X_OKCVAL 
C          12/05/2017 extensive editing to use GhostScript DLLs   
C          19/06/2017 made the dll priority 
C
      IMPLICIT   NONE  
C
C Arguments
C          
      CHARACTER (LEN = *), INTENT (IN) :: FNAME
      LOGICAL,             INTENT (IN) :: SUPPLY
C
C Locals
C      
      INTEGER    ISEND, JSEND, KSEND
      PARAMETER (ISEND = 3, JSEND = 8, KSEND = 6)
      INTEGER    N0, N1, N2, N12, N18
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N12 = 12, N18 = 18)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 3,
     +           NSTART = 6, NTEXT = NSTART + NUMOPT - 1, NUMTXT = 22)
      INTEGER    NUMBLD(NUMTXT), NUMPOS(NUMOPT)
      INTEGER    LSTART, LSTOP, L1, L2, NIN
      INTEGER    ITYPE
      DOUBLE PRECISION X1, X2, Y1, Y2
      CHARACTER (LEN = 1024) FILE1, FILE2, GS, LINE, STRNG, TFILE 
      CHARACTER (LEN = 100 ) TEXT(30)
      CHARACTER (LEN = 28  ) DFOLT
      PARAMETER (DFOLT = '-q -dBATCH -dSAFER -dNOPAUSE')
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, OK, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   OFILES, GETNOU, LBOX01, PATCH1, INFOGS, PS2INI, PUTADV
      EXTERNAL   W_EPS2GS, W_STARTP, GSTYPE
      INTRINSIC  ADJUSTL, LEN_TRIM
      DATA       NUMBLD / NUMTXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Part 1: See if we can find ghostscript and/or the DLL
C -------  
C    
      CALL GSTYPE (ITYPE,
     +             GS)!returns ITYPE: 0 = neither, 6 = DLL, 8 = GS, 14 = both  
      IF (ITYPE.LT.KSEND) THEN
         CALL PUTADV ('Cannot find Ghostscript or the DLL')
         RETURN
      ENDIF   
      IF (SUPPLY) THEN
         CALL PS2INI (X1, X2, Y1, Y2, 
     +                'pdf', FILE1, FILE2, FNAME,
     +                OK)!returns FILE1 and FILE2 double quoted
         IF (.NOT.OK) RETURN             
      ENDIF    
C
C Part 2: Main branch point for cycling
C -------
C                                         
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (SUPPLY) THEN
            NUMDEC = N1
            REPEET = .FALSE.
         ELSE   
            WRITE (TEXT,100) DFOLT
            NUMDEC = NUMOPT - N1
            NUMBLD(1) = 1
            NUMBLD(4) = 1
            CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT, 
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = 0
            NUMBLD(4) = 0 
         ENDIF   
         IF (NUMDEC.EQ.N1) THEN 
C
C NUMDEC = N1
C           
            IF (.NOT.SUPPLY) THEN
C
C If no file has been supplied then try to get a file
C
               CALL GETNOU (NIN)
               CLOSE (UNIT = NIN) 
               CALL OFILES (ISEND, NIN, 
     +                      TFILE,
     +                      ABORT)
               CLOSE (UNIT = NIN)  
               IF (ABORT) THEN 
                  CLOSE (UNIT = NIN)
                  NUMDEC = N0
                  OK = .FALSE.
               ELSE   
                  CALL PS2INI (X1, X2, Y1, Y2, 
     +                        'pdf', FILE1, FILE2, TFILE,
     +                        OK)
                  IF (.NOT.OK) NUMDEC = N0    
               ENDIF
            ENDIF 
            IF (OK) THEN       
C
C Step 1: initialise STRNG
C
               STRNG = DFOLT 
C
C Step 2: Build up the command line
C
               LINE = BLANK     
C
C Step 3: Build up the command line...add the string
C
               LSTART = N1
               LSTOP = N1
               L1 = N1
               L2 = LEN_TRIM(STRNG)
               LSTART = LSTOP + N1
               LSTOP = LSTART + L2 - N1
               LINE(LSTART:LSTOP) = STRNG(L1:L2)
C
C Step 4: Build up the command line...add the device
C
               LSTART = LSTOP + N1
               LSTOP = LSTART + N18
               LINE(LSTART:LSTOP) = ' -sDEVICE=pdfwrite'
C            
C Step 5: Build up the command line...name the output file
C
               LSTART = LSTOP + N1
               LSTOP = LSTART + N12
               LINE(LSTART:LSTOP) = '-sOutputFile='
               L1 = N1
               L2 = LEN_TRIM(FILE2)
               LSTART = LSTOP + N1
               LSTOP = LSTART + L2 - N1
               LINE(LSTART:LSTOP) = FILE2(L1:L2)
               LSTART = LSTOP + N1
               LSTOP = LSTART
               LINE(LSTART:LSTOP) = BLANK
C
C Step 6: Build up the command line...add the input filename
C
               L1 = N1
               L2 = LEN_TRIM(FILE1)
               LSTART = LSTOP + N1
               LSTOP = LSTART + L2 - N1
               LINE(LSTART:LSTOP) = FILE1(L1:L2)
C
C Step 7: Use W_EPS2GS to fire up Ghostscript
C
               LINE = ADJUSTL(LINE)
               IF (ITYPE.EQ.JSEND) THEN
                  CALL W_STARTP (GS,
     +                           LINE)! = 8 so use GhostScript  
                  ABORT = .FALSE.                 
               ELSE  
                  CALL W_EPS2GS (LINE,
     +                           ABORT)! >= 6 so use the DLL 
               ENDIF
               IF (.NOT.ABORT) CALL INFOGS (N2,
     +                                      FILE2)   
            ENDIF
         ELSEIF (NUMDEC.EQ.N2) THEN  
C
C NUMDEC = 2: help
C ===========
C         
            WRITE (TEXT,200)
            NUMBLD(12) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(12) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: quit
C ================
C         
            REPEET = .FALSE.   
         ENDIF  
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Creating .pdf files from .eps files'
     +/
     +/'The current ghostscript command line argument is:'
     +/A
     +/
     +/'Create a .pdf file (using -sDEVICE=pdfwrite)'
     +/'Help'
     +/'Cancel') 
  200 FORMAT (
     + 'PostScript files are the best graph files for scientific plots'
     +/'but sometimes it is necessary to transform them into bit maps'
     +/'despite the associated loss of quality. Normal .bmp files are'
     +/'too large and, for the Internet, a compressed bitmap format is'
     +/'required. For scientific plots PNG files are superior to JPEG'
     +/'format but, for the best results you should use the high level'
     +/'portable document format. This program will read in a .eps file'
     +/'and build up a command line so that Ghostscript can create a'
     +/'PDF file with the same name but with extension .pdf, i.e.'
     +/'myfile.ps (or .eps) is unchanged, but myfile.pdf is created.'
     +/
     +/'The following points should be noted'
     +/
     +/'1)`Simfit must be linked to Ghostscript or the DLL'
     +/'2)`The .eps file supplied must be correctly formatted'
     +/'3)`There is no prompt for overwriting an existing myfile.pdf'
     +/'4)`The resolution for embedded bitmaps will not apply to .eps'
     +/'  `files created by Simfit'
     +/'5)`For larger files you must adjust the size as output from'
     +/'  `the Simfit PostScript configuration control.'
     +/'6)`To use this control directly after creating a .eps file from'
     +/'  `Simfit, just select the file type required.')  
      END
C
C

