C
C
      SUBROUTINE PS2SVG (FNAME,
     +                   SUPPLY)       
C
C ACTION : PS to SVG using GHOSTSCRIPT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          26/03/2009 derived from PS2PNG
C          23/06/2009 added call to X_OKCVAL
C          28/09/2010 sets CVAL(9) = BLANK not GSPaths
C          24/01/2011 added TRIM100
C          12/05/2013 added SVGREP to repair ghostscript errors 
C          04/10/2013 added ADJUSTL and improved 
C          13/04/2017 switched off pending further developments
C          09/05/2017 added logical argument in call to X_OKCVAL
C
C          Arguments will be found in the Ghostscript files, e.g.
C          use.htm, devices.htm, etc.  
C          
C
      IMPLICIT   NONE 
C
C Arguments
C          
      CHARACTER (LEN = *), INTENT (IN) :: FNAME
      LOGICAL,             INTENT (IN) :: SUPPLY
C
C Locals
C      
      INTEGER    ISEND, ISEND1, JSEND, MODE
      PARAMETER (ISEND = 3, JSEND = 8, MODE = 0)
      INTEGER    N0, N1, N2, N3, N4, N12, N13
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N12 = 12,
     +           N13 = 13)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 3,
     +           NSTART = 6, NTEXT = NSTART + NUMOPT - 1, NUMTXT = 22)
      INTEGER    NUMBLD(NUMTXT), NUMPOS(NUMOPT)
      INTEGER    LEN200, LSTART, LSTOP, L1, L2, NIN, NUMERR
      INTEGER    NVAL(N12)
      DOUBLE PRECISION X1, X2, Y1, Y2
      CHARACTER  CVAL(N12)*1024
      CHARACTER  FILE1*1024, FILE2*1024, GS*1024, LINE*1024, STRNG*1024,
     +           STRNG1*100, WORD3*3, WORD4*4, WORD5*5   
      CHARACTER  TEMP*1024, TFILE*1024, TRIM100*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  TEXT(30)*100
      CHARACTER  DFOLT*28
      PARAMETER (DFOLT = '-q -dBATCH -dSAFER -dNOPAUSE')
      LOGICAL    ABORT, GSOK, OK, PS2, PS3, PS4, READY, REPEET,
     +           THERE
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ASKIF
      PARAMETER (ASKIF = .FALSE.)      
      LOGICAL    LINUX3
      EXTERNAL   W_CONFIG, OFILES, GETNOU, TRIML1, UCASE1, LEN200,
     +           LBOX01, PATCH1, PUTFAT, PS2CHK, DELEET, SVGREP,
     +           LINUX2, LINUX3, INFOGS, TRIM100, PUTADV 
      EXTERNAL   STARTP, X_OKCVAL
      INTRINSIC  ADJUSTL
      DATA       NUMBLD / NUMTXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      ISEND1 = ISEND
      IF (ISEND1.EQ.N3) THEN
         WRITE (TEXT,500)
         NUMBLD(1) = 1
         NUMBLD(8) = 1
         NUMBLD(16) = 1
         ISEND1 = 20
         CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, ISEND1,
     +                TEXT,
     +                BORDER)
         NUMBLD(1) = 0
         NUMBLD(8) = 0
         NUMBLD(16) = 0
         RETURN
      ENDIF      
C
C Part 1: See if we can find ghostscript and font/initialisation files
C -------
C     
      CALL X_OKCVAL (JSEND,
     +               ABORT)
      CALL W_CONFIG (MODE, NVAL,
     +               CVAL)
      CALL TRIML1(CVAL(8))
      CVAL(9) = BLANK!to suppress calculation of the -I argument
      L1 = N1
      L2 = LEN200 (CVAL(8))
      LSTART = N1
      LSTOP = L2   
      GS = BLANK
      GS(LSTART:LSTOP) = CVAL(8)(L1:L2)
      INQUIRE (FILE = GS, EXIST = THERE)
      IF (THERE) THEN
         GSOK = .TRUE.
      ELSE 
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         GS = BLANK
         GSOK = .FALSE.
      ENDIF      
C
C Part 2: Main branch point for cycling
C -------
C                                         
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Initialise
C
         PS2 = .FALSE.
         PS3 = .FALSE.
         PS4 = .FALSE.
         READY = .FALSE.
         FILE1 = BLANK
         FILE2 = BLANK
         LINE = BLANK
         STRNG = DFOLT
         STRNG1 = TRIM100(STRNG)
         WRITE (TEXT,200) STRNG1
         NUMDEC = NUMOPT - N1
         NUMBLD(1) = 1
         NUMBLD(4) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0 
C
C If NUMDEC = 1 then check that the GS executable has been found
C         
         IF (NUMDEC.EQ.N1) THEN 
            IF (GSOK) THEN
               OK = .TRUE.
            ELSE      
               WRITE (LINE,100)
               CALL PUTFAT (LINE)
               NUMDEC = N0 
               OK = .FALSE.
            ENDIF   
         ELSE
            OK = .FALSE.   
         ENDIF    
         IF (OK) THEN
C
C If OK then try to get a file
C
            CALL GETNOU (NIN)
            IF (SUPPLY) THEN 
               INQUIRE (FILE = FNAME, EXIST = THERE)
               IF (THERE) THEN
                  ABORT = .FALSE.
                  FILE1 = FNAME
                  OPEN (UNIT = NIN, FILE = FILE1) 
               ELSE   
                  ABORT = .TRUE.
               ENDIF   
            ELSE   
               CALL OFILES (ISEND, NIN, 
     +                      FILE1,
     +                      ABORT)
            ENDIF
            IF (ABORT) THEN 
               CLOSE (UNIT = NIN)
               NUMDEC = N0
               OK = .FALSE.
            ELSE   
C
C Is the filename long enough ?
C                         
               CALL TRIML1 (FILE1)
               L2 = LEN200 (FILE1)
               IF (L2.LT.N4) THEN  
                  WRITE (LINE,300)
                  CALL PUTFAT (LINE)
                  CLOSE (UNIT = NIN)
                  NUMDEC = N0
                  OK = .FALSE.
               ENDIF
C
C Is it a .ps or .eps file ?
C                      
               IF (OK) THEN   
                  L1 = L2 - N2
                  WORD3 = FILE1(L1:L2) 
                  CALL UCASE1 (WORD3)
                  IF (WORD3.EQ.'.PS') THEN
                     PS2 = .TRUE.
                     READY = .TRUE.
                  ENDIF
                  IF (.NOT.READY) THEN
                     L1 = L1 - N1
                     WORD4 = FILE1(L1:L2)
                     CALL UCASE1 (WORD4)
                     IF (WORD4.EQ.'.EPS') THEN
                        PS3 = .TRUE.
                        READY = .TRUE.
                     ENDIF
                  ENDIF      
                  IF (.NOT.READY .AND. L1.GT.N1) THEN
                     L1 = L1 - N1
                     WORD5 = FILE1(L1:L2)
                     CALL UCASE1 (WORD5)
                     IF (WORD5.EQ.'.EPSF' .OR. WORD5.EQ.'.EPSI') THEN
                        PS4 = .TRUE.
                        READY = .TRUE.
                     ENDIF
                  ENDIF
                  IF (.NOT.READY) THEN 
                     WRITE (LINE,300)
                     CALL PUTFAT (LINE)
                     CLOSE (UNIT = NIN)
                     NUMDEC = N0
                     OK = .FALSE.
                  ENDIF 
               ENDIF
C
C Does the file start with %!, etc. ?
C                
               IF (OK) THEN 
                  CALL PS2CHK (NIN,
     +                         X1, X2, Y1, Y2, 
     +                         TFILE,
     +                         ABORT)
                  CLOSE (UNIT = NIN)
                  IF (ABORT) THEN 
                     WRITE (LINE,300)
                     CALL PUTFAT (LINE)
                     CALL DELEET (TFILE, 
     +                            ASKIF, THERE)
                     NUMDEC = N0
                     OK = .FALSE.
                  ENDIF
               ENDIF
            ENDIF   
         ENDIF
         IF (OK) THEN      
C         
C NUMDEC = 1: file seems OK
C =========================
C
            STRNG = DFOLT
C
C Step 2: Define output file...inputfile.ps or inputfile.eps become outputfile.png
C                      
            TEMP = FILE1
            CALL LINUX2 (GS, TEMP)
            L2 = LEN200 (TEMP)  
            L1 = N1
            IF (PS2) THEN
               L2 = L2 - N2
            ELSEIF (PS3) THEN
               L2 = L2 - N3  
            ELSEIF (PS4) THEN
               L2 = L2 - N4 
            ENDIF
            FILE2 = '"'//TEMP(L1:L2)//'svg"' 
C
C Step 3: Build up the command line... -I<> if not a Linux binary 
C
            LINE = BLANK   
            IF (.NOT.LINUX3(GS) .AND. CVAL(9).NE.BLANK) THEN            
               LSTART = N1
               LSTOP = LSTART + N1
               LINE(LSTART:LSTOP) = '-I'
               L1 = N1
               L2 = LEN200(CVAL(9))
               LSTART = LSTOP + N1
               LSTOP = LSTOP + L2
               LINE(LSTART:LSTOP) = CVAL(9)(L1:L2)
               LSTART = LSTOP + N1
               LSTOP = LSTART
               LINE(LSTART:LSTOP) = BLANK
            ENDIF   
C
C Step 4: Build up the command line...add the string
C
            L1 = N1
            L2 = LEN200 (STRNG)
            LSTART = LSTOP + N1
            LSTOP = LSTART + L2 - N1
            LINE(LSTART:LSTOP) = STRNG(L1:L2)
C
C Step 5: Build up the command line...add the device
C
            LSTART = LSTOP + N1
            LSTOP = LSTART + N13
            LINE(LSTART:LSTOP) = ' -sDEVICE=svg'
C            
C Step 6: Build up the command line...name the output file
C
            LSTART = LSTOP + N1
            LSTOP = LSTART + N12
            LINE(LSTART:LSTOP) = '-sOutputFile='
            L1 = N1
            L2 = LEN200 (FILE2)
            LSTART = LSTOP + N1
            LSTOP = LSTART + L2 - N1
            LINE(LSTART:LSTOP) = FILE2(L1:L2)
            LSTART = LSTOP + N1
            LSTOP = LSTART
            LINE(LSTART:LSTOP) = BLANK
C
C Step 7: Build up the command line...add the input filename
C
            L1 = N1
            L2 = LEN200 (TFILE)
            LSTART = LSTOP + N1
            LSTOP = LSTART + L2 - N1
            LINE(LSTART:LSTOP) = TFILE(L1:L2)
C
C Step 8: Use STARTP to fire up Ghostscript
C                
            LINE = ADJUSTL (LINE)                
            CALL STARTP (GS, LINE)
            CALL DELEET (TFILE,
     +                   ASKIF, THERE)
            CALL INFOGS (N2,
     +                   FILE2) 
     
C
C Repair SVG files from early ghostscript versions (< 9.08)
C     
            CALL SVGREP (NUMERR,
     +                   FILE2,
     +                   ABORT) 
            IF (ABORT) CALL PUTADV (         
     +'There may be errors in the *.SVG file that SIMFIT cannot repair')              
           
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: help
C ===========
C         
            WRITE (TEXT,400)
            NUMBLD(12) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                TEXT,
     +                BORDER)
            NUMBLD(12) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: quit
C ================
C         
            REPEET = .FALSE.   
         ENDIF  
      ENDDO
  100 FORMAT (
     +'Cannot find Ghostscript, e.g. gswin64c.exe ... configure')    
  200 FORMAT (
     + 'Creating .svg files from .eps files'
     +/
     +/'The current ghostscript command line argument is:'
     +/A
     +/
     +/'Create a .svg file (-sDEVICE=svg)'
     +/'Help'
     +/'Cancel') 
  300 FORMAT (
     +'Not a valid (.ps,.eps, or .epsf) Encapsulated PostScript file')   
  400 FORMAT (
     + 'PostScript files are the best graph files for scientific plots'
     +/'but sometimes it is necessary to transform into other formats'
     +/'despite the associated loss of quality. Normal .bmp files are'
     +/'too large and, for the Internet, a compressed bitmap format may'
     +/'be required. For scientific plots, GIF and PNG files are better'
     +/'than JPEG or TIFF, but scaleable vector graphics are now the'
     +/'recommended vector files. This program will read in a .eps file'
     +/'and build up a command line, so that Ghostscript can create a'
     +/'SVG file with the same name but with extension .svg, i.e.'
     +/'myfile.ps (or .eps) is unchanged, but myfile.svg is created.'
     +/
     +/'The following points should be noted'
     +/
     +/'1)`Simfit must be configured to use the Ghostscript executable'
     +/'2)`The .eps file supplied must be correctly formatted'
     +/'3)`There is no prompt for overwriting an existing myfile.svg'
     +/'4)`Scaleable vector graphics files (.svg) are now the standard'
     +/'  `scientific graphics files for use with the Web.'
     +/'5)`SVG files are XML based text files supported by the W3C and'
     +/'  `are recommended for maintaining the quality of .eps files.'
     +/'6)`Note: myfile.svg will tend to be be larger than myfile.eps'
     +/'  `and may not have quite such good line resolution or fonts.')
  500 FORMAT (
     + 'Using Ghostscript to generate SVG from EPS'
     +/
     +/'This option has now been discontinued, but it is intended to'
     +/'provide a direct Simfit option to perform this transformation'
     +/'eventually. However, there are already two other ways to get'
     +/'high quality vector SVG files from Simfit graphics.'
     +/
     +/'Creating SVG files directly'
     +/
     +/'Once a graph has been displayed it is possible to choose the'
     +/'[Win] or [Windows] option and then select the SVG procedure.'
     +/'This causes the graph to be redrawn, but with the graphics' 
     +/'instructions being written to a chosen SVG file instead of the'
     +/'display.'
     +/
     +/'Using Gsview'
     +/
     +/'Versions of Gsview from 6 onwards can be obtained from Artifex'
     +/'Software under license and will perform transformation of'
     +/'Simfit EPS files into various graphics formats including SVG.')
      END
C
C
     
c
c
      subroutine svgrep (numerr, 
     +                   fname_in,
     +                   abort)
c
c action: repair possibly deficient svg files from earlier versions of ghostscript 
c author: w.g.bardsley, university of manchester, u.k., 11/05/2013
c
c numerr: -1 if error opening fname_in, o/w numerr = number of errors
c  fname: svg file 
c  abort: error indicator
c
c Note: surrounding double quotes are stripped from filenames 
c       this subroutine will not be required for ghostscript > 9.07 which should
c       always return numerr = 0 and abort = .false,
c       for earlier versions it should return numerr > 0 but with abort = .false. 
c       indicating successful repair 
c       numerr > 0 with abort = .true. indicates failure to repair
c
     
      implicit none
c
c argument
c            
      integer,                intent (out) :: numerr   
      character (len = 1024), intent (in)  :: fname_in
      logical,                intent (out) :: abort 
c
c locals
c      
      integer    i, ios, k
      integer    nin, nout
      character (len = 1   ) blank, dquote, hash, quote
      parameter (blank = " ", dquote = '"', hash = "#", quote = "'")
      character (len = 2   ) word2, test
      character (len = 6   ) fill
      parameter (fill = ' fill=')
      character (len = 7   ) part2
      character (len = 20  ) part1
      character (len = 1024) part3
      character (len = 1024) fname, temp_file
      character (len = 4096) line
      logical    askif, read_only, there 
      parameter (askif = .false.)
      external   attrib, deleet, getnou, gettmp, triml1
      intrinsic  index
c
c initialise numerr and abort then check that fname exists and is not read_only
c      
      numerr = -1
      abort = .true.
c
c remove quotes if any
c       
      fname = fname_in
      i = index(fname,dquote)
      if (i.gt.0) then
         fname(i:i) = blank
         i = index(fname,dquote)
         if (i.gt.0) fname(i:i) = blank  
      endif   
      call triml1 (fname)
      call attrib (fname,
     +             there, read_only)
      if (.not.there) return
c
c check if the file needs repairing
c
      call getnou (nin)
      open (unit = nin, file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nin)
         return
      endif  
      numerr = 0
      test = quote//hash
      do while (ios.eq.0 .and. numerr.eq.0)
         read (nin,'(a)',iostat=ios) line 
         if (ios.eq.0) then
            k = len_trim(line)
            if (k.ge.21) then
               word2 = line(20:21) 
               if (word2.eq.test) then
                  ios = 1
                  numerr = 1
                  exit
               endif   
            endif     
         endif   
      enddo
      close (unit = nin)
      if (numerr.eq.0) then
c
c the file does not need repairing
c        
         abort = .false.
         return
      elseif (read_only) then
c
c the file is deficient but cannot be repaired
c      
         return   
      endif  
c
c repair is needed so get a temporary file then connect units nin and nout 
c        
      call gettmp (ios,
     +             temp_file)
      if (ios.ne.0) return
      call getnou (nout)
      open (unit = nout, file = temp_file, iostat = ios)
      if (ios.ne.0) then
          close (unit = nout)
          return
      endif  
      call getnou (nin)
      open (unit = nin, file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nin)
         close (unit = nout)
         return
      endif  
c
c copy fname into temp_file making corrections if required
c         
      numerr = 0
      do while (ios.eq.0)
         read (nin,'(a)',iostat=ios) line 
         if (ios.eq.0) then
            k = len_trim(line)
            if (k.ge.21) then
               word2 = line(20:21) 
               if (word2.eq.test) then
                  numerr = numerr + 1
                  if (k.lt.28) then
                     close (unit = nin)
                     close (unit = nout)
                     return
                  else   
                     part1 = line(1:20)
                     part2 = line(21:27)
                     part3 = line(28:k)
                     line = part1//fill//quote//part2//quote//part3
                     k = len_trim(line)
                  endif   
               endif
            endif   
            write (nout,'(a)',iostat=ios) line(1:k)
         endif   
      enddo
      close (unit = nin)
      close (unit = nout)
      if (numerr.eq.0) then
c
c corrections are not required but this should have already been trapped
c        
         call deleet (temp_file,
     +                askif, there)         
         abort = .false.
         return
      else
c
c copy the corrected file into the original file
c        
         call deleet (fname,
     +                askif, there) 
         if (there) then
            return
         else
            call getnou (nout)
            open (unit = nout, file = fname, iostat = ios)
            if (ios.ne.0) then
               close (unit = nin)
               return
           endif
           call getnou (nin)
           open (unit = nin, file = temp_file, iostat = ios)
           if (ios.ne.0) then 
              close (unit = nin)
              close (unit = nout)  
              call deleet (temp_file,
     +                     askif, there)
              return
           else        
              do while (ios.eq.0)
                 read (nin,'(a)',iostat=ios) line
                 if (ios.eq.0) then
                    k = len_trim(line)
                    write (nout,'(a)',iostat=ios) line(1:k)
                 endif
              enddo      
              close (unit = nin)
              close (unit = nout)
              call deleet (temp_file,
     +                     askif, there)
              if (.not.there) abort = .false.             
           endif 
         endif             
      endif  
      end       
c
c
                






    
   