c
c
      subroutine ps_stretch (isend,
     +                       psfile,
     +                       abort)
c
c
c action: stretch a simfit ps file
c author: w.g.bardsley, university of manchester, u.k., 26/11/2002 
c         23/04/2007 added intents 
c
c         isend = 1: on entry then show the menu o/w use current defaults
c         psfile = file supplied which is overwritten by edited file
c         abort = .false. on return then overwriting has occurred
c
c         Note: the local stretching, clipping and sliding arguments are
c                saved between calls
c
      implicit   none
c
c arguments
c      
      integer,             intent (in)  :: isend
      character (len = *), intent (in)  :: psfile
      logical,             intent (out) :: abort
c
c locals
c      
      integer    icount, ifail, ios, jcount, nin, nout
      integer    icolor, ix, iy, lshade, numdec, numopt, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 9,
     +           numtxt = 20)
      integer    numbld(numtxt), numpos(numopt)
      double precision x, xclip(2), y, yclip(2)
      double precision value
      double precision zero, one, two, bot, top, epsi
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00,
     +           bot = 0.1d+00, top = 100.0d+00, epsi = 0.01d+00)
      character  file1*1024, file2*1024, mssage*100
      character  cipher*40, line*1024, text(numtxt)*100
      logical    ok
      logical    portrait, slide
      logical    suppress
      logical    askif, border, read_only, repeet, there
      parameter (askif = .false., border = .false.)
      external   ps_stretch1, gettmp, deleet, getnou, attrib, getdm1,
     +           lbox02, patch1
      external   putfat$
      intrinsic  index
      save       x, xclip, y, yclip
      save       slide, suppress
      data       x, xclip, y, yclip / one, zero, one, one, zero, one /
      data       slide, suppress / .true., .false. /
      data       numpos / numopt*1 /
      data       numbld / numtxt*0 /
c
c See if the control has been suppressed
c
      if (suppress) return
c
c check that the file exists and is not read only
c
      call attrib (psfile, 
     +             there, read_only)
      if (.not.there) then
         call putfat$('File supplied to PS_STRETCH does not exist')
         return
      endif
      if (read_only) then
         call putfat$('File supplied to PS_STRETCH is read_only')
         return
      endif
      abort = .true.
      call gettmp (ifail,
     +             file1)
      if (ifail.ne.0) return
c
c menu
c
      if (isend.eq.1) then
         repeet = .true.
         numdec = numopt - 1
         do while (repeet)
            if (slide) then
               cipher = '(current = slide)'
            else
               cipher = '(current = not slide)'
            endif
            write (text,100) x, y, xclip(1), xclip(2),
     +                             yclip(1), yclip(2), cipher
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos, text)
            if (numdec.eq.1) then
               call getdm1 (bot, x, top, 'x-stretch factor')
            elseif (numdec.eq.2) then
               call getdm1 (bot, y, top, 'y-stretch factor')
            elseif (numdec.eq.3) then
               value = one - two*epsi
               call getdm1 (zero, xclip(1), value, 'x_clip low')
               value = xclip(1) + epsi
               call getdm1 (value, xclip(2), one, 'x_clip high')
            elseif (numdec.eq.4) then
               value = one - two*epsi
               call getdm1 (zero, yclip(1), value, 'y_clip low')
               value = yclip(1) + epsi
               call getdm1 (value, yclip(2), one, 'y_clip high')
            elseif (numdec.eq.5) then
               slide = .not.slide
            elseif (numdec.eq.6) then
               x = one
               xclip(1) = zero
               xclip(2) = one
               y = one
               yclip(1) = zero
               yclip(2) = one
               slide = .true.
            elseif (numdec.eq.7) then
               suppress = .true.
               return
            elseif (numdec.eq.8) then
               write (text,200)
               numbld(1) = 1
               numbld(5) = 1
               numbld(11) = 1
               numbld(18) = 1
               call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                      text,
     +                      border)
               numbld(1) = 0
               numbld(5) = 0
               numbld(11) = 0
               numbld(18) = 0
            else
               repeet = .false.
            endif
            numdec = numopt
         enddo
      endif
c
c copy psfile into file1 then get a name for file2
c
      call getnou (nin)
      open (unit = nin, file = psfile)
      call getnou (nout)
      open (unit = nout, file = file1)
      ok = .false.
      ios = 0
      do while (ios.eq.0)
         read (nin,'(a)',iostat=ios) line
         if (ios.eq.0) then
            write (nout,'(a)',iostat=ios) line
            if (.not.ok) then
c
c set ok = .true. only if %#portrait or %#landscape are read off the input file
c the ciphers %#portrait and %#landscape MUST NOT BE ALTERED in the next code
c
               if (index(line,'%#portrait').gt.0) then
                  ok = .true.
                  portrait = .true.
               endif
               if (.not.ok) then
                  if (index(line,'%#landscape').gt.0) then
                     ok = .true.
                     portrait = .false.
                  endif
               endif
            endif
         endif
      enddo
      close (unit = nin)
      close (unit = nout)
      if (.not.ok) then
         call putfat$('Not a SIMFIT .eps file >= v5.4 release 4.026')
         call deleet (file1, 
     +                askif, there)
         abort = .true.
         return
      endif
      call gettmp (ifail,
     +             file2)
      if (ifail.ne.0) return
c
c edit file1 to create file2
c
      call ps_stretch1 (icount, jcount,
     +                  x, xclip, y, yclip,
     +                  file1, file2, mssage,
     +                  abort, portrait, slide)
      if (abort) then
         write (line,300) icount, jcount, mssage
         call putfat$(line)
      else
c
c warn that editing has not occurred
c
         if (icount.eq.0) then
            mssage = 'Not a valid SIMFIT PostScript file'
            write (line,300) icount, jcount, mssage
            call putfat$(line)
         else
c
c delete psfile then copy file2 into original psfile
c
            call deleet (psfile, 
     +                   askif, there)
            if (there) return
            call getnou (nin)
            open (unit = nin, file = file2)
            call getnou (nout)
            open (unit = nout, file = psfile)
            ios = 0
            do while (ios.eq.0)
               read (nin,'(a)',iostat=ios) line
               if (ios.eq.0) write (nout,'(a)',iostat=ios) line
            enddo
         endif
         close (unit = nin)
         close (unit = nout)
      endif
c
c delete the temporary files
c
      call deleet (file1, 
     +             askif, there)
      call deleet (file2,
     +             askif, there)
c
c format stements
c     
  100 format (
     + 'Change x_stretch (current =',f8.4,')'
     +/'Change y_stretch (current =',f8.4,')'
     +/'Change x_clip (current =',f8.4,',',f8.4,')'
     +/'Change y_clip (current =',f8.4,',',f8.4,')'
     +/'Change slide status',1x,a
     +/'Default parameters: restore'
     +/'Default parameters: use from now on'
     +/'Help'
     +/'Apply')
  200 format (
     + 'Stretching, clipping and sliding overcrowded graphs'
     +/'The plot is ready for printing or saving to file, but editing'
     +/'is possible where symbols or labels overlap. You can switch off'
     +/'these options and use defaults for the rest of the current run.'
     +/'Stretching'
     +/'You can stretch the x and y axes in such a way that symbols and'
     +/'text retain original aspect ratios, by defining x_stretch and'
     +/'y_stretch. This differs from scaling in that only empty space'
     +/'between graphical objects is altered and is used when there are'
     +/'too many points as in time series, or labels as in dendrograms.'
     +/'Clipping.'
     +/'By defining x_clip and y_clip, stretched plots can be cut into'
     +/'sub-graphs, e.g. x_stretch = 2, y_stretch = 1, xclip = (0,0.5),'
     +/'y_clip = (0,1) would isolate the first half of the plot, but'
     +/'with x_clip = (0.5,1) and y_clip = (0,1) the second half of the'
     +/'graph would be isolated. This is useful where it is wished to'
     +/'plot a dendrogram as disjoint sub-graph sections.'
     +/'Sliding'
     +/'After stretching and clipping, sliding can be selected to slide'
     +/'sub-graphs into a suitable position for printing.')
  300 format ('lines edited =',i4,', lines read =',i5,' ... ',a)
      end
c
c
