c
c
      subroutine ps_stretch1 (icount, jcount,
     +                        x, xclip, y, yclip,
     +                        file1, file2, mssage,
     +                        abort, portrait, slide)
c
c
c action: stretch a simfit ps file
c author: w.g.bardsley, university of manchester, u.k., 22/11/2002 
c         23/04/2007 added intents
c
c         icount = returned as number of lines stretched
c         jcount = returned as number of lines read off file1
c         x, y = supplied as stretching factors
c         xclip, yclip = supplied as clipping factors
c         file1 = supplied as input file (unchanged)
c         file2 = supplied to receive stretched file
c         mssage = returned as error message if any
c         abort = returned as .true. if successful o/w .false.
c         portrait = supplied as orientation
c         slide = supplied as .true. then translate
c
      implicit   none 
c
c arguments
c      
      integer,             intent (out) :: icount, jcount 
      double precision,    intent (in)  :: x, xclip(2), y, yclip(2)
      character (len = *), intent (in)  :: file1, file2
      character (len = *), intent (out) :: mssage 
      logical,             intent (in)  :: portrait, slide
      logical,             intent (out) :: abort
c
c locals
c      
      integer    ios1, ios2, nbbox, nhash, nin, nout, ntype, nval
      double precision zero
      parameter (zero = 0.0d+00)
      character  line1*1024, line2*1024
      character  blank*1, pchash*2, word1*1, word2*2, word3*3, word14*14
      parameter (blank = ' ', pchash = '%#')
      external   getnou, ps_stretch2, triml1
      intrinsic  index
c
c initialise then open nin and nout
c
      abort = .false.
      icount = 0
      jcount = 0
      mssage = blank
      nbbox = 0
      call getnou (nin)
      open (unit = nin, file = file1, iostat = ios1)
      call getnou (nout)
      open (unit = nout, file = file2, iostat = ios2)
      do while (ios1.eq.0 .and. ios2.eq.0)
         read (nin,'(a)',iostat=ios1) line1
         if (ios1.ne.0) then
            close (unit = nin)
            close (unit = nout)
            return
         endif
c
c increment jcount then look for '%#'
c
         jcount = jcount + 1
         if (nbbox.eq.0) then
            call triml1 (line1)
            word14 = line1(1:14)
            if (word14.eq.'%%BoundingBox:') then
               nbbox = 1
               nhash = 100
            else
               nhash = index(line1,pchash)
            endif
         else
            nhash = index(line1,pchash)
         endif
         if (nhash.le.2) then
c
c normal line so just copy
c
            line2 = line1
         else
c
c a %# line so process
c
            ntype = 0
            nval = 0
            word1 = line1(nhash + 2:nhash + 2)
            word2 = line1(nhash + 2:nhash + 3)
            word3 = line1(nhash + 2:nhash + 4)
            if (nbbox.eq.1) then
c
c 1: BoundingBox so set nbbox = 2 so no embedded bounding boxes will count
c
               nbbox = 2
               ntype = 1
            elseif (word3.eq.'cli') then
c
c 2: Clipping
c
               ntype = 2
            elseif (slide .and. word3.eq.'por' .or. word3.eq.'lan') then
c
c 3: Shape if slide = .true. and xclip(1) > 0 and yclip(1) > 0
c
               if (xclip(1).gt.zero .or. yclip(1).gt.zero) then
                  ntype = 3
               else
                  ntype = 0
               endif
            elseif (word1.eq.'2') then
c
c 4: 2 variables
c
               ntype = 4
               nval = 2
            elseif (word1.eq.'4') then
c
c 4: 4 variables
c
               ntype = 4
               nval = 4
            elseif (word1.eq.'6') then
c
c 4: 6 variables
c
               ntype = 4
               nval = 6
            elseif (word1.eq.'8') then
c
c 4: 8 variables
c
               ntype = 4
               nval = 8
            elseif (word2.eq.'10') then
c
c 4: 10 variables
c
               ntype = 4
               nval = 10
            elseif (word2.eq.'12') then
c
c 4: 12 variables
c
               ntype = 4
               nval = 12
            elseif (word2.eq.'14') then
c
c 4: 14 variables
c
               ntype = 4
               nval = 14
            elseif (word2.eq.'()') then
c
c 5: () 2 variables
c
               ntype = 5
               nval = 2
            elseif (word3.eq.'tit') then
c
c 6: ti 2 variables ... title
c
               ntype = 6
               nval = 2
            elseif (word3.eq.'x l' .or. word3.eq.'xle') then
c
c 7: xl 2 variables ... xlegend
c
               ntype = 7
               nval = 2
            elseif (word3.eq.'y l' .or. word3.eq.'yle') then
c
c 8: yl 2 variables ... ylegend
c
               ntype = 8
               nval = 2
            elseif (word3.eq.'z l' .or. word3.eq.'zle') then
c
c 9: zl 2 variables ... zlegend
c
               ntype = 9
               nval = 2
            elseif (word3.eq.'str' .or. word3.eq.'tex') then
c
c 10: st 2 variables string
c
               ntype = 10
               nval = 2
            endif
            if (ntype.gt.0) then
c
c a type has been identified so proceed to stretch the x, y coordinates
c
               icount = icount + 1
               call ps_stretch2 (nhash, ntype, nval,
     +                           x, xclip, y, yclip,
     +                           line1, line2, mssage,
     +                           abort, portrait, slide)
               if (abort) then
                  close (unit = nin)
                  close (unit = nout)
                  return
               endif
            else
               line2 = line1
            endif
         endif
         write (nout,'(a)',iostat=ios2) line2
      enddo
c
c make sure the units are closed
c
      close (unit = nin)
      close (unit = nout)
      end
c
c
