c
c
      subroutine ps_stretch2 (nhash, ntype, nval,
     +                        x, xclip, y, yclip,
     +                        line1, line2, mssage,
     +                        abort, portrait, slide)
c
c
c action: format a simfit ps line ending in %#
c author: w.g.bardsley, university of manchester, u.k., 22/11/2002   
c         23/04/2007 added intents 
c
c         nhash = supplied as start position for '%#' in line1
c         ntype = supplied as type of string
c         x, y = supplied as stretch factors
c         line1 = line supplied
c         line2 = line returned
c         mssage = returtned as error message if any
c         abort = returned as success/failure of stretching
c         portrait = supplied as orientation
c         slide = supplied as translate ?
c
      implicit   none  
c
c arguments
c      
      integer,             intent (inout) :: nhash
      integer,             intent (in)    :: ntype, nval  
      double precision,    intent (in)    :: x, xclip(2), y, yclip(2) 
      character (len = *), intent (inout) :: line1
      character (len = *), intent (out)   :: line2, mssage
      logical,             intent (out)   :: abort
      logical,             intent (in)    :: portrait, slide
c
c locals
c      
      integer    ios, ix(7), ixbb(4), iy(7), iybb(4)
      integer    i, i1, i2, j, k, lstore
      double precision xstart, xstop, ystart, ystop
      double precision xdelta, xdiff, xtemp, ydelta, ydiff, ytemp
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character  line3*1024, store*1024, temp*1024, word12*12
      character  blank*1, blank2*2, hash*1, letter*1
      parameter (blank = ' ', blank2 = '  ', hash = '#')
      logical    notyet
      intrinsic  dble, nint, index, len, ichar
      save       xstart, xstop, ystart, ystop
      save       ixbb, iybb
      data       xstart, xstop, ystart, ystop / zero, one, zero, one /
      data       ixbb, iybb / 0, 1, 1, 0, 0, 0, 1, 1 /
      abort = .false.
      mssage = blank
      line2 = blank
      line3 = line1
      if (ntype.eq.1) then
c
c ntype = 1: bounding box
c            used to define xstart, xstop, ystart, ystop
c
         j = index(line1,':')
         i1 = j + 1
         i2 = j
         k = len(line1)
         ios = 32
         notyet = .true.
         do while (notyet .and. j.lt.k)
            j = j + 1
            ios = ichar(line1(j:j))
            if (ios.eq.32 .or. (ios.ge.48 .and. ios.le.57)) then
               i2 = i2 + 1
            else
               notyet = .false.
               j = k
            endif
         enddo
         temp = line1(i1:i2)
         read (temp,*,iostat=ios) ix(1), iy(1), ix(2), iy(2)
         if (ios.eq.0) then
            if (portrait) then
c
c code for portrait bounding box
c
               xstart = dble(ix(1))
               xstop = dble(ix(2))
               xdiff = xstop - xstart
               ystart = dble(iy(1))
               ystop = dble(iy(2))
               ydiff = ystop - ystart
               ix(2) = ix(1) + nint(x*xdiff)
               iy(2) = iy(1) + nint(y*ydiff)
               if (xclip(1).gt.zero .or. xclip(2).lt.one .or.
     +            yclip(1).gt.zero .or. yclip(2).lt.one) then
c
c adjust for clipping
c
                  xstop = dble(ix(2))
                  ystop = dble(iy(2))
                  xdiff = xstop - xstart
                  ydiff = ystop - ystart
                  xdelta = xdiff*xclip(1)
                  ix(1) = ix(1) + nint(xdelta)
                  xdelta = xdiff*(one - xclip(2))
                  ix(2) = ix(2) - nint(xdelta)
                  ydelta = ydiff*yclip(1)
                  iy(1) = iy(1) + nint(ydelta)
                  ydelta = ydiff*(one - yclip(2))
                  iy(2) = iy(2) - nint(ydelta)
                  if (slide) then
c
c slide back to original start position
c
                     xdelta = xclip(1)*xdiff
                     ydelta = yclip(1)*ydiff
                     ix(1) = ix(1) - nint(xdelta)
                     ix(2) = ix(2) - nint(xdelta)
                     iy(1) = iy(1) - nint(ydelta)
                     iy(2) = iy(2) - nint(ydelta)
                  endif
               endif
            else
c
c code for landscape bounding box
c
               xstart = dble(ix(1))
               xstop = dble(ix(2))
               xdiff = xstop - xstart
               ystart = dble(iy(1))
               ystop = dble(iy(2))
               ydiff = ystop - ystart
               ix(1) = ix(2) - nint(y*xdiff)
               iy(2) = iy(1) + nint(x*ydiff)
               if (xclip(1).gt.zero .or. xclip(2).lt.one .or.
     +             yclip(1).gt.zero .or. yclip(2).lt.one) then
c
c adjust for clipping
c
                  xstart = dble(ix(1))
                  ystop = dble(iy(2))
                  xdiff = xstop - xstart
                  ydiff = ystop - ystart
                  xdelta = xdiff*(one - yclip(2))
                  ix(1) = ix(1) + nint(xdelta)
                  xdelta = xdiff*yclip(1)
                  ix(2) = ix(2) - nint(xdelta)
                  ydelta = ydiff*xclip(1)
                  iy(1) = iy(1) + nint(ydelta)
                  ydelta = ydiff*(one - xclip(2))
                  iy(2) = iy(2) - nint(ydelta)
                  if (slide) then
c
c slide back to original start position
c
                     xdelta = yclip(1)*xdiff
                     ydelta = xclip(1)*ydiff
                     ix(1) = ix(1) + nint(xdelta)
                     ix(2) = ix(2) + nint(xdelta)
                     iy(1) = iy(1) - nint(ydelta)
                     iy(2) = iy(2) - nint(ydelta)
                  endif
               endif
            endif
            ixbb(1) = ix(1)
            ixbb(2) = ix(2)
            ixbb(3) = ixbb(2)
            ixbb(4) = ixbb(1)
            iybb(1) = iy(1)
            iybb(2) = iybb(1)
            iybb(3) = iy(2)
            iybb(4) = iybb(3)
            write (line2,100) ix(1), iy(1), ix(2), iy(2)
         else
            abort = .true.
            mssage = 'Failure to adjust BoundingBox:'
         endif
         return
      endif
      if (ntype.eq.2) then
c
c ntype = 2: clipping
c
         i1 = 1
         i2 = nhash - 1
         temp = line1(i1:i2)
         read (temp,*,iostat=ios) ix(1), iy(1), ix(2), iy(2),
     +                            ix(3), iy(3), ix(4), iy(4)
         if (ios.eq.0) then
            write (line2,200) ixbb(1), iybb(1), ixbb(2), iybb(2),
     +                        ixbb(3), iybb(3), ixbb(4), iybb(4)
         else
            abort = .true.
            mssage = 'Failure to adjust clipping coordinates'
         endif
         return
      endif
c
c ntype = 3: translate if slide = .true. and xclip(1) > 0 and yclip(1) > 0
c
      if (ntype.eq.3) then
         i1 = 1
         i2 = index(line1,'translate') - 1
         if (i2.ge.3) then
            temp = line1(i1:i2)
            read (temp,*,iostat=ios) xtemp, ytemp
         else
            ios = -1
         endif
         if (ios.eq.0) then
            if (portrait) then
               xdelta = xclip(1)*(xstop - xstart)
               xtemp = xtemp - xdelta
               ydelta = yclip(1)*(ystop - ystart)
               ytemp = ytemp - ydelta
            else
               xdelta = yclip(1)*(xstop - xstart)
               xtemp = xtemp + xdelta
               ydelta = xclip(1)*(ystop - ystart)
               ytemp = ytemp - ydelta
            endif
            write (line2,300) xtemp, ytemp, line1(i2:nhash - 1)
         else
            abort = .true.
            mssage = 'Failure to read data with NTYPE = 3'
         endif
         return
      endif
c
c all cases except ntype = 10, strip any leading blanks and pack with '#'
c
      if (ntype.ne.10) then
         letter = line1(1:1)
         do while (letter.eq.blank)
            do i = 1, nhash - 2
               line1(i:i) = line1(i + 1:i + 1)
            enddo
            nhash = nhash - 1
            letter = line1(1:1)
         enddo
         do i = nhash, len(line1)
            line1(i:i) = hash
         enddo
      endif
      if (ntype.eq.4) then
c
c ntype = 4: simple numbers so suppress all multiple blanks
c
         j = index(line1,blank2)
         do while (j.gt.0)
            do i = j + 1, nhash - 2
               line1(i:i) = line1(i + 1:i + 1)
            enddo
            nhash = nhash - 1
            line1(nhash:nhash) = hash
            j = index(line1,blank2)
         enddo
c
c find i = string position after nval integers have been read
c
         i = 0
         j = 0
         do while (j.lt.nval)
           i = i + 1
           if (line1(i:i).eq.blank .or. line1(i:i).eq.hash) j = j + 1
         enddo
         i1 = 1
         i2 = i - 1
         temp = line1(i1:i2)
c
c read and adjust the integers
c
         if (nval.eq.2) then
            read (temp,*,iostat=ios) ix(1), iy(1)
         elseif (nval.eq.4) then
            read (temp,*,iostat=ios) ix(1), iy(1), ix(2), iy(2)
         elseif (nval.eq.6) then
            read (temp,*,iostat=ios) ix(1), iy(1), ix(2), iy(2),
     +                               ix(3), iy(3)
         elseif (nval.eq.8) then
            read (temp,*,iostat=ios) ix(1), iy(1), ix(2), iy(2),
     +                               ix(3), iy(3), ix(4), iy(4)
         elseif (nval.eq.10) then
            read (temp,*,iostat=ios) ix(1), iy(1), ix(2), iy(2),
     +                               ix(3), iy(3), ix(4), iy(4),
     +                               ix(5), iy(5)
         elseif (nval.eq.12) then
            read (temp,*,iostat=ios) ix(1), iy(1), ix(2), iy(2),
     +                               ix(3), iy(3), ix(4), iy(4),
     +                               ix(5), iy(5), ix(6), iy(6)
         elseif (nval.eq.14) then
            read (temp,*,iostat=ios) ix(1), iy(1), ix(2), iy(2),
     +                               ix(3), iy(3), ix(4), iy(4),
     +                               ix(5), iy(5), ix(6), iy(6),
     +                               ix(7), iy(7)
         endif
         if (ios.eq.0) then
            do i = 1, nval/2
               ix(i) = nint(x*dble(ix(i)))
               iy(i) = nint(y*dble(iy(i)))
            enddo
            i1 = i2 + 1
            i2 = nhash - 1
            if (nval.eq.2) then
               write (line2,302) ix(1), iy(1), line1(i1:i2)
            elseif (nval.eq.4) then
               write (line2,304) ix(1), iy(1), ix(2), iy(2),
     +                           line1(i1:i2)
            elseif (nval.eq.6) then
               write (line2,306) ix(1), iy(1), ix(2), iy(2),
     +                           ix(3), iy(3), line1(i1:i2)
            elseif (nval.eq.8) then
               write (line2,308) ix(1), iy(1), ix(2), iy(2),
     +                           ix(3), iy(3), ix(4), iy(4),
     +                           line1(i1:i2)
            elseif (nval.eq.10) then
               write (line2,310) ix(1), iy(1), ix(2), iy(2),
     +                           ix(3), iy(3), ix(4), iy(4),
     +                           ix(5), iy(5), line1(i1:i2)
            elseif (nval.eq.12) then
               write (line2,312) ix(1), iy(1), ix(2), iy(2),
     +                           ix(3), iy(3), ix(4), iy(4),
     +                           ix(5), iy(5), ix(6), iy(6),
     +                           line1(i1:i2)
            elseif (nval.eq.14) then
               write (line2,314) ix(1), iy(1), ix(2), iy(2),
     +                           ix(3), iy(3), ix(4), iy(4),
     +                           ix(5), iy(5), ix(6), iy(6),
     +                           ix(7), iy(7), line1(i1:i2)
            endif
         else
            abort = .true.
            mssage = 'Failure to read data with NTYPE = 3'
         endif
         return
      endif
      if (ntype.ge.5 .and. ntype.le.9) then
c
c ntype = 5, 6, 7, 8, 9 (...) then 2 numbers
c
         i = nhash
         lstore = 0
         do while (lstore.eq.0)
c
c find the last ')', store text up to this point, then shuffle
c
            i = i - 1
            if (line1(i:i).eq.')') lstore = i
         enddo
         store(1:lstore) = line1(1:lstore)
         do i = 1, nhash - 1
            line1(i:i) = line1(i + lstore:i + lstore)
         enddo
         nhash = nhash - lstore
c
c strip out any leading blanks from the shuffled line1
c
         letter = line1(1:1)
         do while (letter.eq.blank)
            do i = 1, nhash - 2
               line1(i:i) = line1(i + 1:i + 1)
            enddo
            nhash = nhash - 1
            line1(nhash:nhash) = hash
            letter = line1(1:1)
         enddo
c
c suppress any multiple blanks
c
         j = index(line1,blank2)
         do while (j.gt.0)
            do i = j + 1, nhash - 2
               line1(i:i) = line1(i + 1:i + 1)
            enddo
            nhash = nhash - 1
            line1(nhash:nhash) = hash
            j = index(line1,blank2)
         enddo
c
c find the point after nval integers
c
         i = 0
         j = 0
         do while (j.lt.nval)
           i = i + 1
           if (line1(i:i).eq.blank .or. line1(i:i).eq.hash) j = j + 1
         enddo
         i1 = 1
         i2 = i - 1
         temp = line1(i1:i2)
         read (temp,*,iostat=ios) ix(1), iy(1)
         if (ios.eq.0) then
            i1 = i2 + 1
            i2 = nhash - 1
            ix(1) = nint(x*dble(ix(1)))
            iy(1) = nint(y*dble(iy(1)))
            if (ntype.eq.5) then
               write (line2,400) store(1:lstore), ix(1), iy(1),
     +                           line1(i1:i2)
            elseif (ntype.eq.6) then
               write (line2,402) store(1:lstore), ix(1), iy(1),
     +                           line1(i1:i2)
            elseif (ntype.eq.7) then
               write (line2,404) store(1:lstore), ix(1), iy(1),
     +                           line1(i1:i2)
            elseif (ntype.eq.8) then
               write (line2,406) store(1:lstore), ix(1), iy(1),
     +                           line1(i1:i2)
            elseif (ntype.eq.9) then
               write (line2,408) store(1:lstore), ix(1), iy(1),
     +                           line1(i1:i2)
            endif
         else
            abort = .true.
            mssage = 'Failure to read data with NTYPE = 4,5,6,7,or 8'
         endif
         return
      endif
c
c ntype = 10: extra character string
c
      if (ntype.eq.10) then
         i1 = 0
         i2 = 0
         do i = 1, nhash - 1
            letter = line1(i:i)
            if (letter.eq.'S') then
               i1 = i
            elseif (letter.eq.'M') then
               i2 = i
            endif
         enddo
         if (i1.ge.16 .and. (i2 - i1).ge.3) then
            temp = line1(i1 + 1:i2 - 1)
            read (temp,*,iostat=ios) ix(1), iy(1)
         else
            ios = -1
         endif
         if (ios.eq.0) then
            ix(1) = nint(x*dble(ix(1)))
            iy(1) = nint(y*dble(iy(1)))
            write (word12,'(2i6)') ix(1), iy(1)
            write (line2,500) line1(1:i1), word12, line1(i2:nhash - 1)
            return
         else
            abort = .true.
            mssage = 'Failure to read data with NTYPE = 9'
         endif
      endif
c
c just copy if the format is not recognised for any reason
c
      line2 = line3
c
c these format statements must NOT be edited
c      
  100 format ('%%BoundingBox:',4i6)
  200 format (8i6,'%#clipping coordinates')
  300 format (2f8.2,' ',a,'%#shape')
  302 format (2i6,a,'%#2')
  304 format (4i6,a,'%#4')
  306 format (6i6,a,'%#6')
  308 format (8i6,a,'%#8')
  310 format (10i6,a,'%#10')
  312 format (12i6,a,'%#12')
  314 format (14i6,a,'%#14')
  400 format (a,2i6,a,'%#()2')
  402 format (a,2i6,a,'%#title')
  404 format (a,2i6,a,'%#x legend')
  406 format (a,2i6,a,'%#y legend')
  408 format (a,2i6,a,'%#z legend')
  500 format (a,' ',a,' ',a,'%#string')
      end
c
c
