C
C
      SUBROUTINE PSCOLR$(ISEND, JCOLOR, NOUT_PS,
     +                   BLUE, GREEN, RED)
C
C ACTION : Postscript colour palette
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 21/8/95   
C          19/03/2007 introduced call to PSCOL1$ and altered call with ISEND = 2
C
C ADVICE : NCOLOR must agree with the value in PSCOL1$
C          ISEND = 1 : set/change background     (JCOLOR)
C          ISEND = 2 : set palette               (BLUE, GREEN, RED)
C          ISEND = 3 : write to file header      (NOUT_PS)
C          ISEND = 4 : check/change colour       (JCOLOR, NOUT_PS)
C          ISEND = 5 : close down/re-initialise
C
C          26/2/97 Win32 version ... restored 0 and 15
C          ============================================
C CAUTION : The PS file now has 0 = black and 15 = white. This version
C           does not interchange 0 and 15  to be consistent with the
C           other Win32 graphics functions.  
C
C 
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: ISEND, JCOLOR, NOUT_PS 
      DOUBLE PRECISION, INTENT (IN) :: BLUE(*), GREEN(*), RED(*)
C
C Locals
C      
      INTEGER    N0, N1, N2, N8, N15, NCOLOR
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N8 = 8, N15 = 15, NCOLOR = 72)
      INTEGER    I, ISAV, J, JSAV, K
      DOUBLE PRECISION BSAV(NCOLOR), GSAV(NCOLOR), RSAV(NCOLOR)
      EXTERNAL   PSCOL1$
      SAVE       ISAV, JSAV
      DATA       ISAV, JSAV / N0, N15 / 
      IF (ISEND.EQ.1) THEN
C
C Store the background colour
C ... Only uses JCOLOR
C
         JSAV = JCOLOR
      ELSEIF (ISEND.EQ.2) THEN
C
C Store the default colour palette
C ... Only uses BLUE, GREEN, RED     
C ... Default colours are then stored in PSCOLR1$
C
         DO I = N1, NCOLOR
            BSAV(I) = BLUE(I)
            GSAV(I) = GREEN(I)
            RSAV(I) = RED(I)
         ENDDO 
         CALL PSCOL1$(N2,
     +                BSAV, GSAV, RSAV) 
      ELSEIF (ISEND.EQ.3) THEN
C
C Write colour details to file header
C ... Only uses NOUT_PS 
C ... Default colours are first retrieved from PSCOLR1$
C                          
         CALL PSCOL1$(N1,
     +                BSAV, GSAV, RSAV)         
         IF (JSAV.EQ.N15) THEN
            WRITE (NOUT_PS,100)
         ELSEIF (JSAV.EQ.N0) THEN
            WRITE (NOUT_PS,200)
         ELSE
            WRITE (NOUT_PS,300) RSAV(JCOLOR), GSAV(JCOLOR), BSAV(JCOLOR)
         ENDIF
         DO I = N0, NCOLOR - N1, N2
            J = I + N1
            K = I + N2
            IF (I.LE.N8) THEN
               WRITE (NOUT_PS,400) I, RSAV(J), GSAV(J), BSAV(J),
     +                             J, RSAV(K), GSAV(K), BSAV(K)
            ELSE
               WRITE (NOUT_PS,500) I, RSAV(J), GSAV(J), BSAV(J),
     +                             J, RSAV(K), GSAV(K), BSAV(K)
            ENDIF
         ENDDO
      ELSEIF (ISEND.EQ.4) THEN
C
C No action if the colour is the same as the previous color
C ... Only uses JCOLOR
C
         IF (JCOLOR.NE.ISAV) THEN
            ISAV = JCOLOR
            IF (ISAV.LE.9) THEN
               WRITE (NOUT_PS,600) ISAV
            ELSE
               WRITE (NOUT_PS,700) ISAV
            ENDIF
         ENDIF
      ELSEIF (ISEND.EQ.5) THEN
C
C Final entry .. re-set the defaults
C
         ISAV = N0
         JSAV = N15
      ENDIF   
C
C These format statements must NOT be edited
C      
  100 FORMAT (
     + '/background{1 setgray}D /foreground{0 setgray}D')
  200 FORMAT (
     + '/background{0 setgray}D /foreground{1 setgray}D')
  300 FORMAT (
     + '/background{',F5.3,2F6.3,' rgb}D /foreground{1 setgray}D')
  400 FORMAT ('/c',I1,'{',F5.3,2F6.3,' rgb}D',
     +     1X,'/c',I1,'{',F5.3,2F6.3,' rgb}D')
  500 FORMAT ('/c',I2,'{',F5.3,2F6.3,' rgb}D',
     +     1X,'/c',I2,'{',F5.3,2F6.3,' rgb}D')
  600 FORMAT ('c',I1)
  700 FORMAT ('c',I2)
      END
C 
C