C
C PSFILE
C ======
C
C Creates the SIMFIT PostScript file
C
      SUBROUTINE PSFILE$(NFONT, NOUT, PS_SCALE, PS_THETA, PS_THICK,
     +                   PS_XOFF, PS_YOFF, XCLIP, YCLIP, CIPHER, FNAME)
C
C ACTION : Open/Close PostScript file
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.5/1/95
C          Bounding box will only be correct for theta 0 or 90 and
C          the default 640x480 VGA dimensions
C          17/08/1995 Added td for downward text
C          23/08/1995 Added call to PSCOLR$
C          09/09/1996 Re-named TYPE as TYPE 4 (freestyle option)
C          04/11/1996 New calculation of bounding box, XCLIP, YCLIP
C          07/11/1996 Accents
C          08/01/1997 PSfrag
C          06/12/1997 Added call to PSCOLOR$ with KSEND = 1 to initialise
C          08/02/1999 corrected 1 setgray in ce and ch
C          22/11/1999 added Symbol font for key = K
C          22/02/2000 added WGBCFG$ for dynamic font sizes
C          25/10/2000 increased fonts from 6 to 8
C          13/11/2000 increased the number of maths substitutions
C          25/11/2000 new font pattern and included Courier and Symbol
C          26/02/2001 WIDTH set to 1.2 (originally 1.1, then changed to 1.25)
C          27/11/2002 added %# escape sequences
C          23/04/2007 added INTENTS 
C          15/06/2007 removed dfngks.ins and added GETGKS_INT
C          15/08/2008 added functions for outline circle/triangle/square/diamond
C          17/06/2011 added upside down triangles ue, uf, uh, uo 
C          23/12/2013 added FUDGE_FACTOR ... Note: this must be the same as in TTYPE1 
C          29/12/2013 changed 0 linejoin to 1 linejoin in format 200 which overrides SETLIM
C          25/08/2014 changed pc to use mitred line joins
C          16/03/2021 added %%BeginDocument and %%EndDocument  
C          20/03/2021 commented out these extra DSC comments as I think the application must provide them not the free standing files
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NFONT, NOUT 
      DOUBLE PRECISION, INTENT (IN) :: PS_SCALE, PS_THETA, PS_THICK,
     +                                 PS_XOFF, PS_YOFF,
     +                                 XCLIP(2), YCLIP(2)
C
C Locals
C                      
      INTEGER    NOUT_PS
      INTEGER    IX1BB, IX2BB, IY1BB, IY2BB
      INTEGER    IX1CP, IX2CP, IX3CP, IX4CP,
     +           IY1CP, IY2CP, IY3CP, IY4CP
      INTEGER    I, ISIZE(10)
      INTEGER    ISEND, JSEND, KSEND, K15
      PARAMETER (ISEND = 3, JSEND = 5, KSEND = 1, K15 = 15)
      INTEGER    N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13
      PARAMETER (N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6, N7 = 7,
     +           N8 = 8, N9 = 9, N10 = 10, N11 = 11, N12 = 12, N13 = 13)
      DOUBLE PRECISION F360, F480, F640, F72, F90, ONE, TEN, WIDTH
      PARAMETER (F360 = 360.0D+00, F480 = 480.0D+00, F640 = 640.0D+00,
     +           F72 = 72.0D+00, F90 = 90.0D+00, ONE = 1.0D+00,
     +           TEN = 10.0D+00, WIDTH = 1.20D+00)
      DOUBLE PRECISION EPSI, PIBY2, SETLIM, TWOPI
      PARAMETER (EPSI = 0.1D+00, PIBY2 = 1.5707963D+00,
     +           SETLIM = 2.5D+00, TWOPI = 6.2831853D+00)
      DOUBLE PRECISION B(16), G(16), R(16), THETA1,
     +                 XTEMP, XX1, XX2, XX3, XX4, X1, X2,
     +                 YTEMP, YY1, YY2, YY3, YY4, Y1, Y2,
     +                 ZTEMP
      DOUBLE PRECISION FUDGE_FACTOR
      PARAMETER (FUDGE_FACTOR = 0.85D+00)
      DOUBLE PRECISION SIZES(10), SIZE1
      DOUBLE PRECISION WGBCFG$
      CHARACTER  CIPHER*(*), FNAME*(*), ORIENT*11
      CHARACTER  DATE*40
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      EXTERNAL   DATE01
      EXTERNAL   PSCOLR$, WGBCFG$ 
      EXTERNAL   GETGKS_INT, PUTGKS_INT
      INTRINSIC  ABS, NINT, ATAN, COS, SIN, MAX, MIN, SQRT
      SAVE       SIZES
      DATA       SIZES / 240.0D+00, 220.0D+00, 220.0D+00, 220.0D+00,
     +                   170.0D+00, 170.0D+00, 170.0D+00, 170.0D+00,
     +                   170.0D+00, 170.0D+00 /
      IF (CIPHER.EQ. 'OPEN' .OR. CIPHER.EQ.'open') THEN
C
C Initialise PSCOLOR$ to the background colour K15
C                          
         CALL GETGKS_INT (N5, NOUT_PS)
         CALL PSCOLR$(KSEND, K15, NOUT_PS,
     +                B, G, R)
C
C Calculate bounding box for EPSF
C
         IF (ABS(PS_THETA).LE.EPSI) THEN
C
C First calculation for portrait style
C
            ORIENT = '%#portrait'
            IX1BB = NINT(F72*PS_XOFF)
            IX2BB = NINT(F72*PS_XOFF + PS_SCALE*F640)
            IY1BB = NINT(F72*PS_YOFF)
            IY2BB = NINT(F72*PS_YOFF + PS_SCALE*F480)
C
C Now correct for clipping
C
            IX1BB = IX1BB + NINT(XCLIP(1)*PS_SCALE*F640)
            IX2BB = IX2BB - NINT((ONE - XCLIP(2))*PS_SCALE*F640)
            IY1BB = IY1BB + NINT(YCLIP(1)*PS_SCALE*F480)
            IY2BB = IY2BB - NINT((ONE - YCLIP(2))*PS_SCALE*F480)
            IX1CP = IX1BB - N2
            IX2CP = IX2BB + N2
            IX3CP = IX2CP
            IX4CP = IX1CP
            IY1CP = IY1BB - N2
            IY2CP = IY1CP
            IY3CP = IY2BB + N2
            IY4CP = IY3CP
         ELSEIF (ABS(PS_THETA - F90).LE.EPSI) THEN
            ORIENT = '%#landscape'
            IX1BB = NINT(F72*PS_XOFF - PS_SCALE*F480)
            IX2BB = NINT(F72*PS_XOFF)
            IY1BB = NINT(F72*PS_YOFF)
            IY2BB = NINT(F72*PS_YOFF + PS_SCALE*F640)
C
C Now correct for clipping
C
            IX1BB = IX1BB +  NINT((ONE - YCLIP(2))*PS_SCALE*F480)
            IX2BB = IX2BB - NINT(YCLIP(1)*PS_SCALE*F480)
            IY1BB = IY1BB + NINT(XCLIP(1)*PS_SCALE*F640)
            IY2BB = IY2BB - NINT((ONE - XCLIP(2))*PS_SCALE*F640)
            IX1CP = IX1BB - N2
            IX2CP = IX2BB + N2
            IX3CP = IX2CP
            IX4CP = IX1CP
            IY1CP = IY1BB - N2
            IY2CP = IY1CP
            IY3CP = IY2BB + N2
            IY4CP = IY3CP
         ELSE
            ORIENT = BLANK
            XX1 = F72*PS_XOFF
            YY1 = F72*PS_YOFF
            XTEMP = PS_SCALE*F640
            YTEMP = PS_SCALE*F480
            ZTEMP = SQRT(XTEMP**2 + YTEMP**2)
            THETA1 = TWOPI*PS_THETA/F360
            XX2 = XX1 + XTEMP*COS(THETA1)
            YY2 = YY1 + XTEMP*SIN(THETA1)
            THETA1 = ATAN(YTEMP/XTEMP) + TWOPI*PS_THETA/F360
            XX3 = XX1 + ZTEMP*COS(THETA1)
            YY3 = YY1 + ZTEMP*SIN(THETA1)
            THETA1 = PIBY2 + TWOPI*PS_THETA/F360
            XX4 = XX1 + YTEMP*COS(THETA1)
            YY4 = YY1 + YTEMP*SIN(THETA1)
            X1 = MIN(XX1, XX2, XX3, XX4)
            X2 = MAX(XX1, XX2, XX3, XX4)
            Y1 = MIN(YY1, YY2, YY3, YY4)
            Y2 = MAX(YY1, YY2, YY3, YY4)
            IX1BB = NINT(X1)
            IX2BB = NINT(X2)
            IY1BB = NINT(Y1)
            IY2BB = NINT(Y2)
            IX1CP = NINT(XX1)
            IX2CP = NINT(XX2)
            IX3CP = NINT(XX3)
            IX4CP = NINT(XX4)
            IY1CP = NINT(YY1)
            IY2CP = NINT(YY2)
            IY3CP = NINT(YY3)
            IY4CP = NINT(YY4)
         ENDIF
C
C NOUT_PS also defined by GKSDEC in DEFNGKS.INS ... Open PostScript file
C
         NOUT_PS = NOUT
         CALL PUTGKS_INT (N5, NOUT_PS)
         OPEN (UNIT = NOUT_PS, FILE = FNAME)
         CALL DATE01 (DATE)
         WRITE (NOUT_PS,100) IX1BB, IY1BB, IX2BB, IY2BB, DATE
         WRITE (NOUT_PS,200) IX1CP, IY1CP, IX2CP, IY2CP,
     +                       IX3CP, IY3CP, IX4CP, IY4CP,
     +                       F72*PS_XOFF, F72*PS_YOFF,
     +                       PS_SCALE/TEN, PS_SCALE/TEN,
     +                       PS_THETA, ORIENT, TEN*WIDTH*PS_THICK,
     +                       SETLIM
         WRITE (NOUT_PS, 300)
         WRITE (NOUT_PS, 400)
         WRITE (NOUT_PS, 500)
         WRITE (NOUT_PS, 600)
         WRITE (NOUT_PS, 620)
         WRITE (NOUT_PS, 640)
         WRITE (NOUT_PS, 660)
         WRITE (NOUT_PS, 680)
         WRITE (NOUT_PS, 700)
         WRITE (NOUT_PS, 800)
         WRITE (NOUT_PS, 900)
         WRITE (NOUT_PS,1000)
         WRITE (NOUT_PS,1100)
         WRITE (NOUT_PS,1200)
         WRITE (NOUT_PS,1300)
         WRITE (NOUT_PS,1400)
         WRITE (NOUT_PS,1500)
         WRITE (NOUT_PS,1600)
         CALL PSCOLR$(ISEND, ISEND, NOUT_PS, B, G, R)
         IF (NFONT.EQ.N1) THEN
            WRITE (NOUT_PS,1700)
         ELSEIF (NFONT.EQ.N2) THEN
            WRITE (NOUT_PS,1800)
         ELSEIF (NFONT.EQ.N3) THEN
            WRITE (NOUT_PS,1900)
         ELSEIF (NFONT.EQ.N4) THEN
            WRITE (NOUT_PS,2000)
         ELSEIF (NFONT.EQ.N5) THEN
            WRITE (NOUT_PS,2100)
         ELSEIF (NFONT.EQ.N6) THEN
            WRITE (NOUT_PS,2200)
         ELSEIF (NFONT.EQ.N7) THEN
            WRITE (NOUT_PS,2300)
         ELSEIF (NFONT.EQ.N8) THEN
            WRITE (NOUT_PS,2400)
         ELSEIF (NFONT.EQ.N9) THEN
            WRITE (NOUT_PS,2500)
         ELSEIF (NFONT.EQ.N10) THEN
            WRITE (NOUT_PS,2600)
         ELSEIF (NFONT.EQ.N11) THEN
            WRITE (NOUT_PS,2700)
         ELSEIF (NFONT.EQ.N12) THEN
            WRITE (NOUT_PS,2800)
         ELSEIF (NFONT.EQ.N13) THEN
            WRITE (NOUT_PS,2900)
         ENDIF
         I = N4
         SIZE1 = FUDGE_FACTOR*WGBCFG$(I)
         DO I = N1, N10
            ISIZE(I) = NINT(SIZES(I)*SIZE1)
         ENDDO
         WRITE (NOUT_PS,3000) (ISIZE(I), I = N1, N10)
         WRITE (NOUT_PS,3100)
      ELSE
C
C Close PostScript file and re-set PostScript default colours
C                            
         CALL GETGKS_INT (N5, NOUT_PS)
         WRITE (NOUT_PS,5000)
         CLOSE (UNIT = NOUT_PS)
         CALL PSCOLR$(JSEND, JSEND, NOUT_PS, B, G, R)
      ENDIF  
C
C These format statements must NOT be translated
C      
  100 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
C****+/'%%BeginDocument'
     +/'%%BoundingBox:',4I6
     +/'%%Creator: Simfit: Version 8.1.2, https://simfit.uk'
     +/'%%Title: colours=72/ISOLatin1Encoding/Accents/special/PSfrag/',
     + 'dict=300'
     +/'%%CreationDate:',1X,A
     +/'%%EndComments')
  200 FORMAT (
     + '%'
     +/'%Start of SIMFIT PostScript file'
     +/'%'
     +/'save %save current state before clipping, etc.'
     +/8I6,'%#clipping'
     +/'newpath moveto lineto lineto lineto closepath clip newpath'
     +/2F8.2,1X,'translate',2F8.2,1X,'scale',F8.2,1X,'rotate',A
     +/F8.2,1X,'setlinewidth 0 setlinecap 1 setlinejoin [] 0 setdash'
     +/F8.2,1X,'setmiterlimit')
  300 FORMAT (
     + '%'
     +/'%prolog(1) to (6) can be used by DVIPS as a header'
     +/'%****cut the invariant prolog/header out from here'
     +/'/SIMFIT 300 dict def SIMFIT begin'
     +/'%'
     +/'% prolog(1): definitions'
     +/'%'
     +/'/C{copy}def /D{def}def /E{exch}D /F{findfont}D /GR{grestore}D'
     +/'/GS{gsave}D /M{moveto}D /N{newpath}D /P{pop}D /R{rmoveto}D'
     +/'/S{scalefont setfont}D /d{dup}D /i{putinterval}D /p{put}D')
  400 FORMAT (
     + '%'
     +/'% prolog(2): construct Greek/maths font'
     +/'%'
     +/'/Symbol F d length dict begin'
     +/'{1 index /FID ne {D} {P P} ifelse} forall',
     + ' Encoding d length array C'
     +/'d 33 [/perpendicular /Rfraktur /infinity /infinity /aleph',
     + ' /circleplus'
     +/'/spade /heart /club /multiply /plusminus /lozenge /approxequal',
     + ' /bullet'
     +/'/divide /radical /florin /partialdiff /gradient /integral',
     + ' /product'
     +/'/summation /arrowright /arrowleft /arrowup /arrowdown',
     + ' /arrowboth'
     +/'/lessequal /equivalence /greaterequal /notequal /degree] i')
  500 FORMAT (
     + 'd 67 /Gamma p d 99 /gamma p'
     +/'d 70 [/Zeta /Eta /Theta] i d 102 [/zeta /eta /theta1] i'
     +/'d 74 [/Kappa /Lambda /Mu /Nu /Xi] i d 106 [/kappa /lambda',
     + ' /mu /nu /xi] i'
     +/'d 81 [/Rho /Sigma /Tau /Upsilon1 /Phi /Chi /Psi /Omega',
     + ' /partialdiff'
     +/'      /element /circlemultiply /arrowvertex /arrowhorizex',
     + ' /intersection',
     +/'      /union /universal] i'
     +/'d 113 [/rho /sigma /tau /upsilon /phi1 /chi /psi /omega',
     + ' /theta /phi',
     +/'      /propersuperset /propersubset /existential',
     +' /suchthat] i'
     +/'       /Encoding E D currentdict end /Greek E definefont P'
     +/'%End definition of Greek font')
  600 FORMAT (
     + '%'
     +/'%prolog (3): character functions'
     +/'%'
     +/'/bar{g5 show GS 10.0 setlinewidth w neg h 1.2 mul R w 0 rlineto'
     +/'     stroke GR}D'
     +/'/bar1{g5 bs GS 15.0 setlinewidth w neg h 1.2 mul R w 0 rlineto'
     +/'      stroke GR}D'
     +/'/hat{g5 show GS 10.0 setlinewidth w neg h 1.2 mul R w .5 mul h'
     +/'     .3 mul rlineto w .5 mul h .3 mul neg rlineto stroke GR}D'
     +/'/hat1{g5 bs GS 15.0 setlinewidth w neg h 1.2 mul R w .5 mul h'
     +/'      .3 mul rlineto w .5 mul h .3 mul neg rlineto stroke GR}D'
     +/'/bs{false charpath GS 5.0 setlinewidth stroke GR',
     + ' currentpoint'
     +/'    fill N M}D /a1 (A) D'
     +/'/PSfrag where'
     +/'   {P /fx{/ar E D /st E D PSfragLib /S get st /convert PSfrag',
     +/'    known {st show} {f1} ifelse GR}D}'
     +/'   {/fx{/ar E D /st E D f1 GR}D} ifelse'
     +/'/f1{0 1 st length 1 sub {d st E get a1 E 0 E p a1 E f2}',
     + ' for}D')
  620 FORMAT (
     + '/f2{ar E get /nu E D     % ... get the text key'
     +/'    nu 48 gt nu 58 lt and% ... is it in 0 to 9?'
     +/'   {nu 49 eq {sb} if nu 50 eq {sp} if'
     +/'    nu 51 eq {g1 show g2} if nu 52 eq {g1 ',
     + 'sb g2} if nu 53 eq'
     +/'   {g1 sp g2} if nu 54 eq {g1 bs g2} if',
     + ' nu 55 eq {g3 show g2} if'
     +/'    nu 56 eq {g4 show g2} if'
     +/'    nu 57 eq {special} if}')
  640 FORMAT (
     + '   {nu 64 gt nu 77 lt and% ... is it in A to L?'
     +/'   {nu 65 eq {g5 show g6 h1} if nu 66 eq {g5 show g6 h2} if'
     +/'    nu 67 eq {g5 show g6 h3} if nu 68 eq {g5 show g6 h4} if'
     +/'    nu 69 eq {g5 show g6 h5} if nu 70 eq {g5 show g6 h6} if'
     +/'    nu 71 eq {g5 g1 hat g2}  if nu 72 eq {g5 g1 bar g2}  if'
     +/'    nu 73 eq {g5 g1 hat1 g2} if nu 74 eq {g5 g1 bar1 g2} if'
     +/'    nu 75 eq {g7 show g2}    if nu 76 eq {g7 bs g2} if}'
     +/'   {show} ifelse}        % ... if key not valid'
     +/'    ifelse}D')
  660 FORMAT (
     + '/f3{F size S}D /f4{S 3 -1 roll d stringwidth P}D',
     + ' /f5{S M}D'
     +/'/f6{4 -1 roll E sub 3 -1 roll M GS}D',
     + ' /f7{3 -1 roll E M GS}D'
     +/'/g1{d ($) eq {P (\243)} {/Greek f3} ifelse}D'
     +/'/g2{font f3}D /g3{/ZapfDingbats f3}D'
     +/'/g4{/ISOLatin1Encoding where {P font F d length dict begin'
     +/'    {1 index /FID ne {D} {P P} ifelse}forall'
     +/'    /Encoding ISOLatin1Encoding D currentdict end'
     +/'    /ISO E definefont P /ISO f3}if}D')
  680 FORMAT (
     + '/g5{d GS newpath 0 0 M true charpath pathbbox',
     +' GR /h E D /w E D P P}D'
     +/'/g6{GS 0 0 M (a) true charpath pathbbox GR /ha E D P P P',
     +' GS w neg}D'
     +/'/g7{/Symbol f3}D'
     +/'/h1{h ha sub R w (\301) stringwidth P sub .5 mul 0',
     +' R (\301) show GR}D'
     +/'/h2{h ha sub R w (\302) stringwidth P sub .5 mul 0',
     +' R (\302) show GR}D'
     +/'/h3{h ha sub R w (\303) stringwidth P sub .5 mul 0',
     +' R (\303) show GR}D'
     +/'/h4{h ha sub R w (\304) stringwidth P sub .5 mul 0',
     +' R (\304) show GR}D'
     +/'/h5{h ha sub R w (\305) stringwidth P sub .5 mul 0',
     +' R (\305) show GR}D'
     +/'/h6{h ha sub R w (\310) stringwidth P sub .5 mul 0',
     +' R (\310) show GR}D')
  700 FORMAT (
     + '/ti{/font ti-font D /size ti-size D ti-font F',
     + ' ti-size f4 2 div f6}D'
     +/'/xl{/font xl-font D /size xl-size D xl-font F',
     + ' xl-size f4 2 div f6}D'
     +/'/yl{/font yl-font D /size yl-size D yl-font F',
     + ' yl-size f4 2 div'
     +/'    3 -1 roll E sub f7 90 rotate}D'
     +/'/zl{/font zl-font D /size zl-size D zl-font F',
     + ' zl-size f4 2 div'
     +/'    3 -1 roll E add f7 -90 rotate}D')
  800 FORMAT (
     + '/tc{/font tc-font D /size tc-size D tc-font F',
     + ' tc-size f4 2 div f6}D'
     +/'/td{/font td-font D /size td-size D td-font F',
     + ' td-size f5 GS'
     +/'    td-size 3 div neg 0 R -90 rotate}D'
     +/'/tl{/font tl-font D /size tl-size D tl-font F',
     + ' tl-size f5 GS}D'
     +/'/re45{/font td-font D /size td-size D td-font F td-size f4 d'
     +/'      .707 mul 5 -1 roll E sub td-size 2 div add 4 1 roll'
     +/'      .707 mul 3 -1 roll E sub td-size 2 div sub f7 45 rotate}D'
     +/'/re60{/font td-font D /size td-size D td-font F td-size f4 d'
     +/'      .500 mul 5 -1 roll E sub td-size 3 div add 4 1 roll'
     +/'      .866 mul 3 -1 roll E sub td-size 3 div sub f7 60 rotate}D'
     +/'/re75{/font td-font D /size td-size D td-font F td-size f4 d'
     +/'      .259 mul 5 -1 roll E sub td-size 4 div add 4 1 roll'
     +/'      .966 mul 3 -1 roll E sub td-size 4 div sub f7 75 rotate}D'
     +/'/ro45{/font td-font D /size td-size D td-font F',
     + ' td-size f5 GS'
     +/'      td-size 3 div neg td-size 2 div neg R -45 rotate}D'
     +/'/ro60{/font td-font D /size td-size D td-font F',
     + ' td-size f5 GS'
     +/'      td-size 3 div neg td-size 3 div neg R -60 rotate}D'
     +/'/ro75{/font td-font D /size td-size D td-font F',
     + ' td-size f5 GS'
     +/'      td-size 3 div neg td-size 4 div neg R -75 rotate}D'
     +/'/tu{/font td-font D /size td-size D td-font F',
     + ' td-size f4 3 -1 roll'
     +/'    E sub f7 90 rotate 0 td-size 3 div neg R}D'
     +/'/ty{/font ty-font D /size ty-size D ty-font F',
     + ' ty-size f5 d stringwidth'
     +/'    P neg ty-size 3 div neg R GS}D')
  900 FORMAT (
     + '/tz{/font tz-font D /size tz-size D tz-font F',
     + ' tz-size f5 0 tz-size'
     +/'    3 div neg R GS}D'
     +/'/tr{/font tr-font D /size tr-size D tr-font F',
     + ' tr-size f4 f6}D'
     +/'/sb{0 size y-down mul R GS sb-size sb-size scale d',
     + ' stringwidth P E'
     +/'    show GR sb-size mul size y-down mul -1 mul R}D'
     +/'/sp{0 size y-up mul R GS sp-size sp-size scale d ',
     + 'stringwidth P E'
     +/'    show GR sp-size mul size y-up mul -1 mul ',
     + 'R}D')
 1000 FORMAT (
     + '%'
     +/'%prolog (4): lines'
     +/'%'
     +/'/l1{0 setdash N 3 1 roll}D',
     + '/l2{M 1 sub {lineto} repeat stroke GR}D'
     +/'/da{GS [60 40] l1 l2}D /do{GS [20 40] l1 l2}D'
     +/'/dd{GS [60 40 20 40] l1 l2}D /li{M lineto stroke}D'
     +/'/pl{GS N 3 1 roll l2}D')
 1100 FORMAT (
     + '%'
     +/'%prolog (5): polygons'
     +/'%'
     +/'/p1{N 3 1 roll M 1 sub {lineto} repeat closepath}D'
     +/'/pc{0 setlinejoin p1 stroke 1 setlinejoin}D' 
     +/'/pe{GS p1 background fill GR}D /pf{p1 fill}D')
 1200 FORMAT (
     + '%'
     +/'%prolog (6): symbols'
     +/'%'
     +/'/s1{N x y z}D /s2{arc closepath GS}D',
     + ' /xyz{/z E D /y E D /x E D}D'
     +/'/xa{x z add}D /xs{x z sub}D',
     + ' /ya{y z add}D /ys{y z sub}D'
     +/'/ad{xyz x ys x ya li xs y xa y li}D /as{3 C ad cr}D'
     +/'/ce{xyz s1 0 360 s2 background fill GR stroke}D'
     +/'/ch{xyz s1 90 270 s2 background fill GR s1 90 270 arcn',
     + ' closepath fill s1'
     +/'    0 360 arc closepath stroke}D'
     +/'/cf{xyz s1 0 360 s2 fill GR stroke}D'
     +/'/co{xyz s1 0 360 s2 GR stroke}D'
     +/'/cr{xyz z 2.0 sqrt div /z E D xs ys xa ya li xa ys xs ya',
     + ' li}D')
 1300 FORMAT (
     + '/de{xyz x ys xa y x ya xs y 4 9 C pe pc}D'
     +/'/dh{xyz x ys xa y x ya 3 pf x ys x ya xs y 3 pe x ys xa y x ya',
     + ' xs y 4'
     +/'    pc}D /mi{xyz xs y xa y li}D'
     +/'/df{xyz x ys xa y x ya xs y 4 9 C pf pc}D'
     +/'/dn{xyz x ys xa y x ya xs y 4 pc}D'
     +/'/se{xyz xa ys xa ya xs ya xs ys 4 9 C pe pc}D'
     +/'/sh{xyz x ys xa ys xa ya x ya 4 pf x ys x ya xs ya xs ys 4 pe',
     + ' xa ys xa'
     +/'    ya xs ya xs ys 4 pc}D'
     +/'/sf{xyz xa ys xa ya xs ya xs ys 4 9 C pf pc}D'
     +/'/so{xyz xa ys xa ya xs ya xs ys 4 pc}D'
     +/'/te{xyz xa ys x ya xs ys 3 7 C pe pc}D'
     +/'/th{xyz x ys xa ys x ya 3 pf x ys x ya xs ys 3 pe xa ys x ya',
     + ' xs ys 3',
     +/'    pc}D',
     +/'/tf{xyz xa ys x ya xs ys 3 7 C pf pc}D'
     +/'/to{xyz xa ys x ya xs ys 3 pc}D'
     +/'/ue{xyz x ys xa ya xs ya 3 7 C pe pc}D'
     +/'/uh{xyz x ys xa ya x ya 3 pf x ys x ya xs ya 3 pe x ys xa ya',
     +' xs ya 3',
     +/'   pc}D'
     +/'/uf{xyz x ys xa ya xs ya 3 7 C pf pc}D' 
     +/'/uo{xyz x ys xa ya xs ya 3 pc}D'
     +/'end'
     +/'%****cut the invariant prolog/header down to here')
 1400 FORMAT (
     + '%'
     +/'%end of invariant prolog/header ... start of script'
     +/'%'
     +/'SIMFIT begin%call up invariant prolog/header')
 1500 FORMAT (
     + '%'
     +/'% prolog(7): user supplied special function'
     +/'%'
     +/'%begin{special} ... start of user''s special font function'
     +/'/special{g5 show GS w neg h 1.2 mul R w 0 rlineto stroke GR}D'
     +/'%end{special} ... end of user''s special font function')
 1600 FORMAT (
     + '%'
     +/'%prolog (8): width/colours/fonts'
     +/'%'
     +/'currentlinewidth /thickness E D /rgb{setrgbcolor}D')
 1700 FORMAT (
     + '/ti-font /Times-Bold  D%plot-title'
     +/'/xl-font /Times-Roman D%x-legend'
     +/'/yl-font /Times-Roman D%y-legend'
     +/'/zl-font /Times-Roman D%z-legend'
     +/'/tc-font /Times-Roman D%text centred'
     +/'/td-font /Times-Roman D%text down/up/slant'
     +/'/tl-font /Times-Roman D%text left to right'
     +/'/tr-font /Times-Roman D%text right to left'
     +/'/ty-font /Times-Roman D%text right y-mid'
     +/'/tz-font /Times-Roman D%text left  y-mid')
 1800 FORMAT (
     + '/ti-font /Times-Bold D%plot-title'
     +/'/xl-font /Times-Bold D%x-legend'
     +/'/yl-font /Times-Bold D%y-legend'
     +/'/zl-font /Times-Bold D%z-legend'
     +/'/tc-font /Times-Bold D%text centred'
     +/'/td-font /Times-Bold D%text down/up/slant'
     +/'/tl-font /Times-Bold D%text left to right'
     +/'/tr-font /Times-Bold D%text right to left'
     +/'/ty-font /Times-Bold D%text right y-mid'
     +/'/tz-font /Times-Bold D%text left  y-mid')
 1900 FORMAT (
     + '/ti-font /Times-BoldItalic D%plot-title'
     +/'/xl-font /Times-Italic     D%x-legend'
     +/'/yl-font /Times-Italic     D%y-legend'
     +/'/zl-font /Times-Italic     D%z-legend'
     +/'/tc-font /Times-Italic     D%text centred'
     +/'/td-font /Times-Italic     D%text down/up/slant'
     +/'/tl-font /Times-Italic     D%text left to right'
     +/'/tr-font /Times-Italic     D%text right to left'
     +/'/ty-font /Times-Italic     D%text right y-mid'
     +/'/tz-font /Times-Italic     D%text left  y-mid')
 2000 FORMAT (
     + '/ti-font /Times-BoldItalic D%plot-title'
     +/'/xl-font /Times-BoldItalic D%x-legend'
     +/'/yl-font /Times-BoldItalic D%y-legend'
     +/'/zl-font /Times-BoldItalic D%z-legend'
     +/'/tc-font /Times-BoldItalic D%text centred'
     +/'/td-font /Times-BoldItalic D%text down/up/slant'
     +/'/tl-font /Times-BoldItalic D%text left to right'
     +/'/tr-font /Times-BoldItalic D%text right to left'
     +/'/ty-font /Times-BoldItalic D%text right y-mid'
     +/'/tz-font /Times-BoldItalic D%text left  y-mid')
 2100 FORMAT (
     + '/ti-font /Helvetica-Bold D%plot-title'
     +/'/xl-font /Helvetica      D%x-legend'
     +/'/yl-font /Helvetica      D%y-legend'
     +/'/zl-font /Helvetica      D%z-legend'
     +/'/tc-font /Helvetica      D%text centred'
     +/'/td-font /Helvetica      D%text down/up/slant'
     +/'/tl-font /Helvetica      D%text left to right'
     +/'/tr-font /Helvetica      D%text right to left'
     +/'/ty-font /Helvetica      D%text right y-mid'
     +/'/tz-font /Helvetica      D%text left  y-mid')
 2200 FORMAT (
     + '/ti-font /Helvetica-Bold D%plot-title'
     +/'/xl-font /Helvetica-Bold D%x-legend'
     +/'/yl-font /Helvetica-Bold D%y-legend'
     +/'/zl-font /Helvetica-Bold D%z-legend'
     +/'/tc-font /Helvetica-Bold D%text centred'
     +/'/td-font /Helvetica-Bold D%text down/up/slant'
     +/'/tl-font /Helvetica-Bold D%text left to right'
     +/'/tr-font /Helvetica-Bold D%text right to left'
     +/'/ty-font /Helvetica-Bold D%text right y-mid'
     +/'/tz-font /Helvetica-Bold D%text left  y-mid')
 2300 FORMAT (
     + '/ti-font /Helvetica-BoldOblique D%plot-title'
     +/'/xl-font /Helvetica-Oblique     D%x-legend'
     +/'/yl-font /Helvetica-Oblique     D%y-legend'
     +/'/zl-font /Helvetica-Oblique     D%z-legend'
     +/'/tc-font /Helvetica-Oblique     D%text centred'
     +/'/td-font /Helvetica-Oblique     D%text down/up/slant'
     +/'/tl-font /Helvetica-Oblique     D%text left to right'
     +/'/tr-font /Helvetica-Oblique     D%text right to left'
     +/'/ty-font /Helvetica-Oblique     D%text right y-mid'
     +/'/tz-font /Helvetica-Oblique     D%text left  y-mid')
 2400 FORMAT (
     + '/ti-font /Helvetica-BoldOblique D%plot-title'
     +/'/xl-font /Helvetica-BoldOblique D%x-legend'
     +/'/yl-font /Helvetica-BoldOblique D%y-legend'
     +/'/zl-font /Helvetica-BoldOblique D%z-legend'
     +/'/tc-font /Helvetica-BoldOblique D%text centred'
     +/'/td-font /Helvetica-BoldOblique D%text down/up/slant'
     +/'/tl-font /Helvetica-BoldOblique D%text left to right'
     +/'/tr-font /Helvetica-BoldOblique D%text right to left'
     +/'/ty-font /Helvetica-BoldOblique D%text right y-mid'
     +/'/tz-font /Helvetica-BoldOblique D%text left  y-mid')
 2500 FORMAT (
     + '/ti-font /Courier-Bold D%plot-title'
     +/'/xl-font /Courier      D%x-legend'
     +/'/yl-font /Courier      D%y-legend'
     +/'/zl-font /Courier      D%z-legend'
     +/'/tc-font /Courier      D%text centred'
     +/'/td-font /Courier      D%text down/up/slant'
     +/'/tl-font /Courier      D%text left to right'
     +/'/tr-font /Courier      D%text right to left'
     +/'/ty-font /Courier      D%text right y-mid'
     +/'/tz-font /Courier      D%text left  y-mid')
 2600 FORMAT (
     + '/ti-font /Courier-Bold D%plot-title'
     +/'/xl-font /Courier-Bold D%x-legend'
     +/'/yl-font /Courier-Bold D%y-legend'
     +/'/zl-font /Courier-Bold D%z-legend'
     +/'/tc-font /Courier-Bold D%text centred'
     +/'/td-font /Courier-Bold D%text down/up/slant'
     +/'/tl-font /Courier-Bold D%text left to right'
     +/'/tr-font /Courier-Bold D%text right to left'
     +/'/ty-font /Courier-Bold D%text right y-mid'
     +/'/tz-font /Courier-Bold D%text left  y-mid')
 2700 FORMAT (
     + '/ti-font /Courier-BoldOblique D%plot-title'
     +/'/xl-font /Courier-Oblique     D%x-legend'
     +/'/yl-font /Courier-Oblique     D%y-legend'
     +/'/zl-font /Courier-Oblique     D%z-legend'
     +/'/tc-font /Courier-Oblique     D%text centred'
     +/'/td-font /Courier-Oblique     D%text down/up/slant'
     +/'/tl-font /Courier-Oblique     D%text left to right'
     +/'/tr-font /Courier-Oblique     D%text right to left'
     +/'/ty-font /Courier-Oblique     D%text right y-mid'
     +/'/tz-font /Courier-Oblique     D%text left  y-mid')
 2800 FORMAT (
     + '/ti-font /Courier-BoldOblique D%plot-title'
     +/'/xl-font /Courier-BoldOblique D%x-legend'
     +/'/yl-font /Courier-BoldOblique D%y-legend'
     +/'/zl-font /Courier-BoldOblique D%z-legend'
     +/'/tc-font /Courier-BoldOblique D%text centred'
     +/'/td-font /Courier-BoldOblique D%text down/up/slant'
     +/'/tl-font /Courier-BoldOblique D%text left to right'
     +/'/tr-font /Courier-BoldOblique D%text right to left'
     +/'/ty-font /Courier-BoldOblique D%text right y-mid'
     +/'/tz-font /Courier-BoldOblique D%text left  y-mid')
 2900 FORMAT (
     + '/ti-font /Symbol D%plot-title'
     +/'/xl-font /Symbol D%x-legend'
     +/'/yl-font /Symbol D%y-legend'
     +/'/zl-font /Symbol D%z-legend'
     +/'/tc-font /Symbol D%text centred'
     +/'/td-font /Symbol D%text down/up/slant'
     +/'/tl-font /Symbol D%text left to right'
     +/'/tr-font /Symbol D%text right to left'
     +/'/ty-font /Symbol D%text right y-mid'
     +/'/tz-font /Symbol D%text left  y-mid')
 3000 FORMAT (
C Note that the following values are the same size as the
C Hershey fonts (Title is a bit bigger) so change carefully
C****+ '/ti-size 240 D /xl-size 220 D',
C****+ ' /yl-size 220 D /zl-size 220 D'
C****+/'/tc-size 180 D /td-size 180 D',
C****+ ' /tl-size 180 D /tr-size 180 D'
C****+/'/ty-size 180 D /tz-size 180 D'
ccccc+ '/ti-size 240 D /xl-size 226 D',
ccccc+ ' /yl-size 226 D /zl-size 226 D'
ccccc+/'/tc-size 185 D /td-size 185 D',
ccccc+ ' /tl-size 185 D /tr-size 185 D'
ccccc+/'/ty-size 185 D /tz-size 185 D'
     + '/ti-size',I4,' D /xl-size',I4,' D',
     + ' /yl-size',I4,' D /zl-size',I4,' D'
     +/'/tc-size',I4,' D /td-size',I4,' D',
     + ' /tl-size',I4,' D /tr-size',I4,' D'
     +/'/ty-size',I4,' D /tz-size',I4,' D'
     +/'/sb-size 0.75 D /sp-size 0.75 D%sub/superscript expansion'
     +/'/y-down -0.33 sb-size mul D',
     + ' /y-up 0.33 sp-size div D%sub/sup shift')
 3100 FORMAT (
     + '%'
     +/'foreground thickness setlinewidth')
 5000 FORMAT (
     + '%'
     +/'%end of script'
     +/'%'
     +/'end %end SIMFIT dictionary'
     +/'showpage'
     +/'restore %restore to original state'
     +/'%'
     +/'%end of SIMFIT PostScript file')
C****+/'%%EndDocument')
       END
C
C
