C
C
      SUBROUTINE PSLINE$(ICOLOR,
     +                   X1, Y1, X2, Y2)
C
C ACTION : Output PostScript line
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/11/94
C          23/08/1995 Added checks and call to PSCOLR$
C          25/02/1997 Win32 version
C          28/11/2002 added %#4 escape sequence
C          23/04/2007 added INTENTS 
C          15/06/2007 removed defngks.ins and added GETGKS_INT
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: ICOLOR
      DOUBLE PRECISION, INTENT (IN) :: X1, X2, Y1, Y2 
C
C Locals
C                      
      INTEGER    N5
      PARAMETER (N5 = 5) 
      INTEGER    ISEND, N72
      PARAMETER (ISEND = 4, N72 = 72)
      INTEGER    IX1, IX2, IY1, IY2
      INTEGER    LEN200, NOUT_PS
      CHARACTER  LINE*40
      DOUBLE PRECISION B(N72), G(N72), R(N72)
      EXTERNAL   GKSR2I$, PSTRIP$, PSCOLR$ 
      EXTERNAL   GETGKS_INT
      EXTERNAL   LEN200
C
C Transform the coordinates
C
      CALL GKSR2I$(IX1, IY1,
     +             X1, Y1)
      CALL GKSR2I$(IX2, IY2,
     +             X2, Y2)
C
C Check if a line can be drawn
C
      IF (IX1.EQ.IX2 .AND. IY1.EQ.IY2) RETURN
C
C Set the colour scheme then write to the file
C                          
      CALL GETGKS_INT (N5, NOUT_PS)
      CALL PSCOLR$(ISEND, ICOLOR, NOUT_PS,
     +             B, G, R)
      WRITE (LINE,100) IX1, IY1, IX2, IY2
      CALL PSTRIP$(LINE)
      WRITE (NOUT_PS,200) LINE(1:LEN200(LINE))
C
C This format statement must NOT be translated
C      
  100 FORMAT (4I6,1X,'li%#4')
  200 FORMAT (A)
      END
C  
C