C
C PSPOLY$: chop a polyline into linked contiguous sections 
C PSPOLY1: draw a polyline 
C PSJOIN$: swap line join type   
C PSLCAP$: swap line cap type   
C    Note: NMAX in PSPOLY1 should  be >= NMAX in PSPOLY$ 
C
      SUBROUTINE PSPOLY$(ICOLOR, N,
     +                   X, Y,
     +                   TYPE1)
C
C ACTION : call pspoly1
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 14/12/2015
C
C This subroutine now copies what draw_polylineD does in splitting up the 
C polyline into sections with length =< nmax to avoid problems with large
C polylines and to then agree with what draw_polylineD does.
C
      IMPLICIT   NONE
C
C Arguments
C          
      INTEGER,             INTENT (IN) :: ICOLOR, N 
      DOUBLE PRECISION,    INTENT (IN) :: X(N), Y(N) 
      CHARACTER (LEN = *), INTENT (IN) :: TYPE1
c
c locals
c
      integer    i, ndiv, nrem, nstart, nstop, nmax
      parameter (nmax = 6000)
      external   pspoly1
      
      if (n.le.nmax) then 
c
c normal call
c        
         call pspoly1 (icolor, n,
     +                 x, y,
     +                 type1)
      else
c
c split into sections 
c        
         ndiv = (n - 1)/(nmax - 1)
         nstop = 1
         do i = 1, ndiv
            nstart = nstop
            nstop = nstart + nmax - 1
            call pspoly1 (icolor, nmax,
     +                    x(nstart), y(nstart),
     +                    type1)            
         enddo
         nstart = nstop
         nrem = n - nstart + 1
         call pspoly1 (icolor, nrem,
     +                 x(nstart), y(nstart),
     +                 type1)
      endif
      end
c
c
      SUBROUTINE PSPOLY1(ICOLOR, N,
     +                   X, Y,
     +                   TYPE1)
C
C ACTION : Output PostScript polyline or polygon
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/11/94
C          28/11/2002 added %#? escape sequences 
C          08/07/2006 introduced allocatable arrays
C          23/04/2007 aded INTENTS 
C          15/06/2007 removed defngks.ins and added GETGKS_INT
C          14/12/2015 renamed as PSPOLY1, removed allocatable, introduced NMAX
C
      IMPLICIT   NONE
C
C Arguments
C          
      INTEGER,             INTENT (IN) :: ICOLOR, N 
      DOUBLE PRECISION,    INTENT (IN) :: X(N), Y(N) 
      CHARACTER (LEN = *), INTENT (IN) :: TYPE1
C
C Locals
C                         
      INTEGER    ISEND, N72, NMAX
      PARAMETER (ISEND = 4, N72 = 72, NMAX = 7000)
      INTEGER    IX(NMAX), IY(NMAX)
      INTEGER    I, NBOT, NTOP, NOVER6, NOVER7, NLEFT, N5, N6, N7
      PARAMETER (NBOT = - 999, NTOP = 9999, N5 = 5, N6 = 6, N7 = 7)
      INTEGER    LEN200, NOUT_PS
      DOUBLE PRECISION B(N72), G(N72), R(N72)
      CHARACTER (LEN = 100) LINE
      CHARACTER (LEN = 4  ) HASH(6), WORD4
      LOGICAL    FULL_SIZE
      EXTERNAL   GKSA2I$, PSTRIP$, PSCOLR$, LEN200
      EXTERNAL   GETGKS_INT
      DATA       HASH / '%#2 ', '%#4 ', '%#6 ',
     +                  '%#8 ', '%#10', '%#12' /
C
C Check N
C
      IF (N.LT.2) RETURN
C
C Transform coordinates then output data
C                                       
      CALL GKSA2I$(IX, IY, N,
     +             X, Y)
C
C Set the colour scheme
C                          
      CALL GETGKS_INT (N5, NOUT_PS)
      CALL PSCOLR$(ISEND, ICOLOR, NOUT_PS,
     +             B, G, R)
C
C If only 5 or fewer points then write one line then return
C
      IF (N.LE.N5) THEN
         WORD4 = HASH(N)
         IF (N.EQ.2) THEN
            WRITE (LINE,2) (IX(I), IY(I), I = 1, N), N, TYPE1,
     +                      WORD4
         ELSEIF (N.EQ.3) THEN
            WRITE (LINE,3) (IX(I), IY(I), I = 1, N), N, TYPE1,
     +                      WORD4
         ELSEIF (N.EQ.4) THEN
            WRITE (LINE,4) (IX(I), IY(I), I = 1, N), N, TYPE1,
     +                      WORD4
         ELSEIF (N.EQ.5) THEN
            WRITE (LINE,5) (IX(I), IY(I), I = 1, N), N, TYPE1,
     +                      WORD4
         ENDIF
         CALL PSTRIP$(LINE)
         WRITE (NOUT_PS,100) LINE(1:LEN200(LINE))
         RETURN
      ELSE
C
C Check to see if full I6 format is necessary
C
         FULL_SIZE = .FALSE.
         LOOP_1: DO I = 1, N
            IF (IX(I).LT.NBOT .OR. IX(I).GT.NTOP .OR.
     +          IY(I).LT.NBOT .OR. IY(I).GT.NTOP) THEN
                FULL_SIZE = .TRUE.
                EXIT LOOP_1
            ENDIF
         ENDDO LOOP_1
      ENDIF
      IF (FULL_SIZE) THEN
C
C Code for full I6 format
C
         NOVER6 = N/N6
         NLEFT = N - N6*NOVER6
         IF (NLEFT.EQ.0) THEN
            WORD4 = HASH(N)
            WRITE (NOUT_PS,12) (IX(I), IY(I), I = 1, N), WORD4
            WRITE (LINE,13) N, TYPE1
         ELSE
            WRITE (NOUT_PS,12) (IX(I), IY(I), I = 1, N - NLEFT)
            WORD4 = HASH(NLEFT)
            IF (NLEFT.EQ.1) THEN
               WRITE (LINE,1) IX(N), IY(N), N, TYPE1, WORD4
            ELSEIF (NLEFT.EQ.2) THEN
               WRITE (LINE,2) (IX(I), IY(I), I = N - 1, N), N,
     +                         TYPE1, WORD4
            ELSEIF (NLEFT.EQ.3) THEN
               WRITE (LINE,3) (IX(I), IY(I), I = N - 2, N), N,
     +                         TYPE1, WORD4
            ELSEIF (NLEFT.EQ.4) THEN
               WRITE (LINE,4) (IX(I), IY(I), I = N - 3, N), N,
     +                         TYPE1, WORD4
            ELSEIF (NLEFT.EQ.5) THEN
               WRITE (LINE,5) (IX(I), IY(I), I = N - 4, N), N,
     +                         WORD4, TYPE1
            ENDIF
         ENDIF
      ELSE
C
C Code for shorter format. First deal with N = 6 then return
C
         IF (N.EQ.6) THEN
            WORD4 = HASH(N)
            WRITE (LINE,6) (IX(I), IY(I), I = 1, N), N, TYPE1,
     +                      WORD4
            CALL PSTRIP$(LINE)
            WRITE (NOUT_PS,100) LINE(1:LEN200(LINE))
            RETURN
         ENDIF
         NOVER7 = N/N7
         NLEFT = N - N7*NOVER7
         IF (NLEFT.EQ.0) THEN
            WRITE (NOUT_PS,14) (IX(I), IY(I), I = 1, N)
            WRITE (LINE,13) N, TYPE1
         ELSE
            WRITE (NOUT_PS,14) (IX(I),IY(I), I = 1, N - NLEFT)
            WORD4 = HASH(NLEFT)
            IF (NLEFT.EQ.1) THEN
               WRITE (LINE,1) IX(N), IY(N), N, TYPE1, WORD4
            ELSEIF (NLEFT.EQ.2) THEN
               WRITE (LINE,2) (IX(I), IY(I), I = N - 1, N), N,
     +                         TYPE1, WORD4
            ELSEIF (NLEFT.EQ.3) THEN
               WRITE (LINE,3) (IX(I), IY(I), I = N - 2, N), N,
     +                         TYPE1, WORD4
            ELSEIF (NLEFT.EQ.4) THEN
               WRITE (LINE,4) (IX(I), IY(I), I = N - 3, N), N,
     +                         TYPE1, WORD4
            ELSEIF (NLEFT.EQ.5) THEN
               WRITE (LINE,5) (IX(I), IY(I), I = N - 4, N), N,
     +                         TYPE1, WORD4
            ELSEIF (NLEFT.EQ.6) THEN
               WRITE (LINE,6) (IX(I), IY(I), I = N - 5, N), N,
     +                         TYPE1, WORD4
            ENDIF
         ENDIF
      ENDIF
      CALL PSTRIP$(LINE)
      WRITE (NOUT_PS,100) LINE(1:LEN200(LINE))
C
C These format statements must NOT be edited
C      
    1 FORMAT (3I6,1X,A,A)
    2 FORMAT (5I6,1X,A,A)
    3 FORMAT (7I6,1X,A,A)
    4 FORMAT (9I6,1X,A,A)
    5 FORMAT (11I6,1X,A,A)
    6 FORMAT (13I6,1X,A,A)
   12 FORMAT (12I6,A)
   13 FORMAT (I6,1X,A,A)
   14 FORMAT (14I6,'%#14')
  100 FORMAT (A)
      END
C
C------------------------------------------------------------------------------------ 
C
      SUBROUTINE PSJOIN$(ITYPE)
C
C ACTION: write "ITYPE setlinejoin" to PS file to control polyline joins
C AUTHOR: w.g.bardsley, university of manchester, u.k., 22/08/2014
C
C ITYPE = 0 ... miter
C       = 1 ... round (the default)
C       = 2 ... bevel
C    
      IMPLICIT NONE
      INTEGER, INTENT (IN) :: ITYPE
      INTEGER    N5, N6
      PARAMETER (N5 = 5, N6 = 6)
      INTEGER    NOUT_PS
      LOGICAL    PS
      EXTERNAL   GETGKS_INT, GETGKS_LGL
      CALL GETGKS_LGL (N6,
     +                 PS)  
      IF (.NOT.PS .OR. ITYPE.LT.0 .OR. ITYPE.GT.3) THEN
         RETURN
      ELSE
         CALL GETGKS_INT (N5, NOUT_PS)  
         WRITE (NOUT_PS,100) ITYPE
      ENDIF
  100 FORMAT (I1,1X,'setlinejoin')
      END
C 
C------------------------------------------------------------------------------------ 
C
      SUBROUTINE PSLCAP$(ITYPE)
C
C ACTION: write "ITYPE setlinecap" to PS file to control line endcaps
C AUTHOR: w.g.bardsley, university of manchester, u.k., 22/08/2014
C
C ITYPE = 0 ... flat
C       = 1 ... round (the default)
C       = 2 ... square
C    
      IMPLICIT NONE
      INTEGER, INTENT (IN) :: ITYPE
      INTEGER    N5, N6
      PARAMETER (N5 = 5, N6 = 6)
      INTEGER    NOUT_PS
      LOGICAL    PS
      EXTERNAL   GETGKS_INT, GETGKS_LGL
      CALL GETGKS_LGL (N6,
     +                 PS)  
      IF (.NOT.PS .OR. ITYPE.LT.0 .OR. ITYPE.GT.3) THEN
         RETURN
      ELSE
         CALL GETGKS_INT (N5, NOUT_PS)  
         WRITE (NOUT_PS,100) ITYPE
      ENDIF
  100 FORMAT (I1,1X,'setlinecap')
      END                 