c
c
      subroutine psspec$(isend, nout)
c
c action: ps specials
c author: w.g.bardsley, university of manchester, u.k., 03/09/2001
c         19/03/2007 introduced sim256 and intents
c         26/06/2010 added check for read-only and call to infofl
c
c         isend = 1: edit specials and write output file pspecial.cfg
c         isend = 2: use pspecial.cfg data then write specials to nout
c         isend = 3: inform which specials are current
c
      implicit   none 
c
c arguments
c      
      integer, intent (in) :: isend, nout  
c
c locals
c      
      integer    nmax, n6
      parameter (nmax = 10, n6 = 6)
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numdec = 1,
     +           numopt = nmax + 1, nstart = 3)
      integer    numbld(30), numpos(nmax + 1)
      integer    i, ierror(nmax), instal(nmax), ios, j, nerror, ninst,
     +           ntemp
      character  dfolts(nmax)*11, files(nmax)*1024, line*1024,
     +           psscfg*12, text(30)*100
      character  trim80*80, full_path*1024, sim256*1024
      parameter (psscfg = 'pspecial.cfg')
      logical    exist, first, only_read, read_only, there, use1(nmax)
      logical    repeet
      logical    fixed, full, high
      parameter (fixed = .false., full = .false., high = .true.)
      external   attrib, getnou, rbox01, trim80, patch1, table1, sim256, 
     +           infofl
      external   putfat$
      save       numpos, files, first, use1
      data       numpos / nmax*0, 1 /
      data       numbld / 30*0 /
      data       dfolts / 'pspecial.1 ', 'pspecial.2 ', 'pspecial.3 ',
     +                    'pspecial.4 ', 'pspecial.5 ', 'pspecial.6 ',
     +                    'pspecial.7 ', 'pspecial.8 ', 'pspecial.9 ',
     +                    'pspecial.10' /
      data       first, use1  / .true., nmax*.false. /
c
c is isend in range ?
c
      if (isend.lt.1 .or. isend.gt.3) then
         call putfat$('ISEND out of range in call to PSSPEC$')
         return 
      endif    
c
c define files
c      
      do i = 1, nmax
         files(i) = sim256(dfolts(i))
      enddo   
c        
c does psscgf exist ?
c        
      full_path = sim256(psscfg)   
      if (first .or. isend.eq.1) then
         first = .false.          
         call attrib (full_path,
     +                exist, read_only)
         call getnou (ntemp)
         if (exist) then
            if (read_only) then
               call infofl (n6,
     +                      full_path)
               return
            endif                    
c
c read data from psscfg
c
            open (unit = ntemp, file = full_path, iostat=ios)
            do i = 1, nmax
               numpos(i) = 0
               if (ios.eq.0) read (ntemp,*,iostat=ios) j
               if (ios.eq.0) then
                  if (j.eq.0 .or. j.eq.1) numpos(i) = j
               endif
            enddo
            do i = 1, nmax
               if (ios.eq.0) read (ntemp,'(a)',iostat=ios) line
               if (ios.eq.0) files(i) = line
            enddo
            close (unit = ntemp)
         else
c
c create a default psscfg file
c
            open (unit = ntemp, file = full_path, iostat = ios)
            if (ios.eq.0) then
               do i = 1, nmax
                  if (ios.eq.0) write (ntemp,'(i1)',iostat=ios)
     +                                 numpos(i)
               enddo
               do i = 1, nmax
                  if (ios.eq.0) write (ntemp,'(a)',iostat=ios)
     +                                 files(i)
               enddo
               if (ios.eq.0) then
                  exist = .true.
                  write (ntemp,100)
               else
                  exist = .false.
               endif
               read_only = .false.
            else
               exist = .false.
               read_only = .false.
            endif
            close (unit = ntemp)
         endif
      endif
c
c for all isend values find out which files exist and are to be included
c use1(i) = there ... just records if the file is there
c numpos(i) = 0 (ignore), or 1 (use, unless .not.there)
c
      do i = 1, nmax
         call attrib (files(i), 
     +                there, only_read)
         use1(i) = there
         if (.not.there) numpos(i) = 0
      enddo
      if (isend.eq.1) then
c
c edit the special configuration file: pspecial.cfg
c
         numpos(numopt) = 1
         repeet = .true.
         do while (repeet)
            write (text,200) (trim80(files(i)), i = 1, nmax)
            numbld(1) = 1
            ntext = nmax + 3
            call rbox01 (icolor, ix, iy, lshade, numbld, numdec,
     +                   numopt, numpos, nstart, ntext, text,
     +                   fixed, full, high)
            if (numpos(numopt).eq.1) then
               repeet = .true.
               write (text,300)
               ntext = 21
               call patch1 (icolor, ix, iy, lshade, numbld, ntext,
     +                      text, 
     +                      fixed)
               numpos(numopt) = 0
            else
               repeet = .false.
            endif
         enddo
c
c are any files requested that don't exist ?
c
         nerror = 0
         do i = 1, nmax
            if (numpos(i).eq.1 .and. .not.use1(i)) then
               nerror = nerror + 1
               ierror(i) = 1
               numpos(i) = 0
            else
               ierror(i) = 0
            endif
         enddo
         if (nerror.gt.0) then
c
c Print a table of missing files
c
            j = 15
            call table1 (j, 'OPEN')
            j = 4
            if (nerror.eq.1) then
               call table1 (j, 'Cannot find the PS special file:-')
            else
               call table1 (j, 'Cannot find these PS special files:-')
            endif
            j = 0
            do i = 1, nmax
               if (ierror(i).eq.1) call table1 (j, trim80(files(i)))
            enddo
            call table1 (j, 'CLOSE')
         endif
c
c write the current data to pspecial.cfg
c
         if (exist .and. read_only) then
            call putfat$(
     +     'Cannot overwrite pspecial.cfg  ...  Please attrib -r')
         else
            call getnou (ntemp)
            open (unit = ntemp, file = full_path, iostat = ios)
            do i = 1, nmax
               if (ios.eq.0) write (ntemp,'(i1)',iostat=ios) numpos(i)
            enddo
            do i = 1, nmax
               if (ios.eq.0) write (ntemp,'(a)',iostat=ios) files(i)
            enddo
            if (ios.eq.0) write (ntemp,100)
            close (unit = ntemp)
         endif
      elseif (isend.eq.2) then
c
c write the data to the PostScript file opened on unit = nout
c
         do i = 1, nmax
            if (numpos(i).eq.1 .and. use1(i)) then
               call getnou (ntemp)
               open (unit = ntemp, file = files(i), iostat = ios)
               do while (ios.eq.0)
                  read (ntemp,'(a)',iostat=ios) line
                  if (ios.eq.0) write (nout,'(a)') line
               enddo
               close (unit = ntemp)
            endif
         enddo
      elseif (isend.eq.3) then
c
c inform user if any specials are current
c
         ninst = 0
         do i = 1, nmax
            if (numpos(i).eq.1 .and. use1(i)) then
               ninst = ninst + 1
               instal(i) = 1
            else
               instal(i) = 0
            endif
         enddo
         if (ninst.gt.0) then
c
c Print a table of current files
c
            j = 15
            call table1 (j, 'OPEN')
            j = 4
            if (ninst.eq.1) then
               call table1 (j,
     +        'This PostScript special is installed:-')
            else
               call table1 (j,
     +        'These PostScript specials are installed:-')
            endif
            j = 0
            do i = 1, nmax
               if (instal(i).eq.1) then
                  call getnou (ntemp)
                  open (unit = ntemp, file = files(i), iostat = ios)
                  if (ios.eq.0) read (ntemp,'(a)',iostat=ios) line
                  if (ios.eq.0) call table1 (j, trim80(line))
                  close (unit = ntemp)
               endif
            enddo
            write (text,400)
            do i = 1, 9
               if (i.eq.2) then
                  j = 4
               else
                  j = 1
               endif
               call table1 (j, text(i))
            enddo
            call table1 (j, 'CLOSE')
         endif
      endif  
c
c Format statements
c      
  100 format (
     +/'This is the Simfit PostScript special configuration file'
     +/'Meaning of the above 20 lines:'
     +/'lines  1 to 10: 0 = do not use, 1 = add to all PostScript files'
     +/'lines 11 to 20: corresponding filenames for specials 1 to 10'
     +/'You can set lines 1 to 11 from the PS/Fonts graphics option'
     +/'You can edit lines 11 to 20 to install your own specials'
     +/'Define line 1 of specials as shown in the series pspecial.i')
  200 format (
     + 'Installing Simfit PostScript specials'
     +/'...'
     +/A/A/A/A/A/A/A/A/A/A,
     +/'Help')
  300 format (
     + 'Postscript specials'
     +/
     +/'Some users may want to override the Simfit defaults for line'
     +/'types, plotting symbols, colour scheme, size, etc. or even add'
     +/'their own PostScript special code. This could be useful, for'
     +/'instance, to add a departmental heading to plots, to use a font'
     +/'with non-European characters or with decorative features like'
     +/'overprinting or shading. Advanced users might wish to add their'
     +/'own shapes, glyphs, morphs, maps, logos, graphical insets,'
     +/'photographs, jpg files, bitmaps; in short, any of the things'
     +/'that can easily be done using the PostScript language.'
     +/'Users who want these valuable features must provide the code'
     +/'required as header files, defined in the file pspecial.cfg,'
     +/'and these files will be added in sequence to the PostScript'
     +/'output file AFTER the Simfit dictionary has been defined.'/
     +/'Obviously this technique requires informed users and should'
     +/'not be attempted unless you can design a correctly formatted'
     +/'PostScript header, as a badly formatted special can totally'
     +/'destroy Simfit PostScript hardcopy. To get the general idea,'
     +/'practise with the Simfit example specials, pspecial.i.')
  400 format (
     +/'Advice'
     +/'1. Specials can add-logos/re-define fonts, etc.'
     +/'2. They only work in advanced PS graphics mode'
     +/'3. You install/suppress specials using PS/Fonts'
     +/'4. Practise with the Simfit examples pspecial.i'
     +/'5. Edit pspecial.cfg to define your own specials'
     +/'6. Faulty specials can cause serious PS problems'
     +/'7. If you have PS problems delete pspecial.cfg')
      end
c
c
